uniform mat4 u_mvpMatrix;

uniform mat4 u_bonePallette[51];



attribute vec3 a_boneIndices;

attribute vec3 a_boneWeights;

attribute vec3 a_position;

attribute vec2 a_texCoord;

attribute vec3 a_normalCoord;

//attribute vec4 a_color;



varying vec2 v_texCoord;

//varying vec4 v_color;



uniform vec4 u_lights[14];

uniform float u_shadlevel;

varying vec4 v_ambient;

varying vec4 v_diffuse;



void main()

{

	mat4 temp	= u_bonePallette[int(a_boneIndices[0])] * a_boneWeights[0] +  u_bonePallette[int(a_boneIndices[1])] * a_boneWeights[1] +  u_bonePallette[int(a_boneIndices[2])] * a_boneWeights[2];

	vec4 pos	= temp * vec4(a_position,1);

	//gl_Position = u_mvpMatrix * pos ; 

	gl_Position = pos ; //because we're using computed pose that concats all transforms

	v_texCoord	= a_texCoord;

	//v_color		= a_color;



	vec4 diffuse		= vec4(0.0, 0.0, 0.0, 0.0);

	float fInvShadLevel = 1.0 - u_shadlevel;  

	int c = 0;

	while(c<3)

	{

		vec3 lPos = vec3(u_lights[c*2+1].x, u_lights[c*2+1].y, u_lights[c*2+1].z);

		diffuse = diffuse + (fInvShadLevel * u_lights[c*2] + u_shadlevel * u_lights[7 + c*2])* max( 0.0, dot( a_normalCoord, lPos ));

		c++;

	}

	vec4 ambient = fInvShadLevel * u_lights[6] + u_shadlevel * u_lights[13];

	v_ambient = ambient;

	v_diffuse = diffuse;

}



