// PES 17 pitch shader, created to use in PPSSPP.

//===========================//  created by : Riksa
//================
#define SHADEBOOST   1     	//ON:1/OFF:0 /color correction from GSdx/pcsx2 plugin, initially taken from http://irrlicht.sourceforge.net/phpBB2/viewtopic.php?t=21057 
#define saturation   1.80   	//Default: 1.0 //negative will look like inverted colors shader
#define brightness   1.2   	//Normal: 1.0
#define contrast     0.60   	//Default: 1.0 //negative will be... well negative;p
#define red          1.1   	//Default: 1.0
#define green        1.1   	//Default: 1.0
#define blue         1.1   	//Default: 1.0
//Shadeboost presets:		//Shadeboost must be activated, presets override options above
int SEPIA =           1;	   	//Moody coolors:)
int GRAYSCALE =      0;	   	//Just for lols?
int NEGATIVE =       0;	   	//As above
int PSPCOLORS =      1;    	//Makes the colors as on older PSP screens(colder)
//^All presets are simple switch ON:1/OFF:0, 
//================
//================
#define VIGNETTE     1     	//ON:1/OFF:0 /same as in PPSSPP, just with few settings
#define vsize        1.8   	//Default: 1.2 /winter... I mean darkness is coming ~ with higher values
#define VIpos        0.0   	//Default: 0.0 /position of the effect between 0.0 and less than 0.5(where it disappears completely)
#define deVi         1    	//ON:1/OFF:0 /reverse vignette
//================

#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

uniform sampler2D sampler0;
varying vec2 v_texcoord0;

float amount = 0.0; // suitable range = 0.0 - 1.0
float intensity = 0.0; // suitable range = 0.0 - 1.0

void main()
{
  float pos0 = ((v_texcoord0.y + 1.0) * 170.0*amount);
  float pos1 = cos((fract( pos0 ) - 0.5)*3.1415926*intensity)*1.5;
  vec4 rgb = texture2D( sampler0, v_texcoord0 );
  
  // slight contrast curve
  vec4 color = rgb*0.4+0.4*rgb*rgb*0.50;
  
  // color tint
  color *= vec4(0.9,1.0,0.7, 0.0);
  
  // vignette
  color *= 1.9 - 0.6 * (dot(v_texcoord0 - 0.5, v_texcoord0 - 0.5) * 2.5);

  gl_FragColor.rgba = mix(vec4(0,0,0,0), color, pos1);
}
