precision lowp float;

uniform sampler2D s_texture;
uniform sampler2D s_textureName;
uniform sampler2D s_textureBackNumber;
uniform sampler2D s_textureShortNumber;

varying vec4 v_lightColor;

varying vec2 v_texCoord;
varying vec2 v_texNameCoord;
varying vec2 v_texBackNumberCoord;
varying vec2 v_texShortNumberCoord;

void main()
{
	lowp vec4  txt 			 = texture2D(s_texture, v_texCoord);
	lowp vec4  txtName 		 = texture2D(s_textureName, v_texNameCoord);
	lowp vec4  txtBackNumber = texture2D(s_textureBackNumber, v_texBackNumberCoord);
	lowp vec4  txtShortNumber = texture2D(s_textureShortNumber, v_texShortNumberCoord);

	// apply first blend (name)
	txt = txt * (1. - txtName.a) + txtName * txtName.a;
	
	// apply second blend (back number)
	txt = txt * (1. - txtBackNumber.a) + txtBackNumber * txtBackNumber.a;
	
	// apply third blend (short number)
	txt = txt * (1. - txtShortNumber.a) + txtShortNumber * txtShortNumber.a;

	gl_FragColor = txt * v_lightColor;
}