precision mediump float;



varying vec2 v_texCoord;

varying vec3 v_NormalCoord;

uniform sampler2D s_texture;

//

//lighting parameters

//

uniform vec4 u_lightPos;

uniform vec4 u_lightAmb;

uniform vec4 u_lightDiff;

uniform vec4 u_lightSpec;



void main()

{

	vec3 vViewVec		= vec3(u_lightPos.x , u_lightPos.y , u_lightPos.z);

	vec3 lPos		= vec3(u_lightPos.x , u_lightPos.y , u_lightPos.z);

	vec3 vReflect		= normalize( 2.0 * dot( v_NormalCoord, lPos ) * v_NormalCoord - lPos ); 

	vec4 SpecularColor	= u_lightSpec * pow( max( 0.0, dot(vReflect, vViewVec)), 5.0 );

	vec4 DiffuseColor	= u_lightDiff * max( 0.0, dot( v_NormalCoord, lPos ));

	vec2 coord		= vec2(v_texCoord.x, 1.0-v_texCoord.y);

	gl_FragColor = (u_lightAmb + DiffuseColor) * texture2D( s_texture, coord ) + SpecularColor ;

}