

uniform vec4 u_proj;

uniform mat4 u_bonePallette[51];



uniform vec4 u_lightAmbient;

uniform vec4 u_lightDirections[3];

uniform vec4 u_lightColors[3];



attribute vec3 a_boneIndices;

attribute vec3 a_boneWeights;

attribute vec4 a_position;

attribute vec2 a_texCoord;

attribute vec3 a_normalCoord;



varying vec2 v_texCoord;

varying vec4 v_color;



void main()

{

  

  mat4 mv = u_bonePallette[int(a_boneIndices.x)] * a_boneWeights.x + u_bonePallette[int(a_boneIndices.y)] * a_boneWeights.y + u_bonePallette[int(a_boneIndices.z)] * a_boneWeights.z;

 vec4 pos = mv * a_position;

  gl_Position = vec4(pos.xy * u_proj.xy, pos.z * u_proj.z + u_proj.w, -pos.z);

  mat3 temp = mat3(mv[0].xyz, mv[1].xyz, mv[2].xyz);
  
  vec3 norm = temp * a_normalCoord;

  v_color = u_lightAmbient + max(0.0, dot(norm, u_lightDirections[0].xyz)) * u_lightColors[0] + max(0.0, dot(norm, u_lightDirections[1].xyz)) * u_lightColors[1] + max(0.0, dot(norm, u_lightDirections[2].xyz)) * u_lightColors[2];      



  // lazy... lazy... lazy... 

  v_texCoord = vec2(a_texCoord.x, 1.0 - a_texCoord.y);           

   

}