uniform lowp sampler2D s_texture;
uniform lowp sampler2D s_lightMap;
uniform lowp sampler2D s_textLay2;
uniform lowp sampler2D s_textLay3;
uniform lowp sampler2D s_textLay4;
uniform lowp sampler2D s_textLay5;
uniform lowp vec4      u_wearColor;
uniform lowp vec4      u_offsetColor;

varying lowp vec2 v_texCoord;
varying lowp vec2 v_texLay2Coord;
varying lowp vec2 v_texLay3Coord; 
varying lowp vec2 v_texLay5Coord; 
varying lowp vec2 v_lightMapCoord;

void main()
{
   lowp vec4 txt = texture2D(s_texture, v_texCoord);
   lowp vec4 txtL4 = texture2D(s_textLay4, v_lightMapCoord);
 
   lowp vec4 LM =  texture2D(s_textLay2, v_texLay2Coord) * texture2D(s_textLay2, v_texLay2Coord) * texture2D(s_lightMap, v_lightMapCoord) * u_offsetColor;
	
   lowp vec4 finalTex =vec4(txt.rgb + txtL4.rgb, txt.a * txtL4.a);
	
   gl_FragColor =  finalTex * LM + texture2D(s_textLay3, v_texLay3Coord) * u_wearColor ;
}
