uniform vec4 u_proj;
uniform mat4 u_bonePallette[51];
uniform vec4 u_texNameTrans;
uniform vec4 u_texBackNumberTrans;
uniform vec4 u_texShortNumberTrans;

attribute vec3 a_boneIndices;
attribute vec3 a_boneWeights;
attribute vec4 a_position;
attribute vec2 a_texCoord;
attribute vec3 a_normCoord;

varying vec2 v_texCoord;
varying vec2 v_texNameCoord;
varying vec2 v_texBackNumberCoord;
varying vec2 v_texShortNumberCoord;

varying vec4 v_lightColor;

uniform vec4 u_lightAmbient;
uniform vec4 u_lightDirections[3];
uniform vec4 u_lightColors[3];

void main()
{ 
  mat4 mv = u_bonePallette[int(a_boneIndices.x)] * a_boneWeights.x + u_bonePallette[int(a_boneIndices.y)] * a_boneWeights.y + u_bonePallette[int(a_boneIndices.z)] * a_boneWeights.z;

  vec4 pos = mv * a_position;
  gl_Position = vec4(pos.xy * u_proj.xy, pos.z * u_proj.z + u_proj.w, -pos.z);
  vec3 v_normal = mat3(mv[0].xyz, mv[1].xyz, mv[2].xyz) * a_normCoord;
  
  vec3 norm = normalize(v_normal);
  
  v_lightColor = u_lightAmbient + max(0.0, dot(norm, u_lightDirections[0].xyz)) * u_lightColors[0] + max(0.0, dot(norm, u_lightDirections[1].xyz)) * u_lightColors[1] + max(0.0, dot(norm, u_lightDirections[2].xyz)) * u_lightColors[2];
  

  // lazy... lazy... lazy... 
  v_texCoord = vec2(a_texCoord.x, 1.0 - a_texCoord.y);

  // set uv for second layer (name)
  v_texNameCoord = u_texNameTrans.zw - v_texCoord * u_texNameTrans.xy;
  
  // set uv for third layer (back number)
  v_texBackNumberCoord = u_texBackNumberTrans.zw - v_texCoord * u_texBackNumberTrans.xy;
  
  // set uv for forth layer (short number)
  v_texShortNumberCoord = v_texCoord * u_texShortNumberTrans.xy + u_texShortNumberTrans.zw;
}