-- Patch By Ma'ruf ID YouTube --

local ScoreClock = {}

local OverlaysIdContainer, OverlayParam, eventmanager, TableUtil = ...
local Overlays = OverlaysIdContainer.Overlays.OVERLAY_TYPE
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_LOGO_TIM_HOME = "bnd_logo_tim_home"
local BND_LOGO_TIM_AWAY = "bnd_logo_tim_away"

local BND_NAMA_TIM_HOME = "bnd_nama_tim_home"
local BND_NAMA_TIM_AWAY = "bnd_nama_tim_away"

local BND_SKOR_TIM_HOME = "bnd_skor_tim_home"
local BND_SKOR_TIM_AWAY = "bnd_skor_tim_away"

local BND_WAKTU = "bnd_waktu"

local BND_WAKTU_TAMBAHAN = "bnd_waktu_tambahan"

function ScoreClock:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    MatchInfoService = o.api("MatchInfoService"),
    EventManagerService = o.api("EventManagerService"),
    GameSetupService = o.api("GameSetupService"),
    OverlayService = o.api("OverlayService")
  }
  o.eventHandlerID = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  
  o.visible = false
  
  local HOMETEAM = 0
  local AWAYTEAM = 1
  
  o.TeamsData = o.services.MatchInfoService.GetMatchTeams()
  self.homeScore = o.services.OverlayService.GetCurrentScore(HOMETEAM)
  self.awayScore = o.services.OverlayService.GetCurrentScore(AWAYTEAM)

  homeCrest = {
    name = "$Crest",
    id = o.TeamsData[1].assetId
  }
  awayCrest = {
    name = "$Crest",
    id = o.TeamsData[2].assetId
  }
  
  o.im.Subscribe("bnd_visible", function()
    o:publishVisible()
  end)

  o.im.Subscribe(BND_LOGO_TIM_HOME, function()
    o.im.Publish(BND_LOGO_TIM_HOME, homeCrest)
  end)
  o.im.Subscribe(BND_LOGO_TIM_AWAY, function()
    o.im.Publish(BND_LOGO_TIM_AWAY, awayCrest)
  end)

  o.im.Subscribe(BND_NAMA_TIM_HOME, function()
    o.im.Publish(BND_NAMA_TIM_HOME, o.services.GameSetupService.GetTeamShortName(HOMETEAM))
  end)
  o.im.Subscribe(BND_NAMA_TIM_AWAY, function()
    o.im.Publish(BND_NAMA_TIM_AWAY, o.services.GameSetupService.GetTeamShortName(AWAYTEAM))
  end)

  o.im.Subscribe(BND_SKOR_TIM_HOME, function()
    o:publishSkorTimHome()
  end)
  o.im.Subscribe(BND_SKOR_TIM_AWAY, function()
    o:publishSkorTimAway()
  end)

  o.im.Subscribe(BND_WAKTU, function()
    o:publishWaktu()
  end)

  o.im.Subscribe(BND_WAKTU_TAMBAHAN, function()
    o:publishWaktuTambahan()
  end)

  o.im.Subscribe("bnd_waktu_tambahan_visible", function()
    o:waktuTambahanVisibility(false)
  end)

  return o
end



-----------------------------------------------------------------------------------------------------------
function ScoreClock:publishSkorTimHome()
  self.im.Publish("bnd_skor_tim_home", tostring(self.homeScore))
end
function ScoreClock:publishSkorTimAway()
  self.im.Publish("bnd_skor_tim_away", tostring(self.awayScore))
end
function ScoreClock:publishWaktu()
  if self.gameTime ~= "" and self.gameTime ~= nil then
    self.im.Publish("bnd_waktu", tostring(self.gameTime))
  end
end
function ScoreClock:publishWaktuTambahan()
  if self.gameExtraTime ~= "" and self.gameExtraTime ~= nil then
    self.im.Publish("bnd_waktu_tambahan", tostring(self.gameExtraTime))
  end
end
-----------------------------------------------------------------------------------------------------------



function ScoreClock:handleEvent(eventType, data)
  if eventType == EventTypes.OverlayTypeGumby then
    self:updateGameTime(data.subtype, data.hideshow, data.subtypestr, data.msg)
  elseif eventType == EventTypes.OverlayTypeGoal or eventType == EventTypes.OverlayTypeMatchEvents then
    self:updateGameScore(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
end

function ScoreClock:updateGameTime(subtype, hideshow, subtypestr, msg)
  local params = OverlayParam.split(msg, "|")
  self.gameTime = ""
  self.gameExtraTime = ""
  if #params == 3 then
    if string.find(params[1], ":") then
      self.gameExtraTime = params[3]
      self:publishWaktuTambahan()
      self:waktuTambahanVisibility(true)
    end
    self.gameTime = params[1]
    self:publishWaktu()
  elseif #params == 4 then
    self.im.Publish(bndAlpha, params[1] / 100)
  elseif params and table.getn(params) > 0 then
    if string.find(params[1], ":") then
      self.gameTime = params[1]
    end
    if params[1] == "" then
      self:waktuTambahanVisibility(false)
    end
    self:publishWaktu()
  end
  self.visible = hideshow == "SHOW" or hideshow == "UPDATE"
  self:publishVisible()
end

function ScoreClock:updateGameScore(subtype, hideshow, subtypestr, msg)
  if hideshow ~= "HIDE" then
    local params = OverlayParam.split(msg, "|")
    if params and table.getn(params) >= 6 then
      self.homeScore = params[5]
      self.awayScore = params[6]
      self:publishSkorTimHome()
      self:publishSkorTimAway()
    end
  end
end

function ScoreClock:waktuTambahanVisibility(visible)
  self.im.Publish("bnd_waktu_tambahan_visible", visible)
end

function ScoreClock:publishVisible()
  self.im.Publish("bnd_visible", self.visible)
end

function ScoreClock:finalize()
  
  self.im.Unsubscribe(BND_LOGO_TIM_HOME)
  self.im.Unsubscribe(BND_LOGO_TIM_AWAY)

  self.im.Unsubscribe(BND_NAMA_TIM_HOME)
  self.im.Unsubscribe(BND_NAMA_TIM_AWAY)
  
  self.im.Unsubscribe(BND_SKOR_TIM_HOME)
  self.im.Unsubscribe(BND_SKOR_TIM_AWAY)

  self.im.Unsubscribe(BND_WAKTU)
  
  self.im.Unsubscribe(BND_WAKTU_TAMBAHAN)

  self.im.Unsubscribe("bnd_visible")
 
  self.im.Unsubscribe("bnd_waktu_tambahan_visible")

  self.services.EventManagerService.UnregisterHandler(self.eventHandlerID)
end

return ScoreClock

-- MOD Keren dari YouTube Ma'ruf ID --