-- REMOD BY 狮子不留恋过去 bilibili --
print("Substitution.lua")
local Substitution = {}
local bndNationalization = "bnd_nationalization"
local bndSubstitutionList = "bnd_subs_info"
local bndVisible = "bnd_visible"
local OverlaysIdContainer, OverlayParam, eventmanager = ...
local Overlays = OverlaysIdContainer.Overlays.OVERLAY_TYPE
local EventTypes = eventmanager.FE.FIFA.EventTypes
function Substitution:new(init)
  print("Substitution new ")
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.nationalization = 2
  o.services = {
    eventManService = o.api("EventManagerService")
  }
  o.handlerId = o.services.eventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end
  )
  o.im.Subscribe(bndNationalization, function()
  end
  )
  o.im.Subscribe(bndVisible, function()
  end
  )
  o.im.Subscribe(bndSubstitutionList, function()
  end
  )
  return o
end

function Substitution:handleEvent(eventType, data)
  if eventType == EventTypes.OverlayTypeSubstitutionOut then
    self:updateSubstitution(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
end

function Substitution:updateSubstitution(subtype, hideshow, subtypestr, msg)
  print("updateSubstitution " .. msg)
  if hideshow ~= "HIDE" then
    local params = OverlayParam.split(msg, "|")
    if params and table.getn(params) > 0 then
      self.im.Publish(bndVisible, true)
      self.im.Publish(bndNationalization, self.nationalization)
      TeamId = params[1] + 0
      local substitutionsInfo = {
        NumberofSubs = params[3] + 0,
        SubIn1Text = params[4],
        SubIn1NumText = params[5],
        SubIn2Text = params[6],
        SubIn2NumText = params[7],
        SubIn3Text = params[8],
        SubIn3NumText = params[9],
        SubOut1Text = params[11],
        SubOut1NumText = params[12],
        SubOut2Text = params[13],
        SubOut2NumText = params[14],
        SubOut3Text = params[15],
        SubOut3NumText = params[16],
        overlayTitle = ("SUB"),
        TeamId = params[1] + 0
      }
      self.im.Publish(bndSubstitutionList, substitutionsInfo)
    end
  else
    self.im.Publish(bndVisible, false)
  end
end

function Substitution:finalize()
  self.services.eventManService.UnregisterHandler(self.handlerId)
  self.im.Unsubscribe(bndNationalization)
  self.im.Unsubscribe(bndVisible)
  self.im.Unsubscribe(bndSubstitutionList)
end

return Substitution
