-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local SquadCustomization = {}

local eventmanager, Timer = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_SQUAD_CREST = "bnd_squad_crest"

local BND_SELECTED_CREST = "bnd_selected_crest"
local BND_SELECTED_BALL = "bnd_selected_ball"
local BND_SELECTED_STADIUM = "bnd_selected_stadium"
local BND_SELECTED_HOME = "bnd_selected_home_kit"
local BND_SELECTED_AWAY = "bnd_selected_away_kit"

local BND_BALL_LABEL = "bnd_ball_selected_label"
local BND_STADIUM_LABEL = "bnd_stadium_selected_label"
local BND_CREST_LABEL = "bnd_crest_selected_label"
local BND_HOME_LABEL = "bnd_home_selected_label"
local BND_AWAY_LABEL = "bnd_away_selected_label"

local BND_SIZE_VALUE = "bnd_size_value"
local BND_MORAL_VALUE = "bnd_moral_value"

local BND_ITEM_LIST = "bnd_item_list"
local BND_MESSAGE = "bnd_message"
local BND_SHOW_MESSAGE = "bnd_show_message"
local BND_SHOW_LIST = "bnd_show_list"
local BND_DATE_LABEL = "bnd_date_label"
local BND_SQUAD_NAME = "bnd_squad_label"

local BND_BADGE_SELECT_VISIBLE = "bnd_badge_select_visible"
local BND_HOME_SELECT_VISIBLE = "bnd_home_select_visible"
local BND_AWAY_SELECT_VISIBLE = "bnd_away_select_visible"
local BND_BALL_SELECT_VISIBLE = "bnd_ball_select_visible"
local BND_STADIUM_SELECT_VISIBLE = "bnd_stadium_select_visible"

local ACT_BTN_CLICK = "act_btn_click"
local ACT_ITEM_CLICK = "act_item_click"
local ACT_BTN_EDITCLUBNAME = "act_btn_editclubname_click"

local STADIUM = 13
local BALL = 14
local KIT_AWAY = 15
local KIT_HOME = 12
local KITS = 12
local CREST = 11
local COLLECTIONS_ALL = 1

function SquadCustomization:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.isSearching = false
  o.isSearchTimer = false
  o.services = {
    card = o.api("CardService"),
    myClub = o.api("MyClubService"),
    items = o.api("ItemsService"),
    userInfo = o.api("FUTUserInfoService"),
    eventManService = o.api("EventManagerService"),
    logger = o.api("LoggingService")
  }
  o.selectedLevel = 0
  o.selectedData = {}
  o.selectedItem = CREST
  o.categories = o.services.myClub.GetCategoriesForCollection(COLLECTIONS_ALL)
  o.buttonsID = {
    CREST,
    KIT_HOME,
    KIT_AWAY,
    BALL,
    STADIUM
  }
  o.buttonLabels = {}
  o.buttonLabels[CREST] = o.loc.LocalizeString("LTXT_CUSTOMISE_BADGE")
  o.buttonLabels[KIT_HOME] = o.loc.LocalizeString("LTXT_SQDCUST_HOME_KIT")
  o.buttonLabels[KIT_AWAY] = o.loc.LocalizeString("LTXT_SQDCUST_AWAY_KIT")
  o.buttonLabels[BALL] = o.loc.LocalizeString("LTXT_SQDCUST_BALL")
  o.buttonLabels[STADIUM] = o.loc.LocalizeString("LTXT_SQDCUST_STADIUM")
  
  o.assetsType = {}
  
  o.assetsType[CREST] = "$Crest"
  o.assetsType[KIT_HOME] = "$Kits"
  o.assetsType[KIT_AWAY] = "$Kits"
  o.assetsType[BALL] = "$Balls"
  o.assetsType[STADIUM] = "$Stadium"
  
  o.resultData = {}
  
  o.makeActiveCallInProgress = false
  o.searchId = -1
  o.editclubname = false
  o.queueItemId = nil

  o.timer = Timer:new({
    reps = 1,
    interval = 1,
    onTimerComplete = function()
      o:_onTimerComplete()
    end
  })
  
  local crestInfo = o.services.myClub.GetClubCrestInfo()
  local homeKitInfo = o.services.myClub.GetClubHomeKitInfo()
  local awayKitInfo = o.services.myClub.GetClubAwayKitInfo()
  local ballInfo = o.services.myClub.GetClubBallInfo()
  local stadiumInfo = o.services.myClub.GetClubStadiumInfo()
  
  o.squadName = o.services.userInfo.GetClubName()
  
  o.selectedCrest = {
    image = {
      name = o.assetsType[CREST],
      id = crestInfo.assetId
    },
    label = crestInfo.name
  }
  o.selectedHomeKit = {
    image = {
      name = o.assetsType[KIT_HOME],
      id = homeKitInfo.assetId
    },
    label = homeKitInfo.name
  }
  o.selectedAwayKit = {
    image = {
      name = o.assetsType[KIT_AWAY],
      id = awayKitInfo.assetId
    },
    label = awayKitInfo.name
  }
  o.selectedBall = {
    image = {
      name = o.assetsType[BALL],
      id = ballInfo.assetId
    },
    label = ballInfo.name
  }
  o.selectedStadium = {
    image = {
      name = o.assetsType[STADIUM],
      id = stadiumInfo.assetId
    },
    label = stadiumInfo.name,
    size = stadiumInfo.capacity,
    moral = stadiumInfo.boost
  }
  
  o.im.Subscribe(BND_SQUAD_CREST, function()
    o:_publishSquadCrest(o.selectedCrest.image)
  end)
  o.im.Subscribe(BND_DATE_LABEL, function()
    o:_publishDate()
  end)
  o.im.Subscribe(BND_SQUAD_NAME, function()
    o:_publishSquadName()
  end)
  o.im.Subscribe(BND_SELECTED_CREST, function()
    o:_publishSelectedCrest(o.selectedCrest.image)
  end)
  o.im.Subscribe(BND_CREST_LABEL, function()
    o:_publishCrestLabel(o.selectedCrest.label)
  end)
  o.im.Subscribe(BND_SELECTED_BALL, function()
    o:_publishSelectedBall(o.selectedBall.image)
  end)
  o.im.Subscribe(BND_BALL_LABEL, function()
    o:_publishBallLabel(o.selectedBall.label)
  end)
  o.im.Subscribe(BND_SELECTED_STADIUM, function()
    o:_publishSelectedStadium(o.selectedStadium.image)
  end)
  o.im.Subscribe(BND_STADIUM_LABEL, function()
    o:_publishStadiumLabel(o.selectedStadium.label)
  end)
  o.im.Subscribe(BND_SIZE_VALUE, function()
    o:_publishSizeValue(o.selectedStadium.size)
  end)
  o.im.Subscribe(BND_MORAL_VALUE, function()
    o:_publishMoralValue(o.selectedStadium.moral)
  end)
  o.im.Subscribe(BND_SELECTED_HOME, function()
    o:_publishSelectedHomeKit(o.selectedHomeKit.image)
  end)
  o.im.Subscribe(BND_HOME_LABEL, function()
    o:_publishHomeKitLabel(o.selectedHomeKit.label)
  end)
  o.im.Subscribe(BND_SELECTED_AWAY, function()
    o:_publishSelectedAwayKit(o.selectedAwayKit.image)
  end)
  o.im.Subscribe(BND_AWAY_LABEL, function()
    o:_publishAwayKitLabel(o.selectedAwayKit.label)
  end)
  o.im.Subscribe(BND_ITEM_LIST, function()
  end)
  o.im.Subscribe(BND_SHOW_MESSAGE, function()
  end)
  o.im.Subscribe(BND_MESSAGE, function()
  end)
  o.im.Subscribe(BND_SHOW_LIST, function()
  end)
  o.im.Subscribe(BND_BADGE_SELECT_VISIBLE, function()
  end)
  o.im.Subscribe(BND_HOME_SELECT_VISIBLE, function()
  end)
  o.im.Subscribe(BND_AWAY_SELECT_VISIBLE, function()
  end)
  o.im.Subscribe(BND_BALL_SELECT_VISIBLE, function()
  end)
  o.im.Subscribe(BND_STADIUM_SELECT_VISIBLE, function()
  end)
  o:HideSelections()
  o.im.Publish(BND_BADGE_SELECT_VISIBLE, true)
  o.handlerId = o.services.eventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  
  o.im.RegisterAction(ACT_BTN_EDITCLUBNAME, function(actionName, id)
    o.editclubname = true
    o.nav.Event(nil, "evt_show_overlay", {
      vvm = "/flows/mainflow/widgets/bio/popups/EditAcronymPopup.vvm",
      data = {
        callBack = function(data)
          o:_onClubNameChange(data)
        end
      }
    })
  end)
  
  o.im.RegisterAction(ACT_ITEM_CLICK, function(actionName, id)
    if o.isSearching == true then
      o.queueItemId = nil
    elseif o.isSearchTimer == true or o.isSearchQueued == true then
      o.queueItemId = id
    else
      o.queueItemId = nil
      o.currentId = id
      o:_saveData()
    end
  end)
  
  o.im.RegisterAction(ACT_BTN_CLICK, function(actionName, data)
    o.selectedLevel = 0
    if o.buttonsID[data.buttonID + 1] == KIT_AWAY or o.buttonsID[data.buttonID + 1] == KIT_HOME then
      if o.buttonsID[data.buttonID + 1] == KIT_AWAY then
        o.kitSelected = "AWAY_KITS"
        o.selectedItem = KIT_AWAY
      else
        o.kitSelected = "HOME_KITS"
        o.selectedItem = KIT_HOME
      end
    else
      o.selectedItem = o.buttonsID[data.buttonID + 1]
      o.kitSelected = ""
    end
    if o.selectedItem == KIT_AWAY or o.selectedItem == KIT_HOME then
      o.selectedItem = KITS
    end
    o:_PerformSearch()
    o:HideSelections()
    if o.buttonsID[data.buttonID + 1] == STADIUM then
      o.im.Publish(BND_STADIUM_SELECT_VISIBLE, true)
    elseif o.buttonsID[data.buttonID + 1] == BALL then
      o.im.Publish(BND_BALL_SELECT_VISIBLE, true)
    elseif o.buttonsID[data.buttonID + 1] == KIT_AWAY then
      o.im.Publish(BND_AWAY_SELECT_VISIBLE, true)
    elseif o.buttonsID[data.buttonID + 1] == KIT_HOME then
      o.im.Publish(BND_HOME_SELECT_VISIBLE, true)
    elseif o.buttonsID[data.buttonID + 1] == CREST then
      o.im.Publish(BND_BADGE_SELECT_VISIBLE, true)
    end
  end)
  return o
end

function SquadCustomization:HideSelections()
  self.im.Publish(BND_BADGE_SELECT_VISIBLE, false)
  self.im.Publish(BND_HOME_SELECT_VISIBLE, false)
  self.im.Publish(BND_AWAY_SELECT_VISIBLE, false)
  self.im.Publish(BND_BALL_SELECT_VISIBLE, false)
  self.im.Publish(BND_STADIUM_SELECT_VISIBLE, false)
end

function SquadCustomization:handleEvent(eventType, data)
  if eventType == EventTypes.MakeClubCardActive then
    self:_MakeCardActiveCB(data)
  elseif eventType == EventTypes.ClubSearch then
    self:_SearchResultsCb(data)
  elseif eventType ~= EventTypes.OnBackPressed or self.editclubname == true then
  else
    self.nav.Event(nil, "evt_exit")
  end
end

function SquadCustomization:_onClubNameChange(data)
  print("#SQUAD NAME CHANGED!!")
  self.editclubname = false
  self.squadName = data
  self:_publishSquadName()
end
function SquadCustomization:_saveData()
  if not self.makeActiveCallInProgress then
    self.makeActiveCallInProgress = true
    local infoToSend = self.resultData[self.selectedItem][self.currentId]
    self.services.myClub.MakeCardActive(infoToSend)
  end
end

function SquadCustomization:_MakeCardActiveCB(result)
  self.services.logger.Log("LUA", result.status)
  if result.status == "ERROR" then
    print("SAVE RETURNED AN ERROR")
    self:_publishMessage(self.loc.LocalizeString("LTXT_INV_RESULTS_ERROR"))
  elseif result.status == "OK" then
    print("SAVE OK")
    local info = {}
    print("self.selectedItem: " .. self.selectedItem)
    print("kits: ", KITS)
    if self.selectedItem == STADIUM then
      info = self.services.myClub.GetClubStadiumInfo()
      self:_publishSelectedStadium({
        name = self.assetsType[STADIUM],
        id = info.assetId
      })
      self:_publishStadiumLabel(info.name)
      self:_publishSizeValue(info.capacity)
      self:_publishMoralValue(info.boost)
    elseif self.selectedItem == BALL then
      info = self.services.myClub.GetClubBallInfo()
      self:_publishSelectedBall({
        name = self.assetsType[BALL],
        id = info.assetId
      })
      self:_publishBallLabel(info.name)
    elseif self.selectedItem == KITS then
      if self.kitSelected == "HOME_KITS" then
        info = self.services.myClub.GetClubHomeKitInfo()
        self:_publishHomeKitLabel(info.name)
        self:_publishSelectedHomeKit({
          name = self.assetsType[KITS],
          id = info.assetId
        })
      else
        info = self.services.myClub.GetClubAwayKitInfo()
        self:_publishSelectedAwayKit({
          name = self.assetsType[KITS],
          id = info.assetId
        })
        self:_publishAwayKitLabel(info.name)
      end
    elseif self.selectedItem == CREST then
      info = self.services.myClub.GetClubCrestInfo()
      info.image = {
        name = self.assetsType[CREST],
        id = info.assetId
      }
      self:_publishSelectedCrest(info.image)
      self:_publishCrestLabel(info.name)
      self:_publishSquadCrest(info.image)
    end
    self.makeActiveCallInProgress = false
  end
end

function SquadCustomization:_PerformSearch()
  print("SquadCustomization:_PerformSearch (ClubSearch) self.isSearching: ")
  print(self.isSearching)
  if self.isSearching == true then
    return
  end
  if self.isSearchTimer == true then
    self.isSearchQueued = true
    return
  end
  self.queueItemId = nil
  self.searchItem = self.selectedItem
  self.searchKit = self.kitSelected
  local params = {
    LEVEL = self.selectedLevel,
    NUMBER_RESULTS = 250,
    START = 0,
    CONSUMABLE_TYPE = self.selectedItem,
    SEARCH_TYPE = 31
  }
  if self.kitSelected == "HOME_KITS" then
    params.HOME_KITS = true
  else
    params.AWAY_KITS = true
  end
  params.CURRENT_SEARCH_ID = self.searchId
  self.searchId = self.services.items.ClubSearch(params)
  self.isSearching = true
  self.timer:restart()
  self.isSearchTimer = true
  self.isSearchQueued = false
end

function SquadCustomization:_onTimerComplete()
  print("SquadCustomization:_onTimerComplete")
  self.isSearchTimer = false
  if self.isSearchQueued == true then
    self:_PerformSearch()
  elseif self.queueItemId ~= nil and self.isSearching == false then
    self.currentId = self.queueItemId
    self:_saveData()
  end
  self.queueItemId = nil
end

function SquadCustomization:_SearchResultsCb(result)
  print("SquadCustomization:_SearchResultsCb id = " .. tostring(result.searchId))
  self.isSearching = false
  if self.searchItem ~= self.selectedItem or self.searchKit ~= self.kitSelected then
    self:_PerformSearch()
  elseif self.searchId == result.searchId then
    self.searchId = -1
    if result.status == "ERROR" then
      print("SEARCH RETURNED AN ERROR")
      self:_publishMessage(self.loc.LocalizeString("LTXT_INV_RESULTS_ERROR"))
    elseif result.status == "OK" then
      print("SEARCH OK")
      self.resultData[self.selectedItem] = {}
      if #result.data > 0 then
        for i = 1, #result.data do
          local info = self.services.card.FillSpecialCardInfo(result.data[i])
          local imageId = ""
          local imageType = self.assetsType[self.selectedItem]
          self.resultData[self.selectedItem][i] = {}
          self.resultData[self.selectedItem][i] = info
          self.resultData[self.selectedItem][i].label = info.description
          self.resultData[self.selectedItem][i].id = i
          self.resultData[self.selectedItem][i].action = ACT_ITEM_CLICK
          if self.selectedItem == KIT_HOME or self.selectedItem == KIT_AWAY then
            imageId = info.kitAssetId
          elseif self.selectedItem == CREST then
            imageId = info.teamId
          else
            imageId = info.assetID
          end
          self.resultData[self.selectedItem][i].image = {name = imageType, id = imageId}
        end
        self:_publishMessage("")
      else
        self:_publishMessage(self.loc.LocalizeString("LTXT_INV_RESULTS_NO_RESULTS"))
      end
      self:_publishItemList()
    end
  else
    print("SquadCustomization:_SearchResultsCb ignoring id = " .. tostring(result.searchId))
  end
end

function SquadCustomization:_publishDate()
  self.im.Publish(BND_DATE_LABEL, self.services.myClub.GetEstablishedDate().estDate)
end

function SquadCustomization:_publishSquadName()
  self.im.Publish(BND_SQUAD_NAME, self.squadName)
end

function SquadCustomization:_publishMessage(value)
  if value == "" then
    self.im.Publish(BND_SHOW_MESSAGE, false)
    self.im.Publish(BND_SHOW_LIST, true)
  else
    self.im.Publish(BND_MESSAGE, value)
    self.im.Publish(BND_SHOW_MESSAGE, true)
    self.im.Publish(BND_SHOW_LIST, false)
  end
end

function SquadCustomization:_publishItemList()
  self.im.Publish(BND_ITEM_LIST, self.resultData[self.selectedItem])
end
function SquadCustomization:_publishAwayKitLabel(label)
  self.im.Publish(BND_AWAY_LABEL, label)
end
function SquadCustomization:_publishMoralValue(label)
  self.im.Publish(BND_MORAL_VALUE, label)
end
function SquadCustomization:_publishSizeValue(label)
  self.im.Publish(BND_SIZE_VALUE, label)
end
function SquadCustomization:_publishHomeKitLabel(label)
  self.im.Publish(BND_HOME_LABEL, label)
end
function SquadCustomization:_publishCrestLabel(label)
  self.im.Publish(BND_CREST_LABEL, label)
end
function SquadCustomization:_publishStadiumLabel(label)
  self.im.Publish(BND_STADIUM_LABEL, label)
end
function SquadCustomization:_publishBallLabel(label)
  self.im.Publish(BND_BALL_LABEL, label)
end
function SquadCustomization:_publishSelectedAwayKit(image)
  self.im.Publish(BND_SELECTED_AWAY, image)
end
function SquadCustomization:_publishSelectedHomeKit(image)
  self.im.Publish(BND_SELECTED_HOME, image)
end
function SquadCustomization:_publishSelectedStadium(image)
  self.im.Publish(BND_SELECTED_STADIUM, image)
end
function SquadCustomization:_publishSquadCrest(image)
  self.im.Publish(BND_SQUAD_CREST, image)
end
function SquadCustomization:_publishSelectedCrest(image)
  self.im.Publish(BND_SELECTED_CREST, image)
end
function SquadCustomization:_publishSelectedBall(image)
  self.im.Publish(BND_SELECTED_BALL, image)
end
function SquadCustomization:update(elapsedTime)
  if self.timer ~= nil then
    self.timer:update(elapsedTime)
  end
end

function SquadCustomization:finalize()
  self.im.UnregisterAction(ACT_BTN_CLICK)
  self.im.UnregisterAction(ACT_ITEM_CLICK)
  self.im.UnregisterAction(ACT_BTN_EDITCLUBNAME)
  self.im.Unsubscribe(BND_SELECTED_CREST)
  self.im.Unsubscribe(BND_SELECTED_BALL)
  self.im.Unsubscribe(BND_SELECTED_STADIUM)
  self.im.Unsubscribe(BND_SELECTED_HOME)
  self.im.Unsubscribe(BND_SELECTED_AWAY)
  self.im.Unsubscribe(BND_SQUAD_CREST)
  self.im.Unsubscribe(BND_BALL_LABEL)
  self.im.Unsubscribe(BND_STADIUM_LABEL)
  self.im.Unsubscribe(BND_CREST_LABEL)
  self.im.Unsubscribe(BND_HOME_LABEL)
  self.im.Unsubscribe(BND_AWAY_LABEL)
  self.im.Unsubscribe(BND_SIZE_VALUE)
  self.im.Unsubscribe(BND_MORAL_VALUE)
  self.im.Unsubscribe(BND_ITEM_LIST)
  self.im.Unsubscribe(BND_SHOW_MESSAGE)
  self.im.Unsubscribe(BND_MESSAGE)
  self.im.Unsubscribe(BND_SHOW_LIST)
  self.im.Unsubscribe(BND_DATE_LABEL)
  self.im.Unsubscribe(BND_SQUAD_NAME)
  self.im.Unsubscribe(BND_BADGE_SELECT_VISIBLE)
  self.im.Unsubscribe(BND_HOME_SELECT_VISIBLE)
  self.im.Unsubscribe(BND_AWAY_SELECT_VISIBLE)
  self.im.Unsubscribe(BND_BALL_SELECT_VISIBLE)
  self.im.Unsubscribe(BND_STADIUM_SELECT_VISIBLE)
  self.services.eventManService.UnregisterHandler(self.handlerId)
end

return SquadCustomization