-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local FUTHomeHub = {}

local fut_livetiles_service, eventmanager, Timer, VirtualButton, CABModel, FeatureTileModel, TableUtil = ...
local liveTilesType = fut_livetiles_service.FE.UXService.FUTLiveTilesType

local bndLastPlayedData = "bnd_last_played_data"
local bndLastPlayedEnabled = "bnd_last_played_enabled"
local bndLastPlayedLoading = "bnd_last_played_loading"
local bndLastPlayedClickAction = "bnd_last_played_click_action"

local bndAccomplishmentsTile = "bnd_live_tile_accomplishments"
local bndTradePile = "bnd_trade_pile"
local bndPlayerExchange = "bnd_player_exchange"
local bndLiveTileList = "bnd_live_tile_list"
local bndAdvertTitle = "bnd_live_tile_advert"

local BND_PLAYER_EXCHANGE_ENABLED = "bnd_player_exchange_enabled"
local BND_PROGRESS_BAR_DATA = "bnd_progress_bar_data"

local LAST_GAMEMODE_NONE = 0
local LAST_GAMEMODE_OFFLINE_SEASONS = 1
local LAST_GAMEMODE_ONLINE_SEASONS = 2
local LAST_GAMEMODE_OFFLINE_TOURNAMENTS = 3

local ACT_TO_OFFLINE_TOURNAMENTS = "act_to_offline_tournaments"

local EventTypes = eventmanager.FE.FIFA.EventTypes

function FUTHomeHub:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    FUTTournamentService = o.api("FUTTournamentService"),
    liveTilesService = o.api("FUTLiveTilesService"),
    SeasonService = o.api("SeasonService"),
    EventManService = o.api("EventManagerService"),
    PowService = o.api("PowService"),
    PlayerExchangeService = o.api("PlayerExchangeService"),
    FUTStoreService = o.api("FutStoreService")
  }
  o.powService = o.api("PowService")
  o.screenName = "worldfuthub"
  o.advertTileData = {}
  o.models = {
    CABModel = CABModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      screenName = o.screenName
    }),
    FeatureTileModel = FeatureTileModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      viewType = "simple",
      imageScale = 0.7
    })
  }
  o.handlerId = o.services.EventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  o.liveTileTimer = -1
  o.timesLoaded = 0
  o.lastPlayedClickAction = nil
  o.lastPlayedTileProgressBarData = nil
  o.lastPlayedCompetition = o.services.liveTilesService.GetLastPlayedGamemode()
  o.hasTournamentsAvailable = true
  if o.lastPlayedCompetition == LAST_GAMEMODE_NONE or o.lastPlayedCompetition > LAST_GAMEMODE_OFFLINE_TOURNAMENTS then
    o.lastPlayedCompetition = LAST_GAMEMODE_OFFLINE_SEASONS
    o.lastPlayedClickAction = "act_to_offline_seasons"
  end
  o.im.Subscribe(bndLastPlayedData, function()
    o:_publishLastPlayed()
  end)
  o.im.Subscribe(BND_PROGRESS_BAR_DATA, function()
    o:_publishProgressBarData(BND_PROGRESS_BAR_DATA, o.lastPlayedTileProgressBarData)
  end)
  o.im.Subscribe(bndTradePile, function()
    o:_publishTransfers()
  end)
  o.im.Subscribe(bndLiveTileList, function()
    o:_publishLiveTiles()
  end)
  o.im.Subscribe(bndLastPlayedEnabled, function()
    o:_publishLastPlayedEnabled()
  end)
  o.im.Subscribe(bndLastPlayedClickAction, function()
    o.im.Publish(bndLastPlayedClickAction, o.lastPlayedClickAction)
  end)
  o.im.Subscribe(BND_PLAYER_EXCHANGE_ENABLED, function()
    o.im.Publish(BND_PLAYER_EXCHANGE_ENABLED, o.services.PlayerExchangeService.IsPlayerExchangeEnabled())
  end)
  o.im.Subscribe(bndAdvertTitle, function()
    o:publishBannerData()
  end)
  o.isHubLoaded = false
  o.onlineSeasonInfo = {currentPoints = -1}
  o.offlineSeasonInfo = {currentPoints = -1}
  o.services.liveTilesService.RetrieveData()
  if o.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS then
    o.lastPlayedClickAction = "act_to_offline_seasons"
    o.lastPlayedTileProgressBarData = o.offlineSeasonInfo
  elseif o.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
    o.lastPlayedClickAction = "act_to_online_seasons"
    o.lastPlayedTileProgressBarData = o.onlineSeasonInfo
  elseif o.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_TOURNAMENTS then
    o.lastPlayedClickAction = "act_to_offline_tournaments"
  end
  if o.lastPlayedClickAction ~= nil then
    o.im.Publish(bndLastPlayedClickAction, o.lastPlayedClickAction)
  end
  if o.services.FUTTournamentService.IsOfflineTournamentsKillSwitchOn() then
    o.im.ChangeActionState(ACT_TO_OFFLINE_TOURNAMENTS, o.im.GetActionState("INVALID"))
  else
    o.im.ChangeActionState(ACT_TO_OFFLINE_TOURNAMENTS, o.im.GetActionState("VALID"))
  end
  o.im.RegisterAction(ACT_TO_OFFLINE_TOURNAMENTS, function(actionName)
    if o.hasTournamentsAvailable == true then
      o.nav.Event(nil, "evt_to_offline_tournaments")
    else
      local buttonOk = VirtualButton:new({
        nav = o.nav,
        label = "LTXT_CMN_OK",
        clickEvents = {
          "evt_hide_popup"
        }
      })
      local popupData = {
        title = "LTXT_NO_TOURNAMENTS_AVAILABLE_TITLE",
        message = "LTXT_NO_TOURNAMENTS_AVAILABLE_MESSAGE",
        buttons = {buttonOk}
      }
      o.nav.Event(nil, "evt_show_popup", popupData)
    end
  end)
  o.services.liveTilesService.RequestClubStatistics()
  o.powService.RequestAdBannersByScreen(o.screenName)
  return o
end
function FUTHomeHub:publishBannerData()
  if self.advertTileData ~= nil then
    local dataToPublishAdvert = {
      index = 0,
      data = self.advertTileData
    }
    self.im.Publish(bndAdvertTitle, dataToPublishAdvert)
  end
end
function FUTHomeHub:_loadSeasons()
  if self.onlineSeasonInfo.seasonID == nil and self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
    self.services.SeasonService.LoadSeasons(true)
  elseif self.offlineSeasonInfo.seasonID == nil and self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS then
    self.services.SeasonService.LoadSeasons(false)
  end
end
function FUTHomeHub:_onSeasonLoaded(data)
  if data.isOnline then
    self.onlineSeasonInfo = self.services.SeasonService.GetCachedSeasonInfo(true)
  else
    self.offlineSeasonInfo = self.services.SeasonService.GetCachedSeasonInfo(false)
  end
  if self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS then
    self.lastPlayedTileProgressBarData = self.offlineSeasonInfo
  elseif self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
    self.lastPlayedTileProgressBarData = self.onlineSeasonInfo
  end
  self:_publishSeason()
  self:_publishProgressBarData(BND_PROGRESS_BAR_DATA, self.lastPlayedTileProgressBarData)
  self:_loadSeasons()
end
function FUTHomeHub:_publishLastPlayed()
  if self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS or self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
    self:_publishSeason()
  elseif self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_TOURNAMENTS then
    self:_publishOfflineTournament()
  end
end
function FUTHomeHub:_publishLastPlayedEnabled()
  if self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS then
    local seasonEnabled = self.services.SeasonService.IsOfflineSeasonEnabled()
    self.im.Publish(bndLastPlayedEnabled, seasonEnabled)
    self.im.Publish(bndLastPlayedLoading, true)
  elseif self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
    local seasonEnabled = self.services.SeasonService.IsOnlineSeasonEnabled()
    self.im.Publish(bndLastPlayedEnabled, seasonEnabled)
    self.im.Publish(bndLastPlayedLoading, true)
  elseif self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_TOURNAMENTS then
    self.im.Publish(bndLastPlayedEnabled, false)
    self.im.Publish(bndLastPlayedLoading, false)
  end
end
function FUTHomeHub:_publishSeason()
  local button = {}
  local seasonInfo
  if self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
    button.headline = {
      self.loc.LocalizeString("LTXT_LT_LIVE_TILE_ONLINE_SEASONS")
    }
    button.images = {
      "$FUTHubPlayOnlineSeasonsTall"
    }
    seasonInfo = self.services.SeasonService.GetCachedSeasonInfo(true)
  elseif self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS then
    button.headline = {
      self.loc.LocalizeString("LTXT_FUT_LIVE_TILE_OFFLINE_SEASONS")
    }
    button.images = {
      "$FUTHubPlayOfflineSeasonsTall"
    }
    seasonInfo = self.services.SeasonService.GetCachedSeasonInfo(false)
  else
    return
  end
  if seasonInfo ~= nil and seasonInfo.division ~= nil then
    button.feedback = {
      label = self.loc.LocalizeString("LTXT_PLAY_LIVE_TILE_DIV"),
      value = self.loc.LocalizeInteger(seasonInfo.division)
    }
    if seasonInfo.seasonID ~= nil and seasonInfo.seasonID >= 0 then
      button.feedback.subFeedbacks = {
        {
          label = self.loc.LocalizeString("LTXT_PLAY_LIVE_TILE_POINTS"),
          value = self.loc.LocalizeInteger(seasonInfo.points)
        },
        {
          label = self.loc.LocalizeString("LTXT_PLAY_LIVE_TILE_GAMES_REMAINING"),
          value = self.loc.LocalizeInteger(seasonInfo.gamesRemaining)
        }
      }
      if 0 <= seasonInfo.projection then
        table.insert(button.feedback.subFeedbacks, 2, {
          label = self.loc.LocalizeString("LTXT_PLAY_LIVE_TILE_PROJECTION"),
          value = self.loc.LocalizeInteger(seasonInfo.projection)
        })
      end
    end
  end
  self.im.Publish(bndLastPlayedData, button)
end
function FUTHomeHub:_publishProgressBarData(binding, seasonInfo)
  local data
  if seasonInfo ~= nil then
    data = {}
    if seasonInfo.trohpyPoints ~= nil then
      data.totalSteps = math.floor(seasonInfo.trohpyPoints * 10 / 9)
    end
    data.lastPoints = 0
    if seasonInfo.seasonID ~= nil and 0 <= seasonInfo.seasonID then
      data.currentPoints = seasonInfo.points
    else
      data.currentPoints = -1
    end
    data.pointsLabel = self.loc.LocalizeString("FUT_POINTS_ABBR")
    data.relegationLabel = self.loc.LocalizeString("LTXT_SEA_RELEGATION")
    if seasonInfo.heldPoints ~= nil then
      data.relegationPoints = seasonInfo.heldPoints - 1
    end
    data.projectionPoints = seasonInfo.projection
    data.promotionPoints = seasonInfo.promotionPoints
    data.promotionLabel = self.loc.LocalizeString("LTXT_SEA_PROMOTION")
    data.championshipPoints = seasonInfo.trohpyPoints
    data.championshipLabel = self.loc.LocalizeString("LTXT_SEA_CHAMPIONSHIP")
    data.division = seasonInfo.division
    data.divisionLabel = self.loc.LocalizeString("LTXT_SEA_DIV")
  end
  if data ~= nil then
    self.im.Publish(binding, data)
  end
end
function FUTHomeHub:_publishOfflineTournament()
  local infoStats = self.services.liveTilesService.GetViewData_FUTHUB_OFFLINE_TOURNAMENT_STATS()
  local button = {
    headline = {
      self.loc.LocalizeString("LTXT_FUT_LIVE_TILE_OFFLINE_TOURNAMENT")
    },
    images = {
      "$FUTHubPlayOfflineTournamentTall"
    }
  }
  if infoStats.tournamentAvailable then
    local infoTournament = self.services.FUTTournamentService.GetOfflineTournamentInfo(infoStats.tournamentID)
    if infoTournament ~= nil and infoTournament.available == true then
      button.description = infoTournament.tournamentName
    end
  end
  self.im.Publish(bndLastPlayedData, button)
end
function FUTHomeHub:_processAccomplishmentsData()
  self.accomplishmentsTileData = {}
  self.accData = self.models.FeatureTileModel:_getTileAccomplishments()
  local accomplishment = {}
  accomplishment.badgeImage = self.accData.assetPath
  accomplishment.numCompletions = self.accData.numCompletion
  accomplishment.isOneTime = self.accData.isOneTime
  accomplishment.name = self.accData.name
  accomplishment.description = self.accData.description
  if self.accData.packId ~= 0 then
    local rewardPack = self.services.FUTStoreService.GetRewardPackInfo(self.accData.packId)
    accomplishment.rewardPackImageId = rewardPack.assetID + 2
    accomplishment.rewardPackName = rewardPack.name
    if rewardPack.assetPath then
      accomplishment.rewardPackAssetPath = rewardPack.assetPath
    end
  end
  accomplishment.coinReward = self.accData.coins
  accomplishment.xpReward = self.accData.xp
  accomplishment.progressAmount = self.accData.progressStep
  accomplishment.progressTarget = self.accData.progressStepTotal
  accomplishment.progressPercentage = accomplishment.progressAmount / accomplishment.progressTarget
  accomplishment.isComplete = false
  if accomplishment.progressAmount == accomplishment.progressTarget then
    accomplishment.isComplete = true
  end
  if not accomplishment.isComplete then
    self.accData.category.categoryDesc = self.loc.LocalizeString(self.accData.category.categoryDesc)
  end
  accomplishment.type = accomplishment.isComplete and "reedem" or "accomplishment"
  if accomplishment.isComplete then
  else
  end
  accomplishment.eventData = {
    vvm = "/flows/mainflow/accomplishments/redeem/RedeemReward.vvm"
  } or self.accData.category
  accomplishment.event = accomplishment.isComplete and "evt_show_overlay" or "evt_show_accomplishment_list"
  accomplishment.viewType = self.viewType
  accomplishment.isNumeral = false
  if accomplishment.progressTarget > 1 or not accomplishment.isOneTime then
    accomplishment.isNumeral = true
  end
  accomplishment.timeRemaining = self.accData.timeRemaining
  local hasTimer = false
  if accomplishment.timeRemaining ~= nil and accomplishment.timeRemaining > -1 then
    if 0 < accomplishment.timeRemaining then
      hasTimer = true
      accomplishment.locTimeRemaining = self.services.PowService.FormatTimeRemaining(accomplishment.timeRemaining)
      self.liveTileTimer = accomplishment.timeRemaining
    else
      accomplishment.locTimeRemaining = self.loc.LocalizeString("FUT_EXPIRED")
    end
  end
  self.accomplishmentsTileData = accomplishment
end
function FUTHomeHub:_publishTransfers()
  local tradePileTile = {}
  tradePileTile = self.services.liveTilesService.GetViewData_FUTHUB_TRADE_VIEW_TRADE_PILE()
  self.im.Publish(bndTradePile, tradePileTile)
end
function FUTHomeHub:_publishSwipableTilesData()
  self.liveTileLists = {}
  local accData = {
    self.accomplishmentsTileData
  }
  table.insert(self.liveTileLists, accData)
  local pExchangeData = self.services.liveTilesService.GetViewData_FUTHUB_HOMEVIEW_PLAYER_EXCHANGE()
  local playerExchangeEnabled = self.services.PlayerExchangeService.IsPlayerExchangeEnabled()
  pExchangeData.enabled = playerExchangeEnabled
  if playerExchangeEnabled == true then
    pExchangeData.clickAction = "act_to_player_exchange"
  end
  pExchangeData.type = "default"
  local playerExchangeTile = {pExchangeData}
  table.insert(self.liveTileLists, playerExchangeTile)
  self:_publishLiveTiles()
end
function FUTHomeHub:_publishLiveTiles()
  if self.liveTileLists ~= nil then
    local dataToPublish = {
      index = 0,
      data = self.liveTileLists
    }
    self.im.Publish(bndLiveTileList, dataToPublish)
  end
end
function FUTHomeHub:handleEvent(eventType, data)
  if eventType == EventTypes.OnCurrentSeasonLoaded then
    if self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS and not data.isOnline then
      self:_onSeasonLoaded(data)
    elseif self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS and data.isOnline then
      self:_onSeasonLoaded(data)
    end
  elseif eventType == EventTypes.HubDataCallback then
    self.isHubLoaded = true
    if self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_SEASONS or self.lastPlayedCompetition == LAST_GAMEMODE_ONLINE_SEASONS then
      self:_loadSeasons()
    elseif self.lastPlayedCompetition == LAST_GAMEMODE_OFFLINE_TOURNAMENTS then
      self:_publishOfflineTournament()
      self.services.FUTTournamentService.LoadTournaments()
    end
    self:_publishTransfers()
  elseif eventType == EventTypes.AccomplishmentProgressionLoaded then
    self:_processAccomplishmentsData()
    self:_publishSwipableTilesData()
  elseif eventType == EventTypes.FUTTournamentListLoaded then
    self.hasTournamentsAvailable = data.hasTournamentsAvailable
    self.im.Publish(bndLastPlayedEnabled, self.hasTournamentsAvailable and self.services.FUTTournamentService.IsOfflineTournamentsKillSwitchOn() == false)
    self.im.Publish(bndLastPlayedLoading, true)
    self:_publishOfflineTournament()
  elseif eventType == EventTypes.OnSeasonLoaded then
    self.services.SeasonService.LoadCurrentSeason(data.isOnline, true)
  elseif eventType == EventTypes.AdBannersDataAvailable then
    if data.screenName == self.screenName then
      local rawData = self.powService.GetAdBannersByScreen(self.screenName)
      local nData = table.getn(rawData)
      if nData > 0 then
        self.advertTileData = rawData
        self:publishBannerData()
      end
    end
  elseif eventType == EventTypes.AdBannersDataNotAvailable and data.screenName == self.screenName then
    self.advertTileData = self.models.CABModel:getFakeData()
    self:publishBannerData()
  end
end
function FUTHomeHub:update(elapsedTime)
  if self.timer ~= nil then
    self.timer:update(elapsedTime)
  end
  self.models.FeatureTileModel:update(elapsedTime)
end
function FUTHomeHub:finalize()
  self.models.FeatureTileModel:finalize()
  self.services.EventManService.UnregisterHandler(self.handlerId)
  self.models.CABModel:finalize()
  self.im.UnregisterAction(ACT_TO_OFFLINE_TOURNAMENTS)
  self.im.Unsubscribe(bndAdvertTitle)
  self.im.Unsubscribe(bndLastPlayedData)
  self.im.Unsubscribe(bndLastPlayedEnabled)
  self.im.Unsubscribe(bndLastPlayedClickAction)
  self.im.Unsubscribe(BND_PROGRESS_BAR_DATA)
  self.im.Unsubscribe(bndTradePile)
  self.im.Unsubscribe(BND_PLAYER_EXCHANGE_ENABLED)
  self.im.Unsubscribe(bndLiveTileList)
end
return FUTHomeHub