-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local SkillGameSelect = {}

local TableUtil, eventmanager = ...
local eEventTypes = eventmanager.FE.FIFA.EventTypes

local BND_LIVE_TILE_PLAY = "bnd_live_tile_play"
local BND_LIVE_TILE_INFO = "bnd_live_tile_info"

function SkillGameSelect:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    events = o.api("EventManagerService"),
    QuickEvents = o.api("QuickEventsService"),
    ScreenInfoService = o.api("ScreenInfoService")
  }
  o.eventHandlerID = o.services.events.RegisterHandler(function(...)
    o:handleEvents(...)
  end)
  o.services.ScreenInfoService.SetScreenName("SkillGameSelect")
  o.services.QuickEvents.RequestQuickEvents()

----------------------
-- MENU PLAY --
----------------------
  o.im.Subscribe(BND_LIVE_TILE_PLAY, function()
    o:BND_LIVE_TILE_PLAY()
  end)
function SkillGameSelect:BND_LIVE_TILE_PLAY()
  local dataToInsert =
  {
    headline = { "PLAY" }
  }
  self.im.Publish(BND_LIVE_TILE_PLAY, dataToInsert)
end

----------------------
-- MENU INFO --
----------------------
  o.im.Subscribe(BND_LIVE_TILE_INFO, function()
    o:BND_LIVE_TILE_INFO()
  end)
function SkillGameSelect:BND_LIVE_TILE_INFO()
  local dataToInsert =
  {
    headline = { "INFO" }
  }
  self.im.Publish(BND_LIVE_TILE_INFO, dataToInsert)
end

  return o
end

function SkillGameSelect:finalize()
  
  self.im.Unsubscribe(BND_LIVE_TILE_PLAY)
  self.im.Unsubscribe(BND_LIVE_TILE_INFO)

  self.services.events.UnregisterHandler(self.eventHandlerID)
  self.services.ScreenInfoService.UnsetScreenName("SkillGameSelect")
end

return SkillGameSelect