-- THIS PATCH WAS DONE BY    VOLTA SPORT    YOUTUBE CHANNEL --

local TableUtil, FUTLoginManager, VirtualButton, eventmanager, CABModel, FeatureTileModel, Timer, Login_Service, QuickEvents_Service = ...
local LoginStatus = FUTLoginManager.FeCards.LoginStatus
local EventTypes = eventmanager.FE.FIFA.EventTypes
local LoginFrom = Login_Service.FE.UXService.BaseService.LoginFrom
local MainHub = {}
local bndFUTTitle = "bnd_live_tile_fut"
local bndSkillGamesTitle = "bnd_live_tile_skill_games"
local bndAccomplishmentsTitle = "bnd_live_tile_accomplishments"
local bndHelpTitle = "bnd_live_tile_help"
local bndAboutTitle = "bnd_live_tile_about"
local bndAdvertTitle = "bnd_live_tile_advert"
local bndEnableFUT = "bnd_enable_fut"
local bndLiveTileList = "bnd_live_tile_list"
local bndQuickMatchTile = "bnd_quick_match_tile"
local bndSmallFutTile = "bnd_small_fut_tile"
local bndCustomiseTile = "bnd_customise_tile"
local bndLiveTileList = "bnd_live_tile_list"
local bndPR = "bnd_pr"
local BND_DEBUG_VISIBILITY = "BND_DEBUG_VISIBILITY"
local BND_SKILL_GAMES_TIMER = "bnd_skill_games_timer"
local ACT_TO_DYNAMIC_SKILL_GAMES = "act_to_dynamic_skill_games"
local ACT_TO_FUT_MODE = "act_to_fut_mode"
local LOGIN_RETRY_TIMER = 300
local DYNAMIC_TILE_INDEX = 2
function MainHub:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  print("MainHub:new()")
  
  o.liveTileLists = {}
  print("MainHub:newliveTileList()")
  
  ----
  table.insert(o.liveTileLists, {
    headline = {
      "ULTIMATE TEAM"
    },
    description = "",
    images = {
   "$_MockUp1"
    },
    clickAction = "act_to_fut_mode",
    autoScaleImageToTileHeight = true
  })
  ----
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MockUp2"
    },
    clickAction = "act_to_fut_mode",
    autoScaleImageToTileHeight = true
  })
  ----  
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MockUp3"
    },
    clickAction = "act_cab_to_quick_match",
    autoScaleImageToTileHeight = true
  })
  ----  
  table.insert(o.liveTileLists, {
    headline = {
      "SKILL GAMES"
    },
    description = "",
    images = {
      "$_MockUp4"
    },
    clickAction = "act_to_skill_games",
    autoScaleImageToTileHeight = true
  })
  ----
  table.insert(o.liveTileLists, {
    headline = {
      o.loc.LocalizeString("LTXT_MOB_HELP_TOUR")
    },
    description = "",
    images = {
      "$_MockUp5"
    },
    clickAction = "act_to_fut_mode",
    autoScaleImageToTileHeight = true
  })
  ----
  table.insert(o.liveTileLists, {
    headline = {
      "QUICK PLAY MODES"
    },
    subHeadline = " \n Dive into action \n or \n practice your FIFA skills.",
    images = {
      "$_MockUp6"
    },
    clickAction = "act_quick_match_mode",
    autoScaleImageToTileHeight = true
  })
  ----  
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MockUp7"
    },
    clickAction = "act_to_fut_mode",
    autoScaleImageToTileHeight = true
  })
  ----  
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MockUp8"
    },
    clickAction = "act_quick_match_mode",
    autoScaleImageToTileHeight = true
  })
  ----  
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MockUp9"
    },
    clickAction = "act_to_fut_mode",
    autoScaleImageToTileHeight = true
  })
  ----  
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MockUp10"
    },
    clickAction = "",
    autoScaleImageToTileHeight = true
  })  
  ----  
  
  o:updateliveQuickMatchTile()
  o:updateliveSmallFutTile()
  o:updateliveCustomiseTile()
  o.services = {
    liveTilesService = o.api("LiveTilesService"),
    userinfo = o.api("FUTUserInfoService"),
    futsquadmgmt = o.api("FUTSquadManagementService"),
    EventManagerService = o.api("EventManagerService"),
    LoginService = o.api("LoginService"),
    SpeechDownloadService = o.api("SpeechDownloadService"),
    QuickEvents = o.api("QuickEventsService")
  }
  o.powService = o.api("PowService")
  o.screenName = "worldmainhub"
  o.models = {
    CABModel = CABModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      screenName = o.screenName
    }),
    FeatureTileModel = FeatureTileModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      viewType = "normal",
      imageScale = 1
    })
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  o.futTileData = {}
  o.accomplishmentsTileData = {}
  o.isFUTReady = false
  o.showLoginFailure = true
  o.haveDynamicSkillGames = false
  local loginStatus = o.services.userinfo.GetLoginStatus()
  if loginStatus == LoginStatus.LS_CONNECTED then
    o.services.futsquadmgmt.LoadActiveSquad()
    o.isFUTReady = true
  end
  o.futTileData = o.services.liveTilesService.GetViewData_MAINHUB_FUT()
  o.accomplishmentsTileData = o.services.liveTilesService.GetViewData_MAINHUB_ACCOMPLISHMENTS()
  o.helpTileData = o.services.liveTilesService.GetViewData_MAINHUB_HELP()
  o.aboutTileData = o.services.liveTilesService.GetViewData_MAINHUB_ABOUT()
  o.services.liveTilesService.OnMainMenuEnter()
  o.advertTileData = {}
  o.debugVisibility = true
  if EA_FINAL == true and RL_BUILD == true then
    o.debugVisibility = false
  end
  o.im.RegisterAction(ACT_TO_DYNAMIC_SKILL_GAMES, function()
    o.services.QuickEvents.SelectQuickEvent(o.skillgameID.uuid_upper, o.skillgameID.uuid_lower)
    o.nav.Event(nil, "evt_to_dynamic_skill_games")
  end)
  o.im.RegisterAction(ACT_TO_FUT_MODE, function()
    if o.services.userinfo.GetFirstTimeFlow() == true then
      o.nav.Event(nil, "evt_to_play_mode")
    else
      o.nav.Event(nil, "evt_to_fut_mode")
    end
  end)
  o.im.Subscribe(BND_DEBUG_VISIBILITY, function()
    o.im.Publish(BND_DEBUG_VISIBILITY, o.debugVisibility)
  end)
  o.im.Subscribe(bndFUTTitle, function()
    o.im.Publish(bndFUTTitle, o.futTileData)
  end)
  o.im.Subscribe(bndAccomplishmentsTitle, function()
    o.im.Publish(bndAccomplishmentsTitle, o.accomplishmentsTileData)
  end)
  o.im.Subscribe(bndHelpTitle, function()
    o.im.Publish(bndHelpTitle, o.helpTileData)
  end)
  o.im.Subscribe(bndAboutTitle, function()
    o.im.Publish(bndAboutTitle, o.aboutTileData)
  end)
  o.im.Subscribe(bndAdvertTitle, function()
    o:publishBannerData()
  end)
  o.im.Subscribe(bndEnableFUT, function()
    o.im.Publish(bndEnableFUT, o.isFUTReady)
  end)
  
  local PRlabel = "$PlayerRender" 
  math.randomseed(os.clock() * 1357 + os.time())
  local PRid = math.random(8)
  local PR = PRlabel..PRid
  o.im.Subscribe(bndPR, function()
    o.im.Publish(bndPR, PR)
  end)
  
  o.im.Subscribe(bndLiveTileList, function()
    o:_publishLiveTiles()
  end)
  
  o.helpAboutTile = {}
  o.helpTileData.clickAction = "act_to_help_hub"
  o.aboutTileData.clickAction = "act_to_about_hub"
  o.helpTileData.autoScaleImageToTileHeight = true
  o.aboutTileData.autoScaleImageToTileHeight = true
  table.insert(o.helpAboutTile, o.helpTileData)
  table.insert(o.helpAboutTile, o.aboutTileData)
  o.im.Subscribe(bndLiveTileList, function()
    o:_publishLiveTiles()
  end)
  o.im.Subscribe(BND_SKILL_GAMES_TIMER, function()
  end)
  o:_getSkillGameData()
  o.im.Subscribe(bndSkillGamesTitle, function()
    o:_publishSkillGameTiles()
  end)
  o.powService.RequestAdBannersByScreen(o.screenName)
  return o
end
function MainHub:_getSkillGameData()
  print("_getSkillGameData")
  self.skillGamesTileData = self.services.liveTilesService.GetViewData_MAINHUB_SKILL_GAMES()
  self.skillGamesDynamicTileData = self.services.QuickEvents.GetViewData_MAINHUB_DYNAMIC_SKILL_GAMES()
  local isQuickEventsDisabled = self.services.QuickEvents.IsQuickEventsDisabled()
  self.skillGameTile = {}
  self.skillGamesTileData.autoScaleImageToTileHeight = true
  self.skillGamesTileData.clickAction = "act_to_skill_games"
  self.skillGamesTileData.enabled = isQuickEventsDisabled == false
  table.insert(self.skillGameTile, self.skillGamesTileData)
  if isQuickEventsDisabled == false and self.skillGamesDynamicTileData.uuid_upper ~= nil then
    self.skillgameID = {}
    self.skillgameID.uuid_upper = self.skillGamesDynamicTileData.uuid_upper
    self.skillgameID.uuid_lower = self.skillGamesDynamicTileData.uuid_lower
    self.skillGamesDynamicTileData.clickAction = "act_to_dynamic_skill_games"
    self.skillGamesDynamicTileData.bindings = {
      {binding = BND_SKILL_GAMES_TIMER, property = "locTime"}
    }
    table.insert(self.skillGameTile, self.skillGamesDynamicTileData)
    self.haveDynamicSkillGames = true
  end
end
function MainHub:_publishSkillGameTiles()
  print("_publishSkillGameTiles")
  local dataToPublish = {
    index = 0,
    data = self.skillGameTile
  }
  self.im.Publish(bndSkillGamesTitle, dataToPublish)
end
function MainHub:_publishLiveTiles()
  local dataToPublish = {
    index = 0,
    data = self.helpAboutTile
  }
  self.im.Publish(bndLiveTileList, dataToPublish)
end
function MainHub:handleEvent(eventType, data)
  if eventType == EventTypes.OnLoggedIn then
    self:onLoggedIn()
  elseif eventType == EventTypes.AdBannersDataAvailable then
    if data.screenName == self.screenName then
      local rawData = self.powService.GetAdBannersByScreen(self.screenName)
      local nData = table.getn(rawData)
      if 0 < nData then
        self.advertTileData = rawData
        self:publishBannerData()
      end
    end
  elseif eventType == EventTypes.AdBannersDataNotAvailable then
    if data.screenName == self.screenName then
      self.advertTileData = self.models.CABModel:getFakeData()
      self:publishBannerData()
    end
  elseif eventType == EventTypes.AdBannerImageDownloadComplete then
    for i = 1, #self.advertTileData do
      if self.advertTileData[i].image ~= nil and data.image ~= nil then
        local findIndex = string.find(self.advertTileData[i].image, data.image)
        if findIndex ~= nil then
          self.advertTileData[i].downloadState = data.success
          self:publishBannerData()
        end
      end
    end
  elseif eventType == EventTypes.DeepLinkRedirect then
    print("MainHub:DeepLinkRedirect:", data.actionLink)
    if data.actionLink == "act_cab_buy_fifa_points" then
      self.nav.Event(nil, "evt_to_store", {redirect = "fifapoints"})
    elseif data.actionLink == "act_cab_to_store_my_packs" then
      self.nav.Event(nil, "evt_to_store", {redirect = "unassigned"})
    elseif data.actionLink == "act_cab_to_store_shop" then
      self.nav.Event(nil, "evt_to_store", {
        redirect = "consumablepacks"
      })
    elseif data.actionLink == "act_cab_to_store_player" then
      self.nav.Event(nil, "evt_to_store", {
        redirect = "regularpacks"
      })
    elseif data.actionLink == "act_cab_to_store" then
      self.nav.Event(nil, "evt_to_store", {redirect = "shop"})
    elseif data.actionLink == "act_cab_to_accomplishments" then
      self.nav.Event(nil, "evt_to_user_bio", {isInGame = false})
    elseif data.actionLink == "act_cab_to_fut_online_tournaments" then
      self.nav.Event(nil, "evt_shortcut_to_fut_online_tournaments")
    elseif data.actionLink == "act_cab_to_fut_offline_tournaments" then
      self.nav.Event(nil, "evt_shortcut_to_fut_offline_tournaments")
    elseif data.actionLink == "act_cab_to_fut_online_seasons" then
      self.nav.Event(nil, "evt_shortcut_to_fut_online_seasons")
    elseif data.actionLink == "act_cab_to_fut_offline_seasons" then
      self.nav.Event(nil, "evt_shortcut_to_fut_offline_seasons")
    elseif data.actionLink == "act_cab_to_fut_auction_house" then
      self.nav.Event(nil, "evt_shortcut_to_fut_auction_house")
    elseif data.actionLink == "act_cab_to_quick_event " then
      self.nav.Event(nil, "evt_to_skill_games")
    end
  end
end
function MainHub:publishBannerData()
  if self.advertTileData ~= nil then
    local dataToPublishAdvert = {
      index = 0,
      data = self.advertTileData
    }
    self.im.Publish(bndAdvertTitle, dataToPublishAdvert)
  end
end
function MainHub:showNoFutPopup()
  if self.showLoginFailure then
    local buttonOk = VirtualButton:new({
      nav = self.nav,
      label = "LTXT_CMN_OK",
      clickEvents = {
        "evt_hide_popup"
      }
    })
    local popupData = {
      title = "LTXT_CMN_SERVER_ERROR",
      message = "LTXT_MM_FUTISDOWN_PU",
      buttons = {buttonOk}
    }
    self.nav.Event(nil, "evt_show_popup", popupData)
    self.showLoginFailure = false
  end
end
function MainHub:updateliveTileFUT()
end
function MainHub:onLoggedIn()
  local isFUTReady = self.isFUTReady
  local loginStatus = self.services.userinfo.GetLoginStatus()
  if loginStatus == LoginStatus.LS_CONNECTED then
    self.services.futsquadmgmt.LoadActiveSquad()
    self.isFUTReady = true
  else
    self:showNoFutPopup()
    self.isFUTReady = false
  end
  if isFUTReady ~= self.isFUTReady then
    self:updateliveTileFUT()
  end
end
function MainHub:update(elapsedTime)
  if self.haveDynamicSkillGames then
    local updatedTimes = self.services.QuickEvents.GetUpdatedTimes_MAINHUB_DYNAMIC_SKILL_GAMES()
    if updatedTimes.timer <= 0 then
      self:_getSkillGameData()
      self:_publishSkillGameTiles()
    elseif self.skillGameTile[DYNAMIC_TILE_INDEX].timer ~= updatedTimes.timer then
      self.skillGameTile[DYNAMIC_TILE_INDEX].timer = updatedTimes.timer
      self.im.Publish(BND_SKILL_GAMES_TIMER, updatedTimes.locTimer)
    end
  end
  if self.timer ~= nil then
    self.timer:update(elapsedTime)
  end
  self.models.FeatureTileModel:update(elapsedTime)
end

function MainHub:updateliveQuickMatchTile()
  print("MainHub:updateliveQuickMatchTile()")
  local tileData = {
    headline = {
      self.loc.LocalizeString("LTXT_MOB_KICK_OFF")
    },
    
    images = {
      "$_QuickMatchLiveTile"
    },
    status = "none",
    autoScaleImageToTileHeight = true
  }
  self.im.Subscribe(bndQuickMatchTile, function()
    self.im.Publish(bndQuickMatchTile, tileData)
  end)
end

function MainHub:updateliveSmallFutTile()
  print("MainHub:updateliveSmallFutTile()")
  local tileData = {
    headline = {
      self.loc.LocalizeString("LTXT_MHUB_LIVE_TILE_ULTIMATE")
    },
    subHeadline = "",
    images = {
      "$_UltimateLiveTileSmall"
    },
    status = "none",
    autoScaleImageToTileHeight = true
  }
  self.im.Subscribe(bndSmallFutTile, function()
    self.im.Publish(bndSmallFutTile, tileData)
  end)
end

function MainHub:updateliveCustomiseTile()
  print("MainHub:updateliveCustomiseTile()")
  local tileData = {
    headline = {
      self.loc.LocalizeString("LTXT_CMN_NAVIGATION_BAR_SETTINGS_CUSTOMIZE")
    },
    images = {
      "$_CustomiseLiveTile"
    },
    status = "none",
    autoScaleImageToTileHeight = true
  }
  self.im.Subscribe(bndCustomiseTile, function()
    self.im.Publish(bndCustomiseTile, tileData)
  end)
end

function MainHub:_publishLiveTiles()
  local dataToPublish = {
    index = 0,
    data = self.liveTileLists
  }
  self.im.Publish(bndLiveTileList, dataToPublish)
end

function MainHub:finalize()
  print("MainHub:finalize()")
  self.models.CABModel:finalize()
  self.models.FeatureTileModel:finalize()
  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  self.im.Unsubscribe(bndLiveTileList)
  self.im.Unsubscribe(bndFUTTitle)
  self.im.Unsubscribe(bndSkillGamesTitle)
  self.im.Unsubscribe(bndEnableFUT)
  self.im.Unsubscribe(bndAccomplishmentsTitle)
  self.im.Unsubscribe(bndHelpTitle)
  self.im.Unsubscribe(bndAboutTitle)
  self.im.Unsubscribe(bndAdvertTitle)
  self.im.UnregisterAction(ACT_TO_DYNAMIC_SKILL_GAMES)
  self.im.UnregisterAction(ACT_TO_FUT_MODE)
  self.im.Unsubscribe(BND_DEBUG_VISIBILITY)
  self.im.Unsubscribe(BND_SKILL_GAMES_TIMER)
  self.im.Unsubscribe(bndQuickMatchTile)
  self.im.Unsubscribe(bndSmallFutTile)
  self.im.Unsubscribe(bndCustomiseTile)
  self.im.Unsubscribe(bndPR)
  self.im.Unsubscribe(bndLiveTileList)
end
return MainHub
-- THIS PATCH WAS DONE BY    VOLTA SPORT    YOUTUBE CHANNEL --