-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local SelectStadium = {}

local TableUtil = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_SELECTED_STADIUM = "bnd_selected_stadium"

function SelectStadium:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    matchSetup = o.api("MatchSetupService"),
    gameSetup = o.api("GameSetupService"),
    gameState = o.api("GameStateService"),
    preGame = o.api("PregameService"),
    EventManagerService = o.api("EventManagerService")
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  
  o.selectedStadium = {
    image = {
      name = o.assetsType[STADIUM],
      id = stadiumInfo.assetId
    }
  }
  o.assetsType[STADIUM] = "$Stadium"
  
  o.im.Subscribe(BND_SELECTED_STADIUM, function()
    o:_publishSelectedStadium(o.selectedStadium.image)
  end)

  return o
end

function SelectStadium:_publishSelectedStadium(image)
  self.im.Publish(BND_SELECTED_STADIUM, image)
end

function SelectStadium:finalize()

  self.im.Unsubscribe(BND_SELECTED_STADIUM)

return SelectStadium