-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local EditAcronymPopup = {}

local cardserrors, eventmanager = ...
local eErrorCode = cardserrors.FUT.FutServerError
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_NAME_VALID = "bnd_name_valid"
local BND_ABBR_VALID = "bnd_abbr_valid"
local BND_NAME_INVALID = "bnd_name_invalid"
local BND_ABBR_INVALID = "bnd_abbr_invalid"
local BND_CLUB_NAME = "bnd_club_name"
local BND_AUTO_ABBR = "bnd_auto_abbr"
local BND_NAME_BG = "bnd_name_field_background"
local BND_ABBR_BG = "bnd_abbr_field_background"
local BND_ERROR_MESSAGE = "bnd_error_message"

local NAME_MIN_LENGTH = 5
local NAME_MAX_LENGTH = 50
local ABBR_LENGTH = 3

local NORMAL_BG = "$InputTextFieldBacking"
local VALID_BG = "$InputTextFieldGreenBacking"
local INVALID_BG = "$InputTextFieldRedBacking"

local ACT_CONFIRM = "act_confirm"
local ACT_TEXT_CHANGE = "act_text_change"
local ACT_ABBR_CHANGE = "act_abbr_change"

local SINGLE_LINE_Y = 60
local DOBLE_LINE_Y = 30

function EditAcronymPopup:new(init)
  print("[EditAcronymPopup]: new()")
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    eventManService = o.api("EventManagerService"),
    FUTUserInfoService = o.api("FUTUserInfoService"),
    misc = o.api("MiscService")
  }
  o.handlerId = o.services.eventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  o.squadName = o.services.FUTUserInfoService.GetClubName()
  o.squadAbbr = o.services.FUTUserInfoService.GetClubAbbrName()
  o.im.Subscribe(BND_CLUB_NAME, function()
    o.im.Publish(BND_CLUB_NAME, o.squadName)
  end)
  o.im.Subscribe(BND_AUTO_ABBR, function()
    o.im.Publish(BND_AUTO_ABBR, o.squadAbbr)
  end)
  o.im.Subscribe(BND_NAME_VALID, function()
    o:_publishNameValid(true)
  end)
  o.im.Subscribe(BND_ABBR_VALID, function()
    o:_publishAbbrValid(true)
  end)
  o.im.Subscribe(BND_NAME_INVALID, function()
    o:_publishNameValid()
  end)
  o.im.Subscribe(BND_ABBR_INVALID, function()
    o:_publishAbbrValid()
  end)
  o.im.Subscribe(BND_NAME_BG, function()
    o:_publishNameValid(true)
  end)
  o.im.Subscribe(BND_ABBR_BG, function()
    o:_publishAbbrValid(true)
  end)
  o.im.Subscribe(BND_ERROR_MESSAGE, function()
    o.im.Publish(BND_ERROR_MESSAGE, "")
  end)
  o.im.RegisterAction(ACT_TEXT_CHANGE, function(actionName, data)
    if o.squadName ~= o:trim(data.text) then
      o.squadName = o:trim(data.text)
      local isValid = o.services.misc.IsValidName(o.squadName) and o.squadName ~= "" and string.len(o.squadName) >= NAME_MIN_LENGTH
      o:_publishNameValid(isValid)
      o.squadAbbr = string.sub(string.gsub(o.squadName, "%s+", ""), 1, 3)
      o:_publishAutoAbbr(string.upper(o.squadAbbr))
    end
  end)
  o.im.RegisterAction(ACT_ABBR_CHANGE, function(actionName, data)
    o.squadAbbr = o:trim(data.text)
    o:_publishAutoAbbr(string.upper(o.squadAbbr))
  end)
  o.im.RegisterAction(ACT_CONFIRM, function(actionName, data)
    local title = ""
    local message = ""
    if o.services.misc.IsValidName(o.squadName) and o.services.misc.IsValidName(o.squadAbbr) then
      if o.squadName ~= "" and o.squadAbbr ~= "" and string.len(o.squadName) >= NAME_MIN_LENGTH and string.len(o.squadAbbr) >= ABBR_LENGTH then
        o.nav.Event(nil, "evt_show_blocking_load")
        o.services.FUTUserInfoService.ChangeClubName(o.squadName, o.squadAbbr)
      elseif string.len(o.squadName) < NAME_MIN_LENGTH then
        message = o.squadName == "" and "LTXT_FTF_MUST_ENTER_CLUB_NAME" or "LTXT_CLUB_NAME_TOO_SHORT"
        o.im.Publish(BND_ERROR_MESSAGE, o.loc.LocalizeString(message))
      elseif string.len(o.squadAbbr) < ABBR_LENGTH then
        message = o.squadAbbr == "" and "LTXT_FTF_MUST_ENTER_CLUB_ABBR" or "LTXT_FTF_CLUB_ABBR_TOO_SHORT"
        o.im.Publish(BND_ERROR_MESSAGE, o.loc.LocalizeString(message))
      end
    else
      o.im.Publish(BND_ERROR_MESSAGE, o.loc.LocalizeString(o.loc.LocalizeString("LTXT_CREATE_SQUAD_SPECIAL_CHARACTERS")))
    end
  end)
  return o
end

function EditAcronymPopup:_publishAutoAbbr(abbr)
  if abbr ~= nil then
    self.squadAbbr = self:trim(abbr)
    local isValid = self.services.misc.IsValidName(self.squadAbbr) and self.squadAbbr ~= "" and string.len(self.squadAbbr) >= ABBR_LENGTH
    self:_publishAbbrValid(isValid)
    self.im.Publish(BND_AUTO_ABBR, self.squadAbbr)
  end
  self.im.Publish(BND_ERROR_MESSAGE, "")
end

function EditAcronymPopup:_publishNameValid(valid)
  if valid == nil then
    self.im.Publish(BND_NAME_VALID, false)
    self.im.Publish(BND_NAME_INVALID, false)
  else
    self.im.Publish(BND_NAME_VALID, valid)
    self.im.Publish(BND_NAME_INVALID, not valid)
    self.im.Publish(BND_NAME_BG, valid and VALID_BG or INVALID_BG)
  end
end

function EditAcronymPopup:_publishAbbrValid(valid)
  if valid == nil then
    self.im.Publish(BND_ABBR_VALID, false)
    self.im.Publish(BND_ABBR_INVALID, false)
  else
    self.im.Publish(BND_ABBR_VALID, valid)
    self.im.Publish(BND_ABBR_INVALID, not valid)
    self.im.Publish(BND_ABBR_BG, valid and VALID_BG or INVALID_BG)
  end
end

function EditAcronymPopup:trim(s)
  return (s:gsub("^%s*(.-)%s*$", "%1"))
end

function EditAcronymPopup:onChangeClubName(errorcode)
  if errorcode == eErrorCode.CARDS_ERR_OK then
    self.data.callBack(self.squadName)
    self.nav.Event(nil, "evt_hide_overlay")
  elseif errorcode == eErrorCode.CARDS_CB_ERR_PROFANITY then
    self.nav.Event(nil, "evt_hide_blocking_load")
    self:_publishNameValid(false)
    self:_publishAbbrValid(false)
    self.im.Publish(BND_ERROR_MESSAGE, self.loc.LocalizeString("FUT_CLUB_NAME_ERR"))
  else
    self.nav.Event(nil, "evt_hide_blocking_load")
    self.im.Publish(BND_ERROR_MESSAGE, self.loc.LocalizeString("CARDS_CB_ERR_INVALID_ARGUMENT"))
  end
end

function EditAcronymPopup:handleEvent(eventType, data)
  if eventType == EventTypes.FutClubRenameComplete then
    self:onChangeClubName(data.error)
  elseif eventType == EventTypes.OnBackPressed then
    self.nav.Event(nil, "evt_hide_overlay")
  end
end

function EditAcronymPopup:finalize()
  print("[EditAcronymPopup]: finalize()")
  self.im.UnregisterAction(ACT_CONFIRM)
  self.im.UnregisterAction(ACT_TEXT_CHANGE)
  self.im.UnregisterAction(ACT_ABBR_CHANGE)
  self.im.Unsubscribe(BND_NAME_VALID)
  self.im.Unsubscribe(BND_NAME_INVALID)
  self.im.Unsubscribe(BND_ABBR_VALID)
  self.im.Unsubscribe(BND_ABBR_INVALID)
  self.im.Unsubscribe(BND_CLUB_NAME)
  self.im.Unsubscribe(BND_AUTO_ABBR)
  self.im.Unsubscribe(BND_NAME_BG)
  self.im.Unsubscribe(BND_ABBR_BG)
  self.im.Unsubscribe(BND_ERROR_MESSAGE)
  self.nav.Event(nil, "evt_hide_blocking_load")
  self.services.eventManService.UnregisterHandler(self.handlerId)
end

return EditAcronymPopup