-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local EventInfo = {}

local OverlaysIdContainer, OverlayParam, eventmanager = ...
local Overlays = OverlaysIdContainer.Overlays.OVERLAY_TYPE
local EventTypes = eventmanager.FE.FIFA.EventTypes

local initialized = false

local BND_VISIBLE = "bnd_visible"
local BND_NATIONALIZATION = "bnd_nationalization"
local BND_DATA = "bnd_data"
local BND_ALPHA = "bnd_alpha"

function EventInfo:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.nationalization = 2
  o.services = {
    EventManagerService = o.api("EventManagerService")
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  
  o.im.Subscribe(BND_NATIONALIZATION, function()
  end)
  o.im.Subscribe(BND_VISIBLE, function()
    o.im.Publish(BND_VISIBLE, false)
  end)
  o.im.Subscribe(BND_ALPHA, function()
  end)
  o.im.Subscribe(BND_DATA, function()
  end)
  
  return o
end

function EventInfo:handleEvent(eventType, data)
  if eventType == EventTypes.OverlayTypeIngameCardInjury then
    self:updateEventInfo(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
  if eventType == EventTypes.OverlayTypeGoal then
    self:updateGoalScored(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
end

-- Bagian Info Event Seperti Pemain Yang di Kartu Atau Cidera --
function EventInfo:updateEventInfo(subtype, hideshow, subtypestr, msg)
  local params = OverlayParam.split(msg, "|")
  if hideshow == "SHOW" then
    if initialized == false then
      self.im.Publish(BND_NATIONALIZATION, self.nationalization)
      initialized = true
    end
    if params and table.getn(params) > 0 then
      self.im.Publish(BND_VISIBLE, true)
      local bottomText = ""
      local showBottomText = false
      if #params == 7 then
        bottomText = params[7]
        showBottomText = true
      end
      local eventInfo = {
        team = params[3],
        kitNumber = params[5],
        playerName = params[6],
        bottomText = bottomText,
        showBottomText = showBottomText,
        iconType = params[4] + 0
      }
      self.im.Publish(BND_DATA, eventInfo)
    end
  elseif hideshow == "UPDATE" then
    self.im.Publish(BND_ALPHA, params[1] / 100)
  else
    self.im.Publish(BND_VISIBLE, false)
  end
end

-- Bagian Info Pencetak Gol --
function EventInfo:updateGoalScored(subtype, hideshow, subtypestr, msg)
  if hideshow ~= "HIDE" then
    if initialized == false then
      self.im.Publish(BND_NATIONALIZATION, self.nationalization)
      initialized = true
    end
    local params = OverlayParam.split(msg, "|")
    if params and table.getn(params) > 0 then
      self.im.Publish(BND_VISIBLE, true)
      local bottomText = ""
      local showBottomText = false
      local goalScored = {
        kitNumber = "",
        bottomText = bottomText,
        showBottomText = showBottomText,
        iconType = params[13] + 0,
        playerName = params[14],
        team = params[15]
      }
      self.im.Publish(BND_DATA, goalScored)
    end
  else
    self.im.Publish(BND_VISIBLE, false)
  end
end

function EventInfo:finalize()

  self.im.Unsubscribe(BND_VISIBLE)
  self.im.Unsubscribe(BND_ALPHA)
  self.im.Unsubscribe(BND_DATA)
  self.im.Unsubscribe(BND_NATIONALIZATION)
  
  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  
end

return EventInfo

-- MOD Keren dari YouTube Ma'ruf ID --