local TableUtil, CommonNavVars, GameStateServiceEnums, OverlayParam, EventManager = ...
local GameMenu = {}
local BND_HOME_PAUSES = "bnd_home_team_pauses"
local BND_AWAY_PAUSES = "bnd_away_team_pauses"
local BND_HOME_USER_DATA = "bnd_home_user_data"
local BND_AWAY_USER_DATA = "bnd_away_user_data"
local BND_HOME_TEAM_CREST = "bnd_home_team_crest"
local BND_HOME_TEAM_CREST3 = "bnd_home_team_crest3"
local BND_AWAY_TEAM_CREST3 = "bnd_away_team_crest3"
local BND_AWAY_TEAM_CREST = "bnd_away_team_crest"
local BND_TEAM_MAN_HOME = "bnd_team_man_home"
local BND_TEAM_MAN_AWAY = "bnd_team_man_away"
local BND_HOME_TEAM_NAME_ABBR = "bnd_home_team_name_abbr"
local BND_AWAY_TEAM_NAME_ABBR = "bnd_away_team_name_abbr"
local BND_HOME_TEAM_NAME = "bnd_home_team_name"
local BND_AWAY_TEAM_NAME = "bnd_away_team_name"
local BND_RESULT = "bnd_result"
local BND_SHOOTOUT_RESULT = "bnd_shootout_result"
local BND_MATCH_TYPE = "bnd_match_type"
local BND_GAME_STATE = "bnd_game_state"
local BND_STADIUM_NAME = "bnd_stadium_name"
local BND_TIME = "bnd_time"
local BND_MATCH_FACTS = "bnd_match_facts"
local BND_LIVE_TILE_RESUME = "bnd_live_tile_resume"
local BND_LIVE_TILE_SQUAD = "bnd_live_tile_squad"
local bndLiveTileList = "bnd_live_tile_list"
local bndLiveTileList2 = "bnd_live_tile_list2"
local BND_LIVE_TILE_REPLAY = "bnd_live_tile_replay"
local BND_LIVE_TILE_SETTINGS = "bnd_live_tile_settings"
local BND_LIVE_TILE_MATCH_FACTS = "bnd_live_tile_match_facts"
local BND_LIVE_TILE_CAPTURED_MEDIA = "bnd_live_tile_captured_media"
local BND_LIVE_TILE_CAPTURED_MEDIA_ENABLED = "bnd_live_tile_captured_media_enabled"
local BND_LIVE_TILE_QUIT = "bnd_live_tile_quit"
local BND_LIVE_TILE_QUIT_TO_HUB = "bnd_live_tile_quit_to_hub"
local BND_SHOW_ONLINE_INFO = "bnd_show_online_info"
local BND_SHOW_OFFLINE_INFO = "bnd_show_offline_info"
local BND_LIVE_TILE_MATCH_HIGHLIGHTS = "bnd_live_tile_match_highlights"
local BND_LIVE_TILE_REPLAY_ENABLED = "bnd_live_tile_replay_enable"
local ACT_TOGGLE_PAUSE = "act_toggle_pause"
local ACT_FORFEIT_MATCH = "act_forfeit_match"
local ACT_QUIT_MATCH = "act_quit_match"
local ACT_RESTART_MATCH = "act_restart_match"
local ACT_TO_INGAME_SQUAD = "act_to_ingame_squad"
local ACT_TO_INGAME_SQUADAWAY = "act_to_ingame_squadaway"
local EVENT_TYPES = EventManager.FE.FIFA.EventTypes
local BACK_KEY_PRESSED = GameStateServiceEnums.FE.UXService.GameStateServiceListener.BACK_KEY_PRESSED
function GameMenu:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.navContext = o.data
  o.flow = o.navContext.flow
  print("[GameMenu]: new(gamemode = " .. tostring(o.navContext.gamemode) .. ", flow = " .. tostring(o.navContext.flow) .. ", type = " .. tostring(o.navContext.type) .. ", gameState = " .. tostring(o.navContext.gameState) .. ")")
  o.services = {
    GameStateService = o.api("GameStateService"),
    MatchInfoService = o.api("MatchInfoService"),
    OverlayService = o.api("OverlayService"),
    GameSetupService = o.api("GameSetupService"),
    SocialService = o.api("SocialService"),
    PauseMenuService = o.api("PauseMenuService"),
    SeasonProgressService = o.api("SeasonProgressService"),
    SettingsService = o.api("SettingsService"),
    UserPlateService = o.api("UserPlateService"),
    MediaCaptureService = o.api("MediaCaptureService"),
    ReplayService = o.api("ReplayService"),
    ScreenInfoService = o.api("ScreenInfoService"),
    DNFService = o.api("DNFService"),
    EventManagerService = o.api("EventManagerService")
  }
  o.im.RegisterAction(ACT_TOGGLE_PAUSE, function(actionName)
    o:resumeMatch()
  end)
  o.im.RegisterAction(ACT_FORFEIT_MATCH, function(actionName)
    o:forfeitMatch()
  end)
  o.im.RegisterAction(ACT_QUIT_MATCH, function(actionName)
    o:quitMatch()
  end)
  o.im.RegisterAction(ACT_RESTART_MATCH, function(actionName)
    o:restartMatch()
  end)
  o.im.RegisterAction(ACT_TO_INGAME_SQUAD, function(actionName)
    o.nav.Event(nil, "evt_to_ingame_squad")
  end)
  o.im.RegisterAction(ACT_TO_INGAME_SQUADAWAY, function(actionName)
    o.nav.Event(nil, "evt_to_ingame_squadaway")
  end)
  o.eventHandlerID = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  o.im.Subscribe(BND_HOME_PAUSES, function()
    o.im.Publish(BND_HOME_PAUSES, o:getPausesRemaining())
  end)
  o.im.Subscribe(BND_AWAY_PAUSES, function()
    o.im.Publish(BND_AWAY_PAUSES, o:getPausesRemaining(true))
  end)
  o.im.Subscribe(BND_HOME_USER_DATA, function()
    o.im.Publish(BND_HOME_USER_DATA, {
      userImage = o:getAvatarPath(),
      team = o:getTeam().assetId
    })
  end)
  o.im.Subscribe(BND_AWAY_USER_DATA, function()
    o.im.Publish(BND_AWAY_USER_DATA, {
      userImage = o:getAvatarPath(true),
      team = o:getTeam(true).assetId
    })
  end)
  o.im.Subscribe(BND_HOME_TEAM_CREST, function()
    o.im.Publish(BND_HOME_TEAM_CREST, o:getTeamCrest())
  end)
o.im.Subscribe(BND_HOME_TEAM_CREST3, function()
    o.im.Publish(BND_HOME_TEAM_CREST3, o:getTeamCrest3())
  end)
  o.im.Subscribe(BND_AWAY_TEAM_CREST3, function()
    o.im.Publish(BND_AWAY_TEAM_CREST3, o:getTeamCrest3(true))
  end)
  o.im.Subscribe(BND_AWAY_TEAM_CREST, function()
    o.im.Publish(BND_AWAY_TEAM_CREST, o:getTeamCrest(true))
  end)
  o.im.Subscribe(BND_TEAM_MAN_HOME, function()
    o.im.Publish(BND_TEAM_MAN_HOME, o:getManCrest())
  end)
  o.im.Subscribe(BND_TEAM_MAN_AWAY, function()
    o.im.Publish(BND_TEAM_MAN_AWAY, o:getManCrest(true))
  end)
  o.im.Subscribe(BND_HOME_TEAM_NAME_ABBR, function()
    o.im.Publish(BND_HOME_TEAM_NAME_ABBR, o:getTeam().teamNameAbbr)
  end)
  o.im.Subscribe(BND_AWAY_TEAM_NAME_ABBR, function()
    o.im.Publish(BND_AWAY_TEAM_NAME_ABBR, o:getTeam(true).teamNameAbbr)
  end)
  o.im.Subscribe(BND_HOME_TEAM_NAME, function()
    o.im.Publish(BND_HOME_TEAM_NAME, o:getTeam().teamName)
  end)
  o.im.Subscribe(BND_AWAY_TEAM_NAME, function()
    o.im.Publish(BND_AWAY_TEAM_NAME, o:getTeam(true).teamName)
  end)
  o.im.Subscribe(BND_RESULT, function()
    o.im.Publish(BND_RESULT, o.services.MatchInfoService.GetMatchResult())
  end)
  o.im.Subscribe(BND_SHOOTOUT_RESULT, function()
    o.im.Publish(BND_SHOOTOUT_RESULT, o:getShootoutResult())
  end)
  o.im.Subscribe(BND_MATCH_TYPE, function()
    o.im.Publish(BND_MATCH_TYPE, o:getMatchType())
  end)
  o.im.Subscribe(BND_GAME_STATE, function()
    o.im.Publish(BND_GAME_STATE, o:getGameState())
  end)
  o.im.Subscribe(BND_STADIUM_NAME, function()
    o.im.Publish(BND_STADIUM_NAME, o.services.SettingsService.GetCurrentOptions().stadium)
  end)
  o.im.Subscribe(BND_TIME, function()
    o.im.Publish(BND_TIME, o.services.OverlayService.GetGameClockString())
  end)
  o.im.Subscribe(BND_MATCH_FACTS, function()
    o.im.Publish(BND_MATCH_FACTS, o:getMatchFacts())
  end)
  o.im.Subscribe(BND_LIVE_TILE_RESUME, function()
    o.im.Publish(BND_LIVE_TILE_RESUME, OverlayParam.split(o.loc.LocalizeString("LTXT_TILE_RESUME_MATCH"), " "))
  end)
  o.im.Subscribe(BND_LIVE_TILE_SQUAD, function()
    o.im.Publish(BND_LIVE_TILE_SQUAD, {
      o.loc.LocalizeString("LTXT_SQD_SQUAD")
    })
  end)
  o.im.Subscribe(BND_LIVE_TILE_REPLAY, function()
    o.im.Publish(BND_LIVE_TILE_REPLAY, {
      o.loc.LocalizeString("LTXT_PAUSE_INSTANT_REPLAY")
    })
  end)
  o.im.Subscribe(BND_LIVE_TILE_SETTINGS, function()
    o.im.Publish(BND_LIVE_TILE_SETTINGS, {
      o.loc.LocalizeString("LTXT_CMN_OPTION_CUSTOMIZE")
    })
  end)
  o.im.Subscribe(BND_LIVE_TILE_MATCH_FACTS, function()
    o.im.Publish(BND_LIVE_TILE_MATCH_FACTS, {
      o.loc.LocalizeString("LTXT_MATCH_FACTS"),
      o.loc.LocalizeString("LTXT_AND_EVENTS")
    })
  end)
  o.im.Subscribe(BND_LIVE_TILE_CAPTURED_MEDIA, function()
    o.im.Publish(BND_LIVE_TILE_CAPTURED_MEDIA, OverlayParam.split(o.loc.LocalizeString("LTXT_TILE_SHARE_MEDIA"), " "))
  end)
  o.im.Subscribe(BND_LIVE_TILE_CAPTURED_MEDIA_ENABLED, function()
    o.im.Publish(BND_LIVE_TILE_CAPTURED_MEDIA_ENABLED, o.services.MediaCaptureService.HasCapturedMedia())
  end)
  o.im.Subscribe(BND_LIVE_TILE_QUIT, function()
    o.im.Publish(BND_LIVE_TILE_QUIT, OverlayParam.split(o.loc.LocalizeString("LTXT_TILE_FORFEIT_MATCH"), " "))
  end)
  o.im.Subscribe(BND_LIVE_TILE_QUIT_TO_HUB, function()
    o.im.Publish(BND_LIVE_TILE_QUIT_TO_HUB, OverlayParam.split(o.loc.LocalizeString("LTXT_QUIT_TO_MODE_HUB"), "LTXT_CMN_NAVIGATION_BAR_HOME"))
  end)
  o.im.Subscribe(BND_SHOW_ONLINE_INFO, function()
    o.im.Publish(BND_SHOW_ONLINE_INFO, o.navContext.flow == CommonNavVars.FLOWS.ONLINE)
  end)
  o.im.Subscribe(BND_SHOW_OFFLINE_INFO, function()
    o.im.Publish(BND_SHOW_OFFLINE_INFO, o.navContext.flow == CommonNavVars.FLOWS.OFFLINE)
  end)
  o.im.Subscribe(BND_LIVE_TILE_MATCH_HIGHLIGHTS, function()
    o.im.Publish(BND_LIVE_TILE_MATCH_HIGHLIGHTS, {
      headline = {
        o.loc.LocalizeString("LTXT_TILE_MATCH_HIGHLIGHTS"),
        o.loc.LocalizeString("LTXT_TILE_MATCH_HIGHLIGHTS_LINE2")
      }
    })
  end)
  o.liveTileLists = {}
  table.insert(o.liveTileLists, {
    headline = {
      o.loc.LocalizeString("LTXT_SQD_SQUAD")
    },
    subHeadline = "HOME",
    images = {
      o:getTeamCrest()
    },
    autoScaleImageToTileHeight= true,
    clickAction = ACT_TO_INGAME_SQUAD
  })
  table.insert(o.liveTileLists, {
    headline = {
      o.loc.LocalizeString("LTXT_SQD_SQUAD")
    },
    subHeadline = "AWAY",
    images = {
      o:getTeamCrest(true)
    },
    autoScaleImageToTileHeight= true,
    clickAction = ACT_TO_INGAME_SQUADAWAY
  })
  o.im.Subscribe(bndLiveTileList, function()
    o:_publishLiveTiles()
  end)
  o.liveTileLists2 = {}
table.insert(o.liveTileLists2, {
    headline = {
      "CUSTOMIZE"
    },
    images = {
      "$CustomiseMatchPauseMenu"
    },
    autoScaleImageToTileHeight= true,
    clickAction = "act_to_settings"
  })
  table.insert(o.liveTileLists2, {
    headline = {
      "SELECT SIDE"
    },
    images = {
      "$_IconSelectSide"
    },
    autoScaleImageToTileHeight= true,
    clickAction = "act_selectside"
  })
  
  o.im.Subscribe(bndLiveTileList2, function()
    o:_publishLiveTiles2()
  end)
o.im.Subscribe(BND_LIVE_TILE_MATCHHIGHLIGHTS, function()
    o.im.Publish(BND_LIVE_TILE_MATCHHIGHLIGHTS, {
      headline = {
        o.loc.LocalizeString("LTXT_TILE_MATCH_HIGHLIGHTS"),
        o.loc.LocalizeString("LTXT_TILE_MATCH_HIGHLIGHTS_LINE2")
      }
    })
  end
  )
  o.im.Subscribe(BND_LIVE_TILE_REPLAY_ENABLED, function()
    o.im.Publish(BND_LIVE_TILE_REPLAY_ENABLED, not o.services.PauseMenuService.IsOnlineGame())
  end)
  if o.flow == CommonNavVars.FLOWS.OFFLINE then
    o.services.ScreenInfoService.SetScreenName("PauseMenuOffline")
  end
  function o.resumeGameListener(...)
    o:resumeMatch()
  end
  o.services.GameStateService.RegisterListener(BACK_KEY_PRESSED, o.resumeGameListener)
  o.isGamePaused = true
  return o
end

function GameMenu:_publishLiveTiles()
  local dataToPublish = {
    index = 0,
    data = self.liveTileLists
  }
  self.im.Publish(bndLiveTileList, dataToPublish)
end
function GameMenu:_publishLiveTiles2()
  local dataToPublish = {
    index = 0,
    data = self.liveTileLists2
  }
  self.im.Publish(bndLiveTileList2, dataToPublish)
end
function GameMenu:getMatchType()
  if self.navContext.gamemode == CommonNavVars.GAMEMODES.FTF then
    return ("Friendly match")
  elseif self.navContext.gamemode == CommonNavVars.GAMEMODES.REAL then
    return ("Real Team")
  else
    return self.loc.LocalizeString(string.format("%s_%s_%s", self.navContext.gamemode, self.navContext.flow, self.navContext.type))
  end
end
function GameMenu:handleEvent(eventType, data)
  if eventType == EVENT_TYPES.UpdateNumberOfPausesLeft then
    self:onNumberOfPauseLeftChanged()
  end
end
function GameMenu:resumeMatch()
  print("[GameMenu]: resumeMatch()")
  local screenName = self.services.ScreenInfoService.GetCurrentScreenName()
  print("[GameMenu]: resumeMatch: self.isGamePaused = " .. tostring(self.isGamePaused) .. ", GetCurrentScreenName: " .. tostring(screenName))
  if screenName == "GenericPopup" then
    self.nav.Event(nil, "evt_hide_popup")
  elseif screenName == "Customization" or screenName == "TouchControls" or screenName == "AudioVisual" or screenName == "General" or screenName == "ControllerControls" or screenName == "DebugSettings" then
    self.nav.Event(nil, "evt_save_settings")
  elseif screenName == "SpeechDownloadPopup" then
    self.nav.Event(nil, "evt_hide_speechdownload_popup")
  elseif self.isGamePaused then
    self.isGamePaused = false
    self.nav.Event(nil, "evt_toggle_pause")
  end
end
function GameMenu:forfeitMatch()
  print("[GameMenu]: forfeitMatch()")
  if self.navContext.flow ~= CommonNavVars.FLOWS.ONLINE or self.services.DNFService.IsDNFDisplayInfoKillSwitchOn() then
    local buttonNo = {
      icon = "$FooterIconNo",
      label = "LTXT_CMN_NO",
      clickEvents = {
        "evt_hide_popup"
      }
    }
    local buttonYes = {
      icon = "$FooterIconYes",
      label = "LTXT_CMN_YES",
      clickEvents = {
        "evt_quit_from_game",
        "evt_hide_popup"
      }
    }
    local popupData = {
      title = "LTXT_QUIT_MATCH_CONFIRMATION_TITLE",
      message = "LTXT_QUIT_MATCH_CONFIRMATION",
      autoEscape = false,
      buttons = {buttonNo, buttonYes}
    }
    self.nav.Event(nil, "evt_show_popup", popupData)
  else
    self.nav.Event(nil, "evt_show_overlay", {
      vvm = "/flows/mainflow/dnf/DNF.vvm"
    })
  end
end
function GameMenu:quitMatch()
  print("[GameMenu]: quitMatch()")
  if self.navContext.type == CommonNavVars.TYPES.SEASONS and self.navContext.gamemode == CommonNavVars.GAMEMODES.REAL then
    self.services.SeasonProgressService.ReportRetryMatch(false, false)
  end
  self.nav.Event(nil, "evt_quit")
end
function GameMenu:restartMatch()
  print("[GameMenu]: restartMatch()")
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "LTXT_CMN_NO",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "LTXT_CMN_YES",
    clickEvents = {
      "evt_restart_match",
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = "RESTART MATCH",
    message = "Are you sure you want to restart this match?",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end
function GameMenu:onNumberOfPauseLeftChanged()
  self.im.Refresh(BND_HOME_PAUSES)
  self.im.Refresh(BND_AWAY_PAUSES)
end
function GameMenu:getMatchType()
  if self.navContext.gamemode == CommonNavVars.GAMEMODES.FTF then
    return self.loc.LocalizeString("LTXT_SEA_FTF")
  elseif self.navContext.gamemode == CommonNavVars.GAMEMODES.REAL then
    return self.loc.LocalizeString("LTXT_SEA_REAL")
  else
    return self.loc.LocalizeString(string.format("%s_%s_%s", self.navContext.gamemode, self.navContext.flow, self.navContext.type))
  end
end
function GameMenu:getShootoutResult()
  local matchScore = self.services.MatchInfoService.GetMatchScore()
  local homeScore = matchScore.homeShootout
  local awayScore = matchScore.awayShootout
  if homeScore == -1 or awayScore == -1 then
    return ""
  else
    return string.format("(%s - %s) %s", tostring(homeScore), tostring(awayScore), self.loc.LocalizeString("LTXT_CMN_PENALTIES_ABBR"))
  end
end
function GameMenu:getGameState()
  if self.navContext.gameState == CommonNavVars.GAME_STATES.PAUSE then
    return self.loc.LocalizeString("LTXT_GAME_PAUSED")
  elseif self.navContext.gameState == CommonNavVars.GAME_STATES.HALFTIME then
    return self.loc.LocalizeString("CT_GameTime_HalfTime")
  elseif self.navContext.gameState == CommonNavVars.GAME_STATES.FULLTIME then
    return self.loc.LocalizeString("CT_GameTime_FullTime")
  elseif self.navContext.gameState == CommonNavVars.GAME_STATES.OT_HALFTIME then
    return self.loc.LocalizeString("CT_GameTime_ExtraTimeFirstHalf")
  elseif self.navContext.gameState == CommonNavVars.GAME_STATES.OT_FULLTIME then
    return self.loc.LocalizeString("CT_GameTime_ExtraTimeFullTime")
  elseif self.navContext.gameState == CommonNavVars.GAME_STATES.SHOOTOUT_PAUSE then
    return self.loc.LocalizeString("LTXT_CMN_SHOOTOUT_PAUSE")
  else
    return nil
  end
end
function GameMenu:getAvatarPath(isAway)
  local userIsHostTeam = self.services.GameSetupService.IsHostTeam()
  if userIsHostTeam and isAway or not userIsHostTeam and not isAway then
    if self.navContext.flow ~= CommonNavVars.FLOWS.ONLINE then
      return nil
    else
      return self.services.SocialService.GetImagePathForOpponent(true)
    end
  else
    return self.services.SocialService.GetImagePathForUser(true)
  end
end
function GameMenu:getTeam(isAway)
  local teamData = self.services.MatchInfoService.GetMatchTeams()
  if isAway then
    return teamData[2]
  else
    return teamData[1]
  end
end
function GameMenu:getTeamCrest(isAway)
  return {
    name = "$Crest",
    id = self:getTeam(isAway).assetId
  }
end
function GameMenu:getTeam(isAway)
  local teamData = self.services.MatchInfoService.GetMatchTeams()
  if isAway then
    return teamData[2]
  else
    return teamData[1]
  end
end
function GameMenu:getTeamCrest3(isAway)
  return {
    name = "$Crest3",
    id = self:getTeam(isAway).assetId
  }
end
function GameMenu:getTeam(isAway)
  local teamData = self.services.MatchInfoService.GetMatchTeams()
  if isAway then
    return teamData[2]
  else
    return teamData[1]
  end
end
function GameMenu:getManCrest(isAway)
  return {
    name = "$ManagerCard",
    id = self:getTeam(isAway).assetId
  }
end
function GameMenu:getMatchFacts()
  local facts = self.services.MatchInfoService.GetMatchFacts(true)
  local o = facts.homeData
  for i, v in ipairs(o) do
    v.data.valueRight = facts.awayData[i].data.value
  end
  return o
end
function GameMenu:getPausesRemaining(isAway)
  if self.navContext == CommonNavVars.FLOWS.OFFLINE then
    return nil
  end
  local userIsHostTeam = self.services.GameSetupService.IsHostTeam()
  if userIsHostTeam and isAway or not userIsHostTeam and not isAway then
    return tostring(self.services.PauseMenuService.GetOponentPausesLeft())
  else
    return tostring(self.services.PauseMenuService.GetLocalPausesLeft())
  end
end
function GameMenu:finalize()
  print("[GameMenu]: finalize()")
  self.services.GameStateService.UnRegisterListener(BACK_KEY_PRESSED)
  self.im.Unsubscribe(BND_HOME_PAUSES)
  self.im.Unsubscribe(BND_AWAY_PAUSES)
  self.im.Unsubscribe(BND_HOME_USER_DATA)
  self.im.Unsubscribe(BND_AWAY_USER_DATA)
  self.im.Unsubscribe(BND_HOME_TEAM_CREST)
  self.im.Unsubscribe(BND_HOME_TEAM_CREST3)
  self.im.Unsubscribe(BND_AWAY_TEAM_CREST3)
  self.im.Unsubscribe(BND_AWAY_TEAM_CREST)
  self.im.Unsubscribe(BND_TEAM_MAN_HOME)
  self.im.Unsubscribe(BND_TEAM_MAN_AWAY)
  self.im.Unsubscribe(BND_HOME_TEAM_NAME_ABBR)
  self.im.Unsubscribe(BND_AWAY_TEAM_NAME_ABBR)
  self.im.Unsubscribe(BND_HOME_TEAM_NAME)
  self.im.Unsubscribe(BND_AWAY_TEAM_NAME)
  self.im.Unsubscribe(BND_RESULT)
  self.im.Unsubscribe(BND_SHOOTOUT_RESULT)
  self.im.Unsubscribe(BND_MATCH_TYPE)
  self.im.Unsubscribe(BND_GAME_STATE)
  self.im.Unsubscribe(BND_STADIUM_NAME)
  self.im.Unsubscribe(BND_TIME)
  self.im.Unsubscribe(BND_MATCH_FACTS)
  self.im.Unsubscribe(BND_LIVE_TILE_RESUME)
  self.im.Unsubscribe(BND_LIVE_TILE_SQUAD)
  self.im.Unsubscribe(bndLiveTileList)
  self.im.Unsubscribe(BND_LIVE_TILE_REPLAY)
  self.im.Unsubscribe(BND_LIVE_TILE_SETTINGS)
  self.im.Unsubscribe(BND_LIVE_TILE_MATCH_FACTS)
  self.im.Unsubscribe(BND_LIVE_TILE_CAPTURED_MEDIA)
  self.im.Unsubscribe(BND_LIVE_TILE_CAPTURED_MEDIA_ENABLED)
  self.im.Unsubscribe(BND_LIVE_TILE_QUIT)
  self.im.Unsubscribe(bndLiveTileList2)
  self.im.Unsubscribe(BND_LIVE_TILE_QUIT_TO_HUB)
  self.im.Unsubscribe(BND_SHOW_ONLINE_INFO)
  self.im.Unsubscribe(BND_SHOW_OFFLINE_INFO)
  self.im.Unsubscribe(BND_LIVE_TILE_MATCH_HIGHLIGHTS)
  self.im.Unsubscribe(BND_LIVE_TILE_REPLAY_ENABLED)
  self.im.UnregisterAction(ACT_TOGGLE_PAUSE)
  self.im.UnregisterAction(ACT_FORFEIT_MATCH)
  self.im.UnregisterAction(ACT_QUIT_MATCH)
  self.im.UnregisterAction(ACT_TO_INGAME_SQUAD)
  self.im.UnregisterAction(ACT_TO_INGAME_SQUADAWAY)
  self.im.UnregisterAction(ACT_RESTART_MATCH)
  self.services.EventManagerService.UnregisterHandler(self.eventHandlerID)
  if self.flow == CommonNavVars.FLOWS.OFFLINE then
    self.services.ScreenInfoService.UnsetScreenName("PauseMenuOffline")
  end
end
return GameMenu
