local TableUtil, CommonNavVars, CABModel, eventmanager = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes
local USER_MATCH_STATUS = {
  WON = 0,
  LOST = 1,
  DRAW = 2
}
local BND_PRW = "bnd_pr_w"
local BND_PRL = "bnd_pr_l"
local BND_PRD = "bnd_pr_d"
local BND_MATCH_DATA_PANEL_VISIBLE = "bnd_match_data_panel_visible"
local BND_MATCH_WON_FOOTER_VISIBLE = "bnd_match_won_footer_visible"
local BND_MATCH_LOST_FOOTER_VISIBLE = "bnd_match_lost_footer_visible"
local BND_MATCH_DRAW_FOOTER_VISIBLE = "bnd_match_draw_footer_visible"
local BND_DEFAULT_BANNER_VISIBLE = "bnd_default_banner_visible"
local BND_AD_BANNER_DATA = "bnd_ad_banner_data"
local PostmatchMenu = {}
function PostmatchMenu:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.navContext = o.data
  print("[PostmatchMenu]: new(gamemode = " .. tostring(o.navContext.gamemode) .. ", flow = " .. tostring(o.navContext.flow) .. ", type = " .. tostring(o.navContext.type) .. ", gameState = " .. tostring(o.navContext.gameState) .. ")")
  o.services = {
    GameSetupService = o.api("GameSetupService"),
    MatchInfoService = o.api("MatchInfoService"),
    EventManagerService = o.api("EventManagerService")
  }
  o.powService = o.api("PowService")
  o.screenName = "worldpostmatch"
  o.defaultAdVisible = true
  o.models = {
    CABModel = CABModel:new({
      im = o.im,
      api = o.api,
      nav = o.nav,
      loc = o.loc,
      screenName = "worldpostmatch"
    })
  }
  math.randomseed(os.clock() * 1000 + os.time())
  local PRwon = (math.random(75, 96)* 0.1)
  local PRlost = (math.random(31, 49)* 0.1)
  local PRdraw = (math.random(51, 74)* 0.1)
  o.im.Subscribe(BND_PRW, function()
    o.im.Publish(BND_PRW, PRwon)
  end)
  o.im.Subscribe(BND_PRL, function()
    o.im.Publish(BND_PRL, PRlost)
  end)
  o.im.Subscribe(BND_PRD, function()
    o.im.Publish(BND_PRD, PRdraw)
  end)
  o.im.Subscribe(BND_MATCH_DATA_PANEL_VISIBLE, function()
    o.im.Publish(BND_MATCH_DATA_PANEL_VISIBLE, o:_isDefaultMatchDataPanelVisible())
  end)
  o.im.Subscribe(BND_MATCH_WON_FOOTER_VISIBLE, function()
    o.im.Publish(BND_MATCH_WON_FOOTER_VISIBLE, o:getUserMatchStatus() == USER_MATCH_STATUS.WON)
  end)
  o.im.Subscribe(BND_MATCH_LOST_FOOTER_VISIBLE, function()
    o.im.Publish(BND_MATCH_LOST_FOOTER_VISIBLE, o:getUserMatchStatus() == USER_MATCH_STATUS.LOST)
  end)
  o.im.Subscribe(BND_MATCH_DRAW_FOOTER_VISIBLE, function()
    o.im.Publish(BND_MATCH_DRAW_FOOTER_VISIBLE, o:getUserMatchStatus() == USER_MATCH_STATUS.DRAW)
  end)
  o.im.Subscribe(BND_DEFAULT_BANNER_VISIBLE, function()
    o.im.Publish(BND_DEFAULT_BANNER_VISIBLE, o:_isDefaultAdBannerVisible())
  end)
  o.im.Subscribe(BND_AD_BANNER_DATA, function()
    o:publishBannerData()
  end)
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  o.powService.RequestAdBannersByScreen(o.screenName)
  return o
end
function PostmatchMenu:getUserMatchStatus()
  local userIsHostTeam = self.services.GameSetupService.IsHostTeam()
  local scoreResult = self.services.MatchInfoService.GetMatchScore()
  local TEAM_HOME = 0
  local TEAM_AWAY = 1
  if scoreResult.winner ~= TEAM_HOME and scoreResult.winner ~= TEAM_AWAY then
    return USER_MATCH_STATUS.DRAW
  elseif scoreResult.winner == TEAM_HOME and userIsHostTeam or scoreResult.winner == TEAM_AWAY and not userIsHostTeam then
    return USER_MATCH_STATUS.WON
  else
    return USER_MATCH_STATUS.LOST
  end
end
function PostmatchMenu:getGoals(isAway)
  local matchResults = self.services.MatchInfoService.GetMatchResult()
  local dashIdx = string.find(matchResults, self.loc.LocalizeString("LTXT_COMMON_SCORE_SEPARATOR"))
  local homeGoals = tonumber(string.sub(matchResults, 1, dashIdx - 2))
  local awayGoals = tonumber(string.sub(matchResults, dashIdx + 2))
  if isAway then
    return awayGoals
  else
    return homeGoals
  end
end
function PostmatchMenu:handleEvent(eventType, data)
  if eventType == EventTypes.AdBannersDataAvailable then
    if data.screenName == self.screenName then
      local rawData = self.powService.GetAdBannersByScreen(self.screenName)
      local nData = table.getn(rawData)
      if 0 < nData then
        self.advertTileData = rawData
        self:publishBannerData()
      end
    end
  elseif eventType == EventTypes.AdBannersDataNotAvailable then
    if data.screenName == self.screenName then
      self.advertTileData = self.models.CABModel:getFakeData()
      self:publishBannerData()
    end
  elseif eventType == EventTypes.OnBackPressed then
    print("PostmatchMenu:handleEvent OnBackPressed")
    self.nav.Event(nil, "evt_quit")
  end
end
function PostmatchMenu:publishBannerData()
  if self.advertTileData ~= nil then
    self.im.Publish(BND_AD_BANNER_DATA, self.advertTileData[1])
    self.im.Publish(BND_DEFAULT_BANNER_VISIBLE, self:_isDefaultAdBannerVisible())
  end
end
function PostmatchMenu:_isDefaultMatchDataPanelVisible()
  if self.navContext.type == CommonNavVars.TYPES.SEASONS or self.navContext.type == CommonNavVars.TYPES.TOURNAMENTS then
    return false
  else
    return true
  end
end
function PostmatchMenu:_isDefaultAdBannerVisible()
  if self.advertTileData == nil then
    self.defaultAdVisible = true
    return true
  end
  local nData = table.getn(self.advertTileData)
  if 0 < nData then
    self.defaultAdVisible = false
  end
  return self.defaultAdVisible
end
function PostmatchMenu:finalize()
  print("[PostmatchMenu]: finalize()")
  self.models.CABModel:finalize()
  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  self.im.Unsubscribe(BND_MATCH_DATA_PANEL_VISIBLE)
  self.im.Unsubscribe(BND_MATCH_WON_FOOTER_VISIBLE)
  self.im.Unsubscribe(BND_MATCH_LOST_FOOTER_VISIBLE)
  self.im.Unsubscribe(BND_MATCH_DRAW_FOOTER_VISIBLE)
  self.im.Unsubscribe(BND_DEFAULT_BANNER_VISIBLE)
  self.im.Unsubscribe(BND_AD_BANNER_DATA)
  self.im.Unsubscribe(BND_PRW)
  self.im.Unsubscribe(BND_PRL)
  self.im.Unsubscribe(BND_PRD)
end
return PostmatchMenu
