-- Patch By Ma'ruf ID YouTube --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

local MainHub = {}

local TableUtil, FUTLoginManager, VirtualButton, eventmanager, CABModel, OverlayParam, FeatureTileModel, Timer, Login_Service, QuickEvents_Service = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes
local LoginFrom = Login_Service.FE.UXService.BaseService.LoginFrom

local BND_LIVE_TILE_QUICKMATCH = "bnd_live_tile_quickmatch"
local BND_LIVE_TILE_ULTIMATETEAM = "bnd_live_tile_ultimateteam"
local BND_LIVE_TILE_SKILLGAMES = "bnd_live_tile_skillgames"
local BND_LIVE_TILE_TEST = "bnd_live_tile_test"
local BND_LIVE_TILE_LIST = "bnd_live_tile_list"

function MainHub:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    liveTilesService = o.api("LiveTilesService"),
    EventManagerService = o.api("EventManagerService"),
    OverlayService = o.api("OverlayService"),
    LoginService = o.api("LoginService"),
    SpeechDownloadService = o.api("SpeechDownloadService"),
    QuickEvents = o.api("QuickEventsService")
  }
  o.powService = o.api("PowService")
  o.screenName = "worldmainhub"
  o.models = {
    CABModel = CABModel:new({
      im = o.im,
      api = o.api,
      loc = o.loc,
      nav = o.nav,
      screenName = o.screenName
    })
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  
  o.liveTileLists = {}

-----------------------------------
-- MENU QUICK MATCH --
-----------------------------------
  o.im.Subscribe(BND_LIVE_TILE_QUICKMATCH, function()
    o:BND_LIVE_TILE_QUICKMATCH()
  end)
function MainHub:BND_LIVE_TILE_QUICKMATCH()
  local dataToInsert =
  {
    headline = { "" },
    description = ""
  }
  self.im.Publish(BND_LIVE_TILE_QUICKMATCH, dataToInsert)
end

--------------------------------------
-- MENU ULTIMATE TEAM --
--------------------------------------
  o.im.Subscribe(BND_LIVE_TILE_ULTIMATETEAM, function()
    o:BND_LIVE_TILE_ULTIMATETEAM()
  end)
function MainHub:BND_LIVE_TILE_ULTIMATETEAM()
  local dataToInsert =
  {
    headline = { "" },
    description = ""
  }
  self.im.Publish(BND_LIVE_TILE_ULTIMATETEAM, dataToInsert)
end

----------------------------------
-- MENU SKILL GAMES --
----------------------------------
  o.im.Subscribe(BND_LIVE_TILE_SKILLGAMES, function()
    o:BND_LIVE_TILE_SKILLGAMES()
  end)
function MainHub:BND_LIVE_TILE_SKILLGAMES()
  local dataToInsert =
  {
    headline = { "" },
    description = ""
  }
  self.im.Publish(BND_LIVE_TILE_SKILLGAMES, dataToInsert)
end

----------------------
-- MENU TEST --
----------------------
  o.im.Subscribe(BND_LIVE_TILE_TEST, function()
    o:BND_LIVE_TILE_TEST()
  end)
function MainHub:BND_LIVE_TILE_TEST()
  local dataToInsert =
  {
    headline = { "" },
    description = ""
  }
  self.im.Publish(BND_LIVE_TILE_TEST, dataToInsert)
end

------------------------------------
-- MENU HELP & ABOUT --
------------------------------------
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MenuHelp"
    },
    clickAction = "act_to_help"
  })
  table.insert(o.liveTileLists, {
    headline = {
      ""
    },
    description = "",
    images = {
      "$_MenuAbout"
    },
    clickAction = "act_to_about"
  })
  
  o.im.Subscribe(BND_LIVE_TILE_LIST, function()
    o:_publishLiveTiles()
  end)
  
  return o
end

function MainHub:_publishLiveTiles()
  local dataToPublish = {
    index = 0,
    data = self.liveTileLists
  }
  self.im.Publish(BND_LIVE_TILE_LIST, dataToPublish)
end

function MainHub:finalize()

  self.models.CABModel:finalize()
  self.models.FeatureTileModel:finalize()
  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  
  self.im.Unsubscribe(BND_LIVE_TILE_QUICKMATCH)
  self.im.Unsubscribe(BND_LIVE_TILE_ULTIMATETEAM)
  self.im.Unsubscribe(BND_LIVE_TILE_SKILLGAMES)
  self.im.Unsubscribe(BND_LIVE_TILE_TEST)
  self.im.Unsubscribe(BND_LIVE_TILE_LIST)
  
end

return MainHub
