-- Patch By Ma'ruf ID YouTube --
-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID -- ReMOD By Dc-1712™ --
-------------------------------------------------------

local DetailStats = {}

local eventmanager, PregameManager, CommonNavVars, TableUtil = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_LOGO_TEAM_HOME = "bnd_logo_tim_home1"
local BND_LOGO_TIM_HOME = "bnd_logo_tim_home"
local BND_LOGO_TEAM_AWAY = "bnd_logo_tim_away1"
local BND_LOGO_TIM_AWAY = "bnd_logo_tim_away"

local BND_NAMA_TIM_HOME = "bnd_nama_tim_home"
local BND_NAMA_TIM_AWAY = "bnd_nama_tim_away"

function DetailStats:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    matchSetup = o.api("MatchSetupService"),
    gameSetup = o.api("GameSetupService"),
    gameState = o.api("GameStateService"),
    preGame = o.api("PregameService"),
    MatchInfoService = o.api("MatchInfoService"),
    SettingsService = o.api("SettingsService"),
    EventManagerService = o.api("EventManagerService")
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)

  o.TeamsData = o.services.MatchInfoService.GetMatchTeams()

  o.CurrentOptions = o.services.SettingsService.GetCurrentOptions()

  o.im.Subscribe(BND_LOGO_TEAM_HOME, function()
    o.im.Publish(BND_LOGO_TEAM_HOME, {
      name = "$Crest1",
      id = string.format("%d", o.services.gameSetup.GetHomeAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TIM_HOME, function()
    o.im.Publish(BND_LOGO_TIM_HOME, {
      name = "$Crest",
      id = string.format("%d", o.services.gameSetup.GetHomeAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TEAM_AWAY, function()
    o.im.Publish(BND_LOGO_TEAM_AWAY, {
      name = "$Crest1",
      id = string.format("%d", o.services.gameSetup.GetAwayAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TIM_AWAY, function()
    o.im.Publish(BND_LOGO_TIM_AWAY, {
      name = "$Crest",
      id = string.format("%d", o.services.gameSetup.GetAwayAssetId())
    })
  end)
  
  o.im.Subscribe(BND_NAMA_TIM_HOME, function()
    o.im.Publish(BND_NAMA_TIM_HOME, o.TeamsData[1].teamName)
  end)
  o.im.Subscribe(BND_NAMA_TIM_AWAY, function()
    o.im.Publish(BND_NAMA_TIM_AWAY, o.TeamsData[2].teamName)
  end)

  o.im.Subscribe(BND_NAMA_STADION, function()
    o.im.Publish(BND_NAMA_STADION, o.CurrentOptions.stadium)
  end)

  o.im.RegisterAction(ACT_PLAYMATCH, function(actionName)
    o:PlayMatch()
  end)

  return o
end

function DetailStats:finalize()

  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  
  self.im.Unsubscribe(BND_LOGO_TEAM_HOME)
  self.im.Unsubscribe(BND_LOGO_TIM_HOME)
  self.im.Unsubscribe(BND_LOGO_TIM_AWAY)
    self.im.Unsubscribe(BND_LOGO_TEAM_AWAY)
  
  self.im.Unsubscribe(BND_NAMA_TIM_HOME)
  self.im.Unsubscribe(BND_NAMA_TIM_AWAY)
  
end

return DetailStats 

-- Created By Ma'ruf ID YouTube --