-- Patch By Ma'ruf ID YouTube --

-- New Menu MatchSelect Spesial Patch di v7 --

-------------------------------------------------------
-- MOD Keren dari YouTube Ma'ruf ID --
-------------------------------------------------------

-------------------------------------------------------
-- RMOD AWAY_FORMATION BY YouTube LAOSIJI  --
-------------------------------------------------------

local MatchSelect = {}

local eventmanager, PregameManager, CommonNavVars, TableUtil = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_LOGO_TIM_HOME = "bnd_logo_tim_home"
local BND_LOGO_TIM_AWAY = "bnd_logo_tim_away"

local BND_NAMA_TIM_HOME = "bnd_nama_tim_home"
local BND_NAMA_TIM_AWAY = "bnd_nama_tim_away"

local BND_NAMA_STADION = "bnd_nama_stadion"

local BND_LIVE_TILE_PLAYMATCH = "bnd_live_tile_playmatch"
local BND_LIVE_TILE_FORMATIONS = "bnd_live_tile_formations"
local BND_LIVE_TILE_FORMATIONS_AWAY = "bnd_live_tile_formations_away"
local BND_LIVE_TILE_GAMESETTINGS = "bnd_live_tile_gamesettings"
local BND_LIVE_TILE_SELECTSIDE = "bnd_live_tile_selectside"
local BND_LIVE_TILE_SELECTSTADIUM = "bnd_live_tile_selectstadium"

local ACT_PLAYMATCH = "act_playmatch"
local actSquadAway = "act_formations_away"
function MatchSelect:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    matchSetup = o.api("MatchSetupService"),
    gameSetup = o.api("GameSetupService"),
    gameState = o.api("GameStateService"),
    preGame = o.api("PregameService"),
    MatchInfoService = o.api("MatchInfoService"),
    SettingsService = o.api("SettingsService"),
    EventManagerService = o.api("EventManagerService")
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)

  o.TeamsData = o.services.MatchInfoService.GetMatchTeams()

  o.CurrentOptions = o.services.SettingsService.GetCurrentOptions()

  o.im.Subscribe(BND_LOGO_TIM_HOME, function()
    o.im.Publish(BND_LOGO_TIM_HOME, {
      name = "$Crest",
      id = string.format("%d", o.services.gameSetup.GetHomeAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TIM_AWAY, function()
    o.im.Publish(BND_LOGO_TIM_AWAY, {
      name = "$Crest",
      id = string.format("%d", o.services.gameSetup.GetAwayAssetId())
    })
  end)
  
  o.im.Subscribe(BND_NAMA_TIM_HOME, function()
    o.im.Publish(BND_NAMA_TIM_HOME, o.TeamsData[1].teamName)
  end)
  o.im.Subscribe(BND_NAMA_TIM_AWAY, function()
    o.im.Publish(BND_NAMA_TIM_AWAY, o.TeamsData[2].teamName)
  end)

  o.im.Subscribe(BND_NAMA_STADION, function()
    o.im.Publish(BND_NAMA_STADION, o.CurrentOptions.stadium)
  end)

  o.im.RegisterAction(ACT_PLAYMATCH, function(actionName)
    o:PlayMatch()
  end)

  ----------------------------------
  -- MENU PLAY MATCH --
  ----------------------------------
  o.im.Subscribe(BND_LIVE_TILE_PLAYMATCH, function()
    o:BND_LIVE_TILE_PLAYMATCH()
  end)
  function MatchSelect:BND_LIVE_TILE_PLAYMATCH()
  local dataToInsert =
  {
    headline = { "PLAY MATCH" }
  }
  self.im.Publish(BND_LIVE_TILE_PLAYMATCH, dataToInsert)
  end

  ----------------------------------
  -- MENU FORMATIONS --
  ----------------------------------
  o.im.Subscribe(BND_LIVE_TILE_FORMATIONS, function()
    o:BND_LIVE_TILE_FORMATIONS()
  end)
  function MatchSelect:BND_LIVE_TILE_FORMATIONS()
  local dataToInsert =
  {
    headline = { "HOME" }
  }
  self.im.Publish(BND_LIVE_TILE_FORMATIONS, dataToInsert)
  end
  
  ----------------------------------
  -- MENU FORMATIONS_AWAY --
  ----------------------------------
  o.im.Subscribe(BND_LIVE_TILE_FORMATIONS_AWAY, function()
    o:BND_LIVE_TILE_FORMATIONS_AWAY()
  end)
  function MatchSelect:BND_LIVE_TILE_FORMATIONS_AWAY()
  local dataToInsert =
  {
    headline = { "AWAY" }
  }
  self.im.Publish(BND_LIVE_TILE_FORMATIONS_AWAY, dataToInsert)
  end

  --------------------------------------
  -- MENU GAME SETTINGS --
  --------------------------------------
  o.im.Subscribe(BND_LIVE_TILE_GAMESETTINGS, function()
    o:BND_LIVE_TILE_GAMESETTINGS()
  end)
  function MatchSelect:BND_LIVE_TILE_GAMESETTINGS()
  local dataToInsert =
  {
    headline = { "GAME SETTINGS" }
  }
  self.im.Publish(BND_LIVE_TILE_GAMESETTINGS, dataToInsert)
  end

  ---------------------------------
  -- MENU SELECT SIDE --
  ---------------------------------
  o.im.Subscribe(BND_LIVE_TILE_SELECTSIDE, function()
    o:BND_LIVE_TILE_SELECTSIDE()
  end)
  function MatchSelect:BND_LIVE_TILE_SELECTSIDE()
  local dataToInsert =
  {
    headline = { "SELECT SIDE" }
  }
  self.im.Publish(BND_LIVE_TILE_SELECTSIDE, dataToInsert)
  end

  ---------------------------------------
  -- MENU SELECT STADIUM --
  ---------------------------------------
  o.im.Subscribe(BND_LIVE_TILE_SELECTSTADIUM, function()
    o:BND_LIVE_TILE_SELECTSTADIUM()
  end)
  function MatchSelect:BND_LIVE_TILE_SELECTSTADIUM()
  local dataToInsert =
  {
    headline = { "SELECT STADIUM" }
  }
  self.im.Publish(BND_LIVE_TILE_SELECTSTADIUM, dataToInsert)
  end
  o.im.RegisterAction(actSquadAway, function(actionName, data)
    o.nav.Event(nil, "evt_formations_away")
  end)
  return o
end

-- Menu Play Match --
function MatchSelect:PlayMatch()
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "LTXT_CMN_NO",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "LTXT_CMN_YES",
    clickEvents = {
      "evt_playmatch",
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = " PLAY MATCH *",
    message = " ARE YOU READY TO PLAY MATCH NOW ? *",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end

function MatchSelect:finalize()

  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  
  self.im.Unsubscribe(BND_LOGO_TIM_HOME)
  self.im.Unsubscribe(BND_LOGO_TIM_AWAY)
  
  self.im.Unsubscribe(BND_NAMA_TIM_HOME)
  self.im.Unsubscribe(BND_NAMA_TIM_AWAY)
  
  self.im.Unsubscribe(BND_NAMA_STADION)

  self.im.Unsubscribe(BND_LIVE_TILE_PLAYMATCH)
  self.im.Unsubscribe(BND_LIVE_TILE_FORMATIONS)
  self.im.Unsubscribe(BND_LIVE_TILE_FORMATIONS_AWAY)
  self.im.Unsubscribe(BND_LIVE_TILE_GAMESETTINGS)
  self.im.Unsubscribe(BND_LIVE_TILE_SELECTSIDE)
  self.im.Unsubscribe(BND_LIVE_TILE_SELECTSTADIUM)

  self.im.UnregisterAction(ACT_PLAYMATCH)
  self.im.UnregisterAction(actSquadAway)

end

return MatchSelect

-- Created By Ma'ruf ID YouTube --