Baik, berikut adalah skrip kode yang diatur dengan parameter grafik yang lebih ringan dan dapat bekerja lebih baik pada chipset MediaTek:

local GraphicsUpdate = function()
	local as = gSportsRNA
	local settingTable = as:GetTable("Settings")

	local effectsQuality = as:GetString(settingTable, "TextureQuality")
                                                     as:GetString(settingTable, "EffectsQuality")

	-- Force TextureQuality - 'Quality.High'
              if (levelOfDetail == "" or levelOfDetail == "high") then

		local textureQuality = as:GetString(settingTable, "TextureQuality")
		if (textureQuality == "" or textureQuality == Quality.High) then
			textureQuality = "Quality.Medium"
			as:SetGlobalString(settingTable, "TextureQuality", textureQuality)
		end

		-- Set TextureQuality settings
		applyQualitySettings("TextureQuality", {    	
			[Quality.Low]=[=[
				Texture.SkipMipmapCount 2
				TextureStreaming.PoolSize 500000
				TextureStreaming.PoolHeadroomSize 8192
				TerrainStreaming.HeightfieldAtlasSampleCountXFactor 0.5
				TerrainStreaming.HeightfieldAtlasSampleCountYFactor 1
				TerrainStreaming.MaskAtlasSampleCountXFactor 0.5
				TerrainStreaming.MaskAtlasSampleCountYFactor 1
				TerrainStreaming.ColorAtlasSampleCountXFactor 0.5
				TerrainStreaming.ColorAtlasSampleCountYFactor 1
				VisualTerrain.TextureAtlasSampleCountXFactor 0.5
				VisualTerrain.TextureAtlasSampleCountYFactor 1
				VisualTerrain.TextureRenderJobCount 1
				VisualTerrain.TextureRenderJobsLaunchedPerFrameCountMax 1
				VisualTerrain.TextureSkipMipSpeed 15
				VisualTerrain.Decal3dFarDrawDistanceScaleFactor 1.2
				WorldMobileRender.SkyEnvmapResolution 128
				WorldMobileRender.LocalIBLResolution 64
				WorldMobileRender.LocalIBLShadowmapResolution 256
				ShaderSystem.ShaderQualityLevel QualityLevel_Low
				OptionsGraphicsMaxfps 30
				BitmapFilterQuality QualityLevel Medium
			]=],
			[Quality.Medium]=[=[
				Texture.SkipMipmapCount 1
				TextureStreaming.PoolSize 800000
				TextureStreaming.PoolHeadroomSize 16384
				TerrainStreaming.HeightfieldAtlasSampleCountXFactor 0.75
				TerrainStreaming.HeightfieldAtlasSampleCountYFactor 1.5
				TerrainStreaming.MaskAtlasSampleCountXFactor 0.75
				TerrainStreaming.MaskAtlasSampleCountYFactor 1.5
				TerrainStreaming.ColorAtlasSampleCountXFactor 0.75
				TerrainStreaming.ColorAtlasSampleCountYFactor 1.5
				VisualTerrain.TextureAtlasSampleCountXFactor 0.75
				VisualTerrain.TextureAtlasSampleCountYFactor 1.5
				VisualTerrain.TextureRenderJobCount 2
				VisualTerrain.TextureRenderJobsLaunchedPerFrameCountMax 2
				VisualTerrain.TextureSkipMipSpeed 25
				VisualTerrain.Decal3dFarDrawDistanceScaleFactor 1.4
				WorldMobileRender.SkyEnvmapResolution 256
				WorldMobileRender.LocalIBLResolution 128
				WorldMobileRender.LocalIBLShadowmapResolution 512
				ShaderSystem.ShaderQualityLevel QualityLevel_Medium
				OptionsGraphicsMaxfps 60
				BitmapFilterQuality QualityLevel High
			]=],
			[Quality.High]=[=[
				Texture.SkipMipmapCount 0
				TextureStreaming.PoolSize 1200000
				TextureStreaming.PoolHeadroomSize 32768
				TerrainStreaming.HeightfieldAtlasSampleCountXFactor 1
				TerrainStreaming.HeightfieldAtlasSampleCountYFactor 2
				TerrainStreaming.MaskAtlasSampleCountXFactor 1
				TerrainStreaming.MaskAtlasSampleCountYFactor 2
				TerrainStreaming.ColorAtlasSampleCountXFactor 1
				TerrainStreaming.ColorAtlasSampleCountYFactor 2
				VisualTerrain.TextureAtlasSampleCountXFactor 1
				VisualTerrain.TextureAtlasSampleCountYFactor 2
				VisualTerrain.TextureRenderJobCount 2
				VisualTerrain.TextureRenderJobsLaunchedPerFrameCountMax 2
				VisualTerrain.TextureSkipMipSpeed 30
				VisualTerrain.Decal3dFarDrawDistanceScaleFactor 1.7
				WorldMobileRender.SkyEnvmapResolution 512
				WorldMobileRender.LocalIBLResolution 256
				WorldMobileRender.LocalIBLShadowmapResolution 1024
				ShaderSystem.ShaderQualityLevel QualityLevel_High
				OptionsGraphicsMaxfps 100
				BitmapFilterQuality QualityLevel High
			]=],
		})

    -- Texture filtering Quality
    applyQualitySettings("TextureFiltering", {    
         [Quality.Low]=[=[
	      WorldMobileRender.CullScreenAreaScale 1.0
	      Mesh.GlobalLodScale 1.0
	      Mesh.ShadowDistanceScale 0.5
	      Mesh.TessellationEnable 0
	      Mesh.TessellationMaxFactor 1
	      MeshStreaming.PoolSize 80000
	      VegetationSystem.MaxActiveDistance 200
	      VegetationSystem.MaxPreSimsPerJob 2
	      VegetationSystem.SimulationMemKbClient 2048
	      Render.EdgeModelViewDistance 50
	      WaterInteract.WaterQualityLevel Low
	      Crowd.LodScale 2
	      Grass.PatchWidthScale 0.5
         ]=],
         [Quality.Medium]=[=[
              WorldMobileRender.CullScreenAreaScale 1.25
              Mesh.GlobalLodScale 1.25
              Mesh.ShadowDistanceScale 0.75
              Mesh.TessellationEnable 1
              Mesh.TessellationMaxFactor 3
              MeshStreaming.PoolSize 160000
              VegetationSystem.MaxActiveDistance 250
              VegetationSystem.MaxPreSimsPerJob 3
              VegetationSystem.SimulationMemKbClient 3072
              Render.EdgeModelViewDistance 75
              WaterInteract.WaterQualityLevel Medium
              Crowd.LodScale 2.5
              Grass.PatchWidthScale 0.75
         ]=],
         [Quality.High]=[=[
              WorldMobileRender.CullScreenAreaScale 1.5
              Mesh.GlobalLodScale 1.5
              Mesh.ShadowDistanceScale 1.0
              Mesh.TessellationEnable 1
              Mesh.TessellationMaxFactor 5
              MeshStreaming.PoolSize 240000
              VegetationSystem.MaxActiveDistance 300
              VegetationSystem.MaxPreSimsPerJob 4
              VegetationSystem.SimulationMemKbClient 4096
              Render.EdgeModelViewDistance 100
              WaterInteract.WaterQualityLevel High
              Crowd.LodScale 3
              Grass.PatchWidthScale 1.0
         ]=],
	})

	-- Effects Quality
    applyQualitySettings("EffectsQuality", {    
         [Quality.Low]="",
		 [Quality.Medium]=[=[
			EmitterSystem.DynamicEmitCountMax 750
			VisualTerrain.MaterialLayerResolutionDivider 2
			WorldMobileRender.HalfResLensFlaresEnable 0
			Earain.DensityLodScale 0.5
			TemporalAA.SampleCount 2
			TemporalAA.SampleDistanceScale 1
         ]=],
         [Quality.High]=[=[
			EmitterSystem.DynamicEmitCountMax 1000
			VisualTerrain.MaterialLayerResolutionDivider 1
			WorldMobileRender.HalfResLensFlaresEnable 1
			Earain.DensityLodScale 1
			TemporalAA.SampleCount 4
			TemporalAA.SampleDistanceScale 2
         ]=],
    })

	-- Ambient Occlusion
	applyQualitySettings("AmbientOcclusion", {
		[AmbientOcclusion.Off]="",
		[AmbientOcclusion.SSAO]=[[
			PostProcess.DynamicAOEnable 1
			PostProcess.DynamicAOMethod DynamicAOMethod_SSAO
			PostProcess.DynamicAOHorizonBased true
			PostProcess.DynamicAOTemporalFilterEnable 0
			PostProcess.DynamicAOSampleDirCount 4
			PostProcess.DynamicAOSampleStepCount 2
		]],
		[AmbientOcclusion.HBAO]=[[
			PostProcess.DynamicAOEnable 1
			PostProcess.DynamicAOMethod DynamicAOMethod_HBAO
			PostProcess.DynamicAOHorizonBased true
			PostProcess.DynamicAOTemporalFilterEnable 0
			PostProcess.DynamicAOSampleDirCount 4
			PostProcess.DynamicAOSampleStepCount 2
		]],
	})

	-- Light quality
	applyQualitySettings("LightingQuality", {    
        [Quality.Low]=[=[
			WorldMobileRender.SunShadowmapLevel QualityLevel_Low
			WorldMobileRender.ShadowmapViewDistance 100
			WorldMobileRender.ShadowmapResolution 1024
			WorldMobileRender.Game

--playShadowmapResolution 1024 WorldMobileRender.SubSurfaceScatteringEnable false WorldMobileRender.LocalLightTranslucencyEnable false Mesh.CastShadowQualityLevel Medium Mesh.CastDynamicReflectionQualityLevel Medium VegetationSystem.UseShadowLodOffset 1 ]=], [Quality.Medium]=[=[ WorldMobileRender.SunShadowmapLevel QualityLevel_Medium WorldMobileRender.ShadowmapViewDistance 150 WorldMobileRender.ShadowmapResolution 2048 WorldMobileRender.GameplayShadowmapResolution 1024 Mesh.CastShadowQualityLevel High Mesh.CastDynamicReflectionQualityLevel High VegetationSystem.UseShadowLodOffset 2 WorldMobileRender.SubSurfaceScatteringEnable false WorldMobileRender.LocalLightTranslucencyEnable false ]=], [Quality.High]="", })

--Resolution and Screen Settings RenderDevice = RenderDevice or {}

RenderDevice.AutodetectedResolution = false RenderDevice.FullscreenRefreshRate = 60 RenderDevice.Fullscreen = true RenderDevice.FullscreenOutputIndex = 0 RenderDevice.VSyncEnable = false

--Resolution scale Render.ResolutionScale = 2.0

--Brightness PostProcess.UIBrightnessNorm = 260.0

--Contrast PostProcess.UIContrastNorm = 331.0

--Settings and resolution detection WorldMobileRender.HairStrandsEnabled = false Render.DynamicResolutionScaleFeatureEnable = true

FifaWorldMobileRender = FifaWorldMobileRender or {} FifaWorldMobileRender.UseGoalNets3d = true

--Scripts/GameView.cfg# Enable variable frame rate for faster. Client.VsyncEnable true

--GameView runs in (true) fullscreen mode. So need to do costly gather device infos etc. RenderDevice.FullscreenModeEnable true

--This is the "Game view" mode so want to be able to render using the debug renderer from the Editor. Render.DebugRenderServiceEnable true end

setQualitySettings = function(quality) --Set Texture Quality local as = gSportsRNA local settingTable = as:GetTable("Settings") as:SetGlobalString(settingTable, "TextureQuality", quality)

--Call graphics update GraphicsUpdate() end

--Sets graphics to low settings setLowQuality = function() setQualitySettings("Quality.Low") end

--Sets graphics to medium settings setMediumQuality = function() setQualitySettings("Quality.Medium") end

--Sets graphics to high settings setHighQuality = function() setQualitySettings("Quality.High") end

--Call low quality settings by default setLowQuality()


