function ParticlesUpdate(idx)
	local as = gSportsRNA
	local effect = as:GetTable("wvParticlesEffect", idx)
    
    local state = as:GetTable("wvState")
    db.particleseffect[idx].prefix = as:GetString(state, "wvAttribStadType")
	db.particleseffect[idx].stadiumID = as:GetInt(state, "wvAttribStadID")
	db.particleseffect[idx].stadiumLightID = as:GetInt(state, "wvAttribStadLightID")

	db.particleseffect[idx].effectName = as:GetString(effect, "effectName") 
	db.particleseffect[idx].assetId = as:GetInt(effect, "assetId") 
	db.particleseffect[idx].path = "particles"
		
	if (string.find( db.particleseffect[idx].effectName, "glares")) then
		db.particleseffect[idx].path = "fx"
	else
		db.particleseffect[idx].effectName = db.particleseffect[idx].effectName.."_"..db.particleseffect[idx].assetId
	end
    
    if (string.find(as:GetString(effect, "stadiumDependent"), "false")) then
		-- force invalid stadium
		db.particleseffect[idx].stadiumID = -1
	end
end

function ParticlesAssetBind(particles)
	local gr = gRenderables
   	local lod = 0
    
	gr:AddCallback(particles, lod, "ParticlesUpdate(?)")
	gr:AddAsset(particles, lod, "shader", "data/fifarna/shader.big")
	gr:AddAsset(particles, lod, "particlestex", "data/sceneassets/${db.particleseffect[?].path}/${db.particleseffect[?].effectName}.rx3")
	gr:AddAsset(particles, lod, "particleslnx", "data/sceneassets/${db.particleseffect[?].path}/${db.particleseffect[?].effectName}.lnx")
    gr:AddAsset(particles, lod, "stadium", "data/sceneassets/stadium/${db.particleseffect[?].prefix}_${db.particleseffect[?].stadiumID}_${db.particleseffect[?].stadiumLightID}_container_0.rx3")
	
	return particles
end

