function PlayerUpdate(idx)
	local as = gSportsRNA
	local player = as:GetTable("wvPlayer", idx)
	local state = as:GetTable("wvState")
	
	db.player[idx].envLighting = as:GetInt(state, "wvAttribEnvLighting")
	db.player[idx].stadiumLightID = as:GetInt(state, "wvAttribStadLightID")
	db.player[idx].stadiumID = as:GetInt(state, "wvAttribStadID")
	local weather = as:GetInt(state, "wvAttribStadWeather" )
	if (weather == 1 or weather == 2) then
		db.player[idx].wet = 1
	else
		db.player[idx].wet = 0
	end
	
	db.player[idx].playerassetid = as:GetInt(player, "playerassetid") 
	db.player[idx].teamid = as:GetInt(player, "teamid") 
	db.player[idx].teamside = as:GetInt(player, "teamside") 
	db.player[idx].isgoalie = as:GetInt(player, "goalie") 
	
	db.player[idx].kit = as:GetInt(player, "kit") 
	db.player[idx].kitType = as:GetInt(player, "kitType") 
	db.player[idx].kitYear = as:GetInt(player, "kitYear") 

	local kitNumber = as:GetInt(player, "kitNumber") 
	db.player[idx].kitNumberTens = math.floor ( kitNumber / 10 )
	db.player[idx].kitNumberUnits = math.floor ( math.fmod(kitNumber, 10) )

	db.player[idx].kitNameFont = as:GetInt(player, "kitNameFont")
	db.player[idx].kitNumberFont = as:GetInt(player, "kitNumberFont")
	db.player[idx].kitNumberColor = as:GetInt(player, "kitNumberColor")
	db.player[idx].kitNameColor = as:GetInt(player, "kitNameColor")
	
	db.player[idx].shortsNumberFont = as:GetInt(player, "shortsNumberFont")
	db.player[idx].shortsNumberColor = as:GetInt(player, "shortsNumberColor")
	db.player[idx].jerseyNameVisible = as:GetInt(player, "jerseyNameVisible")
	db.player[idx].jerseyNameLayout = as:GetInt(player, "jerseyNameLayout")
	
	db.player[idx].head = as:GetInt(player, "playerHead") 
	db.player[idx].headClass = as:GetInt(player, "playerHeadClass") 
	
	db.player[idx].jerseyCollarType = as:GetInt(player, "jerseyCollarType") 
 -- 0 = male  1 = female
    db.player[idx].gender = as:GetInt(player, "jerseySleeveLength") 
	
	db.player[idx].jerseyArmBand = as:GetInt(player, "jerseyArmBand") 
	db.player[idx].jerseyTucked = as:GetInt(player, "jerseyTucked") 
	db.player[idx].jerseyfit = as:GetInt(player, "jerseyfit") 
	db.player[idx].socklength = as:GetInt(player, "socklength")
	db.player[idx].shortstyle = as:GetInt(player, "shortstyle")
	
	db.player[idx].bodySkinToneType = as:GetInt(player, "playerBodySkinToneType")
	db.player[idx].headSkinToneType = as:GetInt(player, "playerHeadSkinToneType")
	db.player[idx].headSkinType = as:GetInt(player, "playerHeadSkinType")
	db.player[idx].playerBodySkinColor = as:GetInt(player, "playerBodySkinColor")
	db.player[idx].faceGenSkinToneType = as:GetInt(player, "faceGenSkinToneType")
	
	db.player[idx].shoeType = as:GetInt(player, "shoeType")
	db.player[idx].shoeDesign = as:GetInt(player, "shoeDesign")
	db.player[idx].shoeColorPri = as:GetInt(player, "shoeColorPrim")
	db.player[idx].shoeColorSec = as:GetInt(player, "shoeColorSec")
	db.player[idx].shoeColorTer = as:GetInt(player, "shoeColorTer")

	db.player[idx].faceType = as:GetInt(player, "faceType")
	db.player[idx].faceProxyHeadClass = as:GetInt(player, "faceProxyHeadClass")
	-- Faceproxyheadclass should never be greater than one including createplayer
	if (db.player[idx].faceProxyHeadClass == 2) then
		db.player[idx].faceProxyHeadClass = 1
	end
	
	db.player[idx].faceSideBurn = as:GetInt(player, "faceSideBurn")
	db.player[idx].facialHairColor = as:GetInt(player, "facialHairColor")
	db.player[idx].facialHairType = as:GetInt(player, "facialHairType")
	db.player[idx].eyebrow = as:GetInt(player, "eyebrow")
	
	db.player[idx].isVirtualPro = as:GetInt(player, "isVirtualPro")
	db.player[idx].isCreatePlayer = as:GetInt(player, "isCreatePlayer")
	db.player[idx].faceTexExtension = "rx3"
	
	db.player[idx].isCreationZone = as:GetInt(player, "isFCZ")
	db.player[idx].hasCzCrestImage = as:GetInt(player, "hasCzCrestImage")
	db.player[idx].crestAssetId = as:GetInt(player, "crestAssetId")
	db.player[idx].forceLowResBNM = as:GetInt(player, "forceLowResBNM")
	db.player[idx].forcePowerOfTwoBNM = as:GetInt(player, "forcePowerOfTwoBNM")
	db.player[idx].forceunderarm = as:GetInt(player, "forceunderarm")
	db.player[idx].forceundershorts = as:GetInt(player, "forceundershorts")
	db.player[idx].forceunderneck = as:GetInt(player, "forceunderneck")

	db.player[idx].sponsorAssetId = as:GetInt(player, "sponsorAssetId")
	db.player[idx].hotspotJerseySponsorL = as:GetFloat(player, "hotspotJerseySponsorL")
	db.player[idx].hotspotJerseySponsorT = as:GetFloat(player, "hotspotJerseySponsorT")
	db.player[idx].hotspotJerseySponsorR = as:GetFloat(player, "hotspotJerseySponsorR")
	db.player[idx].hotspotJerseySponsorB = as:GetFloat(player, "hotspotJerseySponsorB")
	
	db.player[idx].kitColourJerseyPri = as:GetInt(player, "kitColourJerseyPri")
	db.player[idx].kitColourJerseySec = as:GetInt(player, "kitColourJerseySec")
	db.player[idx].kitColourJerseyTer = as:GetInt(player, "kitColourJerseyTer")

	db.player[idx].kitColourShortPri = as:GetInt(player, "kitColourShortPri")
	db.player[idx].kitColourShortSec = as:GetInt(player, "kitColourShortSec")
	db.player[idx].kitColourShortTer = as:GetInt(player, "kitColourShortTer")

	db.player[idx].kitColourSocksPri = as:GetInt(player, "kitColourSocksPri")
	db.player[idx].kitColourSocksSec = as:GetInt(player, "kitColourSocksSec")
	db.player[idx].kitColourSocksTer = as:GetInt(player, "kitColourSocksTer")

	db.player[idx].sponsorcolour = as:GetInt(player, "sponsorcolour")

	db.player[idx].crestTexName = "crest_cm"
	
	if (db.player[idx].isCreationZone == 1 and db.player[idx].hasCzCrestImage > 0) then
		db.player[idx].crestTexName = "png";
	end

	if (db.player[idx].isVirtualPro == 1) then
		db.player[idx].faceTexExtension = "dds"
	end
	
	db.player[idx].faceTypeFallback = 0
	db.player[idx].headFallback = 0
	db.player[idx].faceSideBurnFallback = db.player[idx].faceSideBurn
	db.player[idx].facialHairColorFallback = db.player[idx].facialHairColor
	db.player[idx].facialHairTypeFallback = db.player[idx].facialHairType
	db.player[idx].headSkinTypeFallback = db.player[idx].headSkinType
	db.player[idx].headSkinToneTypeFallback = db.player[idx].headSkinToneType
	
	if(db.player[idx].headSkinToneTypeFallback == 1 or db.player[idx].headSkinToneTypeFallback == 3 or db.player[idx].headSkinToneTypeFallback == 7) then
		db.player[idx].headSkinToneTypeFallback = db.player[idx].headSkinToneTypeFallback + 1
	end
	
	-- If create player then we need the create player head
	-- head_{id}_{headClass}.rx2
	-- {id} == 0 is create player
	-- {id} == 1 is create player copy
	-- {id} == 2 is facegen head
	-- {id} == 3 is facegen head copy
 	if (db.player[idx].isCreatePlayer == 1) then
		db.player[idx].headClass = 2
		db.player[idx].faceProxyHeadClass = 1
		
		if (db.player[idx].isVirtualPro == 1) then
			db.player[idx].faceSideBurn = 0
			db.player[idx].facialHairColor = 0
			db.player[idx].facialHairType = 0
			db.player[idx].headSkinType = 0
			db.player[idx].headSkinToneType = 0
			
		end
	end
	
	db.player[idx].eyeColor = as:GetInt(player, "eyeColor")
	db.player[idx].hair = as:GetInt(player, "hair")
	db.player[idx].hairColor = as:GetInt(player, "hairColor") 
	
	--FACE
	db.player[idx].headClass = getPlayerFace(db.player[idx].playerassetid,db.player[idx].headClass)
	db.player[idx].faceProxyHeadClass = getPlayerFace(db.player[idx].playerassetid,db.player[idx].faceProxyHeadClass)
	
	if (db.player[idx].headClass == 0) then
	
		local playerassetid = db.player[idx].playerassetid
		
		db.player[idx].head = playerassetid 
		db.player[idx].eyeColor = 0

		db.player[idx].eyebrow = 0
		db.player[idx].faceType = playerassetid
		db.player[idx].faceSideBurn = 0
		db.player[idx].facialHairColor = 0
		db.player[idx].facialHairType = 0
		db.player[idx].headSkinType = 0
		db.player[idx].headSkinToneType = 0

		db.player[idx].hair = playerassetid
		db.player[idx].hairColor = 0
	else
		if(db.player[idx].headSkinToneType == 1 or db.player[idx].headSkinToneType == 3 or db.player[idx].headSkinToneType == 7) then
			db.player[idx].headSkinToneType = db.player[idx].headSkinToneType + 1
		end
		--tmp
		-- db.player[idx].hairColorIdx = db.player[idx].hairColor
		-- db.player[idx].hairColor = 0	
	end

-- Seasonal Assets --
	-- These exist only here and not in the code:
	local seasonal = as:GetInt(player, "seasonaljersey")
	
	--local weather2 = as:GetInt(state, "wvAttribStadWeather" )
	
	--GET ACCESSORY WEATHER
	local winterAcc = getWinterAccessoriesWeather(weather)
	
	--GET PLAYER WINTER ACCESSORIES
	if (db.player[idx].kitType == 5) then
	seasonal = getRefereeWinterAccessories(seasonal)
	end
	
	seasonal = getWinterAccessories(db.player[idx].playerassetid,seasonal)
	
	--SLEEVE LENGTH
	db.player[idx].jerseySleeveLength = getSleeveLength(db.player[idx].playerassetid,db.player[idx].jerseySleeveLength)
		
	if (not winterAcc) then
	--if(db.player[idx].wet == 0) then
		seasonal = db.player[idx].jerseySleeveLength
	end	
	
  db.player[idx].armLength = 0
  db.player[idx].underneck = -1
  db.player[idx].underarms = -1
  db.player[idx].undershorts = -1
  --db.player[idx].jerseyCollarType = 15

  if (seasonal == 0) then
    -- 短袖 Short Sleeves
    db.player[idx].jerseySleeveLength  = 0
    db.player[idx].underneck = -1
    db.player[idx].underarms = -1
    db.player[idx].armLength = 0
  elseif (seasonal == 1) then
    -- 长袖 Long Sleeves
    db.player[idx].jerseySleeveLength = 1
    db.player[idx].underneck = -1
    db.player[idx].underarms = -1
    db.player[idx].armLength = 1
  elseif (seasonal == 2) then
    -- 长袖 + 脖套 Long Sleeves and just underarmor neck
    db.player[idx].jerseySleeveLength = 1
    db.player[idx].underneck = 0
    db.player[idx].underarms = -1
    db.player[idx].armLength = 1
  elseif (seasonal == 3) then
    -- 冰袖 Short Sleeves with underarmor arms
    db.player[idx].jerseySleeveLength = 0
    db.player[idx].underneck = -1
    db.player[idx].underarms = 0
    db.player[idx].armLength = 1
  elseif (seasonal == 4) then
    -- 冰袖 + 脖套 Short Sleeves with underarmor neck and arms
    db.player[idx].jerseySleeveLength = 0
    db.player[idx].underneck = 0
    db.player[idx].underarms = 0
    db.player[idx].armLength = 1
  elseif (seasonal == 5) then
    -- 长袖 + 内裤 Long Sleeves and undershorts
    db.player[idx].jerseySleeveLength = 1
    db.player[idx].underneck = -1
    db.player[idx].underarms = -1
    db.player[idx].armLength = 1
    db.player[idx].undershorts = 0
  elseif (seasonal == 6) then
    -- 长袖 + 内裤 + 脖套 Long Sleeves and undershorts and underarmor neck
    db.player[idx].jerseySleeveLength = 1
    db.player[idx].underneck = 0
    db.player[idx].underarms = -1
    db.player[idx].armLength = 1
    db.player[idx].undershorts = 0
  elseif (seasonal == 7) then
    -- 冰袖 + 内裤 Short Sleeves with underarmor arms and undershorts
    db.player[idx].jerseySleeveLength = 0
    db.player[idx].underneck = -1
    db.player[idx].underarms = 0
    db.player[idx].armLength = 1
    db.player[idx].undershorts = 0
  -- elseif (seasonal == 4) then 8 then
  --   -- 冰袖 + 内裤 + 脖套 Short Sleeves with underarmor arms and undershorts and underarmor neck
  --   db.player[idx].jerseySleeveLength = 0
  --   db.player[idx].underneck = 0
  --   db.player[idx].underarms = 0
  --   db.player[idx].armLength = 1
  --   db.player[idx].undershorts = 0
  else
    -- 短袖 Short Sleeves
    db.player[idx].jerseySleeveLength  = 0
    db.player[idx].underneck = -1
    db.player[idx].underarms = -1
    db.player[idx].armLength = 0
  end

  -- if db.player[idx].wet > 0 or db.player[idx].isVirtualPro == 1 or db.player[idx].isCreatePlayer == 1 then
  --   db.player[idx].undershorts = -1
  -- else
  --   db.player[idx].undershorts = -1
  -- end

  if db.player[idx].forceunderarm == 1 then
    db.player[idx].jerseySleeveLength = 0
    db.player[idx].underarms = 0
    db.player[idx].armLength = 1
  end
  if db.player[idx].forceundershorts == 1 then
    db.player[idx].undershorts = 0
  end
  if db.player[idx].forceunderneck == 1 then
    db.player[idx].underneck = 0
  end
  if db.player[idx].shortstyle == 1 then
    db.player[idx].socklength = -1
    db.player[idx].undershorts = -1
  end

  -- db.player[idx].jerseySleeveLength = ("wvPlayer", idx), "jerseySleeveLength")
  -- db.player[idx].armLength = db.player[idx].jerseySleeveLength
  -- db.player[idx].underneck = -1
  -- db.player[idx].underarms = -1
  -- db.player[idx].undershorts = -1
  -- db.player[idx].socklength = 0
  
-- idx
-- playerId
-- jerseySleeveType 
   -- 0 = short sleeve 
   -- 1 = long sleeve
   -- 2 = short sleeve + underarms 
-- withUnderNeck 
   -- 0 = with no underneck 
   -- 1 = with underneck 
-- sockLength
   -- 0 = middle
   -- 1 = short
   -- 2 = long
-- withUnderShort 
   -- 0 = with no undershorts
   -- 1 = with undershorts
-- shoeType custom shoe
-- jerseyFit 0 -(normal)  1 -(tight)
-- jerseyTucked 0n -(none)   1 -(has)
-- jersey_noarmband 0 jersey_witharmband 1

--URUTAN > SetCustomPlayer (idx, playerId, jerseySleeveType, withUnderNeck, sockLength, withUnderShort, shoeType, jerseyFit, jerseyTucked,jerseyarmband,
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------	 
--Wasit Women
SetCustomPlayer		(idx, 381, 2, 0, 2, 0, 203, 0, 1, 0) --
SetCustomPlayer		(idx, 382, 0, 0, 2, 0, 194, 0, 1, 0) --
SetCustomPlayer		(idx, 383, 2, 0, 2, 0, 163, 0, 1, 0) --
SetCustomPlayer		(idx, 384, 0, 0, 2, 0, 129, 0, 1, 0) -- 
SetCustomPlayer		(idx, 385, 2, 0, 2, 0, 147, 0, 1, 0) -- 
SetCustomPlayer		(idx, 386, 2, 0, 2, 0, 107, 0, 1, 0) --

--Wasit Man
SetCustomPlayer		(idx, 500374, 0, 0, 0, 0, 146, 0, 1, 0) 

--Aston Villa Women
SetCustomPlayer		(idx, 263009, 2, 0, 2, 0, 42, 0, 1, 0) --Hanna Hampton
SetCustomPlayer		(idx, 265326, 0, 0, 2, 0, 43, 0, 1, 0) --Mayling
SetCustomPlayer		(idx, 245875, 2, 0, 2, 0, 42, 0, 1, 0) --Rachel Corsie
SetCustomPlayer		(idx, 265237, 0, 0, 2, 0, 32, 0, 1, 0) -- Anna Patten
SetCustomPlayer		(idx, 245875, 2, 0, 2, 0, 48, 0, 1, 0) -- Rachel Corsie
SetCustomPlayer		(idx, 265319, 2, 0, 2, 0, 49, 0, 1, 0) -- Mayumi Pacheco
SetCustomPlayer		(idx, 265325, 0, 0, 2, 0, 29, 0, 1, 0) -- Ruesha Littlejohn
SetCustomPlayer		(idx, 227353, 0, 0, 2, 0, 23, 0, 1, 0) -- Kenza Dali
SetCustomPlayer		(idx, 265317, 2, 0, 2, 0, 34, 0, 1, 0) --Laura Blindkilde Brown
SetCustomPlayer		(idx, 265311, 1, 0, 1, 0, 49, 0, 1, 1) --Alisha Lehman
SetCustomPlayer		(idx, 235657, 2, 0, 1, 0, 136, 0, 1, 0) --Rachel Daly
SetCustomPlayer		(idx, 233200, 0, 0, 2, 0, 86, 0, 1, 0) -- Emily Gielnik
SetCustomPlayer		(idx, 265324, 2, 0, 2, 0, 56, 0, 1, 0) --Remy Allen
SetCustomPlayer		(idx, 265353, 0, 0, 2, 0, 86, 0, 1, 0) --Natasha Harding
SetCustomPlayer		(idx, 265332, 2, 0, 2, 0, 63, 0, 1, 0) --Danielle Turner
SetCustomPlayer		(idx, 265320, 0, 0, 2, 0, 59, 0, 1, 0) --Meaghan Sargeant
SetCustomPlayer		(idx, 242524, 2, 0, 2, 0, 133, 0, 1, 0) --Anna Leat
SetCustomPlayer		(idx, 265338, 0, 0, 2, 0, 62, 0, 1, 0) --Simone Magill
SetCustomPlayer		(idx, 265312, 2, 0, 2, 0, 56, 0, 1, 0) --Chantelle Boye-Hlorkah
SetCustomPlayer		(idx, 265315, 0, 0, 2, 0, 131, 0, 1, 0) --Freya Gregory
SetCustomPlayer		(idx, 265313, 2, 0, 2, 0, 132, 0, 1, 0) --Elisha N'Dow
SetCustomPlayer		(idx, 266504, 0, 0, 2, 0, 184, 0, 1, 0) --Isobel Goodwin

--Arsenal Women
SetCustomPlayer		(idx, 265242, 2, 0, 2, 0, 56, 0, 1, 0) --Zinsberger
SetCustomPlayer		(idx, 265243, 2, 0, 2, 0, 56, 0, 1, 0) -- Maritz
SetCustomPlayer		(idx, 246426, 0, 0, 2, 0, 56, 0, 1, 0) --Williamson
SetCustomPlayer		(idx, 263013, 2, 0, 2, 0, 56, 0, 1, 0) --Wubben-Moy
SetCustomPlayer		(idx, 227119, 0, 0, 2, 0, 56, 0, 1, 0) --Steph Catley
SetCustomPlayer		(idx, 245872, 2, 0, 2, 0, 56, 0, 1, 0) -- Kim Little
SetCustomPlayer		(idx, 265240, 0, 0, 2, 0, 56, 0, 1, 0) --Lia Walti
SetCustomPlayer		(idx, 245802, 2, 0, 2, 0, 56, 0, 1, 0) --Beth Mead
SetCustomPlayer		(idx, 227110, 2, 0, 2, 0, 56, 0, 1, 0) -- Caitlin Foord
SetCustomPlayer		(idx, 265239, 0, 0, 2, 0, 56, 0, 1, 0) -- Catie McCabe
SetCustomPlayer		(idx, 233746, 0, 0, 2, 0, 56, 0, 1, 0) --Vivianne Miedema
SetCustomPlayer		(idx, 233364, 0, 0, 2, 0, 56, 0, 1, 0) --Stina Blackstenius
SetCustomPlayer		(idx, 227257, 2, 0, 2, 0, 56, 0, 1, 0) --Jordan Nobbs
SetCustomPlayer		(idx, 239761, 0, 0, 2, 0, 56, 0, 1, 0) --Frida Maanum
SetCustomPlayer		(idx, 227421, 2, 0, 2, 0, 56, 0, 1, 0) --Rafaelle Leone
SetCustomPlayer		(idx, 270890, 0, 0, 2, 0, 56, 0, 1, 0) --Kailan Marckese
SetCustomPlayer		(idx, 227018, 0, 0, 2, 0, 56, 0, 1, 0) --Mana Iwabuchi
SetCustomPlayer		(idx, 245873, 0, 0, 2, 0, 56, 0, 1, 0) -- Jennifer Beattie
SetCustomPlayer		(idx, 264996, 0, 0, 2, 0, 24, 0, 1, 0) --Torun Wienroither
SetCustomPlayer		(idx, 266457, 2, 0, 2, 0, '', 0, 1, 0) --Teyah Goldie

--Manchester Women
SetCustomPlayer		(idx, 247504, 2, 0, 2, 0, 155, 0, 1, 0) --Marie Earps
SetCustomPlayer		(idx, 253436, 0, 0, 2, 0, 145, 0, 1, 0)  --Ona Batlle Pascual
SetCustomPlayer		(idx, 263012, 0, 0, 2, 0, 172, 0, 1, 0)  --Caicedo
SetCustomPlayer		(idx, 233330, 2, 0, 2, 0, 133, 0, 1, 0)  --Caicedo
SetCustomPlayer		(idx, 247797, 0, 0, 2, 0, 179, 0, 1, 0)  --Hannah Blundell
SetCustomPlayer		(idx, 265273, 2, 0, 2, 0, 197, 0, 1, 0)  --Katie Zelem
SetCustomPlayer		(idx, 265271, 0, 0, 2, 0, 202, 0, 1, 0)  --Hayley Leed
SetCustomPlayer		(idx, 235659, 2, 0, 2, 0, 207, 0, 1, 0)  --Nikita Paris
SetCustomPlayer		(idx, 242796, 2, 0, 2, 0, 303, 0, 1, 0)  --Lucia García Córdoba
SetCustomPlayer		(idx, 265275, 0, 0, 2, 0, 325, 0, 1, 0)  --Lea Galton
SetCustomPlayer		(idx, 258980, 2, 0, 2, 0, 326, 0, 1, 0)  --Alessia Rosso
SetCustomPlayer		(idx, 263011, 2, 0, 2, 0, 200, 0, 1, 0)  --Caicedo
SetCustomPlayer		(idx, 265263, 2, 0, 2, 0, 327, 0, 1, 0)  --Rachel Williams
SetCustomPlayer		(idx, 233852, 2, 0, 2, 0, 201, 0, 1, 0)  --Jackie Groenen
SetCustomPlayer		(idx, 265293, 2, 0, 2, 0, 347, 0, 1, 0)  --Maya Le Tissier
SetCustomPlayer		(idx, 265279, 0, 0, 2, 0, 326, 0, 1, 0)  --Shopie Baggaley
SetCustomPlayer		(idx, 227397, 0, 0, 2, 0, 316, 0, 1, 0)  --Adriana Leon
SetCustomPlayer		(idx, 265277, 0, 0, 2, 0, 317, 0, 1, 0)  --Martha Thomas
SetCustomPlayer		(idx, 265280, 0, 0, 2, 0, 343, 0, 1, 0)  --Vilde Bøe Risa
SetCustomPlayer		(idx, 265274, 0, 0, 2, 0, 52, 0, 1, 0)  --Kirsty Hanson
SetCustomPlayer		(idx, 265268, 0, 0, 2, 0, 139, 0, 1, 0)  --Aoife Mannion
SetCustomPlayer		(idx, 227256, 0, 0, 2, 0, 136, 0, 1, 0)  --Caicedo
SetCustomPlayer		(idx, 246235, 0, 0, 2, 0, 131, 0, 1, 0)  --Caicedo
SetCustomPlayer		(idx, 265333, 0, 0, 2, 0, 140, 0, 1, 0)  --Grace Clinton

--Chelsea Women
SetCustomPlayer		(idx, 236428, 2, 0, 2, 0, 200, 0, 1, 0)  --Periset
SetCustomPlayer		(idx, 226998, 0, 0, 2, 0, 351, 0, 1, 0)  --Eriksson
SetCustomPlayer		(idx, 238257, 2, 0, 2, 0, 350, 0, 1, 0)  --Millie Bright
SetCustomPlayer		(idx, 227282, 2, 0, 2, 0, 131, 0, 1, 0)  -- Maren Mjelde
SetCustomPlayer		(idx, 258310, 0, 0, 2, 0, 161, 0, 1, 0)  --Berger
SetCustomPlayer		(idx, 227125, 1, 0, 1, 0, 177, 0, 1, 0)  -- Sam Kerr
SetCustomPlayer		(idx, 227323, 2, 0, 2, 0, 343, 0, 1, 0)  -- Fran Kirby
SetCustomPlayer		(idx, 265250, 0, 0, 2, 0, 188, 0, 1, 0)  -- Shopie Ingle
SetCustomPlayer		(idx, 245882, 2, 0, 2, 0, 346, 0, 1, 0)  -- Erin Cuthbert
SetCustomPlayer		(idx, 265304, 2, 0, 2, 0, 347, 0, 1, 0)  --Katerina Svitková
SetCustomPlayer		(idx, 263007, 0, 0, 2, 0, 348, 0, 1, 0)  --Niamh Charles
SetCustomPlayer		(idx, 226354, 2, 0, 2, 0, 343, 0, 1, 0)  --Melanie Leupolz
SetCustomPlayer		(idx, 256489, 2, 0, 2, 0, 185, 0, 1, 0)  -- Bethany England
SetCustomPlayer		(idx, 265247, 0, 0, 2, 0, 348, 0, 1, 0)  --Jess Carteer
SetCustomPlayer		(idx, 246317, 0, 0, 2, 0, 189, 0, 1, 0)  --Aniek Nouwen
SetCustomPlayer		(idx, 227387, 2, 0, 2, 0, 190, 0, 1, 0)  --Jessie Flemming
SetCustomPlayer		(idx, 243379, 0, 0, 2, 0, 191, 0, 1, 0)  --Zećira Musovic
SetCustomPlayer		(idx, 270664, 2, 0, 2, 0, 101, 0, 1, 0)  --Lucy Watson
SetCustomPlayer		(idx, 266548, 0, 0, 2, 0, 342, 0, 1, 0)  --Alsu Abdullina
SetCustomPlayer		(idx, 266911, 2, 0, 2, 0, 340, 0, 1, 0)  --Charlotte Wardlaw
SetCustomPlayer		(idx, 265249, 0, 0, 1, 0, 347, 0, 1, 0)  --Lauren James
SetCustomPlayer		(idx, 241491, 0, 0, 2, 0, 339, 0, 1, 0)  --Johanna Rytting Kaneryd
SetCustomPlayer		(idx, 265248, 0, 0, 2, 0, 341, 0, 1, 0)  --Jorja Fox
SetCustomPlayer		(idx, 259287, 0, 0, 2, 0, 357, 0, 1, 0)  --Pernille Harder

--Indonesia Women
SetCustomPlayer		(idx, 61127, 2, 0, 2, 0, 56, 0, 1, 0)  --Fani Supriyanto
SetCustomPlayer		(idx, 61128, 2, 0, 2, 0, 56, 0, 1, 0)  --Nurhalimah
SetCustomPlayer		(idx, 61129, 2, 0, 2, 0, 56, 0, 1, 0)  --Riska Aprilia
SetCustomPlayer		(idx, 61130, 0, 0, 2, 0, 101, 0, 1, 0)  --Shakila Aurelia
SetCustomPlayer		(idx, 61131, 2, 0, 2, 0, 107, 0, 1, 0)  -- Diah Tri
SetCustomPlayer		(idx, 61132, 2, 0, 2, 0, 107, 0, 1, 0)  -- Remini Chere
SetCustomPlayer		(idx, 61133, 0, 0, 2, 0, 101, 0, 1, 0)  -- Vivi Oktavia Riski
SetCustomPlayer		(idx, 61134, 0, 0, 2, 0, 100, 0, 1, 0)  -- Tia Darti Setiawati
SetCustomPlayer		(idx, 61135, 2, 0, 2, 0, 99, 0, 1, 0)  --Ade Mustikiana
SetCustomPlayer		(idx, 61150, 0, 0, 1, 0, 146, 0, 1, 1)  --Shafira Ika Putri
SetCustomPlayer		(idx, 61136, 2, 0, 1, 0, 136, 0, 1, 0)  --Helsa Maeisyaroh
SetCustomPlayer		(idx, 61137, 0, 0, 2, 0, 56, 0, 1, 0)  -- Rani Mulyasari
SetCustomPlayer		(idx, 61138, 2, 0, 2, 0, 56, 0, 1, 0)  --Sabrina Mutiara
SetCustomPlayer		(idx, 61139, 0, 0, 2, 0, 56, 0, 1, 0)  --Octaviani Dwi
SetCustomPlayer		(idx, 61140, 2, 0, 2, 0, 56, 0, 1, 0)  --Maulina Novryliani
SetCustomPlayer		(idx, 61141, 0, 0, 2, 0, 56, 0, 1, 0)  --Rosdilah Siti
SetCustomPlayer		(idx, 61142, 2, 0, 2, 0, 56, 0, 1, 0)  --Viny Silfianus
SetCustomPlayer		(idx, 61143, 0, 0, 2, 0, 56, 0, 1, 0)  --Pani Tri
SetCustomPlayer		(idx, 61144, 2, 0, 2, 0, 56, 0, 1, 0)  --Reva Octaviani
SetCustomPlayer		(idx, 61145, 0, 0, 2, 0, 56, 0, 1, 0)  --Zahra Muzdalifah
SetCustomPlayer		(idx, 61146, 2, 0, 2, 0, 56, 0, 1, 0)  --Baiq Amiatun
SetCustomPlayer		(idx, 61147, 0, 0, 2, 0, 56, 0, 1, 0)  --Marsela Yuliana
SetCustomPlayer		(idx, 61148, 0, 0, 2, 0, 56, 0, 1, 0)  --Carla Bio

--Arsenal
SetCustomPlayer		(idx, 233934, 2, 0, 0, 0, 24, 0, 1, 0)  -- Aaron Ramsdale
SetCustomPlayer		(idx, 233267, 2, 0, 0, 0, 158, 0, 1, 0)  -- Matt Turner
SetCustomPlayer		(idx, 243715, 0, 0, 0, 0, 164, 0, 1, 0)  -- William Saliba
SetCustomPlayer		(idx, 265693, 0, 0, 0, 0, 146, 0, 1, 0)  -- Jakub Kiwior
SetCustomPlayer		(idx, 157304, 0, 0, 0, 0, 24, 0, 1, 0) -- Vermaelen
SetCustomPlayer		(idx, 7826, 0, 0, 0, 0, 24, 0, 1, 0) -- Van Persie
SetCustomPlayer		(idx, 232580, 0, 0, 0, 0, 48, 0, 1, 0)  -- Gabriel Magalhaes
SetCustomPlayer		(idx, 231936, 0, 0, 0, 0, 48, 0, 1, 0)  -- Ben White
SetCustomPlayer		(idx, 251805, 0, 0, 0, 0, 25, 0, 1, 0)  -- Jurrien Timber
SetCustomPlayer		(idx, 232938, 2, 0, 0, 0, 343, 0, 1, 0)  -- Takehiro Tomiyasu
SetCustomPlayer		(idx, 226491, 0, 0, 0, 0, 49, 0, 1, 0)  -- Kieran Tierney
SetCustomPlayer		(idx, 227813, 2, 0, 1, 0, 151, 0, 1, 0)  --  Zinchenko
SetCustomPlayer		(idx, 228295, 0, 0, 0, 0, 131, 0, 1, 0)  -- Rob Holding
SetCustomPlayer		(idx, 211454, 0, 0, 0, 0, 56, 0, 1, 0)  -- Mohamed Elneny
SetCustomPlayer		(idx, 209989, 0, 0, 0, 0, 49, 0, 1, 0)  -- Thomas Partey
SetCustomPlayer		(idx, 256958, 0, 0, 0, 0, 172, 0, 1, 0)  -- Fábio Vieira
SetCustomPlayer		(idx, 240273, 0, 0, 0, 0, 171, 0, 1, 0)  --Smith Rowe
SetCustomPlayer		(idx, 222665, 2, 0, 0, 0, 196, 0, 1, 1)  -- Martin Odegaard
SetCustomPlayer		(idx, 234378, 0, 0, 0, 0, 49, 0, 1, 0)  -- Declan Rice
SetCustomPlayer		(idx, 205498, 0, 0, 0, 0, 86, 0, 1, 0)  -- Jorginho
SetCustomPlayer		(idx, 235790, 2, 0, 0, 0, 141, 0, 1, 1)  -- Kai Havertz
SetCustomPlayer		(idx, 251566, 0, 0, 0, 0, 48, 0, 1, 0)  -- Gabriel Martinelli
SetCustomPlayer		(idx, 246669, 0, 0, 0, 0, 121, 0, 1, 0)  -- Bukayo Saka
SetCustomPlayer		(idx, 207421, 0, 0, 0, 0, 25, 0, 1, 0)  -- Leandro Trossard
SetCustomPlayer		(idx, 233666, 0, 0, 0, 0, 24, 0, 1, 0)  -- Gabriel Jesus
SetCustomPlayer		(idx, 231448, 0, 0, 0, 0, 54, 0, 1, 0)  -- Reiss Nelson
SetCustomPlayer		(idx, 236988, 0, 0, 0, 0, 149, 0, 1, 0)  -- Nketiah
SetCustomPlayer		(idx, 270390, 0, 0, 0, 0, 131, 0, 1, 0)  -- Marquinhos

--Chelsea
SetCustomPlayer		(idx, 206585, 2, 0, 0, 0, 49, 0, 1, 0)  -- Kepa
SetCustomPlayer		(idx, 248158, 2, 0, 0, 0, 163, 0, 1, 0)  -- Gabriel Slonina
SetCustomPlayer		(idx, 238074, 0, 0, 1, 0, 185, 0, 1, 0)  -- Reece James
SetCustomPlayer		(idx, 5471, 0, 0, 0, 0, 24, 0, 1, 0) -- Frank Lampard
SetCustomPlayer		(idx, 178372, 0, 0, 0, 0, 24, 0, 1, 0) -- Ivanovic
SetCustomPlayer		(idx, 230918, 0, 0, 0, 0, 131, 0, 1, 0)  -- Trevoh Chalobah
SetCustomPlayer		(idx, 248695, 0, 0, 0, 0, 54, 0, 1, 0)  -- Wesley Fofana
SetCustomPlayer		(idx, 164240, 0, 0, 0, 0, 86, 0, 1, 0)  -- Thiago Silva
SetCustomPlayer		(idx, 242578, 0, 0, 0, 0, 42, 0, 1, 0)  -- Badiashile
SetCustomPlayer		(idx, 262859, 0, 0, 0, 0, 25, 0, 1, 0)  -- Levi Colwill
SetCustomPlayer		(idx, 229984, 0, 0, 0, 0, 172, 0, 1, 0)   -- Ben Chilwell
SetCustomPlayer		(idx, 239231, 0, 0, 1, 0, 146, 0, 1, 0)  -- Marc Cucurella
SetCustomPlayer		(idx, 235454, 2, 0, 0, 0, 300, 0, 1, 0)  -- Malang Sarr
SetCustomPlayer		(idx, 259307, 2, 0, 0, 0, 146, 0, 1, 0)  -- Malo Gusto
SetCustomPlayer		(idx, 238216, 0, 0, 0, 0, 187, 0, 1, 0)  -- Conor Gallagher
SetCustomPlayer		(idx, 256079, 0, 0, 0, 0, 32, 0, 1, 0)  -- Isaac Caicedo
SetCustomPlayer		(idx, 259356, 0, 0, 0, 0, 172, 0, 1, 0)  -- Chukwuemeka
SetCustomPlayer		(idx, 240740, 0, 0, 0, 0, 42, 0, 1, 0)  -- Hudson-Odoi
SetCustomPlayer		(idx, 273018, 0, 0, 0, 0, 143, 0, 1, 0)  -- Andrey Santos
SetCustomPlayer		(idx, 247090, 0, 0, 0, 0, 176, 0, 1, 1)  -- Enzo Fernandez
SetCustomPlayer		(idx, 208670, 0, 0, 0, 0, 28, 0, 1, 0)  -- Hakim Ziyech
SetCustomPlayer		(idx, 202652, 0, 0, 0, 0, 122, 0, 1, 0)  -- Raheem Sterling
SetCustomPlayer		(idx, 246340, 0, 0, 1, 0, 172, 0, 1, 0)  -- Mykhalio Mudryk
SetCustomPlayer		(idx, 254796, 0, 0, 0, 0, 48, 0, 1, 0)  -- Noni Madueke
SetCustomPlayer		(idx, 232411, 0, 0, 0, 0, 48, 0, 1, 0)  -- Christopher Nkunku
SetCustomPlayer		(idx, 256268, 0, 0, 0, 0, 178, 0, 1, 0)  -- Armando Broja

--Real Madrid
SetCustomPlayer		(idx, 192119, 1, 0, 0, 0, 161, 0, 1, 0)  -- Thibaut Courtois
SetCustomPlayer		(idx, 243952, 0, 0, 0, 0, 343, 0, 1, 0)  -- Lunin
SetCustomPlayer		(idx, 204963, 1, 0, 0, 0, 139, 0, 1, 1)  -- Dani Carvajal
SetCustomPlayer		(idx, 155862, 0, 0, 0, 0, 24, 0, 1, 0) -- Ramos
SetCustomPlayer		(idx, 185020, 0, 0, 0, 0, 24, 0, 1, 0) -- Callejon
SetCustomPlayer		(idx, 167664, 0, 0, 0, 0, 24, 0, 1, 0) -- Higuain
SetCustomPlayer		(idx, 208618, 0, 0, 0, 0, 49, 0, 1, 0)  -- Lucas Vázquez
SetCustomPlayer		(idx, 240130, 0, 0, 0, 0, 24, 0, 1, 0)  -- Éder Militão
SetCustomPlayer		(idx, 197445, 0, 0, 0, 0, 25, 0, 1, 0)  -- David Alaba
SetCustomPlayer		(idx, 205452, 0, 0, 0, 0, 138, 0, 1, 0)  -- Antonio Rüdiger
SetCustomPlayer		(idx, 200724, 0, 0, 0, 0, 24, 0, 1, 0)  -- Nacho
SetCustomPlayer		(idx, 228618, 2, 0, 0, 0, 25, 0, 1, 0)  -- Ferland Mendy
SetCustomPlayer		(idx, 234035, 0, 0, 0, 0, 43, 0, 1, 0)  -- Odriozola
SetCustomPlayer		(idx, 246606, 2, 0, 0, 0, 186, 0, 1, 0)  -- Fran Garcia
SetCustomPlayer		(idx, 182521, 0, 0, 0, 0, 70, 0, 1, 0)  -- Toni Kroos
SetCustomPlayer		(idx, 177003, 0, 0, 0, 0, 176, 0, 1, 0)  -- Luka Modrić
SetCustomPlayer		(idx, 239053, 0, 0, 0, 0, 196, 0, 1, 0)  -- Federico Valverde
SetCustomPlayer		(idx, 248243, 0, 0, 1, 0, 131, 0, 1, 0)  -- Eduardo Camavinga
SetCustomPlayer		(idx, 241637, 0, 0, 0, 0, 144, 0, 1, 0)  -- Aurélien Tchouaméni
SetCustomPlayer		(idx, 222509, 0, 0, 0, 0, 142, 0, 1, 0)  -- Ceballos Fernández
SetCustomPlayer		(idx, 231410, 0, 0, 0, 0, 187, 0, 1, 0)  -- Brahim Diaz
SetCustomPlayer		(idx, 252371, 0, 0, 0, 0, 25, 0, 1, 0)  -- Jude Bellingham
SetCustomPlayer		(idx, 264309, 0, 0, 0, 0, 196, 0, 1, 0)  -- Arda Guller
SetCustomPlayer		(idx, 243812, 0, 0, 0, 0, 136, 0, 1, 0)  -- Rodrygo Goes
SetCustomPlayer		(idx, 238794, 0, 0, 0, 0, 325, 0, 1, 0)  -- Vinícius Jr.
SetCustomPlayer		(idx, 173608, 0, 0, 0, 0, 49, 0, 1, 0)  -- Joselu
SetCustomPlayer		(idx, 265194, 0, 0, 0, 0, 202, 0, 1, 0)  -- Iker Bravo
SetCustomPlayer		(idx, 268411, 0, 0, 0, 0, 202, 0, 1, 0)  -- Vinicius Tobias

--Barcelona
SetCustomPlayer		(idx, 192448, 1, 0, 0, 0, 25, 0, 1, 0)  -- Ter Stegen
SetCustomPlayer		(idx, 246139, 2, 0, 0, 0, 25, 0, 1, 0)  -- Inaki Pena
SetCustomPlayer		(idx, 106573, 0, 0, 0, 0, 24, 0, 1, 0) -- Valdes
SetCustomPlayer		(idx, 110082, 0, 0, 0, 0, 24, 0, 1, 0) -- Pinto
SetCustomPlayer		(idx, 241486, 0, 0, 1, 0, 25, 0, 1, 1)  -- Jules Kounde
SetCustomPlayer		(idx, 199564, 0, 0, 0, 0, 172, 0, 1, 0)  -- Sergio Roberto
SetCustomPlayer		(idx, 152729, 0, 0, 0, 0, 24, 0, 1, 0) -- Pique
SetCustomPlayer		(idx, 13038, 0, 0, 0, 0, 24, 0, 1, 0) -- Puyol
SetCustomPlayer		(idx, 194644, 0, 0, 0, 0, 24, 0, 1, 0) -- Montoya
SetCustomPlayer		(idx, 198141, 0, 0, 0, 0, 24, 0, 1, 0) -- Marc Bartra
SetCustomPlayer		(idx, 247678, 0, 0, 0, 0, 143, 0, 1, 0)  -- Julian Araujo
SetCustomPlayer		(idx, 253163, 0, 0, 0, 0, 164, 0, 1, 0)  -- Ronald Araújo
SetCustomPlayer		(idx, 245037, 0, 0, 1, 0, 65, 0, 1, 0)  -- Eric Garcia
SetCustomPlayer		(idx, 260361, 0, 0, 0, 0, 34, 0, 1, 0)  -- Mikayel Faye
SetCustomPlayer		(idx, 213661, 0, 0, 0, 0, 64, 0, 1, 0)  -- Andreas Christensen
SetCustomPlayer		(idx, 204525, 0, 0, 0, 0, 138, 0, 1, 0)  -- Inigo Martinez Berridi
SetCustomPlayer		(idx, 192638, 0, 0, 0, 0, 131, 0, 1, 0)  -- Marcus Alonso
SetCustomPlayer		(idx, 263578, 0, 0, 0, 0, 196, 0, 1, 0)  -- Balde
SetCustomPlayer		(idx, 186942, 0, 0, 1, 0, 65, 0, 1, 0)  -- İlkay Gündoğan
SetCustomPlayer		(idx, 251854, 0, 0, 1, 0, 24, 0, 1, 0)  -- Pedri
SetCustomPlayer		(idx, 228702, 0, 0, 0, 0, 157, 0, 1, 0)  -- Frankie De Jong
SetCustomPlayer		(idx, 264240, 0, 0, 0, 0, 144, 0, 1, 0)  -- Pablo Gavi
SetCustomPlayer		(idx, 267976, 0, 0, 0, 0, 179, 0, 1, 0)  -- Pablo Torre
SetCustomPlayer		(idx, 202648, 0, 0, 0, 0, 187, 0, 1, 0)  -- Sergi Darder
SetCustomPlayer		(idx, 241461, 0, 0, 0, 0, 49, 0, 1, 0)  -- Ferran Torres
SetCustomPlayer		(idx, 253004, 0, 0, 0, 0, 187, 0, 1, 0)  -- Ansu Fati
SetCustomPlayer		(idx, 233419, 0, 0, 0, 0, 49, 0, 1, 0)  -- Raphinha
SetCustomPlayer		(idx, 188545, 0, 0, 0, 0, 172, 0, 1, 0)  -- Robert Lewandowski
SetCustomPlayer		(idx, 237823, 0, 0, 0, 0, 132, 0, 1, 0)  -- Abe
SetCustomPlayer		(idx, 274133, 0, 0, 0, 0, 202, 0, 1, 0)  -- Lamine Yamal
SetCustomPlayer		(idx, 235790, 0, 0, 0, 0, 196, 0, 1, 0)  -- Vitor Roque

--Manchester United
SetCustomPlayer		(idx, 226753, 2, 0, 0, 0, 21, 0, 1, 0)  -- Onana
SetCustomPlayer		(idx, 163264, 2, 0, 0, 0, 131, 0, 1, 0)  -- Tom Heaton
SetCustomPlayer		(idx, 255981, 2, 0, 0, 0, 131, 0, 1, 0)  -- Suzuki
SetCustomPlayer		(idx, 234574, 2, 0, 0, 0, 187, 0, 1, 0)  -- Diogo Dalot
SetCustomPlayer		(idx, 229880, 0, 0, 0, 0, 49, 0, 1, 0)  -- Aaron Wan-bissaka
SetCustomPlayer		(idx, 201535, 0, 0, 0, 0, 146, 0, 1, 0)  -- Raphael Varane
SetCustomPlayer		(idx, 239301, 0, 0, 0, 0, 49, 0, 1, 0)  -- Lisandro Martínez
SetCustomPlayer		(idx, 203263, 0, 0, 0, 0, 146, 0, 1, 0)  -- Harry Maguire
SetCustomPlayer		(idx, 221660, 0, 0, 0, 0, 140, 0, 1, 0)  -- Victor Lindelof
SetCustomPlayer		(idx, 205988, 0, 0, 1, 0, 49, 0, 1, 0)  -- Luke Shaw
SetCustomPlayer		(idx, 238041, 0, 0, 0, 0, 172, 0, 1, 0)  -- Tyrell Malacia
SetCustomPlayer		(idx, 268889, 0, 0, 0, 0, 48, 0, 1, 0)  -- Alvaro Fernandes
SetCustomPlayer		(idx, 200145, 0, 0, 0, 0, 131, 0, 1, 0)  -- Casemiro
SetCustomPlayer		(idx, 212198, 0, 0, 0, 0, 326, 0, 1, 1)  -- Bruno Fernandes
SetCustomPlayer		(idx, 253283, 0, 0, 0, 0, 300, 0, 1, 0)  -- Pellistri
SetCustomPlayer		(idx, 233064, 0, 0, 0, 0, 131, 0, 1, 0)  -- Mason Mount
SetCustomPlayer		(idx, 190460, 0, 0, 0, 0, 196, 0, 1, 0)  -- Christian Eriksen
SetCustomPlayer		(idx, 224158, 0, 0, 0, 0, 131, 0, 1, 0)  -- Sofyan Amrabat
SetCustomPlayer		(idx, 237238, 0, 0, 0, 0, 49, 0, 1, 0)  -- Scoot McTominay
SetCustomPlayer		(idx, 209297, 0, 0, 0, 0, 187, 0, 1, 0)  -- Fred
SetCustomPlayer		(idx, 269136, 0, 0, 0, 0, 140, 0, 1, 0)  -- K. Mainoo
SetCustomPlayer		(idx, 254088, 0, 0, 0, 0, 29, 0, 1, 0)  -- Amad Diallo
SetCustomPlayer		(idx, 231677, 0, 0, 0, 0, 346, 0, 1, 0)  -- Marcus Rashford
SetCustomPlayer		(idx, 259399, 0, 0, 0, 0, 172, 0, 1, 0)  -- Rasmus Hojlund
SetCustomPlayer		(idx, 255475, 0, 0, 0, 0, 347, 0, 1, 0)  -- Antony
SetCustomPlayer		(idx, 2330490, 0, 0, 0, 0, 205, 0, 1, 0)  -- Jadon Sancho
SetCustomPlayer		(idx, 268438, 0, 0, 0, 0, 172, 0, 1, 0)  -- Alejandro Garnacho
SetCustomPlayer		(idx, 246147, 0, 0, 0, 0, 131, 0, 1, 0)  -- Mason Greenwood
SetCustomPlayer		(idx, 211300, 0, 0, 0, 0, 346, 0, 1, 0)  -- Martial
SetCustomPlayer		(idx, 260910, 0, 0, 0, 0, 131, 0, 1, 0)  -- S. Shoretire

--Manchester United Legend
SetCustomPlayer		(idx, 51539, 2, 0, 1, 0, '', 0, 1, 0)  --  Van Der Sar
SetCustomPlayer		(idx, 244, 0, 0, 1, 0, '', 0, 1, 0)  --  Gary Naville
SetCustomPlayer		(idx, 7289, 0, 0, 1, 0, '', 0, 1, 0)  --  Rio Ferdinand
SetCustomPlayer		(idx, 140601, 0, 0, 1, 0, '', 0, 1, 0) -- Vidic
SetCustomPlayer		(idx, 52091, 0, 0, 1, 0, '', 0, 1, 0) --  Patrice Evra
SetCustomPlayer		(idx, 61493, 0, 0, 1, 0, '', 0, 1, 0) -- CR 7 Young
SetCustomPlayer		(idx, 246, 0, 0, 1, 0, '', 0, 1, 0) --  Paul Scholes
SetCustomPlayer		(idx, 2114, 0, 0, 1, 0, '', 0, 1, 0) --  Michael Carrick
SetCustomPlayer		(idx, 241, 0, 0, 1, 0, '', 0, 1, 0) -- Ryan Giggs
SetCustomPlayer		(idx, 3912, 0, 0, 1, 0, '', 0, 1, 0) -- Patrice Saha
SetCustomPlayer		(idx, 54050, 0, 0, 1, 0, '', 0, 1, 0) -- Wayne Rooney
SetCustomPlayer		(idx, 10264, 0, 0, 1, 0, '', 0, 1, 0) -- Ruud Van Nistelroy
SetCustomPlayer		(idx, 3484, 0, 0, 1, 0, '', 0, 1, 0) -- Jhon Oshea
SetCustomPlayer		(idx, 8222, 0, 0, 1, 0, '', 0, 1, 0) -- Heinze
SetCustomPlayer		(idx, 13130, 0, 0, 1, 0, '', 0, 1, 0) -- Wes Brown
SetCustomPlayer		(idx, 138782, 0, 0, 1, 0, '', 0, 1, 0) -- D. Fletcher
SetCustomPlayer		(idx, 39943, 0, 0, 1, 0, '', 0, 1, 0) --  Park Ji-Sung
SetCustomPlayer		(idx, 1845, 0, 0, 1, 0, '', 0, 1, 0) --  Ole Gunner Solskjær
SetCustomPlayer		(idx, 250, 0, 0, 1, 0, '', 0, 1, 0) -- David Beckam
SetCustomPlayer		(idx, 101473, 0, 0, 1, 0, '', 0, 1, 0) -- Thomas Kuszczak
SetCustomPlayer		(idx, 5818, 0, 0, 1, 0, '', 0, 1, 0) -- Mikael Silvestre
SetCustomPlayer		(idx, 169593, 0, 0, 1, 0, '', 0, 1, 0) -- Kieran Lee
SetCustomPlayer		(idx, 138784, 0, 0, 1, 0, '', 0, 1, 0) -- Kieran Richardson
SetCustomPlayer		(idx, 13739, 0, 0, 1, 0, '', 0, 1, 0) -- Alan Smitch

--PSG
SetCustomPlayer		(idx, 230621, 2, 0, 0, 0, 65, 0, 1, 0) -- Donnarumma
SetCustomPlayer		(idx, 235212, 0, 0, 0, 0, 49, 0, 1, 0) -- Hakimi
SetCustomPlayer		(idx, 226166, 0, 0, 0, 0, 172, 0, 1, 0) -- Mukiele
SetCustomPlayer		(idx, 232363, 0, 0, 0, 0, 86, 0, 1, 0) -- Milan Škriniar
SetCustomPlayer		(idx, 225850, 0, 0, 0, 0, 172, 0, 1, 0) -- Kimpembe
SetCustomPlayer		(idx, 220814, 0, 0, 0, 0, 164, 0, 1, 0) -- Lucas Hernandez
SetCustomPlayer		(idx, 207865, 0, 0, 0, 0, 141, 0, 1, 1) -- Marquinhos
SetCustomPlayer		(idx, 252145, 0, 0, 0, 0, 42, 0, 1, 0) -- Nuno Mendes
SetCustomPlayer		(idx, 205069, 0, 0, 0, 0, 65, 0, 1, 0) -- Juan Bernat
SetCustomPlayer		(idx, 200888, 0, 0, 0, 0, 141, 0, 1, 0) -- Danilo Ferreira
SetCustomPlayer		(idx, 253306, 0, 0, 0, 0, 48, 0, 1, 0) -- Manuel Ugarte
SetCustomPlayer		(idx, 255253, 0, 0, 0, 0, 186, 0, 1, 0) -- Vitinha
SetCustomPlayer		(idx, 270673, 0, 0, 0, 0, 187, 0, 1, 0) -- Warren Zaïre-Emery
SetCustomPlayer		(idx, 206652, 0, 0, 0, 0, 143, 0, 1, 0) -- Rico González
SetCustomPlayer		(idx, 199556, 0, 0, 0, 0, 142, 0, 1, 0) -- Verratti
SetCustomPlayer		(idx, 263193, 0, 0, 0, 0, 24, 0, 1, 0) -- Renato Sanches
SetCustomPlayer		(idx, 226271, 0, 0, 0, 0, 148, 0, 1, 0) -- Marco Ruiz Peña
SetCustomPlayer		(idx, 220834, 2, 0, 0, 0, 25, 0, 1, 0) -- Marco Asensio
SetCustomPlayer		(idx, 190871, 0, 0, 2, 0, 86, 0, 1, 0) -- Neymar
SetCustomPlayer		(idx, 231747, 0, 0, 0, 0, 325, 0, 1, 0) -- Mbappe
SetCustomPlayer		(idx, 257289, 0, 0, 0, 0, 48, 0, 1, 0) -- Ekitike
SetCustomPlayer		(idx, 256903, 0, 0, 0, 0, 143, 0, 1, 0) -- Gonzalo Ramos
SetCustomPlayer		(idx, 243780, 2, 0, 0, 0, 48, 0, 1, 0) -- Lee Kang In
SetCustomPlayer		(idx, 231443, 2, 0, 0, 0, 11, 0, 1, 0)  -- Ousmane Dembélé

--AlNars
SetCustomPlayer		(idx, 176550, 2, 0, 0, 0, 346, 0, 1, 0) -- Ospina
SetCustomPlayer		(idx, 232477, 0, 0, 0, 0, 129, 0, 1, 0) -- Al Ghannam
SetCustomPlayer		(idx, 241197, 0, 0, 0, 0, 156, 0, 1, 0) -- Al Amri
SetCustomPlayer		(idx, 202935, 0, 0, 0, 0, 194, 0, 1, 0) -- Alvaro González
SetCustomPlayer		(idx, 235634, 0, 0, 0, 0, 148, 0, 1, 0) -- Konan
SetCustomPlayer		(idx, 212462, 0, 0, 0, 0, 131, 0, 1, 0) -- Alex Telles
SetCustomPlayer		(idx, 185221, 0, 0, 0, 0, 147, 0, 1, 0) -- Luiz Gustavo
SetCustomPlayer		(idx, 237721, 0, 0, 0, 0, 127, 0, 1, 0) -- Al Khaibari
SetCustomPlayer		(idx, 216320, 0, 0, 0, 0, 328, 0, 1, 0) -- Seko Fofana
SetCustomPlayer		(idx, 242117, 0, 0, 0, 0, 120, 0, 1, 0) -- Abdullah Ghareeb
SetCustomPlayer		(idx, 191848, 0, 0, 0, 0, 15, 0, 1, 0) -- Waleed Abdullah
SetCustomPlayer		(idx, 228783, 0, 0, 0, 0, 83, 0, 1, 0) -- Lajami
SetCustomPlayer		(idx, 199667, 0, 0, 0, 0, 25, 0, 1, 0) -- Funes Mori
SetCustomPlayer		(idx, 242863, 0, 0, 0, 0, 26, 0, 1, 0) -- Al Hassan
SetCustomPlayer		(idx, 220895, 0, 0, 0, 0, 36, 0, 1, 0) -- Al Sulayhim
SetCustomPlayer		(idx, 213007, 0, 0, 0, 0, 83, 0, 1, 0) -- Aseri
SetCustomPlayer		(idx, 253440, 0, 0, 0, 0, 99, 0, 1, 0) -- Ayman Yahya
SetCustomPlayer		(idx, 216352, 0, 0, 0, 0, 186, 0, 1, 0) -- Marcelo Brozovic
SetCustomPlayer		(idx, 226377, 0, 0, 0, 0, 346, 0, 1, 0) -- Gonzalo Martínez
SetCustomPlayer		(idx, 262595, 0, 0, 0, 0, 155, 0, 1, 0) -- J. Masharipov
SetCustomPlayer		(idx, 223816, 0, 0, 0, 0, 180, 0, 1, 0) -- Rodríguez
SetCustomPlayer		(idx, 20801, 0, 0, 0, 0, 187, 0, 1, 1) -- Cristiano Ronaldo
SetCustomPlayer		(idx, 212523, 0, 0, 0, 0, 325, 0, 1, 0) -- Anderson Talisca
SetCustomPlayer		(idx, 255369, 0, 0, 0, 0, 32, 0, 1, 0) -- Moh Maran
SetCustomPlayer		(idx, 208722, 0, 0, 0, 0, 346, 0, 1, 0) -- Sadio Mane

--Liverpool
SetCustomPlayer		(idx, 212831, 2, 0, 0, 0, 158, 0, 1, 0) -- Alisson Becker
SetCustomPlayer		(idx, 240913, 2, 0, 0, 0, 49, 0, 1, 0) -- Caoimhin Kelleher
SetCustomPlayer		(idx, 24630, 0, 0, 0, 0, 24, 0, 1, 0) -- Reina
SetCustomPlayer		(idx, 24630, 0, 0, 0, 0, 24, 0, 1, 0) -- Kuyt
SetCustomPlayer		(idx, 13743, 0, 0, 0, 0, 24, 0, 1, 0) -- Gerrard
SetCustomPlayer		(idx, 5467, 0, 0, 0, 0, 24, 0, 1, 0) -- Carragher
SetCustomPlayer		(idx, 176266, 0, 0, 0, 0, 24, 0, 1, 0) -- Lucas Leiva
SetCustomPlayer		(idx, 183711, 0, 0, 0, 0, 24, 0, 1, 0) -- Henderson
SetCustomPlayer		(idx, 231281, 2, 0, 1, 0, 341, 0, 1, 0) -- Trent Alexander Arnold
SetCustomPlayer		(idx, 252897, 0, 0, 0, 0, 232, 0, 1, 0) -- Calvin Ramsay
SetCustomPlayer		(idx, 225100, 0, 0, 0, 0, 65, 0, 1, 0) -- Joe Gomez
SetCustomPlayer		(idx, 237678, 0, 0, 0, 0, 140, 0, 1, 0) -- Ibrahima Konaté
SetCustomPlayer		(idx, 203376, 0, 0, 0, 0, 157, 0, 1, 1) -- Virgil Van Dijk
SetCustomPlayer		(idx, 197061, 0, 0, 0, 0, 65, 0, 1, 0) -- J. Matip
SetCustomPlayer		(idx, 264298, 0, 0, 0, 0, 131, 0, 1, 0) -- Conor Bradley
SetCustomPlayer		(idx, 232223, 0, 0, 0, 0, 49, 0, 1, 0) -- Konstantinos Tsimikas
SetCustomPlayer		(idx, 216267, 0, 0, 0, 0, 139, 0, 1, 0) -- Andrew Robertson
SetCustomPlayer		(idx, 239837, 0, 0, 1, 0, 65, 0, 1, 0) -- Mac Allister
SetCustomPlayer		(idx, 236772, 0, 0, 0, 0, 32, 0, 1, 0) -- Dominik Szoboszlai
SetCustomPlayer		(idx, 189509, 0, 0, 0, 0, 59, 0, 1, 0) -- Thiago Alcantara
SetCustomPlayer		(idx, 246174, 0, 0, 1, 0, 124, 0, 1, 0) -- Elliot
SetCustomPlayer		(idx, 271975, 0, 0, 0, 0, 68, 0, 1, 0) -- Stefan Bajcetic
SetCustomPlayer		(idx, 242434, 0, 0, 0, 0, 55, 0, 1, 0) -- Curtis Jones
SetCustomPlayer		(idx, 266815, 0, 0, 0, 0, 202, 0, 1, 0) -- Ben Doak
SetCustomPlayer		(idx, 209331, 0, 0, 0, 0, 49, 0, 1, 0) -- Mohamed Salah
SetCustomPlayer		(idx, 242516, 0, 0, 0, 0, 146, 0, 1, 0) -- Cody Gakpo
SetCustomPlayer		(idx, 253072, 0, 0, 1, 0, 196, 0, 1, 0) -- Darwin Núñez
SetCustomPlayer		(idx, 260406, 0, 0, 0, 0, 83, 0, 1, 0) -- Kaide Gordon
SetCustomPlayer		(idx, 241084, 0, 0, 0, 0, 49, 0, 1, 0) -- Luis Diaz
SetCustomPlayer		(idx, 224458, 0, 0, 0, 0, 49, 0, 1, 0) -- Diego Jota

--Manchester City
SetCustomPlayer		(idx, 210257, 1, 0, 1, 0, 86, 0, 1, 0) -- Ederson Moraes
SetCustomPlayer		(idx, 200159, 2, 0, 0, 0, 163, 0, 1, 0) -- Stefan Ortega
SetCustomPlayer		(idx, 150724, 0, 0, 0, 0, 24, 0, 1, 0) -- Joe Hart
SetCustomPlayer		(idx, 20289, 0, 0, 0, 0, 24, 0, 1, 0) -- Yaya Toure
SetCustomPlayer		(idx, 226851, 0, 0, 0, 0, 304, 0, 1, 0) -- Benjamin Pavard
SetCustomPlayer		(idx, 210257, 0, 0, 0, 0, 345, 0, 1, 0) -- Rico Lewis
SetCustomPlayer		(idx, 203574, 0, 0, 0, 0, 131, 0, 1, 0) -- John Stones
SetCustomPlayer		(idx, 239818, 0, 0, 0, 0, 131, 0, 1, 0) -- Ruben Diaz
SetCustomPlayer		(idx, 227927, 0, 0, 0, 0, 150, 0, 1, 0) -- Kyle Walker-Peters
SetCustomPlayer		(idx, 229237, 0, 0, 0, 0, 86, 0, 1, 0) -- Manuel Akanji
SetCustomPlayer		(idx, 208920, 0, 0, 0, 0, 131, 0, 1, 0) -- Nathan Ake
SetCustomPlayer		(idx, 210514, 0, 0, 0, 0, 172, 0, 1, 0) -- Cancelo
SetCustomPlayer		(idx, 251517, 0, 0, 0, 0, 68, 0, 1, 0) -- Joško Gvardiol
SetCustomPlayer		(idx, 241811, 0, 0, 0, 0, 345, 0, 1, 0) -- Sergio Gómez 
SetCustomPlayer		(idx, 192985, 0, 0, 0, 0, 327, 0, 1, 1) -- Kevin De Bruyne
SetCustomPlayer		(idx, 231866, 0, 0, 0, 0, 131, 0, 1, 0) -- Rodri
SetCustomPlayer		(idx, 224081, 0, 0, 0, 0, 25, 0, 1, 0) -- Kalvin Phillips
SetCustomPlayer		(idx, 207410, 0, 0, 1, 0, 138, 0, 1, 0) -- Mateo Kovavic
SetCustomPlayer		(idx, 218667, 0, 0, 1, 0, 65, 0, 1, 0) -- Bernardo Silva
SetCustomPlayer		(idx, 206517, 0, 0, 1, 0, 86, 0, 1, 0) -- Jack Grealish
SetCustomPlayer		(idx, 237692, 0, 0, 1, 0, 131, 0, 1, 0) -- Phil Foden
SetCustomPlayer		(idx, 210514, 0, 0, 0, 0, 25, 0, 1, 0) -- Máximo Perrone
SetCustomPlayer		(idx, 246191, 0, 0, 1, 0, 49, 0, 1, 0) -- Julián Álvarez
SetCustomPlayer		(idx, 239085, 0, 0, 0, 0, 131, 0, 1, 0) -- Erling Haaland

--Atletico
SetCustomPlayer		(idx, 200389, 2, 0, 1, 0, 217, 0, 1, 0) -- Jan Oblak
SetCustomPlayer		(idx, 241671, 2, 0, 1, 0, '', 0, 1, 0) -- Livakovic
SetCustomPlayer		(idx, 233084, 0, 0, 1, 0, 12, 0, 1, 0) -- Nahuel Molina
SetCustomPlayer		(idx, 184432, 0, 0, 1, 1, 148, 0, 1, 0) -- Azpilicueta
SetCustomPlayer		(idx, 204639, 0, 0, 1, 0, 127, 0, 1, 0) -- Stefan Savic
SetCustomPlayer		(idx, 229668, 0, 0, 1, 0, 151, 0, 1, 0) -- Mario Hermoso
SetCustomPlayer		(idx, 236045, 0, 0, 1, 0, 12, 0, 1, 0) -- Reinildo Isnard
SetCustomPlayer		(idx, 214997, 0, 0, 1, 0, 148, 0, 1, 0) -- Angel Correa
SetCustomPlayer		(idx, 212616, 0, 0, 1, 0, 132, 0, 1, 0) -- Rodrigo De Paul
SetCustomPlayer		(idx, 208418, 0, 0, 1, 0, 12, 0, 1, 0) --  Yannick Carrasco
SetCustomPlayer		(idx, 194765, 0, 0, 1, 0, 127, 0, 1, 0) -- Antoine Griezmann
SetCustomPlayer		(idx, 201153, 0, 0, 1, 0, 132, 0, 1, 0) -- Alvaro Morata
SetCustomPlayer		(idx, 216460, 0, 0, 1, 0, 12, 0, 1, 0) -- Jose Gimenez
SetCustomPlayer		(idx, 177413, 0, 0, 1, 0, 127, 0, 1, 0) -- Axel Witzel
SetCustomPlayer		(idx, 201455, 0, 0, 1, 0, '', 0, 1, 0) -- Kondogbia
SetCustomPlayer		(idx, 226161, 0, 0, 1, 0, 33, 0, 1, 0) -- Marcos Llorente
SetCustomPlayer		(idx, 213565, 0, 0, 1, 0, 148, 0, 1, 0) -- Thomas Lemar
SetCustomPlayer		(idx, 202556, 0, 0, 1, 0, 127, 0, 1, 0) -- Memphis Depay
SetCustomPlayer		(idx, 264116, 0, 0, 1, 0, '', 0, 1, 0) --  Alejandro Iturbe
SetCustomPlayer		(idx, 201417, 0, 0, 1, 0, '', 0, 1, 0) -- Matt Doherty
SetCustomPlayer		(idx, 245279, 0, 0, 1, 0, '', 0, 1, 0) -- Sergio Reguilon
SetCustomPlayer		(idx, 208421, 0, 0, 1, 0, 122, 0, 1, 0) -- Saul Niguez
SetCustomPlayer		(idx, 262260, 0, 0, 1, 0, '', 0, 1, 0) -- Sergio Guerrero Romero
SetCustomPlayer		(idx, 263945, 0, 0, 1, 0, '', 0, 1, 0) -- Alberto Moreno
SetCustomPlayer		(idx, 265396, 0, 0, 1, 0, '', 0, 1, 0) -- Carlos Martín Domínguez
SetCustomPlayer		(idx, 263197, 0, 0, 1, 0, '', 0, 1, 0) -- Ethyan González Morales
SetCustomPlayer		(idx, 242444, 0, 0, 1, 0, 325, 0, 1, 0) -- Joao Felix

--Bayer Munich
SetCustomPlayer		(idx, 167495, 2, 0, 1, 0, 148, 0, 1, 0) -- Manuel Neuer
SetCustomPlayer		(idx, 237086, 0, 0, 1, 0, 71, 0, 1, 0) -- Kim Min-Jae
SetCustomPlayer		(idx, 229558, 0, 0, 1, 0, 121, 0, 1, 0) -- Dayot Upamecano
SetCustomPlayer		(idx, 235243, 0, 0, 1, 0, 3, 0, 1, 0) -- Matthijs De Light
SetCustomPlayer		(idx, 234396, 0, 0, 1, 0, 12, 0, 1, 0) -- Alphonso Davies
SetCustomPlayer		(idx, 212622, 0, 0, 1, 0, 10, 0, 1, 0) -- Joshua Kimmich
SetCustomPlayer		(idx, 209658, 0, 0, 1, 0, 147, 0, 1, 0) -- Leon Goretzka
SetCustomPlayer		(idx, 206113, 0, 0, 1, 0, 138, 0, 1, 0) -- Serge Gnabry
SetCustomPlayer		(idx, 213345, 0, 0, 1, 0, 215, 0, 1, 0) -- Kingsley Coman
SetCustomPlayer		(idx, 256790, 0, 0, 1, 0, 208, 0, 1, 0) -- Jamal Musiala
SetCustomPlayer		(idx, 183569, 0, 0, 1, 0, 215, 0, 1, 0) -- Choupo-Moting
SetCustomPlayer		(idx, 226851, 0, 0, 1, 0, 146, 0, 1, 0) -- Benjamin Pavard
SetCustomPlayer		(idx, 236401, 0, 0, 1, 0, 28, 0, 1, 0) -- Noussair Mazraoui
SetCustomPlayer		(idx, 190815, 0, 0, 1, 0, '', 0, 1, 0) -- Daley Blind
SetCustomPlayer		(idx, 222492, 0, 0, 1, 0, 28, 0, 1, 0) -- Leroy Sane
SetCustomPlayer		(idx, 189596, 0, 0, 1, 0, 146, 0, 1, 0) -- Thomas Muller
SetCustomPlayer		(idx, 246104, 0, 0, 1, 0, 148, 0, 1, 0) -- Ryan Gravenberch
SetCustomPlayer		(idx, 250955, 0, 0, 1, 0, 147, 0, 1, 0) -- Josip Stanišic
SetCustomPlayer		(idx, 272517, 0, 0, 1, 0, '', 0, 1, 0) -- Gabriel Marusic
SetCustomPlayer		(idx, 266237, 0, 0, 1, 0, '', 0, 1, 0) -- Paul Wanner

--Inter Milan
SetCustomPlayer		(idx, 177683, 2, 0, 1, 0, 109, 0, 1, 0) -- Yann Sommer
SetCustomPlayer		(idx, 269271, 1, 0, 1, 0, 152, 0, 1, 0) -- Filip Stankovic
SetCustomPlayer		(idx, 233096, 0, 0, 1, 0, 132, 0, 1, 0) -- Denzel Dumfries
SetCustomPlayer		(idx, 230048, 0, 0, 1, 0, 127, 0, 1, 0) -- Davide Frattesi
SetCustomPlayer		(idx, 184392, 0, 0, 1, 0, 179, 0, 1, 0) -- Matteo Darmian
SetCustomPlayer		(idx, 199845, 0, 0, 1, 0, 28, 0, 1, 0) -- Francesco Acerbi
SetCustomPlayer		(idx, 237383, 0, 0, 1, 0, 217, 0, 1, 0) -- Alesandro Bastoni
SetCustomPlayer		(idx, 226268, 0, 0, 1, 0, 132, 0, 1, 0) -- Federico Di marco
SetCustomPlayer		(idx, 198176, 0, 0, 1, 0, 83, 0, 1, 0) -- Stefan de Vrij
SetCustomPlayer		(idx, 224232, 0, 0, 1, 0, 32, 0, 1, 0) -- Nicolò Barella
SetCustomPlayer		(idx, 208128, 0, 0, 1, 0, 27, 0, 1, 0) -- Hakan Çalhanoglu
SetCustomPlayer		(idx, 193082, 0, 0, 1, 0, '', 0, 1, 0) -- Cuadrado
SetCustomPlayer		(idx, 212153, 0, 0, 1, 0, '', 0, 1, 0) -- Roberto Gagliardini
SetCustomPlayer		(idx, 192883, 0, 0, 1, 0, 175, 0, 1, 0) -- Mkhitaryan
SetCustomPlayer		(idx, 231478, 0, 0, 1, 0, 120, 0, 1, 0) -- Lautaro Martínez
SetCustomPlayer		(idx, 198946, 0, 0, 1, 0, '', 0, 1, 0) -- Danilo D'Ambrosio
SetCustomPlayer		(idx, 149258, 0, 0, 1, 0, '', 0, 1, 0) -- Alex Cordaz
SetCustomPlayer		(idx, 247229, 0, 0, 1, 0, '', 0, 1, 0) -- Bellanova
SetCustomPlayer		(idx, 271573, 0, 0, 1, 0, '', 0, 1, 0) -- Mattia Zanotti
SetCustomPlayer		(idx, 271572, 0, 0, 1, 0, 28, 0, 1, 0) -- Alesandro Fontanarosa
SetCustomPlayer		(idx, 229148, 0, 0, 1, 0, '', 0, 1, 0) -- Dalbert Chagas Estevão
SetCustomPlayer		(idx, 264699, 0, 0, 1, 0, 124, 0, 1, 0) -- Kristjan Asllani
SetCustomPlayer		(idx, 272602, 0, 0, 1, 0, '', 0, 1, 0) -- Valentine Carboni
SetCustomPlayer		(idx, 215330, 0, 0, 1, 0, 132, 0, 1, 0) -- Correa

--Juventus
SetCustomPlayer		(idx, 186153, 2, 0, 1, 0, '', 0, 1, 0) -- Szczesny
SetCustomPlayer		(idx, 198009, 2, 0, 1, 0, '', 0, 1, 0) -- Mattia Perin
SetCustomPlayer		(idx, 199304, 0, 0, 1, 0, '', 0, 1, 0) -- Danilo Luiz da Silva
SetCustomPlayer		(idx, 239580, 0, 0, 1, 0, '', 0, 1, 0) -- Gleison Bremer
SetCustomPlayer		(idx, 184344, 0, 0, 1, 0, '', 0, 1, 0) -- Leonardo Bonucci
SetCustomPlayer		(idx, 191043, 0, 0, 1, 0, '', 0, 1, 0) -- Alex Sandro
SetCustomPlayer		(idx, 222077, 0, 0, 1, 0, '', 0, 1, 0) -- Manuel Locatelli
SetCustomPlayer		(idx, 195864, 0, 0, 1, 0, '', 0, 1, 0) -- Paul Pogba
SetCustomPlayer		(idx, 210008, 0, 0, 1, 0, '', 0, 1, 0) -- Adrien Rabiot
SetCustomPlayer		(idx, 235805, 0, 0, 1, 0, '', 0, 1, 0) -- Federico Chiesa
SetCustomPlayer		(idx, 246430, 0, 0, 1, 0, '', 0, 1, 0) -- Dušan Vlahovic
SetCustomPlayer		(idx, 208574, 0, 0, 1, 0, '', 0, 1, 0) -- Filips Kostic
SetCustomPlayer		(idx, 206058, 0, 0, 1, 0, '', 0, 1, 0) -- De Sciglio
SetCustomPlayer		(idx, 266872, 0, 0, 1, 0, '', 0, 1, 0) -- Federico Gatti
SetCustomPlayer		(idx, 229261, 0, 0, 1, 0, '', 0, 1, 0) -- Denis Zakaria
SetCustomPlayer		(idx, 243247, 0, 0, 1, 0, '', 0, 1, 0) -- Luca Pellegrini
SetCustomPlayer		(idx, 260823, 0, 0, 1, 0, '', 0, 1, 0) -- Nicolò Fagioli
SetCustomPlayer		(idx, 255001, 0, 0, 1, 0, '', 0, 1, 0) -- Nicolò Rovella
SetCustomPlayer		(idx, 238744, 0, 0, 1, 0, '', 0, 1, 0) -- Weston McKennie
SetCustomPlayer		(idx, 241496, 0, 0, 1, 0, '', 0, 1, 0) -- Timoty Weah
SetCustomPlayer		(idx, 236610, 0, 0, 1, 0, '', 0, 1, 0) -- Moise Kean
SetCustomPlayer		(idx, 272379, 0, 0, 1, 0, '', 0, 1, 0) -- S. Iling-Junior
SetCustomPlayer		(idx, 189342, 0, 0, 1, 0, '', 0, 1, 0) -- Carlo Pinsoglio
SetCustomPlayer		(idx, 211320, 0, 0, 1, 0, '', 0, 1, 0) -- Daniele Rugani
SetCustomPlayer		(idx, 268802, 0, 0, 1, 0, '', 0, 1, 0) -- Fabio Miretti
SetCustomPlayer		(idx, 260644, 0, 0, 1, 0, '', 0, 1, 0) -- Kaio Jorge
SetCustomPlayer		(idx, 271583, 0, 0, 1, 0, '', 0, 1, 0) -- Giovanni
SetCustomPlayer		(idx, 192505, 0, 0, 0, 0, 120, 0, 1, 1)  -- Romero Lukaku
SetCustomPlayer		(idx, 265695, 0, 0, 1, 0, '', 0, 1, 0) -- Mattis Soule
SetCustomPlayer		(idx, 205175, 0, 0, 1, 0, '', 0, 1, 0) -- Arkadiuz Milik

--Milan
SetCustomPlayer		(idx, 215698, 2, 0, 0, 0, 335, 0, 1, 0) -- Mike Maignan
SetCustomPlayer		(idx, 201325, 2, 0, 0, 0, 343, 0, 1, 0) -- Tatarus anu
SetCustomPlayer		(idx, 216065, 0, 0, 0, 0, 31, 0, 1, 0) -- Marco Sportiello
SetCustomPlayer		(idx, 228881, 0, 0, 0, 0, 65, 0, 1, 0) -- Calabria
SetCustomPlayer		(idx, 256261, 0, 0, 0, 0, 163, 0, 1, 0) -- Malik Thiaw
SetCustomPlayer		(idx, 232756, 0, 0, 0, 0, 64, 0, 1, 0) -- Fikayo Tomori
SetCustomPlayer		(idx, 232656, 0, 0, 0, 0, 187, 0, 1, 0) -- Théo Hernandez
SetCustomPlayer		(idx, 213666, 0, 0, 0, 0, 49, 0, 1, 0) -- Loftus Cheek
SetCustomPlayer		(idx, 226754, 0, 0, 0, 0, 138, 0, 1, 0) -- Ismaël Bennacer
SetCustomPlayer		(idx, 240638, 0, 0, 0, 0, 343, 0, 1, 0) -- Tijjani Reijnders
SetCustomPlayer		(idx, 246172, 0, 0, 0, 0, 172, 0, 1, 0) -- Samuel Chukwueze
SetCustomPlayer		(idx, 178509, 0, 0, 0, 0, 146, 0, 1, 1) -- Olivier Giroud
SetCustomPlayer		(idx, 241721, 0, 0, 0, 0, 49, 0, 1, 0) -- Rafael Leo
SetCustomPlayer		(idx, 203551, 0, 0, 0, 0, 142, 0, 1, 0) -- Alessandro Florenzi
SetCustomPlayer		(idx, 255654, 0, 0, 0, 0, 42, 0, 1, 0) -- Pierre Kalulu
SetCustomPlayer		(idx, 179645, 0, 0, 0, 0, 139, 0, 1, 0) -- Simon Kjær
SetCustomPlayer		(idx, 257711, 0, 0, 0, 0, 24, 0, 1, 0) -- Ricardo Calafiori
SetCustomPlayer		(idx, 253177, 0, 0, 0, 0, 150, 0, 1, 0) -- Yunus Musah
SetCustomPlayer		(idx, 229758, 0, 0, 0, 0, 163, 0, 1, 0) -- Rade Krunić
SetCustomPlayer		(idx, 243627, 0, 0, 0, 0, 187, 0, 1, 0) -- Yacine Adli
SetCustomPlayer		(idx, 258467, 0, 0, 0, 0, 178, 0, 1, 0) -- Luka Romero
SetCustomPlayer		(idx, 242530, 0, 0, 0, 0, 172, 0, 1, 0) -- Noah Okafor
SetCustomPlayer		(idx, 227796, 0, 0, 0, 0, 326, 0, 1, 0) -- Christian Pulisic
SetCustomPlayer		(idx, 252060, 0, 0, 0, 0, 25, 0, 1, 0) -- Tommaso Pobega
SetCustomPlayer		(idx, 242664, 0, 0, 0, 0, 42, 0, 1, 0) -- Alexis Saelemaekers

--Timnas Garuda
SetCustomPlayer		(idx, 61821, 2, 0, 1, 0, '', 1, 1, 0) -- Nadeo Argawinata
SetCustomPlayer		(idx, 61811, 0, 0, 1, 0, '', 0, 1, 0) -- M. Riyandi
SetCustomPlayer		(idx, 262098, 0, 0, 1, 0, '', 0, 1, 0) -- Pattynama
SetCustomPlayer		(idx, 198198, 0, 0, 1, 0, '', 0, 1, 0) -- Jordi Amat
SetCustomPlayer		(idx, 220953, 0, 0, 1, 0, '', 0, 1, 0) -- Fachruddin Aryanto
SetCustomPlayer		(idx, 61815, 0, 0, 1, 0, '', 0, 1, 0) -- Pratama Arhan
SetCustomPlayer		(idx, 61802, 0, 0, 1, 0, '', 0, 1, 0) -- Asnawi Mangkualam
SetCustomPlayer		(idx, 260798, 0, 0, 1, 0, '', 0, 1, 0) -- Elkan Baggot
SetCustomPlayer		(idx, 61786, 0, 0, 1, 0, '', 0, 1, 0) -- Ricky Kambuaya
SetCustomPlayer		(idx, 260973, 0, 0, 1, 0, '', 0, 1, 0) -- Abimanyu
SetCustomPlayer		(idx, 61787, 0, 0, 1, 0, '', 0, 1, 0) -- M. Ferdinan
SetCustomPlayer		(idx, 244623, 0, 0, 1, 0, '', 0, 1, 0) -- Egy Maulana Fikri
SetCustomPlayer		(idx, 264469, 0, 0, 1, 0, '', 0, 1, 0) -- Witan Sulaiman
SetCustomPlayer		(idx, 61810, 0, 0, 1, 0, '', 0, 1, 0) -- M.Ramdani
SetCustomPlayer		(idx, 62085, 0, 0, 1, 0, '', 0, 1, 0) -- Irfan Jaya
SetCustomPlayer		(idx, 61634, 0, 0, 1, 0, '', 0, 1, 0) -- Dimas Drajad
SetCustomPlayer		(idx, 61817, 0, 0, 1, 0, '', 0, 1, 0) -- Ronaldo Kwateh
SetCustomPlayer		(idx, 61630, 0, 0, 1, 0, '', 0, 1, 0) -- Evan Dimas
SetCustomPlayer		(idx, 205383, 0, 0, 1, 0, '', 0, 1, 0) -- Lilipaly
SetCustomPlayer		(idx, 61498, 0, 0, 1, 0, '', 0, 1, 0) -- M. Rafli 
SetCustomPlayer		(idx, 60923, 0, 0, 1, 0, '', 0, 1, 0) -- Rizky Ridho
SetCustomPlayer		(idx, 61807, 0, 0, 1, 0, '', 0, 1, 0) -- Alfeandra Dewangga
SetCustomPlayer		(idx, 61814, 0, 0, 1, 0, '', 0, 1, 0) -- Edo Febriansyah
SetCustomPlayer		(idx, 62103, 0, 0, 1, 0, '', 0, 1, 0) -- Rachmat Irianto
SetCustomPlayer		(idx, 244623, 0, 0, 1, 0, '', 0, 1, 0) -- Abduh Lestaluhu
SetCustomPlayer		(idx, 216225, 0, 0, 1, 0, '', 0, 1, 0) -- M. Klok
SetCustomPlayer		(idx, 205618, 0, 0, 1, 0, '', 0, 1, 0) -- Sandy Walsh
SetCustomPlayer		(idx, 62045, 0, 0, 1, 0, '', 0, 1, 0) -- Ernando Ari Sutaryadi
SetCustomPlayer		(idx, 16981, 0, 0, 1, 0, '', 0, 1, 0) -- Sananta
SetCustomPlayer		(idx, 16967, 0, 0, 1, 0, '', 0, 1, 0) -- Yakop Sayuri
SetCustomPlayer		(idx, 16976, 0, 0, 1, 0, '', 0, 1, 0) -- Yance Sayuri
SetCustomPlayer		(idx, 62184, 0, 0, 1, 0, '', 0, 1, 0) -- Rafael Struijk
SetCustomPlayer		(idx, 62183, 0, 0, 1, 0, '', 0, 1, 0) -- Ivar Jenner

--FC Nusantara
SetCustomPlayer		(idx, 274134, 2, 0, 1, 0, '', 0, 1, 0) -- Adjie
SetCustomPlayer		(idx, 274135, 0, 0, 1, 0, '', 0, 1, 0) -- Yosep
SetCustomPlayer		(idx, 274136, 0, 0, 1, 0, '', 0, 1, 0) -- Eko S
SetCustomPlayer		(idx, 274137, 0, 0, 1, 0, '', 0, 1, 0) -- Yunus
SetCustomPlayer		(idx, 274138, 0, 0, 1, 0, '', 0, 1, 0) -- Kusnaedie
SetCustomPlayer		(idx, 274139, 0, 0, 1, 0, '', 0, 1, 0) -- Rodhi
SetCustomPlayer		(idx, 274140, 0, 0, 1, 0, '', 0, 1, 0) -- Rizal
SetCustomPlayer		(idx, 274141, 0, 0, 1, 0, '', 0, 1, 0) -- Tubari Lite
SetCustomPlayer		(idx, 274142, 0, 0, 1, 0, '', 0, 1, 0) -- Mang G
SetCustomPlayer		(idx, 274143, 0, 0, 1, 0, 346, 0, 1, 0) -- Herry Gunawan
SetCustomPlayer		(idx, 274144, 0, 0, 1, 0, '', 0, 1, 0) -- Mccalisters
SetCustomPlayer		(idx, 274145, 0, 0, 1, 0, '', 0, 1, 0) -- Tianz
SetCustomPlayer		(idx, 274146, 0, 0, 1, 0, '', 0, 1, 0) -- Ilham BlockBuster
SetCustomPlayer		(idx, 274147, 0, 0, 1, 0, '', 0, 1, 0) -- Kiano
SetCustomPlayer		(idx, 274148, 0, 0, 1, 0, '', 0, 1, 0) -- Dayat
SetCustomPlayer		(idx, 274149, 0, 0, 1, 0, '', 0, 1, 0) -- Toni Ahmad
SetCustomPlayer		(idx, 274150, 0, 0, 1, 0, '', 0, 1, 0) -- Rendi
SetCustomPlayer		(idx, 274151, 0, 0, 1, 0, '', 0, 1, 0) -- Rafli
SetCustomPlayer		(idx, 274152, 0, 0, 1, 0, '', 0, 1, 0) -- Yayat
SetCustomPlayer		(idx, 274153, 0, 0, 1, 0, '', 0, 1, 0) -- Rian Pross
SetCustomPlayer		(idx, 274154, 0, 0, 1, 0, '', 0, 1, 0) -- Jumardi
SetCustomPlayer		(idx, 274155, 0, 0, 1, 0, '', 0, 1, 0) -- Riadi Hamda

--FC Persija Jakarta
SetCustomPlayer		(idx, 297094, 2, 0, 1, 0, '', 0, 1, 0) -- Andritany
SetCustomPlayer		(idx, 297095, 0, 0, 1, 0, '', 0, 1, 0) -- Muhammad Ferrari
SetCustomPlayer		(idx, 297096, 0, 0, 1, 0, '', 0, 1, 0) -- Hansamu Yama
SetCustomPlayer		(idx, 297097, 0, 0, 1, 0, '', 0, 1, 0) -- Ondrej Kudela
SetCustomPlayer		(idx, 297098, 0, 0, 1, 0, '', 0, 1, 0) -- Rio Fahmi
SetCustomPlayer		(idx, 297099, 0, 0, 1, 0, '', 0, 1, 0) -- Hanif Sjahbandi
SetCustomPlayer		(idx, 193425, 0, 0, 1, 0, '', 0, 1, 0) -- Hanno Behrens
SetCustomPlayer		(idx, 297100, 0, 0, 1, 0, '', 0, 1, 0) -- Firja Andika
SetCustomPlayer		(idx, 260973, 0, 0, 1, 0, '', 0, 1, 0) -- Suphan
SetCustomPlayer		(idx, 297102, 0, 0, 1, 0, '', 0, 1, 0) -- Michael Krmencík
SetCustomPlayer		(idx, 297103, 0, 0, 1, 0, '', 0, 1, 0) -- Riko Simanjuntak
SetCustomPlayer		(idx, 297104, 0, 0, 1, 0, '', 0, 1, 0) -- Cahya Supriadi
SetCustomPlayer		(idx, 297122, 0, 0, 1, 0, '', 0, 1, 0) -- Do Hung Dung
SetCustomPlayer		(idx, 297115, 0, 0, 1, 0, '', 0, 1, 0) -- Dony Pamungkas
SetCustomPlayer		(idx, 297106, 0, 0, 1, 0, '', 0, 1, 0) -- Toni Sucipto
--Young Player
SetCustomPlayer		(idx, 265188, 0, 0, 1, 0, '', 0, 1, 0) -- Giorgio Scalvini
SetCustomPlayer		(idx, 240008, 0, 0, 1, 0, '', 0, 1, 0) -- Papadoupolus
SetCustomPlayer		(idx, 229891, 0, 0, 1, 0, '', 0, 1, 0) -- Ryerson
SetCustomPlayer		(idx, 266032, 0, 0, 1, 0, '', 0, 1, 0) -- Bynoe-Gittens
SetCustomPlayer		(idx, 244261, 0, 0, 1, 0, '', 0, 1, 0) -- Lovro Majer
SetCustomPlayer		(idx, 240753, 0, 0, 1, 0, '', 0, 1, 0) -- Amine Gouiri
SetCustomPlayer		(idx, 243580, 0, 0, 1, 0, '', 0, 1, 0) -- Loïs Openda
SetCustomPlayer		(idx, 253102, 0, 0, 1, 0, '', 0, 1, 0) -- Adil Aouchiche
SetCustomPlayer		(idx, 219693, 0, 0, 1, 0, '', 0, 1, 0) -- Diego Carlos
SetCustomPlayer		(idx, 193983, 0, 0, 1, 0, '', 0, 1, 0) -- Andy Delort
SetCustomPlayer		(idx, 246672, 0, 0, 1, 0, '', 0, 1, 0) -- Barrenetxea
SetCustomPlayer		(idx, 225085, 0, 0, 1, 0, '', 0, 1, 0) -- Bamba
SetCustomPlayer		(idx, 231691, 0, 0, 1, 0, '', 0, 1, 0) -- Alban Lafont
SetCustomPlayer		(idx, 247246, 0, 0, 1, 0, '', 0, 1, 0) -- Khéphren Thuram
SetCustomPlayer		(idx, 257179, 0, 0, 1, 0, '', 0, 1, 0) -- Bernardo Inácio

--Inter Miami
SetCustomPlayer		(idx, 254962, 2, 0, 0, 0, 54, 0, 1, 0) -- Drake Callender
SetCustomPlayer		(idx, 212722, 0, 0, 1, 0, 62, 0, 1, 0) -- Deandre Yedlin
SetCustomPlayer		(idx, 274569, 0, 0, 0, 0, 325, 0, 1, 0) -- Tomás Agustín Avilés
SetCustomPlayer		(idx, 269278, 0, 0, 0, 0, 166, 0, 1, 0) -- Diego Gomez
SetCustomPlayer		(idx, 206414, 0, 0, 0, 0, 115, 0, 1, 0) -- Sergiy Kryvtsov
SetCustomPlayer		(idx, 247648, 0, 0, 0, 0, 102, 0, 1, 0) -- Kamal Miller
SetCustomPlayer		(idx, 272687, 0, 0, 0, 0, 84, 0, 1, 0) -- Benjamin Cremaschi
SetCustomPlayer		(idx, 189332, 0, 0, 0, 0, 52, 0, 1, 0) -- Jordi Alba
SetCustomPlayer		(idx, 189511, 0, 0, 0, 0, 43, 0, 1, 0) -- Sergi Busquest
SetCustomPlayer		(idx, 254234, 0, 0, 0, 0, 59, 0, 1, 0) -- Dixon Arroyo
SetCustomPlayer		(idx, 207877, 0, 0, 1, 0, 29, 0, 1, 0) -- Josef Martinez
SetCustomPlayer		(idx, 158023, 0, 0, 1, 0, 52, 0, 1, 1) -- Lionel Messi
SetCustomPlayer		(idx, 239944, 0, 0, 0, 0, 13, 0, 1, 0) -- Robert Taylor

--Al-Ittihad
SetCustomPlayer		(idx, 167959, 2, 0, 0, 0, '', 0, 1, 0) -- Marcelo Grohe
SetCustomPlayer		(idx, 221658, 0, 0, 1, 0, '', 0, 1, 0) -- Ahmed Sharahili
SetCustomPlayer		(idx, 222134, 0, 0, 0, 0, '', 0, 1, 0) -- Tarek Hamed
SetCustomPlayer		(idx, 210648, 0, 0, 0, 0, '', 0, 1, 0) -- Ahmed Hegazi
SetCustomPlayer		(idx, 340914, 0, 0, 0, 0, 133, 0, 1, 0) -- N'golo Kante
SetCustomPlayer		(idx, 209499, 0, 0, 0, 0, 24, 0, 1, 0) -- Fabinho
SetCustomPlayer		(idx, 209440, 0, 0, 0, 0, 346, 0, 1, 0) -- Romarinho
SetCustomPlayer		(idx, 234570, 0, 0, 0, 0, 170, 0, 1, 0) -- Jota
SetCustomPlayer		(idx, 202599, 0, 0, 0, 0, '', 0, 1, 0) -- Igor Coronado
SetCustomPlayer		(idx, 213761, 0, 0, 0, 0, '', 0, 1, 0) -- Abderrazak Hamdallah
SetCustomPlayer		(idx, 165153, 0, 0, 0, 0, 49, 0, 1, 1) -- Benzema
--Al-Hilal
SetCustomPlayer		(idx, 210140, 2, 0, 0, 0, 326, 1, 1, 0) -- Abdullah Maiouf
SetCustomPlayer		(idx, 246688, 2, 0, 0, 0, 138, 0, 1, 0) -- Saud Hamid
SetCustomPlayer		(idx, 211005, 0, 0, 0, 0, 191, 0, 1, 0) -- Jang Hyeon So
SetCustomPlayer		(idx, 201024, 0, 0, 0, 0, 145, 0, 1, 0) -- Koulibaly
SetCustomPlayer		(idx, 210603, 0, 0, 0, 0, 190, 0, 1, 0) -- Yasir Al-Shahrani
SetCustomPlayer		(idx, 223848, 0, 0, 0, 0, 147, 0, 1, 0) -- Milinković-Savić
SetCustomPlayer		(idx, 224239, 0, 0, 0, 0, 139, 0, 1, 0) -- Ruben Neves
SetCustomPlayer		(idx, 203299, 0, 0, 0, 0, 157, 0, 1, 0) -- Andre Carillo
SetCustomPlayer		(idx, 227536, 0, 0, 0, 0, 328, 0, 1, 0) -- Moussa Marega
SetCustomPlayer		(idx, 185195, 0, 0, 0, 0, 316, 0, 1, 0) -- Odion Ighalo
SetCustomPlayer		(idx, 222737, 0, 0, 0, 0, 317, 0, 1, 0) -- Malcom Oliveira
SetCustomPlayer		(idx, 204485, 0, 0, 0, 0, 133, 0, 1, 1) -- Riyad Mahrez
--Random Player
SetCustomPlayer		(idx, 207439, 0, 0, 0, 0, 49, 0, 1, 0) -- Leandro Paredes
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------	 
  db.player[idx].useTextureComposition = as:GetInt(player, "useTextureComposition")
	
	--COUNTER
	if (idx == 0) then
	if (idx ~= oldplayeridx) then
	assignCustomItems()
	end
	end
	oldplayeridx = idx
	
	local stadium = as:GetTable("wvStadium", 1)
	
	-- db.stadium[1].homeKitTeamID = 0
	-- db.stadium[1].awayKitTeamID = 0
	-- db.stadium[1].homeKitTypeID = 0
	-- db.stadium[1].awayKitTypeID = 0
	
	db.stadium[1].homeKitTeamID = as:GetInt(stadium, "homeKitTeamID" )
	db.stadium[1].awayKitTeamID = as:GetInt(stadium, "awayKitTeamID" )
	db.stadium[1].homeKitTypeID = as:GetInt(stadium, "homeKitTypeID" )
	db.stadium[1].awayKitTypeID = as:GetInt(stadium, "awayKitTypeID" )
	
	
	local wipe3d = as:GetTable("wvWipe", 1)
	
	-- db.wipe3d[1].leagueID = 0
	
	db.wipe3d[1].leagueID = as:GetInt(wipe3d, "leagueID")
	
	db.wipe3d[1].leagueID = getTournamentGraphics(db.wipe3d[1].leagueID)
	


	--IF GENERIC KIT
	db.player[idx].speckitType = -1
	if (db.player[idx].teamid == db.player[idx].kit) then
	db.player[idx].genkit = db.player[idx].teamid
	else
	db.player[idx].genkit = db.player[idx].kit
	if (db.player[idx].kitType ~= 5) then
	db.player[idx].kit = db.player[idx].teamid
	end
	end
	
	if ((db.player[idx].kitYear == 0) and true) then
	db.player[idx].tournid = db.wipe3d[1].leagueID
	else
	db.player[idx].tournid = db.player[idx].kitYear
	end
	
	db.player[idx].defaulttournid = -1
	if (db.player[idx].kitType == 5) then
	if (teamTournament[db.stadium[1].homeKitTeamID] ~= nil) then
	db.player[idx].defaulttournid = teamTournament[db.stadium[1].homeKitTeamID]
	end
	else
	if (teamTournament[db.player[idx].teamid] ~= nil) then
	db.player[idx].defaulttournid = teamTournament[db.player[idx].teamid]
	end
	end
	
	
	--GK KIT SPEC
	if (db.player[idx].kitType == 2) then
	db.player[idx].kit = getSpecificGKKit(db.player[idx].teamid,db.player[idx].kit)
	end
	
	--ARENA PLAYER KIT
	if (idx == 0) then
	db.player[idx].kit = getHomeArenaKit(db.player[idx].teamid,db.player[idx].kit)
	db.player[idx].kitType = getHomeArenaKitType(db.player[idx].teamid,db.player[idx].kitType)
	db.player[idx].kitYear = 0
	db.player[idx].speckitType = 91
	end

	--ARENA GK KIT
	if (idx == 1) then
	db.player[idx].kit = getAwayArenaKit(db.player[idx].teamid,db.player[idx].kit)
	db.player[idx].kitType = getAwayArenaKitType(db.player[idx].teamid,db.player[idx].kitType)
	db.player[idx].kitYear = 0
	db.player[idx].speckitType = 92
	end
	
	--TRAINING KIT HOME
	if ((db.player[idx].genkit == 7000) and (db.player[idx].kitType == 6)) then
	db.player[idx].kit = getHomeTrainingKit(db.player[idx].teamid,db.player[idx].kit)
	db.player[idx].kitType = getHomeTrainingKitType(db.player[idx].teamid,db.player[idx].kitType)
	db.player[idx].speckitType = 93
	end
	
	--TRAINING KIT AWAY
	if ((db.player[idx].genkit == 7000) and (db.player[idx].kitType == 7)) then
	db.player[idx].kit = getAwayTrainingKit(db.player[idx].teamid,db.player[idx].kit)
	db.player[idx].kitType = getAwayTrainingKitType(db.player[idx].teamid,db.player[idx].kitType)
	db.player[idx].speckitType = 94
	end

	
	--GK KITS
	if ((db.player[idx].kitType == 2) and (idx > 1)) then
	
	local isHome = true
	local outidx = 3
	
	if ((idx == 13) or (idx > 26)) then
	isHome = true
	outidx = 14
	end
	
	--CLASSIC GK KIT
	local outplayer = as:GetTable("wvPlayer", outidx)
	local kitYearOutfield = as:GetInt(outplayer, "kitYear")
	db.player[idx].kitYear = getClassicGKKit(db.player[idx].kit,kitYearOutfield,db.player[idx].kitYear)
	
	if (db.player[idx].kitYear == 0) then
	if (isHome) then
	--if (db.player[idx].kit == db.stadium[1].homeKitTeamID) then
	db.player[idx].kitType = getGKKit(db.player[idx].kit,db.stadium[1].homeKitTypeID,db.stadium[1].homeKitTeamID,db.stadium[1].awayKitTeamID,db.player[idx].kitType)
	else
	db.player[idx].kitType = getGKKit(db.player[idx].kit,db.stadium[1].awayKitTypeID,db.stadium[1].homeKitTeamID,db.stadium[1].awayKitTeamID,db.player[idx].kitType)
	end
	end
	
	--NON GK KIT
	else
	
	--SPECIFIC MATCH KIT
	if (db.player[idx].kitYear == 0) then
	db.player[idx].kitType = getGameKit(db.player[idx].kit,db.stadium[1].homeKitTeamID,db.stadium[1].awayKitTeamID,db.player[idx].kitType)
	end
	
	end
	
	
	--PLAYER KIT SET
	if ((db.player[idx].kitType ~= 5) and (db.player[idx].kitYear == 0)) then
	db.player[idx].kitYear = getTournamentPlayerKits(db.player[idx].kit,db.wipe3d[1].leagueID,db.player[idx].kitYear)
	elseif ((db.player[idx].kitType ~= 5) and (db.player[idx].kitYear ~= 0)) then
	db.wipe3d[1].leagueID = db.player[idx].kitYear
	end
	
	
	--KIT DETAILS
	db.player[idx].kitNameFont = getKitNameFont(db.player[idx].kit,db.player[idx].kitType,db.player[idx].kitNameFont,db.wipe3d[1].leagueID,db.player[idx].teamid)
	db.player[idx].kitNumberFont = getKitNumberSet(db.player[idx].kit,db.player[idx].kitType,db.player[idx].kitNumberFont,db.wipe3d[1].leagueID,db.player[idx].teamid)
	db.player[idx].kitNumberColor = getKitNumberColourShirt(db.player[idx].kit,db.player[idx].kitType,db.player[idx].kitNumberColor,db.wipe3d[1].leagueID)
	db.player[idx].kitNameColor = getKitNameColour(db.player[idx].kit,db.player[idx].kitType,db.player[idx].kitNameColor,db.wipe3d[1].leagueID)
	db.player[idx].shortsNumberFont = getKitNumberSet(db.player[idx].kit,db.player[idx].kitType,db.player[idx].shortsNumberFont,db.wipe3d[1].leagueID,db.player[idx].teamid)
	db.player[idx].shortsNumberColor = getKitNumberColourShort(db.player[idx].kit,db.player[idx].kitType,db.player[idx].shortsNumberColor,db.wipe3d[1].leagueID)
	db.player[idx].jerseyNameLayout = getKitNameCurve(db.player[idx].kit,db.player[idx].kitType,db.player[idx].jerseyNameLayout,db.wipe3d[1].leagueID)
	db.player[idx].jerseyCollarType = getKitCollar(db.player[idx].kit,db.player[idx].kitType,db.player[idx].jerseyCollarType,db.wipe3d[1].leagueID)
	db.player[idx].jerseyfit = getKitFit(db.player[idx].kit,db.player[idx].kitType,db.player[idx].jerseyfit,db.wipe3d[1].leagueID,db.player[idx].playerassetid)

	--REF KITS
	if (db.player[idx].kitType == 5) then
	
	if (db.player[idx].kit > 6100) then
	db.player[idx].kit = db.player[idx].kit - 100
	end
	
	db.player[idx].kitYear = getTournamentRefereeKits(db.wipe3d[1].leagueID,db.player[idx].kitYear,db.stadium[1].homeKitTeamID)
	db.player[idx].jerseyCollarType = getTournamentRefereeKitsCollar(db.wipe3d[1].leagueID,db.player[idx].jerseyCollarType,db.stadium[1].homeKitTeamID)
	end
	
	--BOOTS
	db.player[idx].shoeType = getPlayerBoot(db.player[idx].playerassetid,db.player[idx].shoeType)
	if (db.player[idx].shoeType > 0) then
	db.player[idx].shoeDesign = 0
	--db.player[idx].shoeColorPri = hex("FF0000")
	--db.player[idx].shoeColorSec = hex("00FF00")
	--db.player[idx].shoeColorTer = hex("0000FF")
	end
	
	--GK PANTS
	db.player[idx].shortstyle = getGKPants(db.player[idx].playerassetid,db.player[idx].shortstyle)
	db.player[idx].shortstyleset = getTeamGKPants(db.player[idx].kit,0)
	
	--SKIN TONE
	db.player[idx].bodySkinToneType = getPlayerPlayerSkinTone(db.player[idx].playerassetid,db.player[idx].bodySkinToneType)
	
	--JERSEY TUCK
	db.player[idx].jerseyTucked = getJerseyTuck(db.player[idx].playerassetid,db.player[idx].jerseyTucked)
	
	--SOCK HEIGHT
	db.player[idx].socklength = getSockHeight(db.player[idx].playerassetid,db.player[idx].socklength)
	
	--IF GENERIC KIT
	-- if (db.player[idx].genkit == 0) then
	-- db.player[idx].genkit = ""
	-- else
	-- db.player[idx].genkit = ";data/sceneassets/kit/kit_"..db.player[idx].genkit.."_"..db.player[idx].kitType.."_"..db.player[idx].kitYear..".rx3"
	-- end
end
---------------------------------------------------------------------------------------------------
-- Get hair color for generic hair recoloring 
function GetHairColorARGB(idx)
	hairColourList = { 0x00edac57, 0x000e0e0d, 0x00a07741, 0x001f160e, 
                       0x00ffd286, 0x006e4d2b, 0x003b2816, 0x00782c08, 
                       0x00c8c9cf, 0x00525355, 0x00345a34, 0x00263f67,
                       0x00f62f0a }

	local clr = 0x00FF0000
	if (db.player[idx].headClass > 0) then
		clr = hairColourList[db.player[idx].hairColor + 1]
		if (clr == nil) then
			clr = 0x00FF0000
		end
	else
		clr = 0x00808080
	end
	return clr
end

---------------------------------------------------------------------------------------------------
function EASWMorphFile(idx)
	if (db.player[idx].isVirtualPro == 1) then
		return string.format("data/easw/deltas_%d.easwmorph", db.player[idx].faceType) --12366)
	else
		return "dummyasset.easwmorph"
	end
end

---------------------------------------------------------------------------------------------------
function GetHeadAndHairAssetType(idx)
	if (db.player[idx].isCreatePlayer == 1) then
		return "cloneasset"
	else
		return ""
	end
end

---------------------------------------------------------------------------------------------------
function MorphFile(idx)
	if (db.player[idx].isCreatePlayer == 1 and db.player[idx].isVirtualPro == 0) then
		return "data/sceneassets/createplayer/head_0_2_0_1_morphtargets.rx3"
	else
		return "dummyasset.rx3"
	end
end

---------------------------------------------------------------------------------------------------
function PlayerAssetShadow(player, lod)
	local gr = gRenderables
	gr:AddAsset(player, lod, "shadow", "data/sceneassets/body/playershadow_4_1_0.rx3")
	gr:CreateMaterial(player, lod, "shadow", "missingShader.fx")
end

---------------------------------------------------------------------------------------------------
function GetCrestAsset(idx)
	if (db.player[idx].isCreationZone == 1) then
		if (db.player[idx].hasCzCrestImage > 0) then
			-- // The "\\" is so that the mounted image can be found properly by Apt
			return "data\\ugc/cz_crest/${db.player[?].crestAssetId}.png;data/ugc/cz_crest/1.png"
		else
			return "data/sceneassets/crest/crest_${db.player[?].crestAssetId}.rx3"
		end
	else
		return getKitFile()
	end

end

---------------------------------------------------------------------------------------------------
function GetSkinTone(idx, lod)
	local useLight = false
	if db.player[idx].isVirtualPro == 1 then
		-- // 0 is light, 1 is dark
		useLight =  db.player[idx].faceGenSkinToneType == 0 
	else
		useLight =  db.player[idx].bodySkinToneType < 5 
	end
	useLight = false
	if  useLight  then
		return  "skin_light" or "skin_lod_light"
	else
		return  "skin_dark" or "skin_lod_dark"
	end
end

---------------------------------------------------------------------------------------------------
function GetFaceTone(idx, lod)
	local useLight = false
	if db.player[idx].isVirtualPro == 1 then
		-- // 0 is light, 1 is dark
		useLight =  db.player[idx].faceGenSkinToneType == 0 
	else
		useLight =  db.player[idx].bodySkinToneType < 5 
	end
	useLight = false
	if  useLight  then
		return  "face_light" or "face_lod_light"
	else
		return  "face_dark" or "face_lod_dark"
	end
end

function GetArmsByGender(idx)
  if (db.player[idx].gender == 1) then
   return "data/sceneassets/body/arms_${db.player[?].gender}_${db.player[?].armLength}.rx3"
else
   return "data/sceneassets/body/arms_0_${db.player[?].armLength}.rx3"
  end
end

function GetShortsHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/shorts_0_${db.player[?].shortstyle}_1.rx3"
  else
    return "data/sceneassets/body/shorts_0_${db.player[?].shortstyle}.rx3"
  end
end

function GetShortsLowLodByGender(idx, type)
  local res = ""
  if (type == 1) then
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/shorts_1_${db.player[?].shortstyle}_1.rx3"
    else
      res = "data/sceneassets/body/shorts_1_${db.player[?].shortstyle}.rx3"
    end
  else
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/shorts_2_${db.player[?].shortstyle}_1.rx3"
    else
      res = "data/sceneassets/body/shorts_2_${db.player[?].shortstyle}.rx3"
    end
  end
  return res
end


function GetBodyLowLodByGender(idx, type)
  local res = ""
  if (type == 1) then
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/body_1_${db.player[?].armLength}_0_1.rx3"
    else
      res = "data/sceneassets/body/body_1_${db.player[?].armLength}_0.rx3"
    end
  else
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/body_2_${db.player[?].armLength}_0_1.rx3"
    else
      res = "data/sceneassets/body/body_2_${db.player[?].armLength}_0.rx3"
    end
  end
  return res
end

function GetJerseyHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
     return "data/sceneassets/body/jersey_0_${db.player[?].jerseyCollarType}_${db.player[?].jerseySleeveLength}_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_0_1.rx3;data/sceneassets/body/jersey_0_0_${db.player[?].jerseySleeveLength}_0_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_0_1.rx3"
  else
    return "data/sceneassets/body/jersey_0_${db.player[?].jerseyCollarType}_${db.player[?].jerseySleeveLength}_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_${db.player[?].jerseyfit}.rx3"
  end
end

function GetJerseyLowLodByGender(idx, type)
  local res = ""
  if (type == 1) then
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/jersey_1_${db.player[?].jerseyCollarType}_${db.player[?].jerseySleeveLength}_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_0_1.rx3;data/sceneassets/body/jersey_1_0_${db.player[?].jerseySleeveLength}_0_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_0_1.rx3"
    else
      res = "data/sceneassets/body/jersey_1_${db.player[?].jerseyCollarType}_${db.player[?].jerseySleeveLength}_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_${db.player[?].jerseyfit}.rx3"
    end
  else
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/jersey_2_${db.player[?].jerseySleeveLength}_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}_1.rx3"
    else
      res = "data/sceneassets/body/jersey_2_${db.player[?].jerseySleeveLength}_${db.player[?].jerseyArmBand}_${db.player[?].jerseyTucked}.rx3"
     
    end
  end
  return res
end

function GetShoesHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
     return "data/sceneassets/shoe/playershoe_${db.player[?].playerassetid}_0.rx3;data/sceneassets/shoe/shoe_${db.player[?].shoeType}.rx3;data/sceneassets/shoe/shoe_0_1.rx3"
  else

  	 return "data/sceneassets/shoe/playershoe_${db.player[?].playerassetid}_0.rx3;data/sceneassets/shoe/shoe_${db.player[?].shoeType}.rx3;data/sceneassets/shoe/shoe_0.rx3"

  end
end

function GetShoesLowLodByGender(idx, type)
  local res = ""
  if (type == 1) then
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/shoes_1_0_1.rx3"
    else
      res = "data/sceneassets/body/shoes_1_0.rx3"
    end
  else
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/shoes_2_0_1.rx3"
    else
      res = "data/sceneassets/body/shoes_2_0.rx3"
    end
  end
  return res
end

function GetSocksHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/sock_0_${db.player[?].socklength}_1.rx3"
  else
    return "data/sceneassets/body/sock_0_${db.player[?].socklength}.rx3"
  end
end

function GetSocksLowLodByGender(idx, type)
  local res = ""
  if (type == 1) then
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/socks_1_${db.player[?].socklength}.rx3"
    else
      res = "data/sceneassets/body/socks_1_${db.player[?].socklength}.rx3"
    end
  else
    if (db.player[idx].gender == 1) then
      res = "data/sceneassets/body/socks_2_${db.player[?].socklength}.rx3"
    else
      res = "data/sceneassets/body/socks_2_${db.player[?].socklength}.rx3"
    end
  end
  return res
end

function GetLegsHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/legs_0_${db.player[?].socklength}_1.rx3"
  else
    return "data/sceneassets/body/legs_0_${db.player[?].socklength}.rx3"
  end
end

function GetLegsHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/legs_0_${db.player[?].socklength}_1.rx3"
  else
    return "data/sceneassets/body/legs_0_${db.player[?].socklength}.rx3"
  end
end

function GetHeadHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/heads/head_${db.player[?].head}_${db.player[?].headClass}.rx3;data/sceneassets/heads/women/head_${db.player[?].head}_${db.player[?].headClass}.rx3;data/sceneassets/heads/women/head_7501_1.rx3"
  else
    return "data/sceneassets/heads/head_${db.player[?].playerassetid}_0.rx3;data/sceneassets/heads/head_${db.player[?].headClass}.rx3;data/sceneassets/heads/head_4_1.rx3"
   end
end

function GetHairHighLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/hair/women/hair_${db.player[?].playerassetid}_0_0.rx3;data/sceneassets/hair/hair_${db.player[?].hair}_${db.player[?].faceProxyHeadClass}_0.rx3;data/sceneassets/hair/women/hair_104_1_0.rx3"
  else
    return "data/sceneassets/hair/hair_${db.player[?].playerassetid}_0_0.rx3;data/sceneassets/hair/hair_${db.player[?].hair}_${db.player[?].faceProxyHeadClass}_0.rx3;data/sceneassets/hair/hair_195859_0_0.rx3"
  end
end

function GetHairLodByGender(idx)
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/hairlod/women/hairlod_${db.player[?].playerassetid}_0_0.rx3;data/sceneassets/hairlod/hairlod_${db.player[?].hair}_${db.player[idx].faceProxyHeadClass}_0.rx3;data/sceneassets/hairlod/women/hairlod_104_1_0.rx3"
  else
  
  	return "data/sceneassets/hairlod/hairlod_${db.player[?].playerassetid}_0_0.rx3;data/sceneassets/hairlod/hairlod_${db.player[?].hair}_${db.player[idx].faceProxyHeadClass}_0.rx3;data/sceneassets/hairlod/hairlod_195859_0_0.rx3"
  end
end
---------------------------------------------------------------------------------------------------
function PlayerAssetHighLod(player, lod)
	local gr = gRenderables
	
    -- GEO's
	gr:AddAsset(player, lod, "jersey", "${GetJerseyHighLodByGender(?)}")
	gr:AddAsset(player, lod, "arms", "${GetArmsByGender(?)}")
	gr:AddAsset(player, lod, "shorts", "${GetShortsHighLodByGender(?)}")
	gr:AddAsset(player, lod, "shoes", "${GetShoesHighLodByGender(?)}")
	gr:AddAsset(player, lod, "socks", "${GetSocksHighLodByGender(?)}")
	gr:AddAsset(player, lod, "legs", "${GetLegsHighLodByGender(?)}")
	gr:AddAssetEx(player, lod, "${GetHeadAndHairAssetType(?)}", "hair1", "${GetHairHighLodByGender(?)}")
	gr:AddAssetEx(player, lod, "${GetHeadAndHairAssetType(?)}", "hair2", "${GetHairHighLodByGender(?)}")
	gr:AddAssetEx(player, lod, "${GetHeadAndHairAssetType(?)}", "head", "${GetHeadHighLodByGender(?)}")

    
    
   -- Point the eyes to the same asset the head uses, whether it being cloned or not.
	gr:AddAssetEx(player, lod, "fromasset", "eyes", "head")
	-- non volume texture normalMap for socks
	gr:AddAsset(player, lod, "sockbnmlod", "data/sceneassets/kit/shorts_${db.player[?].shortstyle}_bnm_lod.rx3")
	
	-- Add the morph files
	
	local priority = 0	-- default priority
	local temporary = 1	-- mark as temporary asset
	gr:AddAsset(player, lod, "morphhead", "${MorphFile(?)}", priority, temporary)
	gr:AddAsset(player, lod, "easwmorph", "${EASWMorphFile(?)}")
	
	local part = "jersey"
    gr:CreateMaterialFromAttribulator(player, lod, "jersey", "jersey_material", "${AttribMaterial('jersey')}")
    gr:SetTexture(player, lod, "jersey", "textures", "diffuseTexture", "jersey_tex", "jersey_cm")
    gr:SetTexture(player, lod, "jersey", "textures", "specularMap", "kittex_common", "jersey_coeff")
    gr:SetTexture(player, lod, "jersey", "textures", "occlusionMap", "jerseyam", "jersey_am")
    gr:SetTexture(player, lod, "jersey", "textures", "envDiffuseTexture", "charcmn", "envd_")
    gr:SetTexture(player, lod, "jersey", "textures", "envSpecTexture", "charcmn", "envs_")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "cmnweave", "kit_weave", "jersey_weaveMapAtlas")
    gr:SetTexture(player, lod, "jersey", "textures", "wrinkleMap", "jerseybnm", "jersey_nm")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "kitnumbers", "numbers_${db.player[?].kitNumberFont}_${db.player[?].kitNumberColor}_${db.player[?].kitNumberTens}", "jersey_numTensAtlas")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "kitnumbers", "numbers_${db.player[?].kitNumberFont}_${db.player[?].kitNumberColor}_${db.player[?].kitNumberUnits}", "jersey_numUnitsAtlas")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "cresttex", "${db.player[?].crestTexName}", "jersey_decalAtlas")
    gr:SetTextureFromRuntimeToAtlas(player, lod, "jersey", "textures", "atlas", "namestamp${?}", "jersey_nameAtlas")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")
	
	gr:SetHotSpot(player, lod, part, "global", "jersey_decalBounds", "kithotspots", "jersey", "team")
	gr:SetHotSpot(player, lod, part, "global", "jersey_nameBound", "kithotspots", "jersey", "name")
	gr:SetHotSpot(player, lod, part, "global", "jersey_nameArcCenter", "kithotspots", "jersey", "name_arccenter")
		
	gr:SetConstantInt(player, lod, part, "global", "jersey_nameLayout", "${db.player[?].jerseyNameLayout}")
	
	gr:SetConstantARGB(player, lod, part, "global", "jersey_nameColor", "${db.player[?].kitNameColor}")

	skinTone = "${GetSkinTone(?,"..lod..")}"
	faceTone = "${GetFaceTone(?,"..lod..")}"
	
	part = "arms"
	gr:CreateMaterialFromAttribulator(player, lod, part, "head_material",  skinTone)
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "skintex", "body_")  
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "normalMap", "bodycmn", "body_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "bodycmn", "body_coeff")
	gr:SetConstantARGB(player, lod, part, "global", "skincolor", "${db.player[?].playerBodySkinColor}")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	part = "legs"
	gr:CreateMaterialFromAttribulator(player, lod, part, "head_material", skinTone )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "skintex", "body_")	
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "normalMap", "bodycmn", "body_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "bodycmn", "body_coeff")
	gr:SetConstantARGB(player, lod, part, "global", "skincolor", "${db.player[?].playerBodySkinColor}")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	part = "shorts"
	gr:CreateMaterialFromAttribulator(player, lod, part, "shorts_material", "${AttribMaterial('shorts')}") 
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shortstex", "shorts_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "shortstex", "shorts_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "shortsam", "shorts_am")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "shortsbnm", "shorts_nm")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "cmnweave", "kit_weave", "shorts_weaveMapAtlas")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "cresttex", "${db.player[?].crestTexName}", "shorts_decalAtlas")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "shortsnumbers", "numbers_${db.player[?].shortsNumberFont}_${db.player[?].shortsNumberColor}_${db.player[?].kitNumberTens}", "shorts_numTensAtlas")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "shortsnumbers", "numbers_${db.player[?].shortsNumberFont}_${db.player[?].shortsNumberColor}_${db.player[?].kitNumberUnits}", "shorts_numUnitsAtlas")
	gr:SetHotSpot(player, lod, part, "global", "shorts_decalBounds", "shortshotspots", "shorts", "team")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourShortPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourShortSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourShortTer}")

	-- head
	part = "head"
	gr:CreateMaterialFromAttribulator(player, lod, part, "head_material", faceTone )
	gr:SetSubMesh(player, lod, part, "head")
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "facetex", "head_")
	gr:SetTexture(player, lod, part, "textures", "normalMap", "headcmn", "head_0_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "headcmn", "head_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "headcmn", "head_nm_wkl")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMask", "headcmn", "head_nm_mask")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	-- Eyes
	part = "eyes"	 
	gr:CreateMaterialFromAttribulator(player, lod, part, "eye_material", "${AttribMaterial('eyes')}" )
	gr:SetSubMesh(player, lod, part, "eyes")
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "eyetex", "eyes_")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "headcmn", "eye_coeff")
	gr:SetTexture(player, lod, part, "textures", "normalMap", "headcmn", "eyes_nm")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "env_")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	-- hair1
	part = "hair1"
	gr:CreateMaterialFromAttribulator(player, lod, part, "hair_material", "${AttribMaterial('player_hair_kk_alphaA')}")
	gr:SetSubMesh(player, lod, part, "alphaA")
	gr:SetPriority(player, lod, part, 1)             -- haircap render before hair 2
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "hairtex", "hair_cm") 
	gr:SetTexture(player, lod, part, "textures", "specAlphaMap", "hairtex", "hair_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetConstantARGB(player, lod, part, "global", "hairColor", "${GetHairColorARGB(?)}")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	-- hair2
	part = "hair2"
	gr:CreateMaterialFromAttribulator(player, lod, part, "hair_material2", "${AttribMaterial('player_hair_kk_alphaB')}")
	gr:SetSubMesh(player, lod, part, "alphaB")
	gr:SetPriority(player, lod, part, 2)             -- strands render after hair 1
	gr:SetSelfShadowAlpha(player, lod, part)          -- will use different self shadow shader that accounts for alpha
	--gr:DisableSelfShadow(player, lod, part)          -- Don't render the hairstrands into the selfshadow.
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "hairtex", "hair_cm")
	gr:SetTexture(player, lod, part, "textures", "specAlphaMap", "hairtex", "hair_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetConstantARGB(player, lod, part, "global", "hairColor", "${GetHairColorARGB(?)}")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	-- socks
	part = "socks"
	gr:CreateMaterialFromAttribulator(player, lod, "socks", "socks_material", "${AttribMaterial('sock')}" )  
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shortstex", "shorts_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "shortstex", "shorts_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "shortsam", "shorts_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "sockbnmlod", "shorts_nm")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourSocksPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourSocksSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourSocksTer}")

	-- shoes
	part = "shoes"
	gr:CreateMaterialFromAttribulator(player, lod, part, "shoe_material", "${AttribMaterial('shoe')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shoetex", "shoe_cm")	
	gr:SetTexture(player, lod, part, "textures", "normalMap", "shoetex", "shoe_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "shoetex", "shoe_coeff")	
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "customColorPri", "${db.player[?].shoeColorPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "customColorSec", "${db.player[?].shoeColorSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "customColorTer", "${db.player[?].shoeColorTer}")
	
	--underarmor neck
	local part = "underneck"
	gr:CreateMaterialFromAttribulator(player, lod, part, "underneck_material", "${AttribMaterial('undergear')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "jersey_tex", "jersey_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "kittex_common", "jersey_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "jerseyam", "jersey_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "jerseybnm", "jersey_nm")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourJerseyPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourJerseySec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourJerseyTer}")
	
	--underarmor sleeves
	local part = "underarms"
	gr:CreateMaterialFromAttribulator(player, lod, part, "underarms_material", "${AttribMaterial('undergear')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "jersey_tex", "jersey_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "kittex_common", "jersey_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "jerseyam", "jersey_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "jerseybnm", "jersey_nm")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")
	
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourJerseyPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourJerseySec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourJerseyTer}")

	--undershorts
	local part = "undershorts"
	gr:CreateMaterialFromAttribulator(player, lod, part, "undershorts_material", "${AttribMaterial('undergear')}") 
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shortstex", "shorts_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "shortstex", "shorts_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "shortsam", "shorts_am")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "shortsbnm", "shorts_nm")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourShortPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourShortSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourShortTer}")
	
end

---------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------
function PlayerAssetLowLod(player, lod)
	local gr = gRenderables

	skinLodTone = "${GetSkinTone(?,"..lod..")}"
	faceLodTone = "${GetFaceTone(?,"..lod..")}"

	-- GEO's
  if lod == 1 then
		gr:AddAsset(player, lod, "jersey", "${GetJerseyLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "shorts", "${GetShortsLowLodByGender(?," .. lod .. ")}")
		gr:AddAsset(player, lod, "bodyskinlod", "${GetBodyLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "bodyshoelod", "${GetShoesLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "bodysocklod", "${GetSocksLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "headlod",  "data/sceneassets/headlod/headlod_${db.player[?].head}_${db.player[?].headClass}_1.rx3;data/sceneassets/body/head_1.rx3")
		gr:AddAsset(player, lod, "eyeslod",  "data/sceneassets/headlod/headlod_${db.player[?].head}_${db.player[?].headClass}_1.rx3;data/sceneassets/body/head_1.rx3")
		
		
  elseif lod == 2 then
		gr:AddAsset(player, lod, "jersey", "${GetJerseyLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "shorts", "${GetShortsLowLodByGender(?," .. lod .. ")}")
		gr:AddAsset(player, lod, "bodyskinlod", "${GetBodyLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "bodyshoelod", "${GetShoesLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "bodysocklod", "${GetSocksLowLodByGender(?," .. lod ..")}")
		gr:AddAsset(player, lod, "headlod",  "data/sceneassets/headlod/headlod_${db.player[?].head}_${db.player[?].headClass}_2.rx3;data/sceneassets/body/head_2.rx3")
		gr:AddAsset(player, lod, "eyeslod",  "data/sceneassets/headlod/headlod_${db.player[?].head}_${db.player[?].headClass}_2.rx3;data/sceneassets/body/head_2.rx3")
		
  end
	gr:AddAsset(player, lod, "hairlod", "${GetHairLodByGender(?)}")
	gr:AddAsset(player, lod, "jerseybnmlod", "data/sceneassets/kit/jersey_${db.player[?].jerseyTucked}_${db.player[?].jerseyfit}_bnm_lod.rx3")
	gr:AddAsset(player, lod, "shortsbnmlod", "data/sceneassets/kit/shorts_${db.player[?].shortstyle}_bnm_lod.rx3")


	local part = "jersey"
	gr:CreateMaterialFromAttribulator(player, lod, part, "jersey_material", "${AttribMaterial('jerseylod')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "jersey_tex", "jersey_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "kittex_common", "jersey_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "jerseyam", "jersey_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "cmnweave", "kit_weave", "jersey_weaveMapAtlas")
    gr:SetTexture(player, lod, "jersey", "textures", "wrinkleMap", "jerseybnmlod", "jersey_nm")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "kitnumbers", "numbers_${db.player[?].kitNumberFont}_${db.player[?].kitNumberColor}_${db.player[?].kitNumberTens}", "jersey_numTensAtlas")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "kitnumbers", "numbers_${db.player[?].kitNumberFont}_${db.player[?].kitNumberColor}_${db.player[?].kitNumberUnits}", "jersey_numUnitsAtlas")
    gr:SetTextureToAtlas(player, lod, "jersey", "textures", "atlas", "cresttex", "${db.player[?].crestTexName}", "jersey_decalAtlas")
    gr:SetTextureFromRuntimeToAtlas(player, lod, "jersey", "textures", "atlas", "namestamp${?}", "jersey_nameAtlas")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")
	
	gr:SetHotSpot(player, lod, part, "global", "jersey_decalBounds", "kithotspots", "jersey", "team")
	gr:SetHotSpot(player, lod, part, "global", "jersey_nameBound", "kithotspots", "jersey", "name")
	gr:SetHotSpot(player, lod, part, "global", "jersey_nameArcCenter", "kithotspots", "jersey", "name_arccenter")
	gr:SetConstantInt(player, lod, part, "global", "jersey_nameLayout", "${db.player[?].jerseyNameLayout}")
	
	--gr:SetConstantARGB(player, lod, part, "global", "jersey_nameColor", "${db.player[?].kitNameColor}")

	part = "shorts"
	gr:CreateMaterialFromAttribulator(player, lod, part, "body_material", "${AttribMaterial('shortslod')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shortstex", "shorts_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "shortstex", "shorts_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "shortsam", "shorts_am")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "shortsbnmlod", "shorts_nm")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "cmnweave", "kit_weave", "shorts_weaveMapAtlas")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "cresttex", "${db.player[?].crestTexName}", "shorts_decalAtlas")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "shortsnumbers", "numbers_${db.player[?].shortsNumberFont}_${db.player[?].shortsNumberColor}_${db.player[?].kitNumberTens}", "shorts_numTensAtlas")
    gr:SetTextureToAtlas(player, lod, "shorts", "textures", "atlas", "shortsnumbers", "numbers_${db.player[?].shortsNumberFont}_${db.player[?].shortsNumberColor}_${db.player[?].kitNumberUnits}", "shorts_numUnitsAtlas")
	gr:SetHotSpot(player, lod, part, "global", "shorts_decalBounds", "shortshotspots", "shorts", "team")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourShortPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourShortSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourShortTer}")

	part = "bodyskinlod"
	gr:CreateMaterialFromAttribulator(player, lod, part, "body_material", skinLodTone )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "skintex", "body_")  
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "normalMap", "bodycmn", "body_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "bodycmn", "body_coeff")
	gr:SetConstantARGB(player, lod, part, "global", "skincolor", "${db.player[?].playerBodySkinColor}")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	part = "bodyshoelod"
	gr:CreateMaterialFromAttribulator(player, lod, part, "body_material", "${AttribMaterial('shoelod')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shoetex", "shoe_cm")	
	gr:SetTexture(player, lod, part, "textures", "normalMap", "shoetex", "shoe_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "shoetex", "shoe_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")	
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "customColorPri", "${db.player[?].shoeColorPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "customColorSec", "${db.player[?].shoeColorSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "customColorTer", "${db.player[?].shoeColorTer}")

	part = "bodysocklod"
	gr:CreateMaterialFromAttribulator(player, lod, part, "body_material", "${AttribMaterial('socklod')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shortstex", "shorts_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "shortstex", "shorts_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "shortsam", "shorts_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "shortsbnmlod", "shorts_nm")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourSocksPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourSocksSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourSocksTer}")

	-- eyes
	part = "eyeslod"
	gr:CreateMaterialFromAttribulator(player, lod, part, "head_material", "${AttribMaterial('eyeslod')}" )
	gr:SetSubMesh(player, lod, part, "eye")
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "eyetex", "eyes_")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "headcmn", "eye_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "env_")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	-- head
	part = "headlod"
	gr:CreateMaterialFromAttribulator(player, lod, part, "head_material", faceLodTone )
	gr:SetSubMesh(player, lod, part, "head")
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "facetex", "head_")
	gr:SetTexture(player, lod, part, "textures", "normalMap", "headcmn", "head_0_nm")
	gr:SetTexture(player, lod, part, "textures", "coeffMap", "headcmn", "head_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	-- hair
	part = "hairlod"
	gr:CreateMaterialFromAttribulator(player, lod, part, "hair_material", "${AttribMaterial('player_hair_kk_alphaA_lod')}")
	gr:SetSubMesh(player, lod, part, "alphaA")
	gr:SetPriority(player, lod, part, 1)
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "hairtex", "hair_cm")
	gr:SetTexture(player, lod, part, "textures", "specAlphaMap", "hairtex", "hair_coeff")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetConstantARGB(player, lod, part, "global", "hairColor", "${GetHairColorARGB(?)}")
	
	--underarmor neck
	local part = "underneck"
	gr:CreateMaterialFromAttribulator(player, lod, part, "underneck_material", "${AttribMaterial('socklod')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "jersey_tex", "jersey_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "kittex_common", "jersey_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "jerseyam", "jersey_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "jerseybnmlod", "jersey_nm")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourJerseyPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourJerseySec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourJerseyTer}")

	--underarmor sleeves
	local part = "underarms"
	gr:CreateMaterialFromAttribulator(player, lod, part, "underarms_material", "${AttribMaterial('socklod')}" )
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "jersey_tex", "jersey_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "kittex_common", "jersey_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "jerseyam", "jersey_am")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "jerseybnm", "jersey_nm")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourJerseyPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourJerseySec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourJerseyTer}")

	
	--undershorts
	local part = "undershorts"
	gr:CreateMaterialFromAttribulator(player, lod, part, "undershorts_material", "${AttribMaterial('socklod')}") 
	gr:SetTexture(player, lod, part, "textures", "diffuseTexture", "shortstex", "shorts_cm")
	gr:SetTexture(player, lod, part, "textures", "specularMap", "shortstex", "shorts_coeff")
	gr:SetTexture(player, lod, part, "textures", "occlusionMap", "shortsam", "shorts_am")
	gr:SetTexture(player, lod, part, "textures", "wrinkleMap", "shortsbnmlod", "shorts_nm")
	gr:SetTexture(player, lod, part, "textures", "envDiffuseTexture", "charcmn", "envd_")
	gr:SetTexture(player, lod, part, "textures", "envSpecTexture", "charcmn", "envs_")
	gr:SetTexture(player, lod, part, "textures", "weavePatternNormalMap", "cmnweave", "kit_weave")
	gr:SetTextureFromRuntime(player, lod, part, "textures", "coverageMap", "covmap_${db.player[?].stadiumID}_${db.player[?].stadiumLightID}")

	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorPri", "${db.player[?].kitColourShortPri}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorSec", "${db.player[?].kitColourShortSec}")
	--gr:SetConstantARGB(player, lod, part, "global", "jerseyCustomColorTer", "${db.player[?].kitColourShortTer}")
	
end

---------------------------------------------------------------------------------------------------
function GetFaceTexTemplate(idx)
  if db.player[idx].isVirtualPro == 1 then
	facetex = string.format("data/easw/head_%d.dds", db.player[idx].faceType)
	return facetex..";data/sceneassets/faces/face_"..db.player[idx].faceTypeFallback.."_"..db.player[idx].faceProxyHeadClass.."_0_"..db.player[idx].eyebrow.."_"..db.player[idx].faceSideBurnFallback.."_"..db.player[idx].facialHairColorFallback.."_"..db.player[idx].facialHairTypeFallback.."_"..db.player[idx].headSkinTypeFallback.."_"..db.player[idx].headSkinToneTypeFallback.."_textures.rx3"
  else
    if (db.player[idx].gender == 1) then
        return "data/sceneassets/faces/face_"..db.player[idx].playerassetid.."_0_0_0_0_0_0_0_0_textures.rx3;data/sceneassets/faces/face_".. db.player[idx].faceType .. "_" .. db.player[idx].faceProxyHeadClass .. "_0_" .. db.player[idx].eyebrow .. "_" .. db.player[idx].faceSideBurn .. "_" .. db.player[idx].facialHairColor .. "_" .. db.player[idx].facialHairType .. "_" .. db.player[idx].headSkinType .. "_" .. db.player[idx].headSkinToneType .. "_textures." .. db.player[idx].faceTexExtension .. ";data/sceneassets/faces/women/face_0_1_textures.rx3"
    else
		return "data/sceneassets/faces/face_"..db.player[idx].playerassetid.."_0_0_0_0_0_0_0_0_textures.rx3;data/sceneassets/faces/face_"..db.player[idx].faceType.."_"..db.player[idx].faceProxyHeadClass.."_0_"..db.player[idx].eyebrow.."_"..db.player[idx].faceSideBurn.."_"..db.player[idx].facialHairColor.."_"..db.player[idx].facialHairType.."_"..db.player[idx].headSkinType.."_"..db.player[idx].headSkinToneType.."_textures."..db.player[idx].faceTexExtension .. ";data/sceneassets/faces/face_181820_0_0_0_0_0_0_0_0_textures.rx3"
    end
  end
end


---------------------------------------------------------------------------------------------------
function GetJerseyBMN(idx)
  if (db.player[idx].jerseyTucked == 1) then
    return "data/sceneassets/kit/jersey_${db.player[?].jerseyTucked}_1_bnm.rx3;data/sceneassets/kit/jersey_${db.player[?].jerseyTucked}_0_bnm.rx3"
  else
    return "data/sceneassets/kit/jersey_${db.player[?].jerseyTucked}_0_bnm.rx3"
  end
end

---------------------------------------------------------------------------------------------------
function GetShortsBMN(idx)

	if(db.player[idx].forcePowerOfTwoBNM == 1 or db.player[idx].forceLowResBNM == 1) then
		return "data/sceneassets/kit/shorts_0_bnm_x2.rx3"
	end
	
	return "data/sceneassets/kit/shorts_${db.player[idx].shortstyle}_bnm.rx3"
end

---------------------------------------------------------------------------------------------------
-- returns kit texture or goalie pants kit 5200
function GetShortsTex(idx)
	if(db.player[idx].shortstyle == 1) then
		return "data/sceneassets/kit/kit_5200_0_0.rx3"
	else
		return "data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].kitYear}.rx3"

	end
end

function GetKitTextureOperation(idx)
	if (db.player[idx].useTextureComposition == 1) then
		-- Creation Zone requires generated textures, describe the operation
		-- assetOperation generatetexture: "generatetexture texname width, height, mipCount, compression"
		return "generatetexture jersey_cm 1024,1024,9,eadxt1"
	else
		-- For others we do not need to generate the texture, so we just extract the source asset
		return "extracttexture jersey_cm"
	end
end

function GetKitTextureAssetName(idx)
	if (db.player[idx].useTextureComposition == 1) then
		-- Creation Zone requires generated textures, thus give the asset a unique name
		-- For CZ, kittype is always home, and year is always zero.
		return "gentex_kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].kitYear}_${db.player[?].teamside}_${db.player[?].kitColourJerseyPri}_${db.player[?].kitColourJerseySec}_${db.player[?].kitColourJerseyTer}"
	else
		-- Keep regular rx3 name as this is the source of the texture
		return  "data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].kitYear}.rx3"

	end
end

function GetCommonBodyByGender(idx) 
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/body_common_1_textures.rx3"
  else
    return "data/sceneassets/body/body_common_textures.rx3"
  end
end

function GetUnderarmsByGender(idx) 
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/underarms_0_${db.player[?].underarms}_1.rx3"
  else
    return "data/sceneassets/body/underarms_0_${db.player[?].underarms}.rx3"
  end
end

function GetUnderneckByGender(idx) 
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/underneck_0_${db.player[?].underneck}_1.rx3"
  else
    return "data/sceneassets/body/underneck_0_${db.player[?].underneck}.rx3"
  end
end

function GetUndershortsByGender(idx) 
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/body/undershorts_0_${db.player[?].undershorts}_1.rx3"
  else
    return "data/sceneassets/body/undershorts_0_${db.player[?].undershorts}.rx3"
  end
end

function GetHairByGender(idx) 
  if (db.player[idx].gender == 1) then
    return "data/sceneassets/hair/women/hair_${db.player[?].playerassetid}_0_textures.rx3;data/sceneassets/hair/hair_${db.player[?].hair}_${db.player[?].faceProxyHeadClass}_textures.rx3;data/sceneassets/hair/women/hair_104_1_textures.rx3"
  else
    return "data/sceneassets/hair/hair_${db.player[?].playerassetid}_0_textures.rx3;data/sceneassets/hair/hair_${db.player[?].hair}_${db.player[?].faceProxyHeadClass}_textures.rx3;data/sceneassets/hair/hair_195859_0_textures.rx3"
  end
end
---------------------------------------------------------------------------------------------------
function PlayerAssetLod(player, lod)
	local gr = gRenderables
	
	local defaultpriority = 0	-- default priority

	gr:AddCallback(player, lod, "PlayerUpdate(?)")
	
	local kitTexAsset = getKitFile()
	
	-- Generic files needed by all LODs
	gr:AddAsset(player, lod, "shader", "data/fifarna/shader.big")		
	gr:AddAsset(player, lod, "charcmn", "data/sceneassets/charactercmn/charactercmn_${db.player[?].envLighting}.rx3")
	gr:AddAsset(player, lod, "bodycmn", "${GetCommonBodyByGender(?)}")	
	gr:AddAsset(player, lod, "headcmn", "data/sceneassets/heads/head_${db.player[?].playerassetid}_bump.rx3;data/sceneassets/heads/head_common_textures.rx3")	

	-- Sponsor image for stamping onto kit
	gr:AddAsset(player, lod, "sponsortex", "data/ugc/cz_sponsor/${db.player[?].sponsorAssetId}.png;data/ugc/cz_sponsor/1.png", defaultpriority, ALLOCTYPE_TEMP_AUTO_RELEASE)
	
	-- gr:AddAssetEx(asset, lod, assetOperation, assetPart, containerName)
	-- extracttexture will create an asset with just the texture you extract from the source asset, this way we can free the original rx3, freeing unused textures.
	gr:AddAssetEx(player, lod, "extracttexture jersey_coeff", "kittex_common" , kitTexAsset)
	gr:AddAssetEx(player, lod, "extracttexture shorts_cm,shorts_coeff", "shortstex" , "${GetShortsTex(?)}")
	gr:AddAssetEx(player, lod, "extracthotspots", "kithotspots" , kitTexAsset)
	gr:AddAssetEx(player, lod, "extracthotspots", "shortshotspots",  "${GetShortsTex(?)}")
    gr:AddAssetExToAtlas(player, lod, "extracttexturenofreezenokeep ${db.player[?].crestTexName}", "cresttex", "${GetCrestAsset(?)}") 	

	-- Texture composition code
	-- Add the template asset as a temporary asset, auto releasing it when it's not being used (after texture generation in this case)
	gr:AddAssetEx(player, lod, "extracttexture jersey_cm", "kittex_cm_template" , kitTexAsset, defaultpriority, ALLOCTYPE_TEMP_AUTO_RELEASE)
	local part = "jersey_tex"
	-- GetKitTextureOperation will determine if texture composition is needed.
	gr:AddAssetEx(player, lod, "${GetKitTextureOperation(?)}", part , "${GetKitTextureAssetName(?)}")
	-- Describe texture composition in case we have to generate the texture, this material won't be created if no composition is needed.
	gr:CreateMaterial(player, lod, part, "texcomp.fx" )
	gr:SetTexture(player, lod, part, "textures", "texcomp_tex0", "kittex_cm_template", "jersey_cm")
	gr:SetTexture(player, lod, part, "textures", "texcomp_tex1", "sponsortex", "png")
	gr:SetConstantARGB(player, lod, part, "global", "recolorCustomColorPri", "${db.player[?].kitColourJerseyPri}")
	gr:SetConstantARGB(player, lod, part, "global", "recolorCustomColorSec", "${db.player[?].kitColourJerseySec}")
	gr:SetConstantARGB(player, lod, part, "global", "recolorCustomColorTer", "${db.player[?].kitColourJerseyTer}")
	gr:SetConstantARGB(player, lod, part, "global", "recolourMult", "${db.player[?].sponsorcolour}")
	gr:SetConstantHotSpot(player, lod, part, "global", "samplerBounds1", "${db.player[?].hotspotJerseySponsorL};${db.player[?].hotspotJerseySponsorT};${db.player[?].hotspotJerseySponsorR};${db.player[?].hotspotJerseySponsorB}")
	-- End of texture composition
	
	-- Set the jersey texture as a runtime texture so we can use it outside of player
	gr:SetRuntimeTexture(player, lod, "jersey_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].isgoalie}_${db.player[?].teamside}" , "jersey_tex", "jersey_cm")
	gr:AddAsset(player, lod, "shoetex", "data/sceneassets/shoe/playershoe_${db.player[?].playerassetid}_0_textures.rx3;data/sceneassets/shoe/playershoe_0_0_textures.rx3;data/sceneassets/shoe/shoe_${db.player[?].shoeType}_${db.player[?].shoeDesign}_textures.rx3;data/sceneassets/shoe/shoe_0_0_textures.rx3")
	gr:AddAsset(player, lod, "skintex", "data/sceneassets/body/playerskin/playerskin_${db.player[?].playerassetid}_textures.rx3;data/sceneassets/body/skin_${db.player[?].bodySkinToneType}_textures.rx3")
   
    gr:AddAsset(player, lod, "hairtex", "${GetHairByGender(?)}")

	gr:AddAsset(player, lod, "shortsam", "data/sceneassets/kit/shorts_${db.player[?].shortstyle}_${db.player[?].wet}_textures.rx3")
	gr:AddAsset(player, lod, "jerseyam", "data/sceneassets/kit/jersey_${db.player[?].jerseyTucked}_${db.player[?].wet}_textures.rx3")
	local jerseyBNM = "${GetJerseyBMN(?)}"
	gr:AddAsset(player, lod, "jerseybnm", jerseyBNM)

    gr:AddAssetExToAtlas(player, lod, "nofreezenokeep", "cmnweave", "data/sceneassets/kit/kitweave.rx3")


	local shortsBNM = "${GetShortsBMN(?)}"
	gr:AddAsset(player, lod, "shortsbnm", shortsBNM)

	gr:AddAsset(player, lod, "eyetex", "data/sceneassets/heads/eyes_${db.player[?].playerassetid}_0_textures.rx3;data/sceneassets/heads/eyes_${db.player[?].eyeColor}_${db.player[?].faceProxyHeadClass}_textures.rx3")

	
	-- Add font as a temporary asset, because the font is used after the load (bind time), we still have to manually release it from the renderable
	-- TODO: add font stamping support to composite instead of having the renderable do this at bind time
	local kitnamestring = ""
	kitnamestring = kitnamestring.."data/sceneassets/jerseyfonts/specificfont_${db.player[?].teamid}_${db.player[?].tournid}.ttf;"
    kitnamestring = kitnamestring.."data/sceneassets/jerseyfonts/specificfont_0_${db.player[?].tournid}.ttf;"
    kitnamestring = kitnamestring.."data/sceneassets/jerseyfonts/specificfont_${db.player[?].teamid}_0.ttf;"
	kitnamestring = kitnamestring.."data/sceneassets/jerseyfonts/specificfont_0_${db.player[?].defaulttournid}.ttf;"
	kitnamestring = kitnamestring.."data/sceneassets/jerseyfonts/specificfont_0_0.ttf;"
	local kitnumberstring = ""
	kitnumberstring = kitnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_${db.player[?].teamid}_${db.player[?].tournid}_${db.player[?].kitNumberColor}.rx3;"
	kitnumberstring = kitnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_0_${db.player[?].tournid}_${db.player[?].kitNumberColor}.rx3;"
	kitnumberstring = kitnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_${db.player[?].teamid}_0_${db.player[?].kitNumberColor}.rx3;"
	kitnumberstring = kitnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_0_${db.player[?].defaulttournid}_${db.player[?].kitNumberColor}.rx3;"
	kitnumberstring = kitnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_0_0_${db.player[?].kitNumberColor}.rx3;"
	local shortnumberstring = ""
	shortnumberstring = shortnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_${db.player[?].teamid}_${db.player[?].tournid}_${db.player[?].shortsNumberColor}.rx3;"
	shortnumberstring = shortnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_0_${db.player[?].tournid}_${db.player[?].shortsNumberColor}.rx3;"
	shortnumberstring = shortnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_${db.player[?].teamid}_0_${db.player[?].shortsNumberColor}.rx3;"
	shortnumberstring = shortnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_0_${db.player[?].defaulttournid}_${db.player[?].shortsNumberColor}.rx3;"
	shortnumberstring = shortnumberstring.."data/sceneassets/kitnumbers/specifickitnumbers_0_0_${db.player[?].shortsNumberColor}.rx3;"
	gr:AddAsset(player, lod, "font", kitnamestring.."data/sceneassets/jerseyfonts/font_${db.player[?].kitNameFont}.ttf;data/sceneassets/jerseyfonts/font_6.ttf", defaultpriority, ALLOCTYPE_TEMP_MANUAL_RELEASE)
    gr:AddAssetExToAtlas(player, lod, "nofreezenokeep", "kitnumbers", "data/sceneassets/kitnumbers/kitnumbers_${db.player[?].kitNumberFont}_${db.player[?].kitNumberColor}.rx3;data/sceneassets/kitnumbers/kitnumbers_0_0.rx3")
    gr:AddAssetExToAtlas(player, lod, "nofreezenokeep", "shortsnumbers", "data/sceneassets/kitnumbers/kitnumbers_${db.player[?].shortsNumberFont}_${db.player[?].shortsNumberColor}.rx3;data/sceneassets/kitnumbers/kitnumbers_0_0.rx3")
	
	local faceGenTemplate = "${GetFaceTexTemplate(?)}"
	gr:AddAsset(player, lod, "facetex", faceGenTemplate)

   gr:AddAsset(player, lod, "underarms", "${GetUnderarmsByGender(?)}")
   gr:AddAsset(player, lod, "underneck", "${GetUnderneckByGender(?)}")
   gr:AddAsset(player, lod, "undershorts", "${GetUndershortsByGender(?)}")


	if (lod == 0) then
		PlayerAssetHighLod(player, lod)
	elseif (lod == 1) then
		PlayerAssetLowLod(player, lod)	
	elseif (lod == 2) then
		PlayerAssetLowLod(player, lod)	
	elseif (lod == 3) then
		PlayerAssetShadow(player, lod)
	end	
	
end

---------------------------------------------------------------------------------------------------
function PlayerAssetBind(player)
	PlayerAssetLod(player, 0)
	PlayerAssetLod(player, 1)
	PlayerAssetLod(player, 2)
	PlayerAssetLod(player, 3)
	
end


function SetCustomPlayer(idx, playerId, jerseySleeveType, withUnderNeck, sockLength, withUnderShort, shoeType, jerseyFit, jerseyTucked, jerseyArmBand)
  if db.player[idx].playerassetid == playerId then
    if jerseySleeveType and jerseySleeveType ~= "" then
      if jerseySleeveType == 2 then
        db.player[idx].jerseySleeveLength  = 0
        db.player[idx].underarms = 0
        db.player[idx].armLength = 1
      else
        db.player[idx].jerseySleeveLength = jerseySleeveType
        db.player[idx].armLength = jerseySleeveType
      end
    end

    if withUnderNeck and withUnderNeck ~= "" then
      if withUnderNeck == 0 then
        db.player[idx].underneck  = -1
      else
        db.player[idx].underneck  = 0
      end
    end

    if withUnderShort and withUnderShort ~= "" then
      if withUnderShort == 0 then
        db.player[idx].undershorts  = -1
      else
        db.player[idx].undershorts  = 0
      end
    end

    if sockLength and sockLength ~= "" then
      db.player[idx].socklength = sockLength
    end

    if shoeType and shoeType ~= "" then
      db.player[idx].shoeType = shoeType
    end
    
    if jerseyFit and jerseyFit ~= "" then
      db.player[idx].jerseyfit = jerseyFit
    end

    if jerseyTucked and jerseyTucked ~= "" then
      db.player[idx].jerseyTucked = jerseyTucked
    end
    if jerseyArmBand and jerseyArmBand ~= "" then    
    db.player[idx].jerseyArmBand = jerseyArmBand
    end    
  end
end
-- MOD BY LAOSIJI --





playerFace = {}

function assignPlayerFace(id)
playerFace[id] = 0
end

function getPlayerFace(id,headtype)

if (playerFace[id] ~= nil) then
return playerFace[id]
else
return headtype
end

end



function getTournamentGraphics(id)

if (gloTourn ~= nil) then
return gloTourn
end

if (id == -1) then
return frTourn
end

return id
end





weatherAcc = {}
weatherAcc[0] = 0
weatherAcc[1] = 1
weatherAcc[2] = 1

function setWinterAccessoriesWeather(weather,option)
weatherAcc[weather] = option
end

function getWinterAccessoriesWeather(weather)

if (weatherAcc[weather] ~= nil) then
return (weatherAcc[weather] == 1)
end

return true
end


winterAccessories = {}

function assignWinterAccessories(player,option)
winterAccessories[player] = option
end

function getWinterAccessories(player,option)

if (winterAccessories[player] ~= nil) then
return winterAccessories[player]
end

return option
end


sleeveLength = {}

function setSleeveLength(player,option)
sleeveLength[player] = option
end

function getSleeveLength(player,option)

if (sleeveLength[player] ~= nil) then
return sleeveLength[player]
end

return option
end



winterAccessoriesRef = nil

function useGlobalRefereeWinterAccessories(option)
winterAccessoriesRef = option
end

function getRefereeWinterAccessories(option)

if (winterAccessoriesRef ~= nil) then
return winterAccessoriesRef
end

return option
end


function getKitFile()
if (autoKits) then
local kitstring = ""
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].speckitType}_0.rx3;"
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].tournid}.rx3;"
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].defaulttournid}.rx3;"
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].kitYear}.rx3;"
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_0.rx3;"
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].genkit}_${db.player[?].kitType}_${db.player[?].kitYear}.rx3;"
kitstring = kitstring.."data/sceneassets/kit/kit_${db.player[?].genkit}_${db.player[?].kitType}_0.rx3"
return kitstring
end
return "data/sceneassets/kit/kit_${db.player[?].kit}_${db.player[?].kitType}_${db.player[?].kitYear}.rx3;data/sceneassets/kit/kit_${db.player[?].genkit}_${db.player[?].kitType}_${db.player[?].kitYear}.rx3"
end
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
--[ScoUseR09, RaMziDz15, AF, SwanNoMercy, LaoSiji, GiriZcX, HERRY, Syahrul]
--All Member
--EA SPORTS – original lua code
--Code Go BloCkerr ToLOL
--------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------------------------
