function VolumetricFXUpdate(idx)
	local as = gSportsRNA

	local state = as:GetTable("wvState")
	db.volumetricFX[idx].stadiumID = as:GetInt(state, "wvAttribStadID")
	db.volumetricFX[idx].stadiumLightID = as:GetInt(state, "wvAttribStadLightID")
end

function VolumetricFXAssetBind(volumetricFX)
	local gr = gRenderables
   	local lod = 0
    local meshAsset = "data/sceneassets/volumefx/volumefx_${db.volumetricFX[?].stadiumID}_${db.volumetricFX[?].stadiumLightID}.rx3"
    local textureAsset = "data/sceneassets/volumefx/volumefx_textures.rx3"
    
	gr:AddCallback(volumetricFX, lod, "VolumetricFXUpdate(?)")

	gr:AddAsset(volumetricFX, lod, "shader", "data/fifarna/shader.big")

	gr:AddAsset(volumetricFX, lod, "volumetricFX", meshAsset)
	gr:AddAsset(volumetricFX, lod, "tanimconfettihome", meshAsset)
	gr:AddAsset(volumetricFX, lod, "tanimconfettiaway", meshAsset)
	gr:AddAsset(volumetricFX, lod, "tanimstreamerhome", meshAsset)
	gr:AddAsset(volumetricFX, lod, "tanimstreameraway", meshAsset)
	gr:AddAsset(volumetricFX, lod, "commontex", textureAsset)
	
	mesh = "tanimconfettihome"
	gr:CreateMaterialFromAttribulator(volumetricFX, lod, mesh, "confettyhome_mtl", "tanimconfettihome" )
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "diffuse_texture_confetti", "commontex", "fx_confetticolor")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "normal_texture_confetti", "commontex", "fx_confettinormal")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "alpha_texture_confetti", "commontex", "fx_confettialpha")
	
	mesh = "tanimconfettiaway"
	gr:CreateMaterialFromAttribulator(volumetricFX, lod, mesh, "confettyaway_mtl", "tanimconfettiaway" )
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "diffuse_texture_confetti", "commontex", "fx_confetticolor")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "normal_texture_confetti", "commontex", "fx_confettinormal")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "alpha_texture_confetti", "commontex", "fx_confettialpha")

	mesh = "tanimstreamerhome"
	gr:CreateMaterialFromAttribulator(volumetricFX, lod, mesh, "streamerhome_mtl", "tanimstreamerhome" )
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "diffuse_texture_streamers", "commontex", "fx_streamercolor")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "normal_texture_streamers", "commontex", "fx_streamernormal")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "alpha_texture_streamers", "commontex", "fx_streameralpha")

	mesh = "tanimstreameraway"
	gr:CreateMaterialFromAttribulator(volumetricFX, lod, mesh, "streameraway_mtl", "tanimstreameraway" )
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "diffuse_texture_streamers", "commontex", "fx_streamercolor")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "normal_texture_streamers", "commontex", "fx_streamernormal")
	gr:SetTexture(volumetricFX, lod, mesh, "textures", "alpha_texture_streamers", "commontex", "fx_streameralpha")

	return volumetricFX
end

