local InitializeSettings = function()
	local as = gSportsRNA
	local settingTable = as:GetTable("Settings")

	-- Force LevelOfDetail - ultra', 'max', high', 'medium', 'low', 'superslow'
	local levelOfDetail = as:GetString(settingTable, "LevelOfDetail") 
              as:SetGlobalInt("AI_SETTING_DRAWMODE", 3)
	if (levelOfDetail == "ultra") then
		levelOfDetail = "ultra"
		levelOfGraphics = "ultra"
		as:SetString(settingTable, "LevelOfDetail", levelOfDetail)
	end

--	levelOfDetail = "ultra"

	-- Set up defaults (max detail)
	as:SetInt(settingTable, "DropMipRX3_MipsToDrop", 0)			-- number of mips to drop from RX3 textures
	as:SetInt(settingTable, "DropMipRX3_MinTexDimension", 9159)	-- minimum size (here we will ignore the number of mips to drop)
	as:SetInt(settingTable, "FlatShadow_ScaleReduction", 300)		-- flat shadow dimensions 			(0 is normal, 1 is half, 2 is quarter, 3 is an eigth)
	as:SetInt(settingTable, "FlatShadow_MinLights", 2)		-- flat shadow dimensions 			(0 is normal, 1 is half, 2 is quarter, 3 is an eigth)
	as:SetInt(settingTable, "StadiumShadow_ScaleReduction", 0)
	as:SetInt(settingTable, "StadiumLight_MaxLights", 4)		-- flat shadow dimensions 			(0 is normal, 1 is half, 2 is quarter, 3 is an eigth)
	as:SetInt(settingTable, "FlatShadow_MaxLights", 4)			-- jumlah lampu maksimal yang diperbolehkan
	as:SetInt(settingTable, "StadiumShadow_MaxLights", 4)
	as:SetInt(settingTable, "Jumbotron_ScaleReduction", 1)		-- jumbotron render scale reduction 
	as:SetInt(settingTable, "SelfShadow", 1)
	as:SetInt(settingTable, "Brightness_MaxLights", 4)
	as:SetInt(settingTable, "GrassLight_MaxLights", 4)
    as:SetInt(settingTable, "CreateLightmapTexture", 1) 		
	as:SetInt(settingTable, "SelfShadow_ScaleReduction", 2)		-- selfshadow render scale reduction (0 normal, 1 half, 2 quartered)
	as:SetInt(settingTable, "PostFX_RainDrops", 1)
	as:SetInt(settingTable, "lightprobes_lightrig.fx", 1)
	as:SetInt(settingTable, "WeatherMap", 1)
	as:SetInt(settingTable, "LightsMap", 1)
	as:SetInt(settingTable, "PostFX_NightLight", 1)
	as:SetInt(settingTable, "PostFX_StadiumLight", 1)
	as:SetInt(settingTable, "PostFX_NightMode", 1)
	as:SetInt(settingTable, "PostFX_RX3", 1)
	as:SetInt(settingTable, "AreaLight", 1)
	as:SetInt(settingTable, "AreaLightScale", 4)
	as:SetInt(settingTable, "DebugMode", 1)
	if ( EA_PLATFORM_MAC == true ) then
		as:SetInt(settingTable, "PostFX_RainDrops", 1)
		as:SetInt(settingTable, "PostFX_Brightness", 1)
		as:SetInt(settingTable, "PostFX_Stadium", 1)
		as:SetInt(settingTable, "PostFX_LightMap", 1)
		as:SetInt(settingTable, "PostFX_Contrast", 1)
		as:SetInt(settingTable, "PostFX_Texture", 1)
		as:SetInt(settingTable, "PostFX_HD", 1)
		as:SetInt(settingTable, "PostFX_Engine", 1)
		as:SetInt(settingTable, "PostFX_StadiumLights", 1)
		as:SetInt(settingTable, "PostFX_Ball", 1)
		as:SetInt(settingTable, "PostFX_Color", 1)
		as:SetInt(settingTable, "PostFX_Combiners", 1)
		as:SetInt(settingTable, "PostFX_Crowd", 1)
		as:SetInt(settingTable, "PostFX_CovMap", 1)
		as:SetInt(settingTable, "PostFX_Display", 1)
		as:SetInt(settingTable, "PostFX_Weather", 1)
		as:SetInt(settingTable, "PostFX_AutoExp", 1)
		as:SetInt(settingTable, "PostFX_Bloom", 1)
		as:SetInt(settingTable, "PostFX_DOF", 1)
		as:SetInt(settingTable, "PostFX_Rectilinear", 1)
		as:SetInt(settingTable, "PostFX_Vignette", 1)	
		as:SetInt(settingTable, "PostFX_ColorCube", 1)
		as:SetInt(settingTable, "PostFX_ColorCubeDepth", 0)
	else
		as:SetInt(settingTable, "PostFX_RainDrops", 1)
		as:SetInt(settingTable, "PostFX_Brightness", 1)
		as:SetInt(settingTable, "PostFX_Stadium", 1)
		as:SetInt(settingTable, "PostFX_LightMap", 1)
		as:SetInt(settingTable, "PostFX_Contrast", 1)
		as:SetInt(settingTable, "PostFX_Texture", 1)
		as:SetInt(settingTable, "PostFX_HD", 1)
		as:SetInt(settingTable, "PostFX_Engine", 1)
		as:SetInt(settingTable, "PostFX_StadiumLights", 1)
		as:SetInt(settingTable, "PostFX_Ball", 1)
		as:SetInt(settingTable, "PostFX_Color", 1)
		as:SetInt(settingTable, "PostFX_Combiners", 1)
		as:SetInt(settingTable, "PostFX_Crowd", 1)
		as:SetInt(settingTable, "PostFX_CovMap", 1)
		as:SetInt(settingTable, "PostFX_Display", 1)
		as:SetInt(settingTable, "PostFX_Weather", 1)
		as:SetInt(settingTable, "PostFX_AutoExp", 1)
		as:SetInt(settingTable, "PostFX_Bloom", 1)
		as:SetInt(settingTable, "PostFX_DOF", 1)
		as:SetInt(settingTable, "PostFX_Rectilinear", 1)
		as:SetInt(settingTable, "PostFX_Vignette", 1)	
		as:SetInt(settingTable, "PostFX_ColorCube", 1)
		as:SetInt(settingTable, "PostFX_ColorCubeDepth", 0)
	end
	as:SetInt(settingTable, "PostFX_RainDrops", 1)
		as:SetInt(settingTable, "PostFX_Brightness", 1)
		as:SetInt(settingTable, "PostFX_Stadium", 1)
		as:SetInt(settingTable, "PostFX_LightMap", 1)
		as:SetInt(settingTable, "PostFX_Contrast", 1)
		as:SetInt(settingTable, "PostFX_Texture", 1)
		as:SetInt(settingTable, "PostFX_HD", 1)
		as:SetInt(settingTable, "PostFX_Engine", 1)
		as:SetInt(settingTable, "PostFX_StadiumLights", 1)
		as:SetInt(settingTable, "PostFX_Ball", 1)
		as:SetInt(settingTable, "PostFX_Color", 1)
		as:SetInt(settingTable, "PostFX_Combiners", 1)
		as:SetInt(settingTable, "PostFX_Crowd", 1)
		as:SetInt(settingTable, "PostFX_CovMap", 1)
		as:SetInt(settingTable, "PostFX_Display", 1)
		as:SetInt(settingTable, "PostFX_Weather", 1)
		as:SetInt(settingTable, "PostFX_AutoExp", 1)
		as:SetInt(settingTable, "PostFX_Bloom", 1)
		as:SetInt(settingTable, "PostFX_DOF", 1)
		as:SetInt(settingTable, "PostFX_Rectilinear", 1)
		as:SetInt(settingTable, "PostFX_Vignette", 1)	
		as:SetInt(settingTable, "PostFX_ColorCube", 1)
		as:SetInt(settingTable, "PostFX_ColorCubeDepth", 0)

    as:SetInt(settingTable, "DepthBufferPrepass", 1)

	-- Enable grass and cloth
		as:SetInt(settingTable, "Grass", 1)
		as:SetInt(settingTable, "Reflection", 1)
		-- cloth is enabled for hi lods
		-- in case of performance issues disable cloth and always use tucked jerseys
		as:SetInt(settingTable, "Cloth", 1)
		as:SetInt(settingTable, "Graphics", 1)
		as:SetInt(settingTable, "Lights", 1)
		as:SetInt(settingTable, "Accessory", 1)
		as:SetInt(settingTable, "Texture", 1)
		as:SetInt(settingTable, "PostFX", 1)
		as:SetInt(settingTable, "Shaders", 1)
		as:SetInt(settingTable, "Stadium", 1)
		as:SetInt(settingTable, "Brightness", 1)
		as:SetInt(settingTable, "LightMap", 1)
		as:SetInt(settingTable, "Contrast", 1)
		as:SetInt(settingTable, "Texture", 1)
		as:SetInt(settingTable, "HD", 1)
		as:SetInt(settingTable, "Engine", 1)
		as:SetInt(settingTable, "StadiumLights", 1)
		as:SetInt(settingTable, "Ball", 1)
        as:SetInt(settingTable, "Color", 1)
        as:SetInt(settingTable, "Combiners", 1)
        as:SetInt(settingTable, "Crowd", 1)
        as:SetInt(settingTable, "CovMap", 1)
        as:SetInt(settingTable, "Display", 1)
        as:SetInt(settingTable, "Weather", 1)
        as:SetInt(settingTable, "AutoExp", 1)
        as:SetInt(settingTable, "Bloom", 1)
        as:SetInt(settingTable, "DOF", 1)
        as:SetInt(settingTable, "Rectilinear", 1)
        as:SetInt(settingTable, "Vignette", 1)
        as:SetInt(settingTable, "ColorCube", 1)
        as:SetInt(settingTable, "ColorCubeDepth", 1)
    	as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 1000.0)
    	as:SetInt(settingTable, "PlayerLodMinimum", 0)

	-- Override..
   	if (levelOfDetail == "ultra") then

		as:SetInt(settingTable, "FlatShadow_ScaleReduction", 300)
		as:SetInt(settingTable, "FlatShadow_MaxLights", 4)	   
		as:SetInt(settingTable, "StadiumLight_MaxLights", 4)
		as:SetInt(settingTable, "Jumbotron_ScaleReduction", 0) 
		as:SetInt(settingTable, "StadiumShadow_MaxLights", 4)
		as:SetInt(settingTable, "StadiumShadow_ScaleReduction", 3)
		as:SetInt(settingTable, "Grass", 1)
		as:SetInt(settingTable, "Cloth", 1)
		as:SetInt(settingTable, "Texture", 1)
		as:SetInt(settingTable, "SelfShadow_ScaleReduction", 2)
		as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 1000.0)
		as:SetFloat(settingTable, "StadiumLodPercentageMultiplier", 100.0)
		as:SetFloat(settingTable, "GrassLodPercentageMultiplier", 1000.0)

	elseif (levelOfDetail == "ultra" or levelOfDetail == "ultra") then
		-- Downsize Render to texture sizes and detail
		as:SetInt(settingTable, "DropMipRX3_MinTexDimension", 8959)
		as:SetInt(settingTable, "DropMipRX3_MipsToDrop", 3)
		as:SetInt(settingTable, "FlatShadow_ScaleReduction", 3)
		as:SetInt(settingTable, "FlatShadow_MaxLights", 4) 
		as:SetInt(settingTable, "StadiumShadow_ScaleReduction", 3)
		as:SetInt(settingTable, "StadiumLight_MaxLights", 4)
		as:SetInt(settingTable, "StadiumShadow_MaxLights", 4)
		as:SetInt(settingTable, "Jumbotron_ScaleReduction", 1)
		as:SetInt(settingTable, "SelfShadow", 1)	
		as:SetInt(settingTable, "SelfShadow_ScaleReduction", 2)

        -- prepass buffer kedalaman sebagai pengoptimalan mungkin menghemat beberapa biaya piksel - namun dalam kasus spesifikasi minimum, mengingat resolusi yang lebih rendah saat game dijalankan, tidak membawa manfaat apa pun
		-- kita tidak memerlukan buffer kedalaman karena DoF dan kubus warna kedalaman dinonaktifkan pada spesifikasi minimum
		-- juga, tidak ada FX yang memerlukan buffer kedalaman saat ini
		as:SetInt(settingTable, "DepthBufferPrepass", 1)

		-- Enable grass and cloth
		as:SetInt(settingTable, "Grass", 1)
		as:SetInt(settingTable, "Reflection", 1)
		-- cloth is enabled for hi lods
		-- in case of performance issues disable cloth and always use tucked jerseys
		as:SetInt(settingTable, "Cloth", 1)
		as:SetInt(settingTable, "Graphics", 1)
		as:SetInt(settingTable, "Lights", 1)
		as:SetInt(settingTable, "Accessory", 1)
		as:SetInt(settingTable, "Texture", 1)
		as:SetInt(settingTable, "PostFX", 1)
		as:SetInt(settingTable, "Shaders", 1)
		as:SetInt(settingTable, "Stadium", 1)
		as:SetInt(settingTable, "Brightness", 1)
		as:SetInt(settingTable, "LightMap", 1)
		as:SetInt(settingTable, "Contrast", 1)
		as:SetInt(settingTable, "Texture", 1)
		as:SetInt(settingTable, "HD", 1)
		as:SetInt(settingTable, "Engine", 1)
		as:SetInt(settingTable, "StadiumLights", 1)
		as:SetInt(settingTable, "Ball", 1)
        as:SetInt(settingTable, "Color", 1)
        as:SetInt(settingTable, "Combiners", 1)
        as:SetInt(settingTable, "Crowd", 1)
        as:SetInt(settingTable, "CovMap", 1)
        as:SetInt(settingTable, "Display", 1)
        as:SetInt(settingTable, "Weather", 1)
        as:SetInt(settingTable, "AutoExp", 1)
        as:SetInt(settingTable, "Bloom", 1)
        as:SetInt(settingTable, "DOF", 1)
        as:SetInt(settingTable, "Rectilinear", 1)
        as:SetInt(settingTable, "Vignette", 1)
        as:SetInt(settingTable, "ColorCube", 1)
        as:SetInt(settingTable, "ColorCubeDepth", 1)

		-- enable pretty much all PostFX
		as:SetInt(settingTable, "PostFX_RainDrops", 1)
		as:SetInt(settingTable, "PostFX_Brightness", 1)
		as:SetInt(settingTable, "PostFX_Stadium", 1)
		as:SetInt(settingTable, "PostFX_LightMap", 1)
		as:SetInt(settingTable, "PostFX_Contrast", 1)
		as:SetInt(settingTable, "PostFX_Texture", 1)
		as:SetInt(settingTable, "PostFX_HD", 1)
		as:SetInt(settingTable, "PostFX_Engine", 1)
		as:SetInt(settingTable, "PostFX_StadiumLights", 1)
		as:SetInt(settingTable, "PostFX_Ball", 1)
		as:SetInt(settingTable, "PostFX_Color", 1)
		as:SetInt(settingTable, "PostFX_Combiners", 1)
		as:SetInt(settingTable, "PostFX_Crowd", 1)
		as:SetInt(settingTable, "PostFX_CovMap", 1)
		as:SetInt(settingTable, "PostFX_Display", 1)
		as:SetInt(settingTable, "PostFX_Weather", 1)
		as:SetInt(settingTable, "PostFX_AutoExp", 1)
		as:SetInt(settingTable, "PostFX_Bloom", 1)
		as:SetInt(settingTable, "PostFX_DOF", 1)
		as:SetInt(settingTable, "PostFX_Rectilinear", 1)
		as:SetInt(settingTable, "PostFX_Vignette", 1)	
		as:SetInt(settingTable, "PostFX_ColorCube", 1)
		as:SetInt(settingTable, "PostFX_ColorCubeDepth", 0)
	
		as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 1000.0)
	end
	
	if (levelOfDetail == "ultra") then
		-- any extra tweaks here..
	end
end
InitializeSettings()
InitializeSettings = nil