local InitializeSettings = function()
    local as = gSportsRNA
    local settingTable = as:GetTable("Settings")

    -- Force LevelOfDetail - 'high', 'medium', 'low', 'superlow'
    local levelOfDetail = as:GetString(settingTable, "LevelOfDetail")
    if (levelOfDetail == "") then
        levelOfDetail = "medium"
        as:SetString(settingTable, "LevelOfDetail", levelOfDetail)
    end

    -- Set up defaults (high detail)
    as:SetInt(settingTable, "DropMipRX3_MipsToDrop", 0)            -- number of mips to drop from RX3 textures
    as:SetInt(settingTable, "DropMipRX3_MinTexDimension", 8192)    -- minimum size (here we will ignore the number of mips to drop)
    as:SetInt(settingTable, "FlatShadow_ScaleReduction", 0)        -- flat shadow dimensions             (0 is normal, 1 is half, 2 is quarter, 3 is an eigth)
    as:SetInt(settingTable, "FlatShadow_MaxLights", 4)            -- max number of lights to allow
    as:SetFloat(settingTable, "FlatShadow_QuadLenMultiplier", 1.0)    -- multiplier for the length covered on ground by one quad; bigger means better performance, but lower quality
    as:SetInt(settingTable, "FlatShadow_Blur", 1)
    as:SetInt(settingTable, "SelfShadow", 1)
    as:SetInt(settingTable, "SelfShadow_ScaleReduction", 0)        -- selfshadow render scale reduction (0 normal, 1 half, 2 quartered)
    as:SetInt(settingTable, "PostFX_RainDrops", 1)
    if ( EA_PLATFORM_MAC == true ) then
        as:SetInt(settingTable, "PostFX_AutoExp", 0) -- Turn off autoexposure on MAC (This causes it to use simple exposure)
    else
        as:SetInt(settingTable, "PostFX_AutoExp", 1)
    end
    as:SetInt(settingTable, "PostFX_Bloom", 1)
    as:SetInt(settingTable, "PostFX_DOF", 1)
    as:SetInt(settingTable, "PostFX_Rectilinear", 1)
    as:SetInt(settingTable, "PostFX_Vignette", 1)
    as:SetInt(settingTable, "PostFX_Grain", 1)
    as:SetInt(settingTable, "PostFX_ColorCube", 1)
    as:SetInt(settingTable, "PostFX_ColorCubeDepth", 1)
    as:SetInt(settingTable, "PostFX_SSAO", 1)
    as:SetInt(settingTable, "PostFX_MotionBlur", 1)
    -- LumBloom texture reduction (0 is normal, 1 is half, 2 is quarter, 3 is an eigth)
    as:SetInt(settingTable, "PostFX_LumBloom_ScaleReduction", 1)

    as:SetInt(settingTable, "Grass", 1)
    as:SetInt(settingTable, "Cloth", 1)
    as:SetInt(settingTable, "PitchSpray", 1)
    as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 100.0)
    as:SetInt(settingTable, "PlayerLodMinimum", 0)

    as:SetFloat(settingTable, "RainIntensityScaler", 1.0)
    as:SetFloat(settingTable, "Particle_HalfRes_ScaleReduction", 1) -- glares render target scale reduction (3 default)
    as:SetInt(settingTable, "MaxAnisotropy", -1) -- limit anisotropy level for textures

	-- Override..
       if (levelOfDetail == "medium") then

        as:SetInt(settingTable, "FlatShadow_ScaleReduction", 1)
        as:SetInt(settingTable, "FlatShadow_MaxLights", 4)
        as:SetInt(settingTable, "Grass", 1)
        as:SetInt(settingTable, "Cloth", 0)
        as:SetInt(settingTable, "PitchSpray", 1)
        as:SetInt(settingTable, "FlatShadow_Blur", 0)
        as:SetInt(settingTable, "SelfShadow_ScaleReduction", 1)
        as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 100.0)
        as:SetFloat(settingTable, "RainIntensityScaler", 0.5)
        as:SetInt(settingTable, "MaxAnisotropy", 2) -- limit anisotropy level

    elseif (levelOfDetail == "low" or levelOfDetail == "superlow") then
        -- Downsize Render to texture sizes and detail
        as:SetInt(settingTable, "DropMipRX3_MinTexDimension", 512)
        as:SetInt(settingTable, "DropMipRX3_MipsToDrop", 1)
        as:SetInt(settingTable, "FlatShadow_ScaleReduction", 1)
        as:SetInt(settingTable, "FlatShadow_MaxLights", 1)
        as:SetInt(settingTable, "FlatShadow_Blur", 0)
        as:SetInt(settingTable, "SelfShadow", 0)
        as:SetFloat(settingTable, "FlatShadow_QuadLenMultiplier", 1.0)

        -- Disable grass and cloth
        as:SetInt(settingTable, "Grass", 1)
        -- cloth is enabled for hi lods
        -- in case of performance issues disable cloth and always use tucked jerseys
        as:SetInt(settingTable, "Cloth", 0)
        as:SetInt(settingTable, "PitchSpray", 1)

        -- disable pretty much all PostFX
        as:SetInt(settingTable, "PostFX_RainDrops", 0)
        --Need autoexpousre to make lighting correct
        --as:SetInt(settingTable, "PostFX_AutoExp", 0)
        as:SetInt(settingTable, "PostFX_Bloom", 0)
        as:SetInt(settingTable, "PostFX_DOF", 0)
        as:SetInt(settingTable, "PostFX_Rectilinear", 0)
        as:SetInt(settingTable, "PostFX_Vignette", 0)
        as:SetInt(settingTable, "PostFX_Grain", 0)
        as:SetInt(settingTable, "PostFX_ColorCube", 0)
        as:SetInt(settingTable, "PostFX_ColorCubeDepth", 0)
        as:SetInt(settingTable, "PostFX_MotionBlur", 0)

        as:SetFloat(settingTable, "PlayerLodPercentageMultiplier", 100.0)
        as:SetFloat(settingTable, "RainIntensityScaler", 0.2)
        as:SetInt(settingTable, "MaxAnisotropy", 0) -- no anisotropy
    end

    if (levelOfDetail == "superlow") then
        -- any extra tweaks here..
    end
end
InitializeSettings()
InitializeSettings = nil
