uniform    mat4  u_mvpMatrix;
uniform    mat4  u_view;
uniform	   mat4  u_windows;

attribute  vec4  a_position;
attribute  mediump vec2  a_texCoord;
attribute  mediump vec3 a_normalCoord;

uniform mediump vec4 u_lightAmbient;
uniform mediump vec4 u_lightDirections[3];
uniform mediump vec4 u_lightColors[3];

varying    lowp vec2  v_texCoord;
varying    lowp vec4  v_color;
void main()
{
	gl_Position	= u_mvpMatrix * a_position;
	
	vec3 v_normal = mat3(u_view[0].xyz, u_view[1].xyz, u_view[2].xyz) * a_normalCoord;
	
	float check = length(v_normal);
	vec3 norm;
	
	norm = normalize(v_normal);
	
	
	
	v_color =   u_lightAmbient + max(-0.1, dot(norm, u_lightDirections[0].xyz)) * u_lightColors[0] + max(-0.1, dot(norm, u_lightDirections[0].xyz)) * u_lightColors[0] + max(-0.1, dot(norm, u_lightDirections[0].xyz)) *  u_lightColors[0];

	v_texCoord	= a_texCoord;	  
}
