uniform highp sampler2D s_texture;
uniform highp sampler2D s_lightMap;
uniform highp sampler2D s_textLay2;
uniform highp sampler2D s_textLay3;
uniform highp sampler2D s_textLay4;
uniform highp sampler2D s_textLay5;
uniform highp vec4      u_wearColor;
uniform highp vec4      u_offsetColor;

varying highp vec2 v_texCoord;
varying highp vec2 v_texLay2Coord;
varying highp vec2 v_texLay3Coord; 
varying highp vec2 v_texLay5Coord; 
varying highp vec2 v_texLay4Coord; 
varying highp vec2 v_lightMapCoord;

void main()
{
   highp vec4 txt = texture2D(s_texture, v_texCoord);
   highp vec4 txtL4 = texture2D(s_textLay3, v_texLay5Coord);
 
   highp vec4 LM =  texture2D(s_textLay2, v_texLay2Coord) * texture2D(s_textLay2, v_texLay2Coord) * texture2D(s_lightMap, v_lightMapCoord);
	
   highp vec4 finalTex =vec4(txt.rgb + txtL4.rgb, txt.a * txtL4.a);
	
   gl_FragColor =  finalTex * LM+ texture2D(s_textLay3, v_texLay3Coord) *  u_wearColor;
}

