print("ScoreboardSubstitutions.lua")
local ScoreboardSubstitutions = {}
local OverlaysIdContainer, OverlayParam, eventmanager = ...
local Overlays = OverlaysIdContainer.Overlays.OVERLAY_TYPE
local EventTypes = eventmanager.FE.FIFA.EventTypes
local initialized = false
local bndVisible = "bnd_visible"
local bndNationalization = "bnd_nationalization"
local bndData = "bnd_data"
local bndAlpha = "bnd_alpha"
function ScoreboardSubstitutions:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.nationalization = 2
  o.services = {
    eventManService = o.api("EventManagerService"),
    SquadManagementService = o.api("SquadMgtService"),
    GameSetupService = o.api("GameSetupService"),
    MatchInfoService = o.api("MatchInfoService")
  }
  local HOMETEAM = 0
  local AWAYTEAM = 1
  o.TeamsData = o.services.MatchInfoService.GetMatchTeams()
  
  homeTeamlineupData = o.services.SquadManagementService.GetCurrentPlayerLineup(HOMETEAM, o.TeamsData[1].assetId, 0)
  
  awayTeamlineupData = o.services.SquadManagementService.GetCurrentPlayerLineup(AWAYTEAM, o.TeamsData[2].assetId, 0)
  
  HomeTeamData = {
    teamAssetId = o.TeamsData[1].assetId,
    shortName = o.services.GameSetupService.GetTeamShortName(HOMETEAM),
    crest = {
      name = "$Crest",
      id = o.TeamsData[1].assetId
    }
  }

  AwayTeamData = {
    teamAssetId = o.TeamsData[2].assetId,
    shortName = o.services.GameSetupService.GetTeamShortName(AWAYTEAM),
    crest = {
      name = "$Crest",
      id = o.TeamsData[2].assetId
    }
  }

  o.handlerId = o.services.eventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  o.im.Subscribe(bndNationalization, function()
  end)
  o.im.Subscribe(bndVisible, function()
    o.im.Publish(bndVisible, false)
  end)
  o.im.Subscribe(bndAlpha, function()
  end)
  o.im.Subscribe(bndData, function()
  end)
  o.im.Subscribe("bnd_Inplayer_avatar", function()
  end)
  o.im.Subscribe("bnd_Inplayer_name", function()
  end)
  o.im.Subscribe("bnd_Inplayer_number", function()
  end)
  o.im.Subscribe("bnd_Outplayer_avatar", function()
  end)
  o.im.Subscribe("bnd_Outplayer_name", function()
  end)
  o.im.Subscribe("bnd_Outplayer_number", function()
  end)
  o.im.Subscribe("bnd_home_crest_show", function()
    o.im.Publish("bnd_home_crest_show", false)
  end)
  o.im.Subscribe("bnd_away_crest_show", function()
    o.im.Publish("bnd_away_crest_show", false)
  end)
  o.im.Subscribe("bnd_home_crest", function()
    o.im.Publish("bnd_home_crest", HomeTeamData.crest)
  end)
  o.im.Subscribe("bnd_away_crest", function()
    o.im.Publish("bnd_away_crest", AwayTeamData.crest)
  end)
  return o
end
function ScoreboardSubstitutions:handleEvent(eventType, data)
  if eventType == EventTypes.OverlayTypeIngameSubstitution then
    self:updateScoreboardSubstitutions(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
end
function ScoreboardSubstitutions:updateScoreboardSubstitutions(subtype, hideshow, subtypestr, msg)
  local params = OverlayParam.split(msg, "|")
  InplayerAvatar = {
    name = "$Head",
    id = 0
  }
  OutplayerAvatar = {
    name = "$Head",
    id = 0
  }
  if hideshow == "SHOW" then
    if initialized == false then
      self.im.Publish(bndNationalization, self.nationalization)
      initialized = true
    end
    if params and table.getn(params) > 0 then
      self.im.Publish(bndVisible, true)
      local subTeamId = params[2] + 0
      local substitutions = {
        teamName = params[3],
        inPlayer = params[4],
        outPlayer = params[5]
      }
      local teamside = 0
      if subTeamId == self.TeamsData[1].assetId then
        teamside = 0
      else
        teamside = 1
      end
      
      local InplayerInfo = self:getPlayerInfo(teamside, subTeamId, substitutions.inPlayer)
      local OutplayerInfo = self:getPlayerInfo(teamside, subTeamId, substitutions.outPlayer)
      InplayerAvatar.id = InplayerInfo.assetId
      OutplayerAvatar.id = OutplayerInfo.assetId
      self.im.Publish("bnd_Inplayer_avatar", InplayerAvatar)
      self.im.Publish("bnd_Outplayer_avatar", OutplayerAvatar)
      self.im.Publish("bnd_Inplayer_name", InplayerInfo.playerName)
      self.im.Publish("bnd_Outplayer_name", OutplayerInfo.playerName)
      self.im.Publish("bnd_Inplayer_number", InplayerInfo.jerseyNumber.."")
      self.im.Publish("bnd_Outplayer_number", OutplayerInfo.jerseyNumber.."")
      if teamside == 0 then
        self.im.Publish("bnd_home_crest_show", true)
        self.im.Publish("bnd_away_crest_show", false)
      else
        self.im.Publish("bnd_away_crest_show", true)
        self.im.Publish("bnd_home_crest_show", false)
      end
      self.im.Publish(bndData, substitutions)
    end
  elseif hideshow == "UPDATE" then
    self.im.Publish(bndAlpha, params[1] / 100)
    if params and table.getn(params) > 1 then
      self.im.Publish(bndVisible, true)
      local subTeamId = params[2] + 0
      local teamside = 0
      if subTeamId == self.TeamsData[1].assetId then
        teamside = 0
      else
        teamside = 1
      end
      local substitutions = {
        teamName = params[3],
        inPlayer = params[4],
        outPlayer = params[5]
      }
      local InplayerInfo = self:getPlayerInfo(teamside, subTeamId, substitutions.inPlayer)
      local OutplayerInfo = self:getPlayerInfo(teamside, subTeamId, substitutions.outPlayer)
      InplayerAvatar.id = InplayerInfo.assetId
      OutplayerAvatar.id = OutplayerInfo.assetId
      self.im.Publish("bnd_Inplayer_avatar", InplayerAvatar)
      self.im.Publish("bnd_Outplayer_avatar", OutplayerAvatar)
      self.im.Publish("bnd_Inplayer_name", InplayerInfo.playerName)
      self.im.Publish("bnd_Outplayer_name", OutplayerInfo.playerName)
      self.im.Publish("bnd_Inplayer_number", InplayerInfo.jerseyNumber.."")
      self.im.Publish("bnd_Outplayer_number", OutplayerInfo.jerseyNumber.."")
      if teamside == 0 then
        self.im.Publish("bnd_home_crest_show", true)
        self.im.Publish("bnd_away_crest_show", false)
      else
        self.im.Publish("bnd_away_crest_show", true)
        self.im.Publish("bnd_home_crest_show", false)
      end
      self.im.Publish(bndData, substitutions)
    end
  else
    self.im.Publish(bndVisible, false)
    self.im.Publish("bnd_home_crest_show", false)
    self.im.Publish("bnd_away_crest_show", false)
  end
end

function ScoreboardSubstitutions:getPlayerInfo(teamSide, teamID, playername)
  local playerInfo = {
    assetId = 0,
    jerseyNumber = 0,
    playerName = playername
  }
  local teamlineupData
  if teamSide == 0 then
    teamlineupData = homeTeamlineupData
  else 
    teamlineupData = awayTeamlineupData
  end
  
  if string.find(playername, "-") then
    playerInfo.playerName = string.gsub(playername, "%-", " ")
  end
  
  for _FORV_6_ = 1, table.getn(teamlineupData) do
    if string.find(playername, teamlineupData[_FORV_6_].playerName, 1, true) then
      playerInfo.assetId = teamlineupData[_FORV_6_].CARD_ID
      -- playerInfo.level = teamlineupData[_FORV_6_].rating
      playerInfo.jerseyNumber = teamlineupData[_FORV_6_].jerseyNumber
      playerInfo.playerName = teamlineupData[_FORV_6_].playerName
    end
  end
  return playerInfo
end

function ScoreboardSubstitutions:finalize()
  print("ScoreboardSubstitutions:finalize")
  self.services.eventManService.UnregisterHandler(self.handlerId)
  self.im.Unsubscribe(bndVisible)
  self.im.Unsubscribe(bndAlpha)
  self.im.Unsubscribe(bndData)
  self.im.Unsubscribe(bndNationalization)
  self.im.Unsubscribe("bnd_Inplayer_avatar")
  self.im.Unsubscribe("bnd_Inplayer_name")
  self.im.Unsubscribe("bnd_Inplayer_number")
  self.im.Unsubscribe("bnd_Outplayer_avatar")
  self.im.Unsubscribe("bnd_Outplayer_name")
  self.im.Unsubscribe("bnd_Outplayer_number")
  self.im.Unsubscribe("bnd_home_crest_show")
  self.im.Unsubscribe("bnd_away_crest_show")
  self.im.Unsubscribe("bnd_home_crest")
  self.im.Unsubscribe("bnd_away_crest")
end
return ScoreboardSubstitutions
