-- REMOD BY LAOSIJI --
local TableUtil, FormationModel, OverlaysIdContainer, OverlayParam, eventmanager = ...
local Starting11 = {}
local OVERLAY_TYPES = OverlaysIdContainer.Overlays.OVERLAY_TYPE
local EventTypes = eventmanager.FE.FIFA.EventTypes
function Starting11:new(init)
  print("[Starting11]: new()")
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    TacticsService = o.api("TacticsService"),
    SquadManagementService = o.api("SquadMgtService"),
    eventManService = o.api("EventManagerService"),
    MatchInfoService = o.api("MatchInfoService")
  }
  o.handlerId = o.services.eventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end
  )
  o.gamemode = o.data.gamemode or "real"
  o.flow = o.data.flow or "offline"
  o.playerLineup = nil
  o.isActive = false
  o.isVisible = false
  o.models = {
    FormationModel = FormationModel:new({
      im = o.im,
      api = o.api,
      nav = o.nav,
      loc = o.loc,
      gamemode = o.gamemode
    })
  }
  o.bndList = {
    bnd_player1_name = "",
    bnd_player2_name = "",
    bnd_player3_name = "",
    bnd_player4_name = "",
    bnd_player5_name = "",
    bnd_player6_name = "",
    bnd_player7_name = "",
    bnd_player8_name = "",
    bnd_player9_name = "",
    bnd_player10_name = "",
    bnd_player11_name = "",
    bnd_player12_name = "",
    bnd_player13_name = "",
    bnd_player14_name = "",
    bnd_player15_name = "",
    bnd_player16_name = "",
    bnd_player17_name = "",
    bnd_player18_name = "",
    bnd_player1_number = "",
    bnd_player2_number = "",
    bnd_player3_number = "",
    bnd_player4_number = "",
    bnd_player5_number = "",
    bnd_player6_number = "",
    bnd_player7_number = "",
    bnd_player8_number = "",
    bnd_player9_number = "",
    bnd_player10_number = "",
    bnd_player11_number = "",
    bnd_player12_number = "",
    bnd_player13_number = "",
    bnd_player14_number = "",
    bnd_player15_number = "",
    bnd_player16_number = "",
    bnd_player17_number = "",
    bnd_player18_number = "",
    bnd_player1_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player2_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player3_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player4_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player5_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player6_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player7_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player8_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player9_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player10_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player11_avatar = {
      name = "$Head",
      id = 0
    },
    bnd_player1_bottom = 0,
    bnd_player2_bottom = 0,
    bnd_player3_bottom = 0,
    bnd_player4_bottom = 0,
    bnd_player5_bottom = 0,
    bnd_player6_bottom = 0,
    bnd_player7_bottom = 0,
    bnd_player8_bottom = 0,
    bnd_player9_bottom = 0,
    bnd_player10_bottom = 0,
    bnd_player11_bottom = 0,
    bnd_player1_left= 0,
    bnd_player2_left= 0,
    bnd_player3_left= 0,
    bnd_player4_left= 0,
    bnd_player5_left= 0,
    bnd_player6_left= 0,
    bnd_player7_left= 0,
    bnd_player8_left= 0,
    bnd_player9_left= 0,
    bnd_player10_left= 0,
    bnd_player11_left= 0
  }

  o.TeamsData = o.services.MatchInfoService.GetMatchTeams()


  o.crest = {
    name = "$Crest",
    id = 0
  }
  o.crest2 = {
    name = "$Crest9",
    id = 0
  }
  o.formationName = ""

  o.teamName = ""

  o.im.Subscribe("bnd_active", function()
    o:_publishActivity()
  end
  )
  o.im.Subscribe("bnd_visible", function()
    o:_publishActivity()
  end
  )
  o.im.Subscribe("bnd_team_crest", function()
    o:_publishTeamCrest()
  end
  )
  o.im.Subscribe("bnd_team_crest2", function()
    o:_publishTeamCrest2()
  end
  )
  o.im.Subscribe("bnd_team_name", function()
    o:_publishTeamName()
  end
  )
  o.im.Subscribe("bnd_team_formation", function()
    o:_publishTeamFormation()
  end
  )
  for k,v in pairs(o.bndList) do
    o.im.Subscribe(k, function()
    end)
  end
  return o
end

function Starting11:handleEvent(eventType, data)
  if eventType == EventTypes.OverlayTypeIntroSequenceTeamList then
    self:updatePlayerLineup(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
end

function Starting11:updatePlayerLineup(subtype, hideshow, subtypestr, msg)
  print("[Starting11]: updatePlayerLineup(subtype = " .. tostring(subtype) .. ", hideshow = " .. tostring(hideshow) .. ", subtypestr = " .. tostring(subtypestr) .. ", msg = " .. tostring(msg) .. ")")
  if hideshow ~= "HIDE" then
    self.isActive = true
    self.isVisible = true
    local params = OverlayParam.split(msg, "|")
    if params and table.getn(params) > 0 then
      local teamSide = tonumber(params[5])
      local teamID = tonumber(params[3])
      if teamSide == 0 then
        self.crest.id = self.TeamsData[1].assetId
      else
        self.crest.id = self.TeamsData[2].assetId
      end
      if teamSide == 0 then
        self.crest2.id = self.TeamsData[1].assetId
      else
        self.crest2.id = self.TeamsData[2].assetId
      end
      self.teamName = params[2]
      local lineup = self.services.SquadManagementService.GetCurrentPlayerLineup(teamSide, teamID, 0)
      local formationID = self.services.TacticsService.GetFormation(teamSide, teamID)
      if self.gamemode == "fut" then
        formationID = self.services.SquadManagementService.GetFUTRelativeSquadFormation(formationID)
      end
      local formation = self.models.FormationModel:getFormationInfoByID(formationID)
      local formationCoords = formation.coords
      local formationName = formation.name
      local formationPosition = formation.positions
      self.formationName = formationName
      self.playerLineup = {
        players = {},
        teamID = params[1],
        teamName = params[2],
        formationName = formationName,
        starting11Label = (""),
        subsLabel = ("")
      }
      do
        do
          for _FORV_16_ = 1, table.getn(lineup) do
            self.playerLineup.players[_FORV_16_] = {}
            self.playerLineup.players[_FORV_16_].assetId = lineup[_FORV_16_].CARD_ID
            self.playerLineup.players[_FORV_16_].name = lineup[_FORV_16_].playerName
            self.playerLineup.players[_FORV_16_].number = lineup[_FORV_16_].jerseyNumber
            self.playerLineup.players[_FORV_16_].hasYellowCard = false
            if _FORV_16_ <= 11 then
              self.playerLineup.players[_FORV_16_].coords = formationCoords[_FORV_16_]
              self.playerLineup.players[_FORV_16_].jerseyColor = "0x00FF00"
              if formationPosition[_FORV_16_] then
                self.playerLineup.players[_FORV_16_].position = {
                  xPos = 0,
                  yPos = 0
                }
                self.playerLineup.players[_FORV_16_].position.xPos = formationPosition[_FORV_16_].xPos
                self.playerLineup.players[_FORV_16_].position.yPos = formationPosition[_FORV_16_].yPos
              end
            end
          end
        end
      end
      self:_publishPlayerLineup()
      self:_publishTeamCrest()
      self:_publishTeamCrest2()
      self:_publishTeamName()
      self:_publishTeamFormation()
      
    end
  else
    self.isActive = false
    self.isVisible = false
  end
  self:_publishActivity()
end

function Starting11:_publishActivity()
  self.im.Publish("bnd_active", self.isActive)
  self.im.Publish("bnd_visible", self.isVisible)
end

function Starting11:_publishTeamCrest()
  self.im.Publish("bnd_team_crest", self.crest)
end

function Starting11:_publishTeamCrest2()
  self.im.Publish("bnd_team_crest2", self.crest2)
end

function Starting11:_publishTeamName()
  self.im.Publish("bnd_team_name", self.teamName)
end

function Starting11:_publishTeamFormation()
  self.im.Publish("bnd_team_formation", self.formationName)
end

function Starting11:_publishPlayerLineup()
  if self.playerLineup == nil then
    return
  end
  for index = 1, table.getn(self.playerLineup.players) do
    local bindingPlayer = "bnd_player"..index
    local playerAvatar = {
      name = "$Head",
      id = 0
    }
    playerAvatar.id = self.playerLineup.players[index].assetId
    local formatName = self.playerLineup.players[index].name.." "
    self.im.Publish(bindingPlayer.."_name", formatName)
    self.im.Publish(bindingPlayer.."_number", self.playerLineup.players[index].number)
    if index <= 11 then
      self.im.Publish(bindingPlayer.."_avatar", playerAvatar)
      self.im.Publish(bindingPlayer.."_left", self.playerLineup.players[index].position.xPos)
      self.im.Publish(bindingPlayer.."_bottom", self.playerLineup.players[index].position.yPos)
    end
  end
end

function Starting11:finalize()
  print("[Starting11]: finalize()")
  self.models.FormationModel:finalize()
  self.im.Unsubscribe("bnd_active")
  self.im.Unsubscribe("bnd_visible")
  self.im.Unsubscribe("bnd_team_crest")
  self.im.Unsubscribe("bnd_team_crest2")
  self.im.Unsubscribe("bnd_team_name")
  self.im.Unsubscribe("bnd_team_formation")
  for k,v in pairs(self.bndList) do
    self.im.Unsubscribe(k)
  end
  self.services.eventManService.UnregisterHandler(self.handlerId)
end

return Starting11
