-- REMOD BY LAOSIJI --
print("Substitution.lua")
local Substitution = {}
--local bndNationalization = "bnd_nationalization"
local bndSubstitutionList = "bnd_subs_info"
local bndVisible = "bnd_visible"
local OverlaysIdContainer, OverlayParam, eventmanager = ...
local Overlays = OverlaysIdContainer.Overlays.OVERLAY_TYPE
local EventTypes = eventmanager.FE.FIFA.EventTypes



function Substitution:new(init)
  print("Substitution new ")
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.nationalization = 2
  o.services = {
    eventManService = o.api("EventManagerService")
  }
  
  o.bndList = {
  bnd_sub_crest = {
    name = "$Crest",
    id = 0
  },
  bnd_subin1_visible = false,
  bnd_subin2_visible = false,
  bnd_subin3_visible = false,
  bnd_subout1_visible = false,
  bnd_subout2_visible = false,
  bnd_subout3_visible = false,

  bnd_subin_num1 = "",
  bnd_subin_text1 = "",
  bnd_subin_num2 = "",
  bnd_subin_text2 = "",
  bnd_subin_num3 = "",
  bnd_subin_text3 = "",

  bnd_subout_num1 = "",
  bnd_subout_text1 = "",
  bnd_subout_num2 = "",
  bnd_subout_text2 = "",
  bnd_subout_num3 = "",
  bnd_subout_text3 = ""
}
  o.handlerId = o.services.eventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end
  )
  
  o.im.Subscribe(bndVisible, function()
    o.im.Publish(bndVisible, false)
  end
  )
  

  for k,v in pairs(o.bndList) do
    o.im.Subscribe(k, function()
     -- o.im.Publish(k, v)
    end)
  end
  return o
end

function Substitution:handleEvent(eventType, data)
  if eventType == EventTypes.OverlayTypeSubstitutionOut then
    self:updateSubstitution(data.subtype, data.hideshow, data.subtypestr, data.msg)
  end
end

function Substitution:updateSubstitution(subtype, hideshow, subtypestr, msg)
  print("updateSubstitution " .. msg)
  if hideshow ~= "HIDE" then
    local params = OverlayParam.split(msg, "|")
    if params and table.getn(params) > 0 then
      self.im.Publish(bndVisible, true)
     -- self.im.Publish("bnd_subin1_visible", true)
      -- self.im.Publish("bnd_subin_text1", params[4])
       self.bndList.bnd_sub_crest.id = params[1]
      self.im.Publish("bnd_sub_crest", self.bndList.bnd_sub_crest)
     -- self.im.Publish(bndNationalization, self.nationalization)
      TeamId = params[1] + 0
      
      local substitutionsInfo = {
        NumberofSubs = params[3] + 0,
        SubIn1Text = params[4],
        SubIn1NumText = params[5],
        SubIn2Text = params[6],
        SubIn2NumText = params[7],
        SubIn3Text = params[8],
        SubIn3NumText = params[9],
        SubOut1Text = params[11],
        SubOut1NumText = params[12],
        SubOut2Text = params[13],
        SubOut2NumText = params[14],
        SubOut3Text = params[15],
        SubOut3NumText = params[16],
        overlayTitle = ("换人"),
        TeamId = params[1] + 0
      }
      
      --bndList.bnd_sub_crest.id = TeamId and TeamId or 0
     -- self.im.Publish("bnd_sub_crest", bndList.bnd_sub_crest)
      
      if substitutionsInfo.SubIn2NumText == "-1" then
        self.im.Publish("bnd_subin1_visible", true)
        self.im.Publish("bnd_subin2_visible", false)
        self.im.Publish("bnd_subin3_visible", false)
      elseif substitutionsInfo.SubIn3NumText == "-1" then
        self.im.Publish("bnd_subin2_visible", true)
        self.im.Publish("bnd_subin1_visible", false)
        self.im.Publish("bnd_subin3_visible", false)
      elseif substitutionsInfo.SubIn3NumText ~= "-1" then
        self.im.Publish("bnd_subin3_visible", true)
        self.im.Publish("bnd_subin1_visible", false)
        self.im.Publish("bnd_subin2_visible", false)
       else
         self.im.Publish("bnd_subin3_visible", true)
        self.im.Publish("bnd_subin1_visible", false)
        self.im.Publish("bnd_subin2_visible", false)
      end
      if substitutionsInfo.SubOut2NumText == "-1" then
        self.im.Publish("bnd_subout1_visible", true)
        self.im.Publish("bnd_subout2_visible", false)
       self.im.Publish("bnd_subout3_visible", false)
      elseif substitutionsInfo.SubOut3NumText == "-1" then
        self.im.Publish("bnd_subout2_visible", true)
       self.im.Publish("bnd_subout1_visible", false)
       self.im.Publish("bnd_subout3_visible", false)
      elseif substitutionsInfo.SubOut3NumText ~= "-1" then
        self.im.Publish("bnd_subout3_visible", true)
      self.im.Publish("bnd_subout1_visible", false)
       self.im.Publish("bnd_subout2_visible", false)
       else
         self.im.Publish("bnd_subout3_visible", true)
      self.im.Publish("bnd_subout1_visible", false)
       self.im.Publish("bnd_subout2_visible", false)
      end
      self.im.Publish("bnd_subin_num1", substitutionsInfo.SubIn1NumText)
      self.im.Publish("bnd_subin_text1", substitutionsInfo.SubIn1Text)
      self.im.Publish("bnd_subin_num2", substitutionsInfo.SubIn2NumText)
      self.im.Publish("bnd_subin_text2", substitutionsInfo.SubIn2Text)
      self.im.Publish("bnd_subin_num3", substitutionsInfo.SubIn3NumText)
      self.im.Publish("bnd_subin_text3", substitutionsInfo.SubIn3Text)

      self.im.Publish("bnd_subout_num1", substitutionsInfo.SubOut1NumText)
      self.im.Publish("bnd_subout_text1", substitutionsInfo.SubOut1Text)
      self.im.Publish("bnd_subout_num2", substitutionsInfo.SubOut2NumText)
      self.im.Publish("bnd_subout_text2", substitutionsInfo.SubOut2Text)
      self.im.Publish("bnd_subout_num3", substitutionsInfo.SubOut3NumText)
      self.im.Publish("bnd_subout_text3", substitutionsInfo.SubOut3Text)
      --self.im.Publish(bndSubstitutionList, substitutionsInfo)
    end
  else
    self.im.Publish(bndVisible, false)
    self.im.Publish("bnd_subin1_visible", false)
    self.im.Publish("bnd_subin2_visible", false)
    self.im.Publish("bnd_subin3_visible", false)
    self.im.Publish("bnd_subout1_visible", false)
    self.im.Publish("bnd_subout2_visible", false)
    self.im.Publish("bnd_subout3_visible", false)
  end
end

function Substitution:finalize()
  self.services.eventManService.UnregisterHandler(self.handlerId)
 -- self.im.Unsubscribe(bndNationalization)
  self.im.Unsubscribe(bndVisible)
  --self.im.Unsubscribe(bndSubstitutionList)
  for k,v in pairs(self.bndList) do
    self.im.Unsubscribe(k)
  end
end

return Substitution
