local TableUtil, CommonNavVars = ...
local MatchHighlights = {}
local BND_BREAD_CRUMB = "bnd_bread_crumb"
local BND_MATCH_HIGHLIGHTS_LIST = "bnd_match_highlights_list"
local BND_MATCH_HIGHLIGHTS_VISIBLE = "bnd_match_highlights_visible"
local ACT_ENCODE_VIDEOS = "act_encode_videos"
local ACT_ROW_CLICK = "act_row_click"
local ACT_CHECKBOX_CLICK = "act_checkbox_click"
function MatchHighlights:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    ReplayService = o.api("ReplayService")
  }
  o.matchHighlightsList = {}
  local flow = o.data.flow
  local MatchInfoService = o.api("MatchInfoService")
  local teams = MatchInfoService.GetMatchTeams()
  o.teamNames = {}
  o.teamNames[0] = teams[1].teamName
  o.teamNames[1] = teams[2].teamName
  o.im.Subscribe(BND_BREAD_CRUMB, function()
    o:_populateBreadCrumb()
  end)
  o.im.Subscribe(BND_MATCH_HIGHLIGHTS_LIST, function()
    o:_populateHighlightsList()
  end)
  o.im.Subscribe(BND_MATCH_HIGHLIGHTS_VISIBLE, function()
    o.im.Publish(BND_MATCH_HIGHLIGHTS_VISIBLE, true)
  end)
  o.im.RegisterAction(ACT_ROW_CLICK, function(actionName, data)
    local highlightid = o.matchHighlightsList[data.id + 1].data.highlightid
    o.services.ReplayService.PlayHighlights(highlightid)
    o.nav.Event(nil, "evt_hide_highlights")
  end)
  o.im.RegisterAction(ACT_ENCODE_VIDEOS, function(actionName, data)
    o.nav.Event(nil, "evt_show_highlights_encode", "encode")
  end)
  o.im.RegisterAction(ACT_CHECKBOX_CLICK, function(actionName, data)
    local item = o.matchHighlightsList[data.id + 1].data
    local isTagged = not item.tagged
    item.tagged = isTagged
    o.services.ReplayService.TagHighlights(item.highlightid, isTagged)
    o:publishHighlightsList(data.id)
  end)
  o.nav.AddActionHandler("hideMatchHighlights", false, nil, function(action, gamemode)
    o.im.Publish(BND_MATCH_HIGHLIGHTS_VISIBLE, false)
  end)
  o.nav.AddActionHandler("showMatchHighlights", false, nil, function(action, gamemode)
    o.im.Publish(BND_MATCH_HIGHLIGHTS_VISIBLE, true)
  end)
  return o
end
function MatchHighlights:_setCaptureState(forceDisable)
  local hasTagged = false
  for i = 1, table.getn(self.matchHighlightsList) do
    if self.matchHighlightsList[i].data.tagged == true then
      hasTagged = true
      break
    end
  end
  if hasTagged and not forceDisable then
    self.im.ChangeActionState(ACT_ENCODE_VIDEOS, self.im.GetActionState("VALID"))
  else
    self.im.ChangeActionState(ACT_ENCODE_VIDEOS, self.im.GetActionState("INVALID"))
  end
end
function MatchHighlights:_populateBreadCrumb()
  local breadcrumb = {
    alignement = "CENTER",
    current = 0,
    labels = {
      self.loc.LocalizeString("LTXT_HIGHLIGHTS_SELECT_HIGHLIGHTS"),
      self.loc.LocalizeString("LTXT_HIGHLIGHTS_CREATE_VIDEOS"),
      self.loc.LocalizeString("LTXT_HIGHLIGHTS_SHARE_WITH_FRIENDS")
    }
  }
  self.im.Publish(BND_BREAD_CRUMB, breadcrumb)
end
function MatchHighlights:_populateHighlightsList()
  local highlights = self.services.ReplayService.GetHighlightsList()
  for i, highlight in ipairs(highlights) do
    local teamName = self.teamNames[highlight.side]
    local label = string.format("%s %s - %s (%s)", highlight.time, highlight.event, highlight.player, teamName)
    table.insert(self.matchHighlightsList, i, {
      data = {
        highlightid = highlight.id,
        label = label,
        tagged = highlight.isTagged,
        clickAction = ACT_ROW_CLICK
      }
    })
  end
  self:publishHighlightsList()
end
function MatchHighlights:publishHighlightsList(dirtyId)
  local dirties = {}
  if dirtyId ~= nil then
    table.insert(dirties, dirtyId)
  end
  self.im.Publish(BND_MATCH_HIGHLIGHTS_LIST, {
    data = self.matchHighlightsList,
    dirty = dirties
  })
  self:_setCaptureState()
end
function MatchHighlights:finalize()
  self.im.Unsubscribe(BND_BREAD_CRUMB)
  self.im.Unsubscribe(BND_MATCH_HIGHLIGHTS_LIST)
  self.im.Unsubscribe(BND_MATCH_HIGHLIGHTS_VISIBLE)
  self.im.UnregisterAction(ACT_ENCODE_VIDEOS)
  self.im.UnregisterAction(ACT_ROW_CLICK)
  self.im.UnregisterAction(ACT_CHECKBOX_CLICK)
  self.nav.RemoveActionHandler("hideMatchHighlights")
  self.nav.RemoveActionHandler("showMatchHighlights")
end
return MatchHighlights
