-- Thanks : Ma'ruf Id & Laosiji --
-- talamlegit.official - Patch Mod EAFC24 --

local ClassicMatch = {}

local bndMatchList = "bnd_match_list"

local ACT_MATCH_PLAY = "act_match_play"
currentMode = 1

local ClassicMatchList = {
  { HomeTeamID = 241, AwayTeamID = 243, StadiumID1 = 6, StadiumID2 = 2, data = {} },
  { HomeTeamID = 461, AwayTeamID = 481, StadiumID1 = 10, StadiumID2 = 35, data = {} },
  { HomeTeamID = 240, AwayTeamID = 449, data = {}, StadiumID1 = 183, StadiumID2 = 211 },
  { HomeTeamID = 11, AwayTeamID = 10, data = {}, StadiumID1 = 1, StadiumID2 = 246 },
  { HomeTeamID = 9, AwayTeamID = 5, data = {}, StadiumID1 = 13, StadiumID2 = 28 },
  { HomeTeamID = 19, AwayTeamID = 1925, data = {}, StadiumID1 = 32, StadiumID2 = 41 },
  { HomeTeamID = 95, AwayTeamID = 39, data = {}, StadiumID1 = 115, StadiumID2 = 113 },
  { HomeTeamID = 1, AwayTeamID = 18, data = {}, StadiumID1 = 156, StadiumID2 = 116 },
  { HomeTeamID = 144, AwayTeamID = 1799, data = {}, StadiumID1 = 174, StadiumID2 = 177 },
  { HomeTeamID = 13, AwayTeamID = 1943, data = {}, StadiumID1 = 179, StadiumID2 = 182 },
  { HomeTeamID = 1808, AwayTeamID = 2, data = {}, StadiumID1 = 212, StadiumID2 = 225 },
  { HomeTeamID = 8, AwayTeamID = 7, data = {}, StadiumID1 = 228, StadiumID2 = 265 },
  { HomeTeamID = 1792, AwayTeamID = 14, data = {}, StadiumID1 = 276, StadiumID2 = 325 },
  { HomeTeamID = 110, AwayTeamID = 17, data = {}, StadiumID1 = 326, StadiumID2 = 330 },
  { HomeTeamID = 1796, AwayTeamID = 1794, data = {}, StadiumID1 = 329, StadiumID2 = 333 },
  { HomeTeamID = 48, AwayTeamID = 45, data = {}, StadiumID1 = 4, StadiumID2 = 247 },
  { HomeTeamID = 47, AwayTeamID = 44, data = {}, StadiumID1 = 5, StadiumID2 = 178 },
  { HomeTeamID = 155603, AwayTeamID = 155602, data = {}, StadiumID1 = 100, StadiumID2 = 29 },
  { HomeTeamID = 66, AwayTeamID = 73, data = {}, StadiumID1 = 261, StadiumID2 = 14 },
  { HomeTeamID = 69, AwayTeamID = 32, data = {}, StadiumID1 = 26, StadiumID2 = 42 },
  { HomeTeamID = 34, AwayTeamID = 1831, data = {}, StadiumID1 = 332, StadiumID2 = 331 },
  { HomeTeamID = 219, AwayTeamID = 166, data = {}, StadiumID1 = 181, StadiumID2 = 149 },
  { HomeTeamID = 607, AwayTeamID = 605, data = {}, StadiumID1 = 30, StadiumID2 = 262 },
  { HomeTeamID = 112139, AwayTeamID = 111674, data = {}, StadiumID1 = 196, StadiumID2 = 262 },
  { HomeTeamID = 22, AwayTeamID = 21, data = {}, StadiumID1 = 9, StadiumID2 = 137 },
  { HomeTeamID = 112893, AwayTeamID = 112885, data = {}, StadiumID1 = 197, StadiumID2 = 194 },
  { HomeTeamID = 234, AwayTeamID = 236, data = {}, StadiumID1 = 34, StadiumID2 = 172 },
  { HomeTeamID = 111510, AwayTeamID = 111518, data = {}, StadiumID1 = 29, StadiumID2 = 135 },
  { HomeTeamID = 1386, AwayTeamID = 1413, data = {}, StadiumID1 = 104, StadiumID2 = 147 },
  { HomeTeamID = 1318, AwayTeamID = 1365, data = {}, StadiumID1 = 155, StadiumID2 = 153 },
  { HomeTeamID = 1370, AwayTeamID = 1369, data = {}, StadiumID1 = 158, StadiumID2 = 264 },
  { HomeTeamID = 1415, AwayTeamID = 111527, data = {}, StadiumID1 = 192, StadiumID2 = 229 }
}

currentMatch = {
   HomeTeamID = 0,
   AwayTeamID = 0,
   Side = 0, -- 0 home 1 away
   HomeKitIndex = 0,
   AwayKitIndex = 1,
   StadiumID1 = 0,
   StadiumID2 = 0
}

function ClassicMatch:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    SquadManagementService = o.api("SquadMgtService")
  }

o.playerbg = {
    name = "$_FC_PLAYER",
    id = 0
  }
  math.randomseed(os.clock() * 1357 + os.time())
  local currentTime = os.date("%H") + 0
  local random2 = math.random(6)
  o.im.Subscribe("bnd_main_bg", function()
    if currentTime < 12 and currentTime >= 6 then
        o.mainbg.id = 1
    elseif currentTime >= 12 and currentTime < 18 then
        o.mainbg.id = 2
    elseif currentTime >= 18 or currentTime < 6 then
        o.mainbg.id = 3
    end
    o.im.Publish("bnd_main_bg", o.mainbg)
  end)
  o.im.Subscribe("bnd_player_bg", function()
    o.playerbg.id = random2
    o.im.Publish("bnd_player_bg", o.playerbg)
  end)
  
  o.im.Subscribe(bndMatchList, function()
    o:publishMatchRows()
  end)

  o.im.RegisterAction(ACT_MATCH_PLAY, function(actionName, data)
   if data then
     o:PlayMatch(data)
    end
  end)
  
  return o
end


function ClassicMatch:publishMatchRows()
  for i, v in ipairs(ClassicMatchList) do
    v.data.HomeTeamCrest = {
      name = "$Crest",
      id = ClassicMatchList[i].HomeTeamID
    }
    v.data.AwayTeamCrest = {
      name = "$Crest",
      id = ClassicMatchList[i].AwayTeamID
    }
    v.data.HomeTeamName = self.loc.LocalizeString("TeamName_Abbr15_"..ClassicMatchList[i].HomeTeamID)
    v.data.AwayTeamName = self.loc.LocalizeString("TeamName_Abbr15_"..ClassicMatchList[i].AwayTeamID)
    v.data.HomeTeamShortName = self.loc.LocalizeString("TeamName_Abbr3_"..ClassicMatchList[i].HomeTeamID)
    v.data.AwayTeamShortName = self.loc.LocalizeString("TeamName_Abbr3_"..ClassicMatchList[i].AwayTeamID)
    v.data.clickAction = "act_match_play"
  end
  self.im.Publish(bndMatchList, ClassicMatchList)
end

function ClassicMatch:PlayMatch(data)
  local currentMatchIndex = data.id + 1
  currentMatch.HomeTeamID = ClassicMatchList[currentMatchIndex].HomeTeamID
  currentMatch.AwayTeamID = ClassicMatchList[currentMatchIndex].AwayTeamID
  
  currentMatch.StadiumID1 = ClassicMatchList[currentMatchIndex].StadiumID1
  currentMatch.StadiumID2 = ClassicMatchList[currentMatchIndex].StadiumID2
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "Cancel",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "Confirm",
    clickEvents = {
      "evt_match_play",
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = "INFO",
    message = "Are you ready to start the game?",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end


function ClassicMatch:finalize()
  self.im.Unsubscribe(bndMatchList)
  self.im.UnregisterAction(ACT_MATCH_PLAY)
end

return ClassicMatch
