
local Liga = {}
local bndMatchList = "bnd_match_list"
local ACT_ADVANCE = "act_advance"
local ACT_RESTART = "act_restart"

ligaId = 4

currentMatch = {
  HomeTeamID = 0,
  AwayTeamID = 0,
  HomeKitIndex = 0,
  AwayKitIndex = 1
}

local rivalListData = {}

function Liga:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    settingsService = o.api("SettingsService")
    
  }

  o.currentOptions = o.services.settingsService.GetCurrentOptions()
  o.Init()
   o.im.Subscribe(bndMatchList, function()
     o:publishMatchRows()
  end)
  
   o.im.Subscribe("bnd_match_label", function()
    o:publishMatchLabel()
  end)
  o.im.Subscribe("bnd_finish_label", function()
    o:publishMatchLabel2()
  end)
  o.im.Subscribe("bnd_finish_label1", function()
    o:publishMatchLabel3()
  end)
  
  o.im.RegisterAction("act_save", function(actionName)
    local buttonYes = {
      icon = "$FooterIconNo",
      label = "Ok",
      clickEvents = {
        "evt_hide_popup"
      }
    }
    local popupData = {
      title = "Save Success",
      message = "Save Hanya Tersimpan Jika Anda Tidak Keluar Game",
      buttons = {buttonYes}
    }
    o.nav.Event(nil, "evt_show_popup", popupData)
  end)
  
  o.im.RegisterAction(ACT_ADVANCE, function(actionName, data)
    if data then
      o:PlayMatch(data)
    end
  end)
  
  o.im.RegisterAction(ACT_RESTART, function(actionName)
    o:EndMatch()
  end)

  

  return o
end

function Liga:Init()
  local LigaGroupingList = LigaGrouping[ligaId]
  for i = 1, table.getn(LigaGroupingList) do
    local obj = {
      homeID = LigaGroupingList[i][1],
      awayID = LigaGroupingList[i][2],
      homeScore = LigaGroupingList[i][3],
      awayScore = LigaGroupingList[i][4],
      
      clickAction = "act_advance",
      isUnlock = LigaGroupingList[i][8],
      data = {}
    }
    table.insert(rivalListData, obj)
  end
end


function Liga:publishMatchRows()
  for i, v in ipairs(rivalListData) do
    v.data.HomeTeamCrest = {
      name = "$Crest",
      id = rivalListData[i].homeID
    }
    v.data.AwayTeamCrest = {
      name = "$Crest64x64",
      id = rivalListData[i].awayID
    }
    v.data.HomeTeamName = self.loc.LocalizeString("TeamName_Abbr15_"..rivalListData[i].homeID)
    v.data.AwayTeamName = self.loc.LocalizeString("TeamName_Abbr15_"..rivalListData[i].awayID)
    v.data.HomeTeamShortName = self.loc.LocalizeString("TeamName_Abbr3_"..rivalListData[i].homeID)
    v.data.clickAction = rivalListData[i].clickAction

    v.data.TeamScoreFontColor = "0x460240"
    v.data.TeamNameFontColor = "0x460240"
    v.data.FontColor = "0x460240"
    if not rivalListData[i].isUnlock then
      v.data.Icon = {
        name = "$IconMatchLock",
        id = 2
      }
      v.data.RightText = ""
    else
      v.data.Icon = {
        name = "$IconMatchBall",
        id = 3
      }
      v.data.RightText = ""
    end
  end
  self.im.Publish(bndMatchList, rivalListData)
end

function Liga:publishMatchLabel()
  
  if currentLigaInfo[ligaId].isSuccess == 1 then
    self.im.Publish("bnd_match_label", "You Must Win To Open Next Match")
  elseif currentLigaInfo[ligaId].isSuccess == 2 then
    self.im.Publish("bnd_match_label", "Congratulations")
  else
    self.im.Publish("bnd_match_label", "Bundesliga | Devision 1")
  end
end

function Liga:publishMatchLabel2()
  
  if currentLigaInfo[ligaId].isSuccess == 1 then
    self.im.Publish("bnd_finish_label", "FAILED, DO YOU REMATCH ?")
  elseif currentLigaInfo[ligaId].isSuccess == 2 then
    self.im.Publish("bnd_finish_label", "SUCCESFULLY")
  
  else
    self.im.Publish("bnd_finish_label", "WIN ALL MISSION MATCHES")
  end
end

function Liga:publishMatchLabel3()

  if currentLigaInfo[ligaId].isSuccess == 2 then
    self.im.Publish("bnd_finish_label1", "LEAGUE MODE COMPLETED")
  
  end
end


function Liga:PlayMatch(data)
  local currentMatchIndex = data.id + 1
  currentLigaData.Index = ligaId
  currentLigaData.round = currentMatchIndex
  local currentMatchData = LigaGrouping[ligaId][currentMatchIndex]

  local index = 0
  if currentMatchData[5] == false and currentMatchData[8] == true then
    index = 1
  elseif currentMatchData[5] == true and currentMatchData[8] == true then
    index = 2
  elseif currentMatchData[5] == true and currentMatchData[7] == false and currentMatchData[8] == true then
    index = 2
  end
  if index == 1 then
    currentLigaData.homeID = currentLigaInfo[ligaId].homeID
    currentLigaData.awayID = currentMatchData[2]
    currentLigaData.difficulty = currentMatchData[6]
    currentMatch.HomeTeamID = currentLigaData.homeID
    currentMatch.AwayTeamID = currentLigaData.awayID
    self.nav.Event(nil, "evt_advance")
  elseif index == 2 then
    currentLigaData.homeID = currentLigaInfo[ligaId].homeID
    currentLigaData.awayID = currentMatchData[2]
    currentLigaData.difficulty = currentMatchData[6]
    currentMatch.HomeTeamID = currentLigaData.homeID
    currentMatch.AwayTeamID = currentLigaData.awayID
    self:ReMatch()
  else
    self:StopMatch()
  end
end

function Liga:EndMatch()
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "Cancel",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "Confirm",
    clickEvents = {
      "evt_restart",
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = "INFO",
    message = "Do You Want To Change Team & End Progress ?",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end

function Liga:ReMatch()
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "Cancel",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "Confirm",
    clickEvents = {
      "evt_advance",
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = "INFO",
    message = "Do You Want To Rematch ?",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end

function Liga:StopMatch()
  local buttonYes = {
    icon = "$FooterIconNo",
    label = "Close",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = "Next Match",
    message = "Select the Green Icon to Start the Match",
    buttons = {buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end


function Liga:finalize()
  self.im.UnregisterAction(ACT_RESTART)
  self.im.UnregisterAction(ACT_ADVANCE)
  self.im.Unsubscribe("bnd_match_list")
  self.im.Unsubscribe("bnd_match_label")
  self.im.Unsubscribe("bnd_finish_label")
  self.im.Unsubscribe("bnd_finish_label1")
  rivalListData = {}
  
end

return Liga

-- Thanks : Ma'ruf Id & Laosiji --
-- @mvnprod.official - Remain Be Creative --
