-------------------------------------------
-- MOD By laosiji --
-------------------------------------------

local MenuMoreHub = {}

local BND_LIVE_TILE_CHALLENGE = "bnd_live_tile_challenge"
local BND_LIVE_TILE_SEASON = "bnd_live_tile_season"
local BND_LIVE_TILE_MATCHDAY = "bnd_live_tile_matchday"

function MenuMoreHub:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  
  o.im.RegisterAction("act_season", function(actionName)
    local buttonYes = {
      icon = "$FooterIconNo",
      label = "Close",
      clickEvents = {
        "evt_hide_popup"
      }
    }
    local popupData = {
      title = "INFO",
      message = "Don't worry, wait for the next update",
      buttons = {buttonYes}
    }
    o.nav.Event(nil, "evt_show_popup", popupData)
  end)


  
  local random1 = 1
  o.im.Subscribe(BND_LIVE_TILE_CHALLENGE, function()
    o:BND_LIVE_TILE_CHALLENGE()
  end)
  function MenuMoreHub:BND_LIVE_TILE_CHALLENGE()
    local dataToInsert =
    {
      headline = { "CHALLENGE MODE" },
      description = "Challenges from different teams",
      images = {
        {
          name = "$_Challenge",
          id = random1
        }
        
      }
    }
    self.im.Publish(BND_LIVE_TILE_CHALLENGE, dataToInsert)
  end

  local random2 = math.random(1,2)
  o.im.Subscribe(BND_LIVE_TILE_SEASON, function()
    o:BND_LIVE_TILE_SEASON()
  end)
  function MenuMoreHub:BND_LIVE_TILE_SEASON()
    local dataToInsert =
    {
      headline = { "SEASON MODE" },
      description = "Start a new season",
      images = {
        {
          name = "$_Season",
          id = random2
        }
      }
    }
    self.im.Publish(BND_LIVE_TILE_SEASON, dataToInsert)
  end

  local random3 = 0
  o.im.Subscribe(BND_LIVE_TILE_MATCHDAY, function()
    o:BND_LIVE_TILE_MATCHDAY()
  end)
  function MenuMoreHub:BND_LIVE_TILE_MATCHDAY()
    local dataToInsert =
    {
      headline = { "MATCH DAY" },
      description = "Experience daily real match",
      images = {
        {
          name = "$_MatchDay",
          id = random3
        }
      }
    }
    self.im.Publish(BND_LIVE_TILE_MATCHDAY, dataToInsert)
  end
  
  return o
end

return MenuMoreHub