-- Thanks : Ma'ruf Id & Laosiji --
-- talamlegit.official - Patch Mod EAFC24 --

local MatchDayList = ...
local MatchDay = {}

local bndMatchList = "bnd_match_list"

local ACT_MATCH_PLAY = "act_match_play"
currentMode = 6


local typeList = {
  {
    name = "Friendly Match",
    color = ""
  },
  { 
   -- Type 1
   name = "Piala Fa",
    color = "FF6AA1"
  },
  {
  -- Type 2
    name = "Premier League",
    color = "2eb2ec"
  },
  {
  -- Type 3
    name = "La Liga",
    color = "297a7e"
  },
  {
  -- Type 4
    name = "Bundesliga",
    color = "46474a"
  },
  {
  -- Type 5
    name = "Serie A",
    color = "2e4f86"
  },
  {
  -- Type 6
    name = "Ligue",
    color = "1b2b5a"
  },
  {
  -- Type 7
    name = "AFC Asian Cup",
    color = "31146B"
  }
}


currentMatch = {
   MatchIndex = 0,
   HomeTeamID = 0,
   AwayTeamID = 0,
   Side = 0, -- 0 home 1 away
   HomeKitIndex = 0,
   AwayKitIndex = 1,
   SquadId = 0
}

function MatchDay:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    SquadManagementService = o.api("SquadMgtService")
  }
o.playerbg = {
    name = "$_Trophies",
    id = 0
  }
  math.randomseed(os.clock() * 1357 + os.time())
  local currentTime = os.date("%H") + 0
  local random2 = math.random(18)
  o.im.Subscribe("bnd_main_bg", function()
    if currentTime < 12 and currentTime >= 6 then
        o.mainbg.id = 1
    elseif currentTime >= 12 and currentTime < 18 then
        o.mainbg.id = 2
    elseif currentTime >= 18 or currentTime < 6 then
        o.mainbg.id = 3
    end
    o.im.Publish("bnd_main_bg", o.mainbg)
  end)
  o.im.Subscribe("bnd_player_bg", function()
    o.playerbg.id = random2
    o.im.Publish("bnd_player_bg", o.playerbg)
  end)
  o.isEmpty = false
  -- o.currentDayMatchList = {}

  if #currentDayMatchList == 0 then
    o:filterDate()
  end

  o.im.Subscribe(bndMatchList, function()
    o:publishMatchRows()
  end)

  o.im.Subscribe("bnd_match_empty", function()
    o:publishEmpty()
  end)

  o.im.RegisterAction(ACT_MATCH_PLAY, function(actionName, data)
   if data then
     o:PlayMatch(data)
    end
  end)
  
  return o
end

function MatchDay:filterDate()
  local currentDate = os.date("%Y/%m/%d")
  for i = 1, #MatchDayList do
    if MatchDayList[i].Date == currentDate then
      table.insert(currentDayMatchList, MatchDayList[i])
    end
  end
  if #currentDayMatchList == 0 then
    self.isEmpty = true
  end
end

function MatchDay:publishEmpty()
  if #currentDayMatchList == 0 then
    self.isEmpty = true
  end
  self.im.Publish("bnd_match_empty", self.isEmpty)
end


function MatchDay:publishMatchRows()
  for i, v in ipairs(currentDayMatchList) do
    v.data.HomeTeamCrest = {
      name = "$Crest",
      id = currentDayMatchList[i].HomeTeamID
    }
    v.data.AwayTeamCrest = {
      name = "$Crest",
      id = currentDayMatchList[i].AwayTeamID
    }
    v.data.HomeTeamName = self.loc.LocalizeString("TeamName_Abbr3_"..currentDayMatchList[i].HomeTeamID)
    v.data.AwayTeamName = self.loc.LocalizeString("TeamName_Abbr3_"..currentDayMatchList[i].AwayTeamID)
    v.data.MatchScore = currentDayMatchList[i].score == "" and "0 - 0" or currentDayMatchList[i].score
    v.data.MatchTimeAndType = currentDayMatchList[i].Date.." | "..self:getNameByType(currentDayMatchList[i].type)
    v.data.clickAction = "act_match_play"
    v.data.MatchBackground = self:getBackgroundColorByType(currentDayMatchList[i].type)
  end
  self.currentDayMatchList = currentDayMatchList
  self.im.Publish(bndMatchList, self.currentDayMatchList)
end

function MatchDay:getBackgroundColorByType(type)
  local index = type + 1
  return typeList[index].color == "" and "0x00fc7f" or "0x"..typeList[index].color
end

function MatchDay:getNameByType(type)
  local index = type + 1
  return typeList[index].name
end

function MatchDay:PlayMatch(data)
  local currentMatchIndex = data.id + 1
  currentMatch.MatchIndex = currentMatchIndex
  currentMatch.HomeTeamID = currentDayMatchList[currentMatchIndex].HomeTeamID
  currentMatch.AwayTeamID = currentDayMatchList[currentMatchIndex].AwayTeamID
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "Cancel",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "Comfirm",
    clickEvents = {
      "evt_match_play",
      "evt_hide_popup"
    }
  }
  local popupData = {
    title = "INFO",
    message = "Are you ready to start the game?",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end


function MatchDay:finalize()
  self.im.Unsubscribe(bndMatchList)
  self.im.Unsubscribe("bnd_match_empty")
  self.im.UnregisterAction(ACT_MATCH_PLAY)
  self.currentDayMatchList = {}
end

return MatchDay
