-- Thanks : Ma'ruf Id & Laosiji --
-- talamlegit.official - Patch Mod EAFC24 --

local MatchSelect = {}

local eventmanager, PregameManager, CommonNavVars, TableUtil = ...
local EventTypes = eventmanager.FE.FIFA.EventTypes

local BND_LOGO_TEAM_HOME = "bnd_logo_tim_home1"
local BND_LOGO_TIM_HOME = "bnd_logo_tim_home"
local BND_LOGO_TEAM_AWAY = "bnd_logo_tim_away1"
local BND_LOGO_TIM_AWAY = "bnd_logo_tim_away"

local BND_MAN_TEAM_HOME = "bnd_man_team_home"
local BND_MAN_TEAM_AWAY = "bnd_man_team_away"

local BND_LIVE_TILE_SQUAD = "bnd_live_tile_squad"
local BND_LIVE_TILE_MOCKUP = "bnd_live_tile_mockup"

local BND_NAMA_TIM_HOME = "bnd_nama_tim_home"
local BND_NAMA_TIM_AWAY = "bnd_nama_tim_away"

local BND_NAMA_STADION = "bnd_nama_stadion"

local actSquad = "act_squad"
local actSquadAway = "act_squadaway"

local actSettings = "act_settings"
local ACT_PLAYMATCH = "act_playmatch"

function MatchSelect:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    matchSetup = o.api("MatchSetupService"),
    gameSetup = o.api("GameSetupService"),
    gameState = o.api("GameStateService"),
    preGame = o.api("PregameService"),
    MatchInfoService = o.api("MatchInfoService"),
    SettingsService = o.api("SettingsService"),
    EventManagerService = o.api("EventManagerService")
  }
  o.handlerId = o.services.EventManagerService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)

  o.TeamsData = o.services.MatchInfoService.GetMatchTeams()

  o.CurrentOptions = o.services.SettingsService.GetCurrentOptions()

  o.im.Subscribe(BND_LOGO_TEAM_HOME, function()
    o.im.Publish(BND_LOGO_TEAM_HOME, {
      name = "$Crest1",
      id = string.format("%d", o.services.gameSetup.GetHomeAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TIM_HOME, function()
    o.im.Publish(BND_LOGO_TIM_HOME, {
      name = "$Crest",
      id = string.format("%d", o.services.gameSetup.GetHomeAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TEAM_AWAY, function()
    o.im.Publish(BND_LOGO_TEAM_AWAY, {
      name = "$Crest1",
      id = string.format("%d", o.services.gameSetup.GetAwayAssetId())
    })
  end)
  o.im.Subscribe(BND_LOGO_TIM_AWAY, function()
    o.im.Publish(BND_LOGO_TIM_AWAY, {
      name = "$Crest",
      id = string.format("%d", o.services.gameSetup.GetAwayAssetId())
    })
  end)
  o.im.Subscribe(BND_NAMA_TIM_HOME, function()
    o.im.Publish(BND_NAMA_TIM_HOME, o.TeamsData[1].teamName)
  end)
  o.im.Subscribe(BND_NAMA_TIM_AWAY, function()
    o.im.Publish(BND_NAMA_TIM_AWAY, o.TeamsData[2].teamName)
  end)

  o.im.Subscribe(BND_NAMA_STADION, function()
    o.im.Publish(BND_NAMA_STADION, o.CurrentOptions.stadium)
  end)
  
  -- Mockup --
o.MenuMockup = {}
  table.insert(o.MenuMockup, {
    headline = { "" },
    description = "",
    images = { "$INFOmatchselect1" },
    autoScaleImageToTileHeight = { "true" },
    clickAction = ""
  })
  table.insert(o.MenuMockup, {
    headline = { "" },
    description = "",
    images = { "$INFOmatchselect2" },
    autoScaleImageToTileHeight = { "true" },
    clickAction = ""
  })
  table.insert(o.MenuMockup, {
    headline = { "" },
    description = "",
    images = { "$INFOmatchselect3" },
    autoScaleImageToTileHeight = { "true" },
    clickAction = ""
  })
  o.im.Subscribe(BND_LIVE_TILE_MOCKUP, function()
    o:_publishMenuMockup()
  end)
function MatchSelect:_publishMenuMockup()
  local dataToPublish = { index = 0, data = self.MenuMockup }
  self.im.Publish(BND_LIVE_TILE_MOCKUP, dataToPublish)
end

  -- Squad --
o.MenuSquad = {}
  table.insert(o.MenuSquad, {
    headline = { "" },
    description = "",
    images = { "$Pformations" },
    autoScaleImageToTileHeight = { "true" },
    clickAction = "act_squad"
  })
  table.insert(o.MenuSquad, {
    headline = { "" },
    description = "",
    images = { "$PformationsA" },
    autoScaleImageToTileHeight = { "true" },
    clickAction = "act_squadaway"
  })
  o.im.Subscribe(BND_LIVE_TILE_SQUAD, function()
    o:_publishMenuSquad()
  end)
function MatchSelect:_publishMenuSquad()
  local dataToPublish = { index = 0, data = self.MenuSquad }
  self.im.Publish(BND_LIVE_TILE_SQUAD, dataToPublish)
end
o.im.RegisterAction(actSettings, function(actionName, data)
    o.nav.Event(nil, "evt_to_settings")
  end)

o.im.RegisterAction(actSquad, function(actionName, data)
    o.nav.Event(nil, "evt_to_squad")
  end)
  o.im.RegisterAction(actSquadAway, function(actionName, data)
    o.nav.Event(nil, "evt_to_squadaway")
  end)

  o.im.RegisterAction(ACT_PLAYMATCH, function(actionName)
    o:PlayMatch()
  end)

  return o
end

-- Menu Play Match --
function MatchSelect:PlayMatch()
  local buttonNo = {
    icon = "$FooterIconNo",
    label = "LTXT_CMN_NO",
    clickEvents = {
      "evt_hide_popup"
    }
  }
  local buttonYes = {
    icon = "$FooterIconYes",
    label = "LTXT_CMN_YES",
    clickEvents = {
      "evt_playmatch",
      "evt_hide_popup"
    }
  }
  local popupData = {
    message = " ARE YOU READY TO PLAY THIS MATCH NOW ? *",
    buttons = {buttonNo, buttonYes}
  }
  self.nav.Event(nil, "evt_show_popup", popupData)
end

function MatchSelect:finalize()
  self.services.EventManagerService.UnregisterHandler(self.handlerId)
  
  self.im.Unsubscribe(BND_LOGO_TEAM_HOME)
  self.im.Unsubscribe(BND_LOGO_TEAM_AWAY)
  self.im.Unsubscribe(BND_MAN_TEAM_HOME)
  self.im.Unsubscribe(BND_MAN_TEAM_AWAY)
  self.im.UnregisterAction(actSettings)
  self.im.UnregisterAction(actSquad)
  self.im.UnregisterAction(actSquadAway)
end

return MatchSelect