-- REMOD BY YOUTUBE LAOSIJI --
local SettingsCustomizeModel = (...)
local TouchControls = {}
local TableUtil = (...)
local bndControlSchemeOptions = "bnd_control_scheme_options"
local bndFloatingDpadOptions = "bnd_floating_dpad_options"
local bndVButtonPositionOptions = "bnd_virtual_button_position_options"
local bndSkillMovesOptions = "bnd_skill_moves_options"
local BND_TOUCH_CONTROLS_LIST_DATA = "bnd_touch_controls_list_data"
local bndOptionsIndex = "bnd_option_index"
local bndRightSideLabel = "bnd_right_label"
local bndRightSideImage = "bnd_right_image"
local actChangeControlSchemeOption = "act_change_control_scheme_option"
local actChangeFloatingDpadOption = "act_change_floating_dpad_option"
local actChangeVButtonPositionOption = "act_change_virtual_button_position_option"
local actChangeSkillMovesOption = "act_change_skill_moves_option"
local actResetDefaults = "act_reset_all"
local OPTION_TOGGLE_SFX = "act_option_toggle"
local CONTROL_SCHEME_OPTION_INDEX = 1
local FLOATING_DPAD_OPTION_INDEX = 2
local VBUTTON_POSITION_OPTION_INDEX = 3
local SKILL_MOVES_OPTION_INDEX = 4
local controlSchemeIndex = 0
function TouchControls:new(init)
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.models = {
    SettingsCustomizeModel = SettingsCustomizeModel:new({
      im = o.im,
      api = o.api,
      nav = o.nav,
      loc = o.loc
    })
  }
  o.services = {
    FifaCustomizationService = o.api("FifaCustomizationService"),
    gameStateService = o.api("GameStateService")
  }
  o:initValues()
  o.im.RegisterDataAction("bnd_control_scheme_index", actChangeControlSchemeOption, function(bindingName, actionName, index)
    o.controlSchemeIndex = index
    local controllerId = o.services.gameStateService.GetPreferedControllerId()
    o.services.FifaCustomizationService.SaveControlSchemeValue(controllerId, index)
    o:publishTouchControlsListData()
  end
  )
  o.im.RegisterAction(actChangeFloatingDpadOption, function(actionName, data)
    o:onFloatingDpadOptionChanged(data)
  end
  )
  o.im.RegisterAction(actChangeVButtonPositionOption, function(actionName, data)
    o:onVButtonPositionOptionChanged(data)
  end
  )
  o.im.RegisterAction(actChangeSkillMovesOption, function(actionName, data)
    o:onSkillMovesOptionChanged(data)
  end
  )
  o.im.RegisterAction(actResetDefaults, function(actionName, data)
    local title = "Reset Default"
    local desc = ("Are you sure you want to reset back to the default settings?")
    function onConfirmAction()
      o.controlSchemeData.index = 1
      o.floatingDpadData.currentValue = false
      o.vButtonPositionData.currentValue = 0
      o.skillMovesData.currentValue = false
      local controllerId = o.services.gameStateService.GetPreferedControllerId()
      o.services.FifaCustomizationService.SaveControlSchemeValue(controllerId, o.controlSchemeData.index)
      o.services.FifaCustomizationService.SaveFloatingDpadValue(controllerId, o:BooleanToSetting(o.floatingDpadData.currentValue))
      o.services.FifaCustomizationService.SaveVButtonPositionValue(controllerId, o.vButtonPositionData.currentValue)
      o.services.FifaCustomizationService.SaveSkillMovesValue(controllerId, o:BooleanToSetting(o.skillMovesData.currentValue))
      o:publishControlSchemeOptions()
      o:publishFloatingDpadOptions()
      o:publishVButtonPositionOptions()
      o:publishSkillMovesOptions()
      o:publishTouchControlsListData()
    end
    
    o.models.SettingsCustomizeModel:showPopup(title, desc, onConfirmAction)
  end
  )
  o.im.Subscribe(bndControlSchemeOptions, function()
    o:publishControlSchemeOptions()
  end
  )
  o.im.Subscribe(bndFloatingDpadOptions, function()
    o:publishFloatingDpadOptions()
  end
  )
  o.im.Subscribe(bndVButtonPositionOptions, function()
    o:publishVButtonPositionOptions()
  end
  )
  o.im.Subscribe(bndSkillMovesOptions, function()
    o:publishSkillMovesOptions()
  end
  )
  o.im.Subscribe(BND_TOUCH_CONTROLS_LIST_DATA, function()
    o:publishTouchControlsListData()
  end
  )
  o.im.Subscribe(bndRightSideLabel, function()
    o:publishRightSideLabel()
  end
  )
  o.im.Subscribe(bndRightSideImage, function()
    o:publishRightSideImage()
  end
  )
  return o
end

function TouchControls:initValues()
  local controllerId = self.services.gameStateService.GetPreferedControllerId()
  self.touchOptions = self.services.FifaCustomizationService.GetTouchOptions(controllerId)
  self:initControlSchemeData(self.touchOptions[CONTROL_SCHEME_OPTION_INDEX].data)
  self:initFloatingDpadData(self.touchOptions[FLOATING_DPAD_OPTION_INDEX].data)
  self:initVButtonPositionData(self.touchOptions[VBUTTON_POSITION_OPTION_INDEX].data)
  self:initSkillMovesData(self.touchOptions[SKILL_MOVES_OPTION_INDEX].data)
end

function TouchControls:initControlSchemeData(controlSchemeData)
  self.controlSchemeData = controlSchemeData
  self.controlSchemeData.rowChangeAction = actChangeControlSchemeOption
  self:setSelectedIndex(self.controlSchemeData)
  self.controlSchemeIndex = self.controlSchemeData.currentValue
end

function TouchControls:initFloatingDpadData(floatingDpadData)
  self.floatingDpadData = floatingDpadData
  self.floatingDpadData.currentValue = self:SettingToBoolean(self.floatingDpadData.currentValue)
  self.floatingDpadData.rowChangeAction = actChangeFloatingDpadOption
  self.floatingDpadData.clickSFX = OPTION_TOGGLE_SFX
  self:setSelectedIndex(self.floatingDpadData)
end

function TouchControls:initVButtonPositionData(vButtonPositionData)
  self.vButtonPositionData = vButtonPositionData
  self.vButtonPositionData.rowChangeAction = actChangeVButtonPositionOption
  self:setSelectedIndex(self.vButtonPositionData)
end

function TouchControls:initSkillMovesData(skillMovesData)
  self.skillMovesData = skillMovesData
  self.skillMovesData.currentValue = self:SettingToBoolean(self.skillMovesData.currentValue)
  self.skillMovesData.rowChangeAction = actChangeSkillMovesOption
  self.skillMovesData.clickSFX = OPTION_TOGGLE_SFX
  self:setSelectedIndex(self.skillMovesData)
end

function TouchControls:setSelectedIndex(optionData)
  local selectedIndex = self:GetValueIndex(optionData.data, optionData.currentValue)
  optionData.index = selectedIndex
end

function TouchControls:publishControlSchemeOptions()
  local dataList = {
    {
      text = "Free"
    },
    {
      text = "Classic"
    }
  }
  local dataToPublish = {
    data = dataList,
    index = self.controlSchemeData.index
  }
  self.im.Publish(bndControlSchemeOptions, dataToPublish)
  self:publishTouchControlsListData()
end

function TouchControls:publishFloatingDpadOptions()
  self.im.Publish(bndFloatingDpadOptions, self.floatingDpadData)
end

function TouchControls:publishVButtonPositionOptions()
  self.im.Publish(bndVButtonPositionOptions, self.vButtonPositionData)
end

function TouchControls:publishSkillMovesOptions()
  self.im.Publish(bndSkillMovesOptions, self.skillMovesData)
end

function TouchControls:publishRightSideLabel()
  self.im.Publish(bndRightSideLabel, self.label)
end

function TouchControls:publishRightSideImage()
  self.im.Publish(bndRightSideImage, {
    name = self.imagetype,
    id = self.imageID
  })
end

function TouchControls:publishTouchControlsListData()
  local dirtyIndices = {}
  local nRows = 4
  do
    do
      for _FORV_6_ = 0, nRows do
        table.insert(dirtyIndices, _FORV_6_)
      end
    end
  end
  local dataList = {
    dirty = dirtyIndices,
    data = {
      {
        data = self.vButtonPositionData
      },
      {
        data = self.skillMovesData
      },
      {
        data = self.floatingDpadData
      }
    }
  }
  self.im.Publish(BND_TOUCH_CONTROLS_LIST_DATA, dataList)
end

function TouchControls:BooleanToSetting(value)
  local setting = 1
  if value then
    setting = 0
  end
  return setting
end

function TouchControls:SettingToBoolean(value)
  local boolean = true
  if value == 1 then
    boolean = false
  end
  return boolean
end

function TouchControls:onFloatingDpadOptionChanged(newOption)
  local newValue = newOption.value
  if self.floatingDpadData.currentValue ~= newValue then
    self.floatingDpadData.currentValue = newValue
    local controllerId = self.services.gameStateService.GetPreferedControllerId()
    self.services.FifaCustomizationService.SaveFloatingDpadValue(controllerId, self:BooleanToSetting(newValue))
  end
end

function TouchControls:onVButtonPositionOptionChanged(newOption)
  local newValue = newOption.value
  if self.vButtonPositionData.currentValue ~= newValue then
    self.vButtonPositionData.currentValue = newValue
    local controllerId = self.services.gameStateService.GetPreferedControllerId()
    self.services.FifaCustomizationService.SaveVButtonPositionValue(controllerId, newValue)
  end
end

function TouchControls:onSkillMovesOptionChanged(newOption)
  local newValue = newOption.value
  if self.skillMovesData.currentValue ~= newValue then
    self.skillMovesData.currentValue = newValue
    local controllerId = self.services.gameStateService.GetPreferedControllerId()
    self.services.FifaCustomizationService.SaveSkillMovesValue(controllerId, self:BooleanToSetting(newValue))
  end
end

function TouchControls:GetValueIndex(data, value)
  local i = 1
  while i <= #data and data[i].value ~= value do
    i = i + 1
  end
  return i - 1
end

function TouchControls:finalize()
  self.im.Unsubscribe(bndControlSchemeOptions)
  self.im.Unsubscribe(bndFloatingDpadOptions)
  self.im.Unsubscribe(bndVButtonPositionOptions)
  self.im.Unsubscribe(bndSkillMovesOptions)
  self.im.Unsubscribe(BND_TOUCH_CONTROLS_LIST_DATA)
  self.im.Unsubscribe(bndRightSideLabel)
  self.im.Unsubscribe(bndRightSideImage)
  self.im.UnregisterAction(actChangeFloatingDpadOption)
  self.im.UnregisterAction(actChangeVButtonPositionOption)
  self.im.UnregisterAction(actChangeSkillMovesOption)
  self.im.UnregisterDataAction("bnd_control_scheme_index", actChangeControlSchemeOption)
  self.im.UnregisterAction(actResetDefaults)
end

return TouchControls
