local RealMatchReveal = {}
print("loaded MATCH REVEAL LUA")
local eventmanager = (...)
local EventTypes = eventmanager.FE.FIFA.EventTypes
local FLOW_ONLINE = "online"
local FLOW_OFFLINE = "offline"
local FLOW_FRIENDLY = "friendly"
local bndAwayData = "bnd_away_data"
local bndHomeData = "bnd_home_data"
local bndHomeCrest = "bnd_home_team_crest"
local bndAwayCrest = "bnd_away_team_crest"
local bndHomeName = "bnd_home_team_name"
local bndAwayName = "bnd_away_team_name"
local bndAway = "bnd_away"
local bndHome = "bnd_home"
local bndMatchType = "bnd_match_type"
local bndStadium = "bnd_stadium"
local bndVs = "bnd_match_vs"
local bndDif = "bnd_match_difficulty"
local bndUserPlatesVisible = "bnd_user_plates_visible"
local actAdvance = "act_advance"
local flow
function RealMatchReveal:new(init)
  print("New Function MatchRevealLua")
  local o = init or {}
  setmetatable(o, self)
  self.__index = self
  o.services = {
    matchInfo = o.api("MatchInfoService"),
    userPlate = o.api("UserPlateService"),
    settingsService = o.api("SettingsService"),
    gameSetupService = o.api("GameSetupService"),
    EventManService = o.api("EventManagerService"),
    socialService = o.api("SocialService")
  }
  o.handlerId = o.services.EventManService.RegisterHandler(function(...)
    o:handleEvent(...)
  end)
  flow = o.data.flow
  local matchTypeLabel = ""
  if o.data.gamemode == "real" or o.data.type == nil then
    matchTypeLabel = o.loc.LocalizeString("LTXT_SEA_REAL")
  else
    matchTypeLabel = o.loc.LocalizeString(string.format("%s_%s_%s", o.data.gamemode, o.data.flow, o.data.type))
  end
  o.currentOptions = o.services.settingsService.GetCurrentOptions()
  o.TeamsData = o.services.matchInfo.GetMatchTeams()
  o.isUserHome = o.services.gameSetupService.IsHostTeam()
  homeCrest = {
    name = "$Crest",
    id = o.TeamsData[1].assetId
  }
  awaycrest = {
    name = "$Crest",
    id = o.TeamsData[2].assetId
  }
  o.im.Subscribe(bndHomeCrest, function()
    o.im.Publish(bndHomeCrest, homeCrest)
  end)
  o.im.Subscribe(bndAwayCrest, function()
    o.im.Publish(bndAwayCrest, awaycrest)
  end)
  o.im.Subscribe(bndAway, function()
    o.im.Publish(bndAway, o.loc.LocalizeString("LTXT_CMN_SIDE_AWAY"))
  end)
  o.im.Subscribe(bndHome, function()
    o.im.Publish(bndHome, o.loc.LocalizeString("LTXT_CMN_SIDE_HOME"))
  end)
  o.im.Subscribe(bndDif, function()
    if o.data.gamemode == "real" and o.data.flow == "offline" then
      o.im.Publish(bndDif, o.currentOptions.difficulty)
    end
  end)
  o.im.Subscribe(bndVs, function()
    o.im.Publish(bndVs, o.loc.LocalizeString("vs"))
  end)
  o.im.Subscribe(bndHomeName, function()
    o.im.Publish(bndHomeName, o.TeamsData[1].teamName)
  end)
  o.im.Subscribe(bndAwayName, function()
    o.im.Publish(bndAwayName, o.TeamsData[2].teamName)
  end)
  o.im.Subscribe(bndMatchType, function()
    o.im.Publish(bndMatchType, matchTypeLabel)
  end)
  o.im.Subscribe(bndStadium, function()
    o.im.Publish(bndStadium, o.currentOptions.stadium)
  end)
  o.im.Subscribe(bndUserPlatesVisible, function()
    o:publishUserPlatesVisible()
  end)
  o.userData = {
    displayName = o.services.userPlate.GetDisplayName(),
    displayPicture = o.services.socialService.GetImagePathForUser(true),
    wins = o.services.userPlate.GetWins(),
    losses = o.services.userPlate.GetLosses(),
    draws = o.services.userPlate.GetDraws(),
    winsLabel = o.loc.LocalizeString("LTXT_CMN_W"),
    drawsLabel = o.loc.LocalizeString("LTXT_CMN_D"),
    lossesLabel = o.loc.LocalizeString("LTXT_CMN_L")
  }
  o.services.socialService.GetPersonaAvatar(o.services.socialService.GetOpponentPersonaId(), true)
  o.opponentData = {
    displayName = o.services.userPlate.GetOpponentDisplayName(),
    displayPicture = o.services.socialService.GetImagePathForOpponent(true),
    wins = o.services.userPlate.GetOpponentWins(),
    losses = o.services.userPlate.GetOpponentLosses(),
    draws = o.services.userPlate.GetOpponentDraws(),
    winsLabel = o.loc.LocalizeString("LTXT_CMN_W"),
    drawsLabel = o.loc.LocalizeString("LTXT_CMN_D"),
    lossesLabel = o.loc.LocalizeString("LTXT_CMN_L")
  }
  o.im.Subscribe(bndHomeData, function()
    o:publishHomeData()
  end)
  o.im.Subscribe(bndAwayData, function()
    o:publishAwayData()
  end)
  return o
end
function RealMatchReveal:publishHomeData()
  if self.isUserHome then
    self.im.Publish(bndHomeData, self.userData)
  else
    self.im.Publish(bndHomeData, self.opponentData)
  end
end
function RealMatchReveal:publishAwayData()
  if self.isUserHome then
    self.im.Publish(bndAwayData, self.opponentData)
  else
    self.im.Publish(bndAwayData, self.userData)
  end
end
function RealMatchReveal:handleEvent(eventType, data)
  if eventType == EventTypes.OpponentRecordInfoAvailable then
    self:onOpponentRecord(data)
  elseif eventType == EventTypes.PersonaAvatarDownloaded then
    self:onOpponentAvatarDownloaded(data)
  end
end
function RealMatchReveal:onOpponentAvatarDownloaded(data)
  self.opponentData.displayPicture = data.image
  self:publishHomeData()
  self:publishAwayData()
end
function RealMatchReveal:onOpponentRecord(data)
  self.opponentData.wins = self.services.userPlate.GetOpponentWins()
  self.opponentData.losses = self.services.userPlate.GetOpponentLosses()
  self.opponentData.draws = self.services.userPlate.GetOpponentDraws()
  self:publishHomeData()
  self:publishAwayData()
end
function RealMatchReveal:publishUserPlatesVisible()
  self.im.Publish(bndUserPlatesVisible, flow ~= FLOW_OFFLINE)
end
function RealMatchReveal:finalize()
  self.im.Unsubscribe(bndHomeData)
  self.im.Unsubscribe(bndAwayData)
  self.im.Unsubscribe(bndHomeCrest)
  self.im.Unsubscribe(bndAwayCrest)
  self.im.Unsubscribe(bndHomeName)
  self.im.Unsubscribe(bndAwayName)
  self.im.Unsubscribe(bndMatchType)
  self.im.Unsubscribe(bndStadium)
  self.im.Unsubscribe(bndVs)
  self.im.Unsubscribe(bndDif)
  self.im.Unsubscribe(bndAway)
  self.im.Unsubscribe(bndHome)
  self.im.Unsubscribe(bndUserPlatesVisible)
  self.services.EventManService.UnregisterHandler(self.handlerId)
end
return RealMatchReveal
